/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.provider.java;

import com.sun.wbem.cimom.adapter.provider.ProviderAdapterIF;
import com.sun.wbem.cimom.adapter.provider.ProviderProtocolAdapterIF;
import com.sun.wbem.cimom.adapters.provider.java.OldInterfaceConverter;
import com.sun.wbem.cimom.util.DynClassLoader;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.AssociatorProvider;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMIndicationProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import javax.wbem.provider.CIMProvider;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.provider.PropertyProvider;

public class JavaProviderAdapter
implements ProviderProtocolAdapterIF,
CIMInstanceProvider {
    private static final String DESCRIPTION = "A Java class provider adapter";
    private static final String VENDOR = "Sun Microsystems Inc.";
    private static final int VERSION = 1;
    private static final String PROVIDERPATHCLASS = "solaris_providerpath";
    private static final String SYSTEMNS = "\\root\\system";
    private static final String PATHURLPROPERTY = "pathurl";
    private boolean valid = false;
    private ProviderCIMOMHandle mCimom;
    private DynClassLoader dcl = null;
    private boolean passAllCheck = false;
    private InstanceProvider internalProvider;

    public JavaProviderAdapter() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.dcl = classLoader instanceof DynClassLoader ? (DynClassLoader)classLoader : new DynClassLoader(this.getClass().getClassLoader());
    }

    void updatePath(String string) throws CIMException {
        try {
            this.dcl.addToClassPath(string);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public void initialize(ProviderCIMOMHandle providerCIMOMHandle) {
        this.mCimom = providerCIMOMHandle;
        String string = System.getProperty("passAllProviderCheck", "false");
        if (string != null) {
            this.passAllCheck = string.compareToIgnoreCase("true") == 0;
        }
        CIMObjectPath cIMObjectPath = new CIMObjectPath(PROVIDERPATHCLASS);
        cIMObjectPath.setNameSpace(SYSTEMNS);
        try {
            this.internalProvider = this.mCimom.getInternalProvider();
            CIMObjectPath[] cIMObjectPathArray = this.internalProvider.enumerateInstanceNames(cIMObjectPath, null);
            if (cIMObjectPathArray == null) {
                Debug.trace2((String)"Got a null return for enumerate");
                return;
            }
            int n = 0;
            while (n < cIMObjectPathArray.length) {
                CIMObjectPath cIMObjectPath2 = cIMObjectPathArray[n];
                CIMProperty cIMProperty = (CIMProperty)cIMObjectPath2.getKeys().elementAt(0);
                try {
                    String string2 = (String)cIMProperty.getValue().getValue();
                    this.updatePath(string2);
                }
                catch (Exception exception) {
                    Debug.trace1((String)"Failure updating the classpath", (Throwable)exception);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)"Problem enumerating path info", (Throwable)exception);
        }
    }

    public void start() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void stop() {
        this.valid = false;
    }

    public int getVersion() {
        return 1;
    }

    public String getVendor() {
        return VENDOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public Object loadProvider(String string, String string2, String[] stringArray, CIMClass cIMClass) throws ClassNotFoundException, CIMClassException {
        try {
            Debug.trace3((String)("Need to load provider " + string2));
            Object var5_5 = null;
            Class clazz = this.dcl.loadClass(string2);
            Debug.trace3((String)("Loaded java class " + clazz.getName()));
            var5_5 = clazz.newInstance();
            if (var5_5 instanceof ProviderAdapterIF) {
                ProviderAdapterIF providerAdapterIF = var5_5;
                providerAdapterIF.getProvider().initialize((CIMOMHandle)this.mCimom);
                return providerAdapterIF;
            }
            if (var5_5 instanceof CIMProvider) {
                Debug.trace3((String)(clazz.getName() + " is a new provider type"));
                CIMProvider cIMProvider = var5_5;
                WrappedProviderAdapter wrappedProviderAdapter = new WrappedProviderAdapter(cIMProvider);
                wrappedProviderAdapter.getProvider().initialize((CIMOMHandle)this.mCimom);
                return wrappedProviderAdapter;
            }
        }
        catch (InstantiationException instantiationException) {
            throw new ClassNotFoundException(instantiationException.toString(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CIMClassException(illegalAccessException.toString(), (Object)illegalAccessException);
        }
        catch (CIMException cIMException) {
            throw new ClassNotFoundException(cIMException.toString(), cIMException);
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS");
    }

    public void unloadProvider(Object object) throws CIMClassException {
        if (object == null) {
            throw new CIMClassException("CIM_ERR_FAILED", (Object)"Provider identifier is null");
        }
        CIMProvider cIMProvider = this.getProviderAdapter(object).getProvider();
        try {
            cIMProvider.cleanup();
        }
        catch (CIMException cIMException) {
            throw new CIMClassException(cIMException.getID(), (Object)cIMException);
        }
    }

    public ProviderAdapterIF getProviderAdapter(Object object) throws CIMClassException {
        if (object instanceof ProviderAdapterIF) {
            return (ProviderAdapterIF)object;
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)"Unrecognized object!");
    }

    public void terminate() {
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        return this.internalProvider.enumerateInstanceNames(cIMObjectPath, cIMClass);
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        return this.internalProvider.enumerateInstances(cIMObjectPath, bl, bl2, bl3, stringArray, cIMClass);
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        return this.internalProvider.getInstance(cIMObjectPath, bl, bl2, bl3, stringArray, cIMClass);
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String string = (String)cIMInstance.getProperty(PATHURLPROPERTY).getValue().getValue();
            this.updatePath(string);
            return this.internalProvider.createInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, boolean bl, String[] stringArray) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        this.internalProvider.deleteInstance(cIMObjectPath);
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        return this.internalProvider.execQuery(cIMObjectPath, string, string2, cIMClass);
    }

    public void initialize(CIMOMHandle cIMOMHandle) {
    }

    public void cleanup() {
    }

    public class WrappedProviderAdapter
    implements ProviderAdapterIF {
        private CIMProvider mWrapped = null;
        private boolean isCIMInst = false;
        private boolean isCIMMethod = false;
        private boolean isCIMAssoc = false;
        private boolean isCIMIndication = false;
        private boolean isProp = false;
        private boolean isAuth = false;
        private boolean isEvent = false;

        WrappedProviderAdapter(CIMProvider cIMProvider) {
            boolean bl = false;
            this.isCIMInst = cIMProvider instanceof CIMInstanceProvider;
            this.isCIMMethod = cIMProvider instanceof CIMMethodProvider;
            this.isCIMAssoc = cIMProvider instanceof CIMAssociatorProvider;
            this.isCIMIndication = cIMProvider instanceof CIMIndicationProvider;
            this.isProp = cIMProvider instanceof PropertyProvider;
            this.isAuth = cIMProvider instanceof Authorizable;
            this.isEvent = cIMProvider instanceof EventProvider;
            if (!this.isCIMInst && cIMProvider instanceof InstanceProvider) {
                bl = true;
                this.isCIMInst = true;
            }
            if (!this.isCIMMethod && cIMProvider instanceof MethodProvider) {
                bl = true;
                this.isCIMMethod = true;
            }
            if (!this.isCIMAssoc && cIMProvider instanceof AssociatorProvider) {
                bl = true;
                this.isCIMAssoc = true;
            }
            this.mWrapped = bl ? new OldInterfaceConverter(cIMProvider) : cIMProvider;
        }

        public boolean isInstanceProvider() {
            return this.isCIMInst;
        }

        public boolean isPropertyProvider() {
            return this.isProp;
        }

        public boolean isMethodProvider() {
            return this.isCIMMethod;
        }

        public boolean isCIMIndicationProvider() {
            return this.isCIMIndication;
        }

        public boolean isEventProvider() {
            return this.isEvent;
        }

        public boolean isAuthorizable() {
            return this.isAuth;
        }

        public boolean isAssociatorProvider() {
            return this.isCIMAssoc;
        }

        public CIMProvider getProvider() {
            return this.mWrapped;
        }
    }
}

