/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client;

import com.netscape.management.client.CloseVetoException;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.ITaskModel;
import com.netscape.management.client.ITaskModelListener;
import com.netscape.management.client.ITaskObject;
import com.netscape.management.client.LDAPTaskModel;
import com.netscape.management.client.MenuData;
import com.netscape.management.client.StatusItemProgress;
import com.netscape.management.client.TaskModelEvent;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class TaskPage
extends JPanel
implements IPage,
ITaskModelListener,
Cloneable,
SuiConstants {
    public static final String MENU_CONTEXT = "CONTEXT";
    public static final String STATUS_PROGRESS = "StatusItemProgress";
    protected IFramework _framework;
    protected ITaskModel _model;
    protected TaskList _taskList;
    protected String _pageTitle = "";
    protected JPopupMenu _contextMenu = new JPopupMenu();
    protected ITaskObject _selectedTask;
    protected ITaskObject _previousSelectedTask;
    protected MenuInfoAction _menuInfoAction = new MenuInfoAction();
    protected Vector _menuData = new Vector();
    protected Vector _statusItems = new Vector();
    protected Vector _statusItemPositions = new Vector();
    protected boolean _isPageSelected = false;
    public static Icon _defaultTaskIcon;
    protected ConsoleInfo _info;
    protected StatusItemProgress _statusItemProgress = new StatusItemProgress("StatusItemProgress", 0);

    public TaskPage(ITaskModel iTaskModel) {
        if (_defaultTaskIcon == null) {
            _defaultTaskIcon = new RemoteImage(Framework._imageSource + "task.gif");
        }
        this.setTaskModel(iTaskModel);
    }

    public TaskPage(ConsoleInfo consoleInfo, ITaskModel iTaskModel) {
        this(iTaskModel);
        this._info = consoleInfo;
    }

    public TaskPage(ConsoleInfo consoleInfo) {
        this(consoleInfo, LDAPTaskModel.createLDAPTaskModel(consoleInfo));
    }

    public IFramework getFramework() {
        return this._framework;
    }

    public Object clone() {
        TaskPage taskPage = new TaskPage(this._info, this._model);
        taskPage.setPageTitle(this.getPageTitle());
        return taskPage;
    }

    public void setTaskModel(ITaskModel iTaskModel) {
        this._model = iTaskModel;
        this._pageTitle = Framework.i18n("page", "Tasks");
        this.setLayout(new BorderLayout());
        this.removeAll();
        this.add(this.createTaskPanel(this.getModel()));
        this.validate();
    }

    protected Component createTaskPanel(ITaskModel iTaskModel) {
        this._taskList = new TaskList(iTaskModel);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this._taskList);
        BevelBorder bevelBorder = new BevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("control"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow"));
        EmptyBorder emptyBorder = new EmptyBorder(6, 6, 6, 6);
        jScrollPane.setBorder(new CompoundBorder(emptyBorder, bevelBorder));
        return jScrollPane;
    }

    public ITaskModel getModel() {
        return this._model;
    }

    public String getPageTitle() {
        return this._pageTitle;
    }

    public void setPageTitle(String string) {
        this._pageTitle = string;
    }

    public void initialize(IFramework iFramework) {
        Debug.println(6, "TaskPage.initialize");
        this._framework = iFramework;
        if (this._model instanceof IMenuInfo) {
            this.addMenuItems((IMenuInfo)((Object)this._model), this._menuInfoAction);
        }
        this._model.addITaskModelListener(this);
        this.addStatusItem(this._statusItemProgress, "R");
        if (this._model instanceof LDAPTaskModel) {
            LDAPTaskModel lDAPTaskModel = (LDAPTaskModel)this._model;
            lDAPTaskModel.setParentPage(this);
        }
    }

    public ITaskObject getSelection() {
        Debug.println(6, "TaskPage.getSelection: sel=" + this._selectedTask);
        return this._selectedTask;
    }

    public ITaskObject getPreviousSelection() {
        Debug.println(6, "TaskPage.getPreviousSelection: sel=" + this._previousSelectedTask);
        return this._previousSelectedTask;
    }

    public void runComplete(ITaskObject iTaskObject) {
    }

    private boolean isEventTarget(TaskModelEvent taskModelEvent) {
        IPage iPage = taskModelEvent.getViewInstance();
        if (iPage == null) {
            return true;
        }
        return iPage == this;
    }

    public void addMenuItems(TaskModelEvent taskModelEvent) {
        if (this.isEventTarget(taskModelEvent)) {
            this.addMenuItems(taskModelEvent.getMenuInfo(), this._menuInfoAction);
        }
    }

    public void enableMenuItem(TaskModelEvent taskModelEvent) {
        if (this.isEventTarget(taskModelEvent)) {
            MenuData.enableMenuItem(this._menuData, taskModelEvent.getMenuID(), true);
        }
    }

    public void disableMenuItem(TaskModelEvent taskModelEvent) {
        if (this.isEventTarget(taskModelEvent)) {
            MenuData.enableMenuItem(this._menuData, taskModelEvent.getMenuID(), false);
        }
    }

    protected void addMenuItem(String string, IMenuItem iMenuItem) {
        MenuData menuData = new MenuData(string, iMenuItem, null);
        this.populateMenuItem(menuData);
        this._menuData.addElement(menuData);
    }

    private void populateMenuItem(MenuData menuData) {
        if (this.isPageSelected()) {
            if (menuData.getCategoryID().equals(MENU_CONTEXT)) {
                this._contextMenu.add(menuData.getIMenuItem().getComponent());
            } else {
                JMenu jMenu = MenuData.getMenu(this._contextMenu, menuData.getCategoryID());
                if (jMenu != null) {
                    jMenu.add(menuData.getIMenuItem().getComponent());
                } else {
                    this._framework.addMenuItem(menuData.getCategoryID(), menuData.getIMenuItem());
                }
            }
        }
    }

    private void populateMenuItems(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.populateMenuItem((MenuData)enumeration.nextElement());
        }
    }

    private void unpopulateMenuItems(Vector vector) {
        if (this.isPageSelected()) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                MenuData menuData = (MenuData)enumeration.nextElement();
                if (menuData.getCategoryID().equals(MENU_CONTEXT)) {
                    this._contextMenu.remove(menuData.getIMenuItem().getComponent());
                    continue;
                }
                JMenu jMenu = MenuData.getMenu(this._contextMenu, menuData.getCategoryID());
                if (jMenu != null) {
                    jMenu.remove(menuData.getIMenuItem().getComponent());
                    continue;
                }
                this._framework.removeMenuItem(menuData.getIMenuItem());
            }
        }
    }

    protected void addMenuItems(IMenuInfo iMenuInfo, ActionListener actionListener) {
        Vector vector = MenuData.createMenuData(iMenuInfo, actionListener);
        this.populateMenuItems(vector);
        MenuData.addVectors(this._menuData, vector);
    }

    public void removeMenuItems(TaskModelEvent taskModelEvent) {
        if (this.isEventTarget(taskModelEvent)) {
            Vector vector = MenuData.createMenuDataByID(this._menuData, MenuData.createMenuData(taskModelEvent.getMenuInfo(), null));
            this.unpopulateMenuItems(vector);
            MenuData.substractVectors(this._menuData, vector);
        }
    }

    private void addStatusItem(IStatusItem iStatusItem, String string) {
        this._statusItems.addElement(iStatusItem);
        this._statusItemPositions.addElement(string);
    }

    private void removeStatusItem(IStatusItem iStatusItem) {
        int n = this._statusItems.indexOf(iStatusItem);
        this._statusItems.removeElementAt(n);
        this._statusItemPositions.removeElementAt(n);
    }

    protected void populateStatusItems() {
        if (this.isPageSelected()) {
            int n = 0;
            while (n < this._statusItems.size()) {
                IStatusItem iStatusItem = (IStatusItem)this._statusItems.elementAt(n);
                String string = (String)this._statusItemPositions.elementAt(n);
                this._framework.addStatusItem(iStatusItem, string);
                ++n;
            }
        }
    }

    protected void unpopulateStatusItems() {
        if (this.isPageSelected()) {
            int n = this._statusItems.size() - 1;
            while (n >= 0) {
                IStatusItem iStatusItem = (IStatusItem)this._statusItems.elementAt(n);
                this._framework.removeStatusItem(iStatusItem);
                --n;
            }
        }
    }

    public void addStatusItem(TaskModelEvent taskModelEvent) {
        if (this.isEventTarget(taskModelEvent)) {
            IStatusItem iStatusItem = taskModelEvent.getStatusItem();
            String string = taskModelEvent.getStatusItemPosition();
            this.addStatusItem(iStatusItem, string);
            this._framework.addStatusItem(iStatusItem, string);
        }
    }

    public void removeStatusItem(TaskModelEvent taskModelEvent) {
        if (this.isEventTarget(taskModelEvent)) {
            this.removeStatusItem(taskModelEvent.getStatusItem());
            this._framework.removeStatusItem(taskModelEvent.getStatusItem());
        }
    }

    public void changeStatusItemState(TaskModelEvent taskModelEvent) {
        if (this.isEventTarget(taskModelEvent) && this.isPageSelected()) {
            this._framework.changeStatusItemState(taskModelEvent.getStatusItemID(), taskModelEvent.getStatusItemState());
        }
    }

    public void changeFeedbackCursor(TaskModelEvent taskModelEvent) {
        if (this.isEventTarget(taskModelEvent)) {
            if (taskModelEvent.getCursor().getType() == 3 && this._framework instanceof Framework) {
                ((Framework)this._framework).setBusyCursor(true);
            } else if (taskModelEvent.getCursor().getType() == 0 && this._framework instanceof Framework) {
                ((Framework)this._framework).setBusyCursor(false);
            } else {
                this._framework.setCursor(taskModelEvent.getCursor());
            }
        }
    }

    public boolean isPageSelected() {
        return this._isPageSelected;
    }

    public void pageSelected(IFramework iFramework) {
        Debug.println(6, "TaskPage.pageSelected: parent=" + iFramework);
        this._isPageSelected = true;
        this.populateMenuItems(this._menuData);
        this.populateStatusItems();
    }

    public void pageUnselected(IFramework iFramework) {
        Debug.println(6, "TaskPage.pageUnselected: parent=" + iFramework);
        this.unpopulateMenuItems(this._menuData);
        this.unpopulateStatusItems();
        this._isPageSelected = false;
    }

    public void actionViewClosing(IFramework iFramework) throws CloseVetoException {
        this.getModel().actionViewClosing(this);
    }

    class TaskList
    extends JPanel
    implements SwingConstants,
    SuiConstants {
        LabelMouseListener _labelListener = new LabelMouseListener();
        ButtonMouseListener _buttonListener = new ButtonMouseListener();
        TaskKeyListener _keyListener = new TaskKeyListener();
        TaskFocusListener _focusListener = new TaskFocusListener();
        ITaskModel _taskModel;
        int SPACE = 6;
        VisibleTask _visibleTask = null;
        JSeparator _separator = null;

        public TaskList(ITaskModel iTaskModel) {
            Object object;
            this._taskModel = iTaskModel;
            this.setLayout(new GridBagLayout());
            this.setBackground(UIManager.getColor("window"));
            Object object2 = this._taskModel.getRoot();
            int n = this._taskModel.getChildCount(object2);
            int n2 = 0;
            while (n2 < n) {
                object = (ITaskObject)this._taskModel.getChild(object2, n2);
                this._visibleTask = new VisibleTask((ITaskObject)object);
                this._visibleTask.addMouseListener(this._labelListener);
                GridBagUtil.constrain(this, this._visibleTask, 0, -1, 1, 1, 1.0, 0.0, 17, 2, this.SPACE, this.SPACE, this.SPACE, this.SPACE);
                if (n2 != n - 1) {
                    this._separator = new JSeparator();
                    GridBagUtil.constrain(this, this._separator, 0, -1, 1, 1, 1.0, 0.0, 17, 2, 0, 0, 0, 0);
                }
                ++n2;
            }
            object = new JPanel();
            ((JComponent)object).setOpaque(false);
            GridBagUtil.constrain(this, (Component)object, 0, -1, 1, 1, 1.0, 1.0, 17, 1, 0, 0, 0, 0);
        }

        class TaskKeyListener
        implements KeyListener {
            TaskKeyListener() {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                Debug.println(7, "TaskPage.TaskKeyListener.keyPressed " + keyEvent.getSource());
                if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                    ITaskObject iTaskObject;
                    Object object = keyEvent.getSource();
                    if (object instanceof AbstractButton) {
                        ((AbstractButton)object).doClick();
                    }
                    if ((iTaskObject = TaskPage.this.getSelection()) != null) {
                        TaskList.this._taskModel.actionObjectRun(TaskPage.this, iTaskObject);
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        }

        class ButtonMouseListener
        extends MouseAdapter {
            ButtonMouseListener() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                Debug.println(7, "TaskPage.ButtonMouseListener.mouseClicked");
                if (mouseEvent.getClickCount() == 1) {
                    JButton jButton = (JButton)mouseEvent.getSource();
                    VisibleTask visibleTask = (VisibleTask)jButton.getParent();
                    visibleTask.selected();
                    if (!((Framework)TaskPage.this.getFramework()).isClosing()) {
                        TaskList.this._taskModel.actionObjectRun(TaskPage.this, visibleTask.getTaskObject());
                    }
                }
            }
        }

        class LabelMouseListener
        extends MouseAdapter {
            LabelMouseListener() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                Debug.println(7, "TaskPage.LabelMouseListener.mousePressed " + mouseEvent.getSource());
                VisibleTask visibleTask = (VisibleTask)mouseEvent.getSource();
                visibleTask.requestFocus();
                if (((TaskList)TaskList.this).TaskPage.this._contextMenu != null && mouseEvent.isPopupTrigger() && ((TaskList)TaskList.this).TaskPage.this._contextMenu.getComponentCount() > 0) {
                    ((TaskList)TaskList.this).TaskPage.this._contextMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Debug.println(7, "TaskPage.LabelMouseListener.mouseReleased " + mouseEvent.getSource());
                if (((TaskList)TaskList.this).TaskPage.this._contextMenu != null && mouseEvent.isPopupTrigger() && ((TaskList)TaskList.this).TaskPage.this._contextMenu.getComponentCount() > 0) {
                    ((TaskList)TaskList.this).TaskPage.this._contextMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        class TaskFocusListener
        extends FocusAdapter {
            TaskFocusListener() {
            }

            public void focusGained(FocusEvent focusEvent) {
                Debug.println(7, "Focus gained " + focusEvent.getSource());
                VisibleTask visibleTask = (VisibleTask)focusEvent.getComponent().getParent();
                visibleTask.selected();
                ((TaskList)TaskList.this).TaskPage.this._previousSelectedTask = ((TaskList)TaskList.this).TaskPage.this._selectedTask;
                ((TaskList)TaskList.this).TaskPage.this._selectedTask = visibleTask.getTaskObject();
                TaskList.this._taskModel.actionObjectSelected(TaskPage.this, ((TaskList)TaskList.this).TaskPage.this._selectedTask, ((TaskList)TaskList.this).TaskPage.this._previousSelectedTask);
            }

            public void focusLost(FocusEvent focusEvent) {
                Debug.println(7, "Focus lost " + focusEvent.getSource());
            }
        }

        class VisibleTask
        extends JPanel {
            ITaskObject _taskObject;
            JButton button;

            public VisibleTask(ITaskObject iTaskObject) {
                this._taskObject = iTaskObject;
                this.setLayout(new GridBagLayout());
                this.setOpaque(false);
                Icon icon = iTaskObject.getIcon();
                this.button = new JButton(icon == null ? _defaultTaskIcon : icon);
                this.button.setToolTipText(iTaskObject.getDescription());
                this.button.setFocusPainted(true);
                this.button.setMargin(new Insets(0, 0, 0, 0));
                this.button.addMouseListener(TaskList.this._buttonListener);
                this.button.addKeyListener(TaskList.this._keyListener);
                this.button.addFocusListener(TaskList.this._focusListener);
                GridBagUtil.constrain(this, this.button, 0, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 0, 0, 0);
                JLabel jLabel = new JLabel(iTaskObject.getName());
                jLabel.setOpaque(false);
                jLabel.setHorizontalTextPosition(2);
                jLabel.setFont(UIManager.getFont("TaskList.font"));
                jLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
                GridBagUtil.constrain(this, jLabel, 1, 0, 1, 1, 1.0, 0.0, 17, 2, 0, 3, 0, 0);
            }

            public void selected() {
                this.getRootPane().setDefaultButton(this.button);
            }

            public void requestFocus() {
                this.button.requestFocus();
            }

            public ITaskObject getTaskObject() {
                return this._taskObject;
            }
        }
    }

    class MenuInfoAction
    implements ActionListener {
        MenuInfoAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IMenuItem iMenuItem = (IMenuItem)actionEvent.getSource();
            IMenuInfo iMenuInfo = MenuData.findIMenuInfo(TaskPage.this._menuData, iMenuItem);
            iMenuInfo.actionMenuSelected(TaskPage.this, iMenuItem);
        }
    }
}

