/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acleditor.ACLEditorWindow;
import com.netscape.management.client.acleditor.CallbackAction;
import com.netscape.management.client.acleditor.DataModelAdapter;
import com.netscape.management.client.acleditor.RightsDataModel;
import com.netscape.management.client.acleditor.SelectionListener;
import com.netscape.management.client.acleditor.Table;
import com.netscape.management.client.acleditor.WindowFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class RightsWindow
extends ACLEditorWindow
implements SelectionListener {
    Table list;
    RightsDataModel datamodel;

    public RightsWindow(String string, WindowFactory windowFactory, DataModelAdapter dataModelAdapter) {
        super(windowFactory, string, windowFactory.getSessionIdentifier());
        JPanel jPanel = this.createStandardLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.datamodel = (RightsDataModel)dataModelAdapter;
        this.list = new Table(this.datamodel);
        jPanel.add((Component)this.list, gridBagConstraints);
        this.list.setPreferredSize(new Dimension(150, 175));
        this.list.getJTable().setShowGrid(false);
        this.list.getJTable().setRowSelectionAllowed(false);
        this.list.addSelectionListener(this);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 10, 0));
        jPanel2.add(this.createButton("selectAll", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RightsWindow.this.datamodel.toggleSelectAll();
                RightsWindow.this.setSelectAllButtonLabel();
                RightsWindow.this.repaint(0L);
            }
        }));
        this.setSelectAllButtonLabel();
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.setResizable(false);
        this.pack();
    }

    public void selectionNotify(int n, int n2, int n3, CallbackAction callbackAction) {
        this.setSelectAllButtonLabel();
    }

    protected void save(ActionEvent actionEvent) {
        String string = this.datamodel.complete();
        if (string != null) {
            this.showErrorDialog("errorText" + string);
            return;
        }
        super.save(actionEvent);
    }

    protected void setSelectAllButtonLabel() {
        JButton jButton = (JButton)this.getComponent("selectAll");
        if (this.datamodel.getAllSelectedValue()) {
            jButton.setText(this.resources.getString(this.windowName, "deselectAllButton"));
        } else {
            jButton.setText(this.resources.getString(this.windowName, "selectAllButton"));
        }
        jButton.repaint(0L);
    }
}

