/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.comm;

import com.netscape.management.client.comm.CommChannel;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LinkedList;
import com.netscape.management.client.util.LinkedListElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public abstract class CommManager {
    public static final int ASYNC_RESPONSE = 1;
    public static final int FORCE_BASIC_AUTH = 2;
    public static final int NO_TIMEOUT = -1;
    public static final int DEFAULT_RESPONSE_TIMEOUT = 30000;
    public static final int DEFAULT_IDLE_TIMEOUT = 1000;
    public static String BasicAuth = "Basic Auth Request";
    protected static int CommChannelCount = 0;
    protected LinkedList requests = new LinkedList();
    protected Hashtable channels = new Hashtable();
    protected int idleTimeout = 1000;
    protected int responseTimeout = 30000;
    protected int maxChannels = 1;
    protected static String language = "en";
    protected static boolean sendUTF8 = true;
    private IOException channelException;

    protected CommManager() {
        language = Locale.getDefault().getLanguage();
    }

    public synchronized CommRecord send(Object object, CommClient commClient, Object object2, InputStream inputStream, int n, int n2, Object object3) throws IOException {
        Object object4;
        Debug.println("CommManager> New CommRecord (" + object + ")");
        Debug.println("http", (inputStream == null ? "GET  " : "POST ") + object);
        Object object5 = this.targetID(object);
        Vector<Object> vector = (Vector<Object>)this.channels.get(object5);
        if (vector == null) {
            vector = new Vector<Object>();
            this.channels.put(object5, vector);
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            object4 = (CommChannel)vector.elementAt(n3);
            if (object4.ready()) break;
            ++n3;
        }
        if (n3 == vector.size() && n3 < this.maxChannels) {
            object4 = this.createChannel(object5, Integer.toString(CommChannelCount++) + ":" + Integer.toString(n3));
            object4.open();
            vector.addElement(object4);
        }
        object4 = new CommRecord(commClient, object2, object5, object, inputStream, n, n2, object3);
        ((CommRecord)object4).setStatus("Waiting");
        if ((n2 & 1) != 0) {
            ((CommRecord)object4).setAsyncResponseMode();
        }
        if ((n2 & 2) != 0) {
            ((CommRecord)object4).setAuthObj(BasicAuth);
        }
        this.requests.append(object4);
        this.notifyAll();
        return object4;
    }

    public synchronized CommRecord send(Object object, CommClient commClient, Object object2, InputStream inputStream, int n) throws IOException {
        return this.send(object, commClient, object2, inputStream, n, 0, null);
    }

    public synchronized CommRecord send(Object object, CommClient commClient, Object object2, InputStream inputStream, int n, int n2) throws IOException {
        return this.send(object, commClient, object2, inputStream, n, n2, null);
    }

    public synchronized boolean terminate(CommRecord commRecord) throws IOException {
        Object object = commRecord.getStatus();
        if (object.equals("Complete") || object.equals("Error")) {
            Debug.println("CommManager> Terminate request for " + commRecord.getTarget() + " in " + object + " state. Ignored");
            return false;
        }
        if (object.equals("Waiting")) {
            this.requests.remove(commRecord);
            Debug.println("CommManager> " + commRecord.getTarget() + " removed from the queue");
            return true;
        }
        if (object.equals("Assigned") || object.equals("Sent")) {
            CommChannel commChannel = commRecord.getChannel();
            if (commChannel == null) {
                Debug.println("CommManager> Terminate request for " + commRecord.getTarget() + ", unable to close CommChannel");
            }
            this.closeChannel(commChannel);
            Debug.println("CommManager> " + commRecord.getTarget() + " terminated");
            return true;
        }
        Debug.println("CommManager> Terminate request for " + commRecord.getTarget() + ", state unknown");
        return false;
    }

    public void setMaxChannels(int n) {
        this.maxChannels = n;
    }

    public void setTimeout(int n) {
        this.setIdleTimeout(n);
    }

    public void setIdleTimeout(int n) {
        this.idleTimeout = n;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setResponseTimeout(int n) {
        this.responseTimeout = n;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    protected synchronized CommRecord next(CommChannel commChannel) throws IOException {
        boolean bl = false;
        Object object = commChannel.targetID();
        while (true) {
            LinkedListElement linkedListElement = this.requests.head;
            while (linkedListElement != null) {
                CommRecord commRecord = (CommRecord)linkedListElement.obj;
                if (commRecord.getTID().equals(object)) {
                    this.requests.remove(commRecord);
                    commRecord.setStatus("Assigned");
                    return commRecord;
                }
                linkedListElement = linkedListElement.next;
            }
            if (bl) {
                this.closeChannel(commChannel);
                return null;
            }
            if (this.idleTimeout == -1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            long l = System.currentTimeMillis();
            try {
                this.wait(this.idleTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - l <= (long)this.idleTimeout) continue;
            bl = true;
        }
    }

    protected synchronized void retry(CommRecord commRecord) throws IOException {
        CommChannel commChannel;
        Debug.println("CommManager> Retry CommRecord (" + commRecord.getTarget() + ")");
        Object object = commRecord.getTID();
        Vector<CommChannel> vector = (Vector<CommChannel>)this.channels.get(object);
        if (vector == null) {
            vector = new Vector<CommChannel>();
            this.channels.put(object, vector);
        }
        int n = 0;
        while (n < vector.size()) {
            commChannel = (CommChannel)vector.elementAt(n);
            if (commChannel.ready()) break;
            ++n;
        }
        if (n == vector.size() && n < this.maxChannels) {
            commChannel = this.createChannel(object, Integer.toString(CommChannelCount++) + ":" + Integer.toString(n));
            commChannel.open();
            vector.addElement(commChannel);
        }
        commRecord.setStatus("Waiting");
        if (commRecord.getData() != null) {
            commRecord.getData().reset();
        }
        this.requests.prepend(commRecord);
        this.notifyAll();
    }

    protected synchronized void closeChannel(CommChannel commChannel) throws IOException {
        Object object = commChannel.targetID();
        Vector vector = (Vector)this.channels.get(object);
        if (vector == null) {
            return;
        }
        vector.removeElement(commChannel);
        LinkedListElement linkedListElement = this.requests.head;
        while (linkedListElement != null) {
            CommRecord commRecord = (CommRecord)linkedListElement.obj;
            if (commRecord.getTID().equals(object)) {
                CommChannel commChannel2 = this.createChannel(object, Integer.toString(CommChannelCount++) + ":" + Integer.toString(vector.size()));
                commChannel2.open();
                vector.addElement(commChannel2);
            }
            linkedListElement = linkedListElement.next;
        }
        if (vector.size() == 0) {
            this.channels.remove(object);
        }
        commChannel.close();
    }

    public static void setLanguage(String string) {
        language = string;
    }

    public static String getLanguage() {
        return language;
    }

    public static void setSendUTF8(boolean bl) {
        sendUTF8 = bl;
    }

    public static boolean getSendUTF8() {
        return sendUTF8;
    }

    protected abstract Object targetID(Object var1);

    protected abstract CommChannel createChannel(Object var1, String var2) throws IOException;
}

