/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.ClickBorder;
import com.netscape.management.client.components.DotBorder;
import com.netscape.management.client.components.FlatBorder;
import com.netscape.management.client.components.UIConstants;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TimeDayPanel
extends JPanel
implements UIConstants {
    private static final ResourceSet i18n = new ResourceSet("com.netscape.management.client.components.components");
    private JTable timeTable;
    private Vector dayOfWeek = new Vector();
    private JLabel selectionLabel = new JLabel();
    private static int DAY_COLUMN_WIDTH = 90;
    private static int MAX_DAYS = 7;
    static /* synthetic */ Class class$java$lang$Object;

    private static String i18n(String string) {
        return i18n.getString("timeDayPanel", string);
    }

    public TimeDayPanel() {
        int n = 1;
        while (n <= MAX_DAYS) {
            this.dayOfWeek.addElement(TimeDayPanel.i18n("day" + String.valueOf(n)));
            ++n;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        JComponent jComponent = this.createTimeDayPanel();
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(35, 6, 0, 0);
        JComponent jComponent2 = this.createButtonPanel();
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        this.add(jComponent2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(15, 6, 0, 0);
        JComponent jComponent3 = this.createLegendPanel();
        gridBagLayout.setConstraints(jComponent3, gridBagConstraints);
        this.add(jComponent3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, DAY_COLUMN_WIDTH, 0, 0);
        gridBagLayout.setConstraints(this.selectionLabel, gridBagConstraints);
        this.add(this.selectionLabel);
    }

    protected JComponent createButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JButton jButton = ButtonFactory.createButton(TimeDayPanel.i18n("all"));
        jButton.setToolTipText(TimeDayPanel.i18n("all_tt"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeDayPanel.this.setHourSelection(0, 23);
                TimeDayPanel.this.setDaySelection(0, 6);
            }
        });
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        JButton jButton2 = ButtonFactory.createButton(TimeDayPanel.i18n("none"));
        jButton2.setToolTipText(TimeDayPanel.i18n("none_tt"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeDayPanel.this.setDaySelection(-1, -1);
            }
        });
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel.add(jButton2);
        return jPanel;
    }

    protected JComponent createLegendPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 6, 0, 0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(true);
        jPanel2.setBackground(UIManager.getColor("textHighlight"));
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(TimeDayPanel.i18n("selected"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(true);
        jPanel3.setBackground(UIManager.getColor("window"));
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        JLabel jLabel2 = new JLabel(TimeDayPanel.i18n("unselected"));
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        return jPanel;
    }

    protected JComponent createTimeDayPanel() {
        Serializable serializable;
        JTable jTable;
        this.timeTable = jTable = new JTable(new TimeTableModel());
        jTable.setRowSelectionAllowed(false);
        jTable.setColumnSelectionAllowed(true);
        jTable.setSelectionMode(2);
        jTable.setCellSelectionEnabled(true);
        jTable.setAutoResizeMode(2);
        jTable.setPreferredSize(new Dimension(360, 400));
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = TimeDayPanel.class$("java.lang.Object")) : class$java$lang$Object, new TimeCellRenderer());
        jTable.setRowHeight(22);
        jTable.setShowGrid(false);
        jTable.setIntercellSpacing(new Dimension(0, 0));
        TimeSelectionListener timeSelectionListener = new TimeSelectionListener();
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(timeSelectionListener);
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        TimeHeaderRenderer timeHeaderRenderer = new TimeHeaderRenderer();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        tableColumnModel.addColumnModelListener(timeSelectionListener);
        int n = tableColumnModel.getColumnCount();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMinWidth(DAY_COLUMN_WIDTH);
        tableColumn.setResizable(false);
        tableColumn.setHeaderRenderer(timeHeaderRenderer);
        jTable.setPreferredScrollableViewportSize(new Dimension(jTable.getPreferredSize().width, jTable.getRowCount() * jTable.getRowHeight() + jTableHeader.getSize().height));
        int n2 = 1;
        while (n2 < n) {
            serializable = tableColumnModel.getColumn(n2);
            ((TableColumn)serializable).setMinWidth(1);
            ((TableColumn)serializable).setHeaderRenderer(timeHeaderRenderer);
            ++n2;
        }
        serializable = new JScrollPane(jTable);
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder());
        ((JScrollPane)serializable).setVerticalScrollBarPolicy(21);
        ((JScrollPane)serializable).setHorizontalScrollBarPolicy(31);
        return serializable;
    }

    public String toHourString(int n, boolean bl) {
        String string;
        String string2 = string = n < 12 ? "am" : "pm";
        if (n > 12) {
            n -= 12;
        }
        if (n == 0) {
            n = 12;
        }
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(n));
        if (bl) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toDayString(int n) {
        return (String)this.dayOfWeek.elementAt(n);
    }

    public void selectAll() {
        this.setHourSelection(0, 23);
        this.setDaySelection(0, 6);
    }

    public void selectNone() {
        this.setHourSelection(-1, -1);
        this.setDaySelection(-1, -1);
    }

    public void addDaySelection(int n, int n2) {
        if (n == -1 || n2 == -1) {
            this.timeTable.clearSelection();
        } else {
            this.timeTable.addRowSelectionInterval(n, n2);
        }
    }

    public void setDaySelection(int n, int n2) {
        if (n == -1 || n2 == -1) {
            this.timeTable.clearSelection();
        } else {
            this.timeTable.setRowSelectionInterval(n, n2);
        }
    }

    public void addHourSelection(int n, int n2) {
        if (n == -1 || n2 == -1) {
            this.timeTable.clearSelection();
        } else {
            this.timeTable.addColumnSelectionInterval(n + 1, n2 + 1);
        }
    }

    public void setHourSelection(int n, int n2) {
        if (n == -1 || n2 == -1) {
            this.timeTable.clearSelection();
        } else {
            this.timeTable.setColumnSelectionInterval(n + 1, n2 + 1);
        }
    }

    public int[] getDaySelection() {
        return this.timeTable.getSelectedRows();
    }

    public int[] getHourSelection() {
        int[] nArray = this.timeTable.getSelectedColumns();
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        return nArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TimeCellRenderer
    extends JButton
    implements TableCellRenderer {
        Border flatBorder = new FlatBorder();
        Border emptyBorder = BorderFactory.createEmptyBorder();
        Border ClickBorder = new ClickBorder();
        Border dotBorder = new DotBorder(UIManager.getColor("controlShadow"), false, false, true, true);

        TimeCellRenderer() {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof String) {
                Color color = UIManager.getColor("Button.background");
                Border border = this.ClickBorder;
                if (bl) {
                    color = UIManager.getColor("controlShadow");
                }
                this.setBorder(border);
                this.setBackground(color);
                this.setText((String)object);
            } else {
                Color color = UIManager.getColor("window");
                if (bl) {
                    color = UIManager.getColor("textHighlight");
                }
                this.setBackground(color);
                this.setBorder(this.dotBorder);
                this.setText("");
            }
            return this;
        }
    }

    class TimeHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        Border emptyBorder = BorderFactory.createEmptyBorder();
        Border ClickBorder = new ClickBorder();
        JLabel hourIconLabel = new JLabel();
        JLabel hourTextLabel = new JLabel();
        JPanel emptyPanel = new JPanel();
        ImageIcon sunIcon = new RemoteImage("com/netscape/management/client/components/images/sun.gif");
        ImageIcon moonIcon = new RemoteImage("com/netscape/management/client/components/images/moon.gif");

        public TimeHeaderRenderer() {
            this.hourTextLabel.setFont(new Font("SansSerif", 0, 9));
            this.hourTextLabel.setHorizontalAlignment(0);
            this.hourIconLabel.setHorizontalAlignment(0);
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.hourIconLabel, gridBagConstraints);
            this.add(this.hourIconLabel);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.hourTextLabel, gridBagConstraints);
            this.add(this.hourTextLabel);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 15;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.emptyPanel, gridBagConstraints);
            this.add(this.emptyPanel);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.emptyPanel.setBorder(n2 == 0 ? this.emptyBorder : this.ClickBorder);
            if (n2 % 2 == 1) {
                this.hourTextLabel.setText(TimeDayPanel.this.toHourString(n2 - 1, false));
                if (n2 == 1 || n2 == 23) {
                    this.hourIconLabel.setIcon(this.moonIcon);
                }
                if (n2 == 13) {
                    this.hourIconLabel.setIcon(this.sunIcon);
                }
            } else {
                this.hourTextLabel.setText("");
                this.hourIconLabel.setIcon(null);
            }
            return this;
        }
    }

    class TimeTableModel
    extends DefaultTableModel {
        Object hourCell = new Object();

        TimeTableModel() {
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public int getRowCount() {
            return MAX_DAYS;
        }

        public int getColumnCount() {
            return 25;
        }

        public String getColumnName(int n) {
            return " ";
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return TimeDayPanel.this.toDayString(n);
            }
            return this.hourCell;
        }
    }

    class TimeSelectionListener
    implements ListSelectionListener,
    TableColumnModelListener {
        TimeSelectionListener() {
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            this.updateDescription();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            int n2;
            if (!listSelectionEvent.getValueIsAdjusting() && (n2 = TimeDayPanel.this.timeTable.getSelectedColumn()) == 0 && (n = TimeDayPanel.this.timeTable.getSelectedRow()) != -1) {
                TimeDayPanel.this.timeTable.setColumnSelectionInterval(1, 24);
                TimeDayPanel.this.timeTable.addRowSelectionInterval(n, n);
            }
            this.updateDescription();
        }

        void updateDescription() {
            String string = TimeDayPanel.i18n("daySelect");
            String string2 = TimeDayPanel.i18n("timeSelect");
            int[] nArray = TimeDayPanel.this.timeTable.getSelectedRows();
            StringBuffer stringBuffer = new StringBuffer();
            if (nArray.length > 0) {
                if (nArray.length == 1) {
                    stringBuffer.append(TimeDayPanel.this.toDayString(nArray[0]));
                } else {
                    stringBuffer.append(MessageFormat.format(string, TimeDayPanel.this.toDayString(nArray[0]), TimeDayPanel.this.toDayString(nArray[nArray.length - 1])));
                }
                int[] nArray2 = TimeDayPanel.this.timeTable.getSelectedColumns();
                if (nArray2.length > 0 && nArray2[0] > 0) {
                    stringBuffer.append(", ");
                    if (nArray2.length == 1) {
                        stringBuffer.append(TimeDayPanel.this.toHourString(nArray2[0] - 1, true));
                    } else {
                        stringBuffer.append(MessageFormat.format(string2, TimeDayPanel.this.toHourString(nArray2[0] - 1, true), TimeDayPanel.this.toHourString(nArray2[nArray2.length - 1], true)));
                    }
                }
            }
            TimeDayPanel.this.selectionLabel.setText(stringBuffer.toString());
        }
    }
}

