/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.IFramework;
import com.netscape.management.client.IResourceModel;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.StatusItemSecureMode;
import com.netscape.management.client.StatusItemSpacer;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.TopologyModel;
import com.netscape.management.client.topology.customview.ViewSelectorComponent;
import com.netscape.management.client.util.Browser;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingConstants;

class TopologyResourcePage
extends ResourcePage
implements SwingConstants {
    ConsoleInfo _info;
    String _globalParamDN;
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");
    static String _sTopologyResourcePage = "TopologyResourcePage";
    protected StatusItemSecureMode _statusSecureMode = new StatusItemSecureMode("StatusItemSecureMode");
    protected StatusItemSpacer _statusSpacer = new StatusItemSpacer("SECURE_MODE_SPACER");
    protected ViewSelectorComponent _viewSelectorComponent;
    private boolean canEditCustomViews = true;

    public TopologyResourcePage(ConsoleInfo consoleInfo, IResourceModel iResourceModel, boolean bl) {
        super(iResourceModel);
        this.canEditCustomViews = bl;
        this.setRootVisible(false);
        this._info = consoleInfo;
        this._tree.setLargeModel(true);
    }

    public void initialize(IFramework iFramework) {
        super.initialize(iFramework);
        if (this.canEditCustomViews) {
            this.addMenuItem("VIEW", new MenuItemText(_resource.getString(_sTopologyResourcePage, "customview"), "", new CustomViewActionListener()));
        }
        this._viewSelectorComponent.initialize(this._info);
        this.expandTreeRow(0);
        boolean bl = this._info.get("ldapSecurity").equals("on");
        this._statusSecureMode.setSecureMode(bl);
        this._statusSecureMode.setToolTipText((bl ? _resource.getString(_sTopologyResourcePage, "secure") + " ldaps" : _resource.getString(_sTopologyResourcePage, "unsecure") + " ldap") + "://" + this._info.getHost() + ":" + this._info.getPort());
    }

    public void refresh() {
        this._viewSelectorComponent.reloadViewList();
    }

    public Object clone() {
        return null;
    }

    public void startBrowser(String string) {
        Browser browser = new Browser();
        browser.open(string);
    }

    protected void populateStatusItems() {
        this._framework.addStatusItem((IStatusItem)this._statusSpacer, "LF");
        this._framework.addStatusItem((IStatusItem)this._statusSecureMode, "LF");
        super.populateStatusItems();
    }

    protected void unpopulateStatusItems() {
        super.unpopulateStatusItems();
        this._framework.removeStatusItem((IStatusItem)this._statusSecureMode);
        this._framework.removeStatusItem((IStatusItem)this._statusSpacer);
    }

    protected Component createTree(IResourceModel iResourceModel) {
        Component component;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._viewSelectorComponent = new ViewSelectorComponent(iResourceModel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this._viewSelectorComponent, gridBagConstraints);
        Component component2 = super.createTree(iResourceModel);
        if (component2 instanceof JScrollPane && (component = ((JScrollPane)component2).getViewport().getView()) != null && component instanceof JTree) {
            ((JComponent)component).getAccessibleContext().setAccessibleDescription(_resource.getString(_sTopologyResourcePage, "topologyTree_tt"));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        jPanel.add(component2, gridBagConstraints);
        this._viewSelectorComponent.addSelectionActionListener(new ViewChangeActionListener());
        return jPanel;
    }

    void setView(ResourceModel resourceModel) {
        if (resourceModel != null) {
            ResourceObject resourceObject = (ResourceObject)resourceModel.getRoot();
            TopologyModel topologyModel = (TopologyModel)this.getTreeModel();
            topologyModel.setRoot(resourceObject);
            this.setRootVisible(resourceModel.isRootVisible());
            topologyModel.refreshTree(this);
            this.selectTreeRow(0);
        }
    }

    class ViewChangeActionListener
    implements ActionListener {
        ViewChangeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TopologyResourcePage.this.setView((ResourceModel)TopologyResourcePage.this._viewSelectorComponent.getSelectedTreeModel());
        }
    }

    class CustomViewActionListener
    implements ActionListener {
        CustomViewActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TopologyResourcePage.this._viewSelectorComponent.showConfigDialog();
        }
    }
}

