/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.util.ArrowIcon;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class JButtonFactory {
    private static ResourceSet _resource = new ResourceSet("com.netscape.management.client.util.default");
    private static final JPanel _panel = new JPanel();
    private static final int _defaultWidth = 18;

    public static int getHeight(JButton jButton) {
        if (jButton == null) {
            return 0;
        }
        _panel.removeAll();
        JButton jButton2 = new JButton(jButton.getText());
        _panel.add(jButton2);
        _panel.doLayout();
        int n = jButton2.getHeight();
        Debug.println(9, "JButtonFactory: button height = " + n);
        return n;
    }

    public static int getWidth(JButton jButton) {
        if (jButton == null) {
            return 0;
        }
        _panel.removeAll();
        JButton jButton2 = new JButton(jButton.getText());
        _panel.add(jButton2);
        _panel.doLayout();
        int n = jButton2.getWidth();
        n = n + 18 - n % 18;
        Debug.println(9, "JButtonFactory: button width = " + n);
        return n;
    }

    public static JButton create(String string) {
        JButton jButton = new JButton(string);
        JButtonFactory.resize(jButton);
        return jButton;
    }

    public static JButton create(String string, ActionListener actionListener, String string2) {
        JButton jButton = JButtonFactory.create(string);
        jButton.addActionListener(actionListener);
        jButton.setActionCommand(string2);
        JButtonFactory.initializeMnemonic(jButton);
        return jButton;
    }

    public static JButton createDeleteButton(ActionListener actionListener) {
        JButton jButton = JButtonFactory.create(_resource.getString(null, "DeleteButtonLabel"));
        jButton.addActionListener(actionListener);
        jButton.setActionCommand("DELETE");
        jButton.registerKeyboardAction(actionListener, "DELETE", KeyStroke.getKeyStroke(27, 0), 0);
        JButtonFactory.initializeMnemonic(jButton);
        JButtonFactory.resize(jButton);
        return jButton;
    }

    public static JButton createCancelButton(ActionListener actionListener) {
        JButton jButton = JButtonFactory.create(_resource.getString(null, "CancelButtonLabel"));
        jButton.addActionListener(actionListener);
        jButton.setActionCommand("CANCEL");
        jButton.registerKeyboardAction(actionListener, "CANCEL", KeyStroke.getKeyStroke(27, 0), 0);
        JButtonFactory.resize(jButton);
        return jButton;
    }

    public static JButton createHelpButton(ActionListener actionListener) {
        JButton jButton = JButtonFactory.create(_resource.getString(null, "HelpButtonLabel"));
        jButton.addActionListener(actionListener);
        jButton.setActionCommand("HELP");
        jButton.registerKeyboardAction(actionListener, "HELP", KeyStroke.getKeyStroke(10, 0), 0);
        JButtonFactory.initializeMnemonic(jButton);
        JButtonFactory.resize(jButton);
        return jButton;
    }

    public static JButton createNoButton(ActionListener actionListener) {
        JButton jButton = JButtonFactory.create(_resource.getString(null, "NoButtonLabel"));
        jButton.addActionListener(actionListener);
        jButton.setActionCommand("NO");
        jButton.registerKeyboardAction(actionListener, "NO", KeyStroke.getKeyStroke(27, 0), 0);
        JButtonFactory.resize(jButton);
        return jButton;
    }

    public static JButton createYesButton(ActionListener actionListener) {
        JButton jButton = JButtonFactory.create(_resource.getString(null, "YesButtonLabel"));
        jButton.addActionListener(actionListener);
        jButton.setActionCommand("YES");
        jButton.registerKeyboardAction(actionListener, "YES", KeyStroke.getKeyStroke(10, 0), 0);
        JButtonFactory.resize(jButton);
        return jButton;
    }

    public static JButton createOKButton(ActionListener actionListener) {
        JButton jButton = JButtonFactory.create(_resource.getString(null, "OKButtonLabel"));
        jButton.addActionListener(actionListener);
        jButton.setActionCommand("OK");
        jButton.registerKeyboardAction(actionListener, "OK", KeyStroke.getKeyStroke(10, 0), 0);
        JButtonFactory.resize(jButton);
        return jButton;
    }

    public static JButton createCloseButton(ActionListener actionListener) {
        JButton jButton = JButtonFactory.create(_resource.getString(null, "CloseButtonLabel"));
        jButton.addActionListener(actionListener);
        jButton.setActionCommand("CLOSE");
        jButton.registerKeyboardAction(actionListener, "CLOSE", KeyStroke.getKeyStroke(10, 0), 0);
        JButtonFactory.initializeMnemonic(jButton);
        JButtonFactory.resize(jButton);
        return jButton;
    }

    public static JButton[] create(String[] stringArray) {
        if (stringArray.length == 0) {
            return null;
        }
        JButton[] jButtonArray = new JButton[stringArray.length];
        int n = 0;
        while (n < jButtonArray.length) {
            jButtonArray[n] = new JButton(stringArray[n]);
            ++n;
        }
        JButtonFactory.resize(jButtonArray);
        return jButtonArray;
    }

    public static void resize(JButton jButton) {
        if (jButton == null) {
            return;
        }
        int n = JButtonFactory.getWidth(jButton);
        int n2 = JButtonFactory.getHeight(jButton);
        Dimension dimension = new Dimension(n, n2);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
    }

    public static void resize(JButton[] jButtonArray) {
        if (jButtonArray.length == 0) {
            return;
        }
        int n = JButtonFactory.getWidth(jButtonArray[0]);
        int n2 = JButtonFactory.getHeight(jButtonArray[0]);
        int n3 = n;
        if (jButtonArray.length == 1) {
            JButton jButton = JButtonFactory.create(_resource.getString(null, "CancelButtonLabel"));
            n = JButtonFactory.getWidth(jButton);
            n2 = JButtonFactory.getHeight(jButton);
            n3 = n;
        }
        int n4 = 1;
        while (n4 < jButtonArray.length) {
            n = JButtonFactory.getWidth(jButtonArray[n4]);
            n3 = Math.max(n3, n);
            ++n4;
        }
        Dimension dimension = new Dimension(n3, n2);
        int n5 = 0;
        while (n5 < jButtonArray.length) {
            if (jButtonArray[n5] != null) {
                jButtonArray[n5].setPreferredSize(dimension);
                jButtonArray[n5].setMinimumSize(dimension);
            }
            ++n5;
        }
    }

    public static void resizeGroup(JButton jButton, JButton jButton2) {
        JButton[] jButtonArray = new JButton[]{jButton, jButton2};
        JButtonFactory.resize(jButtonArray);
    }

    public static void resizeGroup(JButton jButton, JButton jButton2, JButton jButton3) {
        JButton[] jButtonArray = new JButton[]{jButton, jButton2, jButton3};
        JButtonFactory.resize(jButtonArray);
    }

    public static void resizeGroup(JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4) {
        JButton[] jButtonArray = new JButton[]{jButton, jButton2, jButton3, jButton4};
        JButtonFactory.resize(jButtonArray);
    }

    public static void resize(JButton jButton, JButton jButton2) {
        if (jButton == null || jButton2 == null) {
            return;
        }
        Dimension dimension = jButton.getPreferredSize();
        jButton2.setPreferredSize(dimension);
        jButton2.setMinimumSize(dimension);
    }

    public static void resize(JButton jButton, JButton[] jButtonArray) {
        if (jButton == null) {
            return;
        }
        if (jButtonArray.length == 0) {
            return;
        }
        Dimension dimension = jButton.getPreferredSize();
        int n = 0;
        while (n < jButtonArray.length) {
            if (jButtonArray[n] != null) {
                jButtonArray[n].setPreferredSize(dimension);
                jButtonArray[n].setMinimumSize(dimension);
            }
            ++n;
        }
    }

    public static JButton createLeftArrowButton(String string, ActionListener actionListener, String string2) {
        JButton jButton = JButtonFactory.create(string);
        JButtonFactory.initArrowButton(jButton, 4, actionListener, string2);
        return jButton;
    }

    public static JButton createRightArrowButton(String string, ActionListener actionListener, String string2) {
        JButton jButton = JButtonFactory.create(string);
        JButtonFactory.initArrowButton(jButton, 2, actionListener, string2);
        return jButton;
    }

    public static void initArrowButton(JButton jButton, int n, ActionListener actionListener, String string) {
        jButton.setHorizontalTextPosition(n);
        if (n == 2) {
            jButton.setIcon(new ArrowIcon(ArrowIcon.EAST, 5));
        } else {
            jButton.setIcon(new ArrowIcon(ArrowIcon.WEST, 5));
        }
        jButton.addActionListener(actionListener);
        jButton.setActionCommand(string);
        JButtonFactory.initializeMnemonic(jButton);
    }

    public static void initializeMnemonic(JButton jButton) {
        String string = jButton.getText();
        char c = UITools.getMnemonic(string);
        if (c != '\u0000') {
            jButton.setText(UITools.getDisplayLabel(string));
            jButton.setMnemonic(c);
        }
    }
}

