/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.CommandLineCompiler;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.servlet.JasperLoader;

public class CommandLineContext
implements JspCompilationContext {
    String classPath;
    JspReader reader;
    ServletWriter writer;
    JasperLoader loader;
    boolean errPage;
    String jspFile;
    String servletClassName;
    String servletPackageName;
    String servletJavaFileName;
    String contentType;
    Options options;
    String uriBase;
    File uriRoot;
    boolean packageFlag;

    public CommandLineContext(JasperLoader jasperLoader, String string, String string2, String string3, String string4, boolean bl, Options options) throws JasperException {
        this.loader = jasperLoader;
        this.classPath = string;
        this.uriBase = string3;
        String string5 = string4;
        this.jspFile = string2;
        this.errPage = bl;
        this.options = options;
        if (this.uriBase == null) {
            this.uriBase = "/";
        } else if (this.uriBase.charAt(0) != '/') {
            this.uriBase = "/" + this.uriBase;
        }
        if (this.uriBase.charAt(this.uriBase.length() - 1) != '/') {
            this.uriBase = String.valueOf(this.uriBase) + '/';
        }
        if (string5 == null) {
            this.uriRoot = new File("");
        } else {
            this.uriRoot = new File(string5);
            if (!this.uriRoot.exists() || !this.uriRoot.isDirectory()) {
                throw new JasperException(Constants.getString("jsp.error.jspc.uriroot_not_dir"));
            }
        }
    }

    public void addJar(String string) throws IOException {
        this.loader.addJar(string);
    }

    public Compiler createCompiler() throws JasperException {
        CommandLineCompiler commandLineCompiler = new CommandLineCompiler(this);
        Class clazz = this.options.getJspCompilerPlugin();
        if (clazz != null) {
            JavaCompiler javaCompiler = null;
            try {
                javaCompiler = (JavaCompiler)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JasperException(Constants.getString("jsp.warning.compiler.class.cantcreate"));
            }
            String string = this.options.getJspCompilerPath();
            if (string != null) {
                javaCompiler.setCompilerPath(string);
            }
            commandLineCompiler.setJavaCompiler(javaCompiler);
        }
        return commandLineCompiler;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getClassPath() {
        return String.valueOf(this.loader.getClassPath()) + this.classPath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFullClassName() {
        String string = this.getServletPackageName();
        string = string != null ? String.valueOf(string) + "." : "";
        return String.valueOf(string) + this.getServletClassName();
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getOutputDir() {
        return this.options.getScratchDir().toString();
    }

    public boolean getPackageFlag() {
        return this.packageFlag;
    }

    public JspReader getReader() {
        return this.reader;
    }

    public String getRealPath(String string) {
        if ((string = this.resolveRelativeUri(string)).startsWith("/")) {
            string = string.substring(1);
        }
        File file = new File(this.uriRoot, string.replace('/', File.separatorChar));
        return file.getAbsolutePath();
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        try {
            inputStream = new FileInputStream(this.getRealPath(string));
        }
        catch (IOException iOException) {
            inputStream = null;
        }
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (IOException iOException) {
                inputStream = null;
            }
        }
        if (inputStream == null) {
            inputStream = this.loader.getResourceAsStream(string);
        }
        return inputStream;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public boolean isErrorPage() {
        return this.errPage;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public String resolveRelativeUri(String string) {
        if (string.startsWith("/")) {
            return string;
        }
        return String.valueOf(this.uriBase) + string;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setErrorPage(boolean bl) {
        this.errPage = bl;
    }

    public void setPackageFlag(boolean bl) {
        this.packageFlag = bl;
    }

    public void setReader(JspReader jspReader) {
        this.reader = jspReader;
    }

    public void setServletClassName(String string) {
        this.servletClassName = string;
    }

    public void setServletJavaFileName(String string) {
        this.servletJavaFileName = string;
    }

    public void setServletPackageName(String string) {
        this.servletPackageName = string;
    }

    public void setWriter(ServletWriter servletWriter) {
        this.writer = servletWriter;
    }
}

