/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.query.AttributeExp;
import javax.wbem.query.BinaryRelQueryExp;
import javax.wbem.query.DateTimeExp;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.NumericValue;
import javax.wbem.query.QualifiedAttributeExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.StringValueExp;
import javax.wbem.query.ValueExp;
import javax.wbem.query.WQLParser;

public class ProviderFilter {
    private CIMClass qClass;
    private String query = null;
    private String className;
    private SelectList slist;
    private List canList;
    private String sortProp;
    private int sortOrder;
    private ArrayList selectProps;
    private ArrayList whereProps;
    private boolean allSelected;

    public ProviderFilter(CIMClass cIMClass, String string) throws CIMException {
        this.qClass = cIMClass;
        this.query = string;
        this.slist = null;
        this.canList = null;
        this.sortProp = null;
        this.sortOrder = 0;
        this.selectProps = null;
        this.allSelected = true;
        this.parseQuery(string);
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getSelectedPropertyNames() {
        String[] stringArray = null;
        if (!this.allSelected && this.selectProps != null) {
            stringArray = new String[this.selectProps.size()];
            this.selectProps.toArray(stringArray);
        }
        return stringArray;
    }

    public String[] getPropertiesList() {
        String[] stringArray = null;
        if (!this.allSelected) {
            ArrayList arrayList = null;
            arrayList = this.selectProps != null ? (ArrayList)this.selectProps.clone() : new ArrayList();
            if (this.whereProps != null) {
                Iterator iterator = this.whereProps.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            if (arrayList.size() > 0) {
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
            }
        }
        return stringArray;
    }

    public boolean isAllSelected() {
        return this.allSelected;
    }

    public CIMProperty getSortProperty() {
        CIMProperty cIMProperty = null;
        if (this.sortProp != null) {
            cIMProperty = this.qClass.getProperty(this.sortProp);
        }
        return cIMProperty;
    }

    public boolean isSortAscending() {
        return this.sortOrder == 1;
    }

    public List getCanonicalWhere() {
        return this.canList;
    }

    public boolean apply(CIMInstance cIMInstance) throws CIMException {
        if (this.canList == null || this.canList.size() == 0) {
            return true;
        }
        boolean bl = false;
        Iterator iterator = this.canList.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            if (list == null || list.size() <= 0) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                bl = true;
                BinaryRelQueryExp binaryRelQueryExp = null;
                try {
                    binaryRelQueryExp = (BinaryRelQueryExp)iterator2.next();
                }
                catch (Exception exception) {
                    binaryRelQueryExp = null;
                }
                if (binaryRelQueryExp != null && binaryRelQueryExp.apply((CIMElement)cIMInstance)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public CIMInstance project(CIMInstance cIMInstance) throws CIMException {
        if (this.allSelected) {
            return cIMInstance;
        }
        return (CIMInstance)this.slist.apply((CIMElement)cIMInstance);
    }

    private void parseQuery(String string) throws CIMException {
        SelectExp selectExp = null;
        NonJoinExp nonJoinExp = null;
        QueryExp queryExp = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        try {
            selectExp = (SelectExp)wQLParser.querySpecification();
            this.slist = selectExp.getSelectList();
            nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            queryExp = selectExp.getWhereClause();
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_INVALID_QUERY");
        }
        this.setSelectedPropertyNames(this.slist);
        String string2 = null;
        QualifiedAttributeExp qualifiedAttributeExp = nonJoinExp.getAttribute();
        if (qualifiedAttributeExp != null) {
            string2 = qualifiedAttributeExp.getAttrClassName();
        }
        if (string2 == null) {
            throw new CIMException("CIM_ERR_INVALID_QUERY");
        }
        this.className = new String(string2);
        this.whereProps = new ArrayList();
        if (queryExp != null) {
            this.canList = queryExp.canonizeDOC();
        }
        if (this.canList != null && this.canList.size() > 0) {
            Iterator iterator = this.canList.iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                if (list != null && list.size() > 0) {
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        BinaryRelQueryExp binaryRelQueryExp = null;
                        try {
                            binaryRelQueryExp = (BinaryRelQueryExp)iterator2.next();
                        }
                        catch (Exception exception) {
                            binaryRelQueryExp = null;
                        }
                        if (binaryRelQueryExp != null) {
                            this.verifyExpression(binaryRelQueryExp);
                            continue;
                        }
                        throw new CIMException("CIM_ERR_INVALID_QUERY");
                    }
                    continue;
                }
                throw new CIMException("CIM_ERR_INVALID_QUERY");
            }
        }
        this.sortProp = null;
        this.sortOrder = 0;
    }

    private void verifyExpression(BinaryRelQueryExp binaryRelQueryExp) throws CIMException {
        ValueExp valueExp = binaryRelQueryExp.getLeftValue();
        ValueExp valueExp2 = binaryRelQueryExp.getRightValue();
        int n = binaryRelQueryExp.getOperator();
        String string = ((AttributeExp)valueExp).getAttributeName();
        CIMProperty cIMProperty = this.qClass.getProperty(string);
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)binaryRelQueryExp.toString());
        }
        this.whereProps.add(string);
        if (!(valueExp2 instanceof StringValueExp || valueExp2 instanceof NumericValue || valueExp2 instanceof DateTimeExp)) {
            throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)binaryRelQueryExp.toString());
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new CIMException("CIM_ERR_INVALID_QUERY", (Object)binaryRelQueryExp.toString());
            }
        }
    }

    private void setSelectedPropertyNames(SelectList selectList) {
        this.selectProps = null;
        this.allSelected = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (selectList != null) {
            Enumeration enumeration = selectList.elements();
            while (enumeration.hasMoreElements()) {
                AttributeExp attributeExp = (AttributeExp)enumeration.nextElement();
                String string = attributeExp.getAttributeName();
                if (string.equals("*")) {
                    this.allSelected = true;
                    continue;
                }
                arrayList.add(string);
            }
        }
        if (arrayList.size() == 0) {
            this.allSelected = true;
        }
        if (!this.allSelected) {
            this.selectProps = arrayList;
        }
    }
}

