/*
 * Decompiled with CFR 0.152.
 */
package sun.servlet.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import sun.servlet.http.HttpSessionImpl;

public class SessionContextImpl
implements HttpSessionContext {
    private int mSessionIdCounter = 0;
    private InetAddress mLocalHost;
    private byte[] mSessionIdTemplate;
    private static final char[] sBitChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5'};
    private static final int[] sSecondByteMasks;
    private Hashtable sessions = new Hashtable();

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 31;
        sSecondByteMasks = nArray;
    }

    public SessionContextImpl() {
        this.initializeSessionIdTemplate();
    }

    String convertSessionIdBytesToSessionId(byte[] byArray) {
        int n = byArray.length * 8;
        int n2 = n / 5;
        if (n2 % 5 != 0) {
            ++n2;
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < byArray.length) {
            int n6 = 0;
            if (n4 <= 3) {
                n6 = byArray[n3] >> 3 - n4 & 0x1F;
            } else {
                n6 = byArray[n3] << 5 - (8 - n4);
                if (n3 + 1 < byArray.length) {
                    int n7 = byArray[n3 + 1] >> 8 - (5 - (8 - n4));
                    n6 |= (n7 &= sSecondByteMasks[5 - (8 - n4)]);
                }
                n6 &= 0x1F;
            }
            cArray[n5++] = sBitChars[n6];
            if ((n4 += 5) < 8) continue;
            ++n3;
            n4 -= 8;
        }
        return new String(cArray);
    }

    String generateSessionId() {
        int n;
        byte[] byArray = new byte[this.mSessionIdTemplate.length];
        System.arraycopy(this.mSessionIdTemplate, 0, byArray, 0, this.mSessionIdTemplate.length);
        int n2 = 0;
        int n3 = n = this.generateSessionIdCount();
        long l = System.currentTimeMillis();
        n3 = n3 * 39 + (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        n3 = n3 * 39 + (int)(l & 0xFFFFFFFFFFFFFFFFL);
        byArray[n2++] = (byte)(n3 >> 24 & 0xFF);
        byArray[n2++] = (byte)(n3 >> 16 & 0xFF);
        byArray[n2++] = (byte)(n3 >> 8 & 0xFF);
        byArray[n2++] = (byte)(n3 & 0xFF);
        byArray[n2++] = (byte)(n >> 24 & 0xFF);
        byArray[n2++] = (byte)(n >> 16 & 0xFF);
        byArray[n2++] = (byte)(n >> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        return this.convertSessionIdBytesToSessionId(byArray);
    }

    synchronized int generateSessionIdCount() {
        return this.mSessionIdCounter++;
    }

    public Enumeration getIds() {
        return this.sessions.keys();
    }

    public InetAddress getLocalHost() {
        if (this.mLocalHost == null) {
            SessionContextImpl sessionContextImpl = this;
            synchronized (sessionContextImpl) {
                if (this.mLocalHost == null) {
                    try {
                        this.mLocalHost = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownHostException) {
                        try {
                            this.mLocalHost = InetAddress.getByName("127.0.0.1");
                        }
                        catch (UnknownHostException unknownHostException2) {}
                    }
                }
            }
        }
        return this.mLocalHost;
    }

    public HttpSession getSession(String string) {
        return (HttpSession)this.sessions.get(string);
    }

    protected void initializeSessionIdTemplate() {
        this.mSessionIdTemplate = new byte[14];
        int n = 8;
        byte[] byArray = this.getLocalHost().getAddress();
        System.arraycopy(byArray, 0, this.mSessionIdTemplate, n, 4);
        n += 4;
        int n2 = 0;
        this.mSessionIdTemplate[n++] = (byte)(n2 >> 8 & 0xFF);
        this.mSessionIdTemplate[n++] = (byte)(n2 & 0xFF);
    }

    public void removeSession(String string) {
        if (this.getSession(string) != null) {
            this.sessions.remove(string);
        }
    }

    public synchronized String setSession(HttpSessionImpl httpSessionImpl) {
        String string = this.generateSessionId();
        this.sessions.put(string, httpSessionImpl);
        return string;
    }
}

