/*
 * Decompiled with CFR 0.152.
 */
package sun.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import sun.servlet.util.Ascii;

public class HttpDate
extends Ascii {
    private static final String DATESTR = "Sun, 06 Nov 1994 08:49:37 GMT";
    public static final int DATELEN = "Sun, 06 Nov 1994 08:49:37 GMT".length();
    private static String datePattern = "EEE, dd MMM yyyyy HH:mm:ss z";
    private static Locale loc = Locale.US;
    private static TimeZone zone = TimeZone.getTimeZone("GMT");
    protected Calendar calendar = new GregorianCalendar(zone, loc);
    private SimpleDateFormat dformat = new SimpleDateFormat(datePattern, loc);

    public HttpDate() {
        this(System.currentTimeMillis());
    }

    public HttpDate(long l) {
        this.calendar.setTime(new Date(l));
        this.dformat.setTimeZone(zone);
    }

    public int getBytes(byte[] byArray, int n, int n2) {
        if (n2 < DATELEN) {
            throw new IllegalArgumentException("array too small");
        }
        String string = this.dformat.format(this.calendar.getTime());
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, byArray, n, DATELEN);
        return DATELEN;
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public long getTime() {
        return this.calendar.getTime().getTime();
    }

    public void parse(String string) {
        try {
            Date date = this.dformat.parse(string);
            this.calendar.setTime(date);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Date format invalid: " + string);
        }
    }

    public void parse(byte[] byArray, int n, int n2) {
        String string = new String(byArray, n, n2);
        this.parse(string);
    }

    public void setTime() {
        this.calendar.setTime(new Date(System.currentTimeMillis()));
    }

    public void setTime(long l) {
        this.calendar.setTime(new Date(l));
    }

    public String toString() {
        return this.dformat.format(this.calendar.getTime());
    }

    public void write(OutputStream outputStream) throws IOException {
        String string = this.dformat.format(this.calendar.getTime());
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }
}

