/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.recycle;

import org.apache.java.recycle.Controller;
import org.apache.java.recycle.Recyclable;
import org.apache.java.recycle.RecycleBin;
import org.apache.java.recycle.RecycleBinIsFull;

public class ControlledContainer
implements RecycleBin {
    private RecycleBin container;
    private Controller controller;

    public ControlledContainer(RecycleBin recycleBin, Controller controller) {
        this.container = recycleBin;
        this.controller = controller;
    }

    public Recyclable getRecyclable() {
        this.controller.down();
        return this.container.getRecyclable();
    }

    public int getSize() {
        return this.container.getSize();
    }

    public void recycle(Recyclable recyclable) {
        if (!this.controller.isThereRoomFor(recyclable)) {
            recyclable.destroy();
            throw new RecycleBinIsFull();
        }
        this.container.recycle(recyclable);
        this.controller.up();
    }
}

