*.
*.JEPP/LINK ACCESS SOFTWARE USER GUIDE - VERSION 1.2
*.
*.TABLE OF CONTENTS
*.=================
*.
*.INTRODUCTION
  ============

     Jepp/Link Access software is a helpful PC software interface to
     Jeppesen DataPlan's Jepp/Link service.  The Jepp/Link Access software
     consists of communications software, graphic weather map processors,
     tutorial, and the Jepp/Link user guides.

*.
*.GETTING STARTED
  ===============

*.1. HARDWARE/SOFTWARE REQUIREMENTS
  ---------------------------------

     The following hardware and software is required to use Jepp/Link
     Access software:

          IBM PC or AT class computer
          MS or PC DOS 2.0 and above
          256k of memory
          One of the following:  1)  two floppy drives
                                 2)  single floppy drive at least 720k
                                 3)  hard disk
          Hayes or compatible modem - models 300, 1200, or 2400

     To receive Jeppesen DataPlan's weather maps, additional hardware is
     required:

          Display black and white
              (raster based) maps:      Hercules, CGA, EGA, or VGA

          Display color (.pic format):  EGA or VGA
                                        512k memory

          Print maps:                   IBM ProPrinter, IBM Graphics,
                                        Epson MX, HP LaserJet series, or a
                                        printer which emulates one of the 
                                        above


     NOTE:  When using Jepp/Link, 300 and 1200 baud modems should be
            configured so that the carrier detect signal (CD) becomes
            active only after connection with a remote modem.  This
            feature is enabled by setting dip-switch 6 on Hayes modems in
            the OFF/UP/CLOSED position.  Other modems may use a different
            switch.  (See your modem manual for the proper setting.)  It
            should also be noted that when using an external modem, the
            serial cable must connect pins 2, 3, 7, and 8 (RD, TD, SG, and
            CD).

     You may configure your modem for the Level 4 MNP error correction
     protocol if the modem has that capability.

     NOTE:  IBM-PC, AT, PC-DOS, and ProPrinter are registered trademarks
            of International Business Machines, Inc.  MS-DOS is a registered
            trademark of Microsoft, Inc.  Epson and Epson MX are registered
            trademarks of Epson America, Inc.  HP and LaserJet are registered
            trademarks of Hewlett-Packard Company.  Hayes is a registered
            trademark of Hayes Microcomputer Products, Inc.  CompuServe is
            a registered trademark of CompuServe Incorporated and H&R
            Block, Inc.  Tymnet is a registered trademark of British
            Telecommunications PLC.  Other brand and product names may be
            trademarks or registered trademarks of their respective companies.

*.2. CONTENTS OF THE JEPP/LINK ACCESS DISKETTE
  --------------------------------------------

     Jepp/Link Access software is distributed on one 360k or 720k diskette 
     and contains Jepp/Link Access in compressed form.  The diskette
     must be LOADED and EXPANDED onto a hard disk, two floppies, or a
     single 720K diskette.  If expanded onto two diskettes, one should be
     labeled DOCUMENT/TUTORIAL and the other PROGRAM.

     The Jepp/Link Access DOCUMENT/TUTORIAL diskette contains an
     interactive tutorial, the Jepp/Link Service User Guide, the Jepp/Link
     Access Software User Guide, a file viewing utility called JLVIEW, 
     and a simple text file editor called JED.  To access the user guides 
     and the tutorial, type START and choose from the menu.  To view any 
     ASCII-based text file, enter JLVIEW at the system prompt followed 
     by the name of the file.

          Example:  JLVIEW START.BAT

     To edit any ASCII-based text file, enter JED at the system prompt
     followed by the name of the file.

          Example:  JED START.BAT

     The PROGRAM diskette contains the software to communicate with the
     Jepp/Link service.  To dial the Jepp/Link service, type START and
     choose JEPP/LINK from the menu.  Command line options for the Jepp/Link
     Access program are discussed later in this manual under "OPERATIONAL
     DETAILS".

*.3. INSTALLING JEPP/LINK ACCESS SOFTWARE
  ---------------------------------------

     THIS SECTION DUPLICATES THE INFORMATION IN "GETTING STARTED" AND IS
     FOR REFERENCE ONLY.

     If you have the hardware described above, follow these instructions
     to install the Jepp/Link Access software:

     STEP 1:  Determine how you will run Jepp/Link Access software, then
              follow the instructions which apply to your computer.

              A) TO RUN FROM A HARD DISK:

                 Create a new sub-directory on your hard disk named JEPP.
                 Copy the distribution diskette to that sub-directory.
                 The following example assumes drive c: is the destination
                 hard disk drive and the distribution diskette is loaded
                 in drive a:.  Type and enter:

                      md c:\JEPP
                      copy a:*.* c:\JEPP

                 Make the JEPP subdirectory current (type and enter cd\JEPP), 
                 type LOAD, and do as instructed.

              B) TO RUN FROM TWO 360k DISKETTE DRIVES:

                 Format three diskettes.

                      Label the first:      DOCUMENT/TUTORIAL
                      Label the second:     PROGRAM
                      Label the third:      DATA

                 Load the distribution diskette in drive a:, type LOAD at
                 the a: prompt, and do as instructed.

              C) TO RUN FROM A SINGLE DISKETTE (720K OR GREATER ONLY):

                 Format a single diskette.

                      Label the diskette:   DOCUMENT/TUTORIAL/PROGRAM

                 Copy the distribution diskette to the DOCUMENT/TUTORIAL/
                 PROGRAM diskette.


     NOTE:  Run Jepp/Link Access from your newly created and labeled
            diskette(s) or hard disk. PUT THE ORIGINAL DISTRIBUTION
            DISKETTE IN A SAFE PLACE!


     STEP 2:  Review the user guides and do the tutorial.

              Load your DOCUMENT/TUTORIAL or DOCUMENT/TUTORIAL/PROGRAM
              diskette in drive a: or, if Jepp/Link Access is on a hard
              disk, make the JEPP sub-directory current.  Type START at
              the DOS prompt.  The Jepp/Link Access main menu will be
              displayed.  Menu selections include:  GETTING STARTED,
              which duplicates this installation procedure and exists
              as READ.ME on disk; JEPP/LINK ACCESS SOFTWARE USER GUIDE
              and JEPP/LINK SERVICE USER GUIDE, both of which can be
              printed; and the JEPP/LINK TUTORIAL, an interactive
              offline introduction to the Jepp/Link service.  Although
              Jepp/Link is simple and straightforward, its features will
              be better understood after viewing the tutorial.


     STEP 3:  Run Jepp/Link Access Software.

              To run Jepp/Link Access software on a hard disk, type START
              at the DOS prompt and select JEPP/LINK at the menu.

              To run Jepp/Link Access software from a single diskette,
              follow the same procedure as the hard disk user, but execute
              the following DOS command before starting Jepp/Link Access:

                      assign b=a

              To run Jepp/Link Access software from two diskette drives,
              load the PROGRAM diskette in drive a: and the formatted
              diskette labeled DATA in drive b:.  Make drive a: current.
              Type START, then select JEPP/LINK from the menu.

     NOTE:  Jepp/Link Access software was written to run directly under
            DOS.  If you use a TSR-type (Terminate and Stay Resident) menuing
            system to execute Jepp/Link Access, results are unpredictable.  
            The first time you use the software (initialization), it is best 
            to run it directly under DOS.  Experiment only after successful 
            installation.


    STEP 4:   Jepp/Link Access Initialization

              The first time Jepp/Link Access is executed, it will
              configure itself automatically to your hardware (initialize).
              Before starting the initialization process, CONNECT AND TURN
              ON YOUR MODEM.  TURN OFF YOUR PRINTER.  You will be asked a
              number of questions about your hardware environment.
              Initialization may be ABORTED at any time by pressing the
              ESC key.  Once the system configuration has been written to
              disk, however, the results of the configuration can only be
              modified through the SYSTEM CONFIGURATION screen at the
              UTILITY MENU in Jepp/Link Access.

              The two problems most likely to occur are the inability of
              Jepp/Link Access to detect your modem and failure to have
              the dial-in phone numbers properly set.  These problems
              are discussed in detail under "OPERATIONAL DETAILS:
              INCOMPLETE INSTALLATION DUE TO MODEM NOT DETECTED" later 
              in this guide.

              Once installation is complete, select Item 1, JEPP/LINK,
              at the Jepp/Link Access main menu.  This connects you to
              Jeppesen DataPlan's Jepp/Link service.

     NOTE:  If you have the minimum graphic hardware requirements, you
            can display and/or print a sample map from the tutorial.
            Two-diskette users must load the DOCUMENT/TUTORIAL diskette
            in drive b:, place the PROGRAM diskette in drive a:, and
            run (execute) Jepp/Link Access.  Hard disk users simply 
            run Jepp/Link Access.


*.
*.FUNCTIONS/FEATURES
  ==================

     This section describes the functions of Jepp/Link Access menu
     selections.

*.1. JEPP/LINK
  ------------

     Choose Jepp/Link from the Jepp/Link Access menu to connect with
     Jeppesen DataPlan's on-line Jepp/Link service.

     Full communication diagnostic information is also provided.  When
     a Jepp/Link session is complete, Jepp/Link Access disconnects the
     phone.

*.2. OFFLINE WEATHER MAP DISPLAY/PRINT
  ------------------------------------

     Jepp/Link weather maps are automatically captured to disk so you can
     display and print them offline.

     Please see "HARDWARE/SOFTWARE REQUIREMENTS" for details on
     displaying and printing maps.

     NOTE:  Some maps may not entirely fill your display when they are
            downloaded.  OFFLINE WEATHER MAP DISPLAY automatically corrects
            map aspect ratios and should increase the quality of map
            displays.  Since printer resolution is superior to screen
            resolution, we recommend that maps be printed.

*.3. UTILITY MENU
  ---------------

     Utility functions are accessed through this menu selection.
     Function descriptions follow.

*.   1 - SYSTEM CONFIGURATION
     ------------------------

     SYSTEM CONFIGURATION allows you to alter your hardware configuration
     after INITIALIZATION has occurred.  Use this function when upgrading
     your modem or display hardware and when you wish to enter a phone
     number manually.

     NOTE:  If Jepp/Link Access is unable to locate your modem during
            initialization, you will be prompted for modem information
            or you can use SYSTEM CONFIGURATION to select your modem
            speed and communications port.

*.   2 - PHONE NUMBER SEARCH AND UPDATE
     ----------------------------------

     Given a local area code and an exchange prefix, Jepp/Link Access
     searches for a local phone number using on-line databases from two
     service providers (Tymnet and CompuServe).   Jepp/Link Access
     displays available numbers, and configuration file update occurs
     once you accept a number.  There are no phone charges associated
     with the on-line search.

*.   3 - 'ON THE ROAD' PHONE SEARCH
     ------------------------------

     This function is similar to PHONE NUMBER SEARCH AND UPDATE but
     displays all retrieved numbers, including local, long distance,
     1200, and 2400 baud.  'ON THE ROAD' does not update the configuration
     file.

*.   4 - RE-INITIALIZE JL ACCESS
     ---------------------------

     Jepp/Link Access software may be copied freely.  We recommend you
     RE-INITIALIZE the software before distributing it.  This cancels any
     changes you may have made on the command line and allows Jepp/Link
     Access to detect new hardware and search for new phone numbers.

*.
*.OPERATIONAL DETAILS
  ===================

*.1. OBTAINING HELP
  -----------------

     You can obtain information about the operation of Jepp/Link Access
     software from three sources:

     a. F1-HELP key - Press the F1 function key at any Jepp/Link Access
        prompt to receive additional information about that prompt.

     b. Reference the Table of Contents of this Jepp/Link Access Software
        User Guide.

     c. Contact Customer Service at (408)379-JEPP or (408)379-5377.

*.2. INCOMPLETE INSTALLATION DUE TO MODEM NOT DETECTED
  ----------------------------------------------------

     There are two reasons your modem may have not been detected by the
     software.  The first reason is that despite the claims of many
     manufacturers, NOT all Hayes-compatible modems are 100% compatible.  The
     second reason is that your modem may be configured as COM3 or COM4.

*.   A. HAYES-COMPATIBLE MODEMS
     --------------------------

     Many Hayes-compatible modems are in fact 95% or 96% compatible.  That is,
     they execute and return information from Hayes commands correctly most
     of the time, but not always.  It is entirely possible for the modem to
     work correctly as a Hayes modem but with some subtle nuances.  If,
     during installation, Jepp/Link Access fails to detect your Hayes-
     compatible modem, it is probably due to these nuances.  If your modem
     is in the 95%+ range, you may still be able to use Jepp/Link Access to
     connect with the Jepp/Link Service.

     If, during installation, your modem is turned ON, you receive an
     INFORMATIONAL message regarding the inability to detect your modem, and
     you were unable to complete the installation process by answering all
     the questions, we suggest the following procedure:

          1.  After installation is complete and you are at the Jepp/Link
              Access main menu, select SYSTEM CONFIGURATION under the
              UTILITY menu.  Enter the number for the modem you have
              (the highlighted bar should be on your modem type).  Then,
              enter the number for the serial port to which your modem is
              attached.  If you are not sure, try COM1 first and complete the
              configuration procedure.  If you do not get a connection using
              COM1, try COM2.  If your modem is configured as COM3 or COM4,
              see "MODEMS CONFIGURED AS COM3 OR COM4" for further
              information.

          2.  PRESS ESC and answer YES to update the configuration file.

          3.  Select PHONE SEARCH AND UPDATE and answer the questions.

          4.  Soon after the words "FIRST SERVICE" and a series of dots
              appear on the screen, you should hear your modem dialing and
              connecting.  If you do not hear dialing, if the number of
              dots never increases much past a count of four, or if a
              communication error is displayed, call Jepp/Link Customer
              Service for further assistance.

              Should the first communications service be unavailable, the
              software will automatically dial a SECOND SERVICE.  If you see
              more than four dots but do not hear dialing, your modem speaker
              may be turned off.  Let the software go completely through the
              second service before seeking further assistance.

              When a phone number is found, your modem will work correctly
              with Jepp/Link Access and you can proceed with Jepp/Link.

*.   B. MODEMS CONFIGURED AS COM3 OR COM4
     ------------------------------------

     Jepp/Link Access supports modems configured as COM3 or COM4.  When using
     COM3 or COM4, during installation you will receive a message stating
     that the Access software is unable to detect your modem.  You will
     need to modify the command line by entering more detailed information 
     about your modem configuration.  (See Section 6 - JEPP/LINK ACCESS 
     COMMAND LINE PARAMETERS for instructions.)

     After you have added the appropriate command line parameter for COM3
     or COM4, continue the installation process by completing the steps
     below:

          1.  At the main menu, select SYSTEM CONFIGURATION under the UTILITY
              menu.  If you have not entered your modem type do so now.
              Then, PRESS ESC and answer YES to update the configuration
              file.

          2.  Select PHONE SEARCH AND UPDATE and answer the questions.

          3.  Soon after the words "FIRST SERVICE" and a series of dots
              appear on the screen, you should hear your modem dialing and
              connecting.  If you do not hear dialing, if the number of
              dots never increases much past a count of four, or if a
              communication error is displayed, call Jepp/Link Customer
              Service for further assistance.

              Should the first communications service be unavailable, the
              software will automatically dial a SECOND SERVICE.  If you see
              more than four dots but do not hear dialing, your modem speaker
              may be turned off.  Let the software go completely through the
              second service before seeking further assistance.

              When a phone number is found, your modem will work correctly
              with Jepp/Link Access and you can proceed with Jepp/Link.

*.3. PHONE NUMBERS
  ----------------

     Jepp/Link Access maintains several phone numbers.  Some are
     semi-permanent, and some may be changed directly by the user.  The
     succeeding sections will explain how the software uses and constructs
     the phone number to dial.

*.   A. INITIALIZING
     ---------------

     During initialization, Jepp/Link Access looks for a local access phone
     number to connect to Jeppesen DataPlan's Jepp/Link service.

     If Jepp/Link Access is unable to find a local access number for your
     area, an 800 number is used.  Sometimes, due to changes by the
     providers of these local access connections (Tymnet and CompuServe),
     it may be necessary to search for a NEW local access number.  To do
     this, run PHONE SEARCH AND UPDATE at the UTILITY menu.  If the problem
     appears to be on a particular service, force Jepp/Link Access to
     check the SECOND SERVICE by rejecting the number found by the FIRST
     SERVICE.

     Jepp/Link Access provides help in this area by checking the number
     of continuous failures using a particular local phone number (it does
     not do this for the 800 number).  If three failures occur in a row,
     Jepp/Link Access displays a message suggesting you try the PHONE SEARCH
     AND UPDATE function.

*.   B. MANUAL INPUT AND TEMPORARY CHANGES
     -------------------------------------

     Sometimes you may want to change the phone number used to access
     Jepp/Link without using PHONE SEARCH AND UPDATE.  This and other
     options are described below.  Specifically, you can:

          1.  Change the number and access service directly.

          2.  Force Jepp/Link Access to ask for the number to dial before
              starting each session.  This might be appropriate when
              traveling and when using Jepp/Link Access with a portable PC.
              See 'ON THE ROAD' PHONE SEARCH for further help when
              traveling.

          3.  Force Jepp/Link Access to use the 800 number.

     To make these changes, select SYSTEM CONFIGURATION at the UTILITY
     menu.  At SYSTEM CONFIGURATION, select 41 and answer the questions.
     A few notes here may be helpful.  Do not include phone prefixes such
     as those used for business and long distance services, except when
     you enter the number manually at the start of each session.   When
     entering a number manually, Jepp/Link Access prompts you for "Datacom
     Service".  At this prompt, ALL NUMBERS must be entered, including
     business and long distance prefixes.  This is the ONLY time you will
     enter a prefix at the phone number prompt.  The last pre-stored number
     is not lost when the manual option is chosen.  When you are ready to
     use it again, enter SYSTEM CONFIGURATION, select 41, and request a
     "pre-stored phone number".  (See below for more on prefixes.)

*.   C. BUSINESS AND LONG DISTANCE PREFIXES
     --------------------------------------

     Phone numbers entered in SYSTEM CONFIGURATION should not include
     prefixes.  Jepp/Link Access maintains the prefixes separately from
     the phone numbers and adds them to the numbers as necessary.  If
     you set SYSTEM CONFIGURATION to enter a phone number manually,
     however, ALL NUMBERS, including prefixes, must be entered at the
     phone number prompt.

     Prefixes can be established at SYSTEM CONFIGURATION or at PHONE
     SEARCH AND UPDATE.

*.4. ENTERING LOGON ID AND/OR PASSWORD
  ------------------------------------

     Please refer to the Jepp/Link Service User Guide for a full
     discussion of logon ID and password.

     NOTE:  Each time you access Jepp/Link, you will be asked to enter 
            your logon ID and password.  To automate this procedure, 
            see "JEPP/LINK ACCESS COMMAND LINE PARAMETERS" for further
            information.

*.5. PORTABLE COMPUTERS AND JEPP/LINK ACCESS SOFTWARE
  ---------------------------------------------------

     Here are some notes regarding the use of the Jepp/Link software
     with portable computers:

          1.  While 'on the road', it is possible to use a phone number
              other than your normal home-based number.  See "MANUAL INPUT
              AND TEMPORARY CHANGES" and 'ON THE ROAD' PHONE SEARCH for
              further information.

          2.  Jepp/Link Access was written to work with a hard disk or
              two floppy drives.  Many portables have a single 720k (or
              greater) floppy drive.  If you are using DOS 3.0 or greater
              (earlier DOS versions do not support 720k+ drives), use the
              ASSIGN command to assign drive b: to drive a: before
              executing the software.  For example:

                      assign b=a


              This allows Jepp/Link Access to work with a single floppy
              drive.

     NOTE:  Do not use this technique on smaller-capacity drives since
            Jepp/Link Access will terminate processing when it runs out
            of disk space.

          3.  Some portables use a display type that only allows black
              and white "colors".  If your system is a black-and-white
              "color" system, see "JEPP/LINK ACCESS SOFTWARE COMMAND LINE
              PARAMETERS" for information on how to make the display more
              readable.  

*.6. JEPP/LINK ACCESS SOFTWARE COMMAND LINE PARAMETERS
  ----------------------------------------------------

     Jepp/Link Access supports a number of features which can be triggered
     through the use of command line parameters.  To set the command line
     parameters, we recommend you modify the JL command in the START.BAT
     file.  The JL command line in the START.BAT file can be edited by 
     entering JED START.BAT.  

     NOTE:  We have included a simple text file editor on the Jepp/Link 
            Access software disk called JED.  This editor will display the
            contents of the START.BAT file on the screen and allow you to 
            make changes.

     Four command line parameters are supported.  You may use any combination
     of parameters or none of the parameters, depending upon your needs.  The
     parameters may appear in any order on the command line.

     To modify the JL command line, locate the line containing "JL" which 
     follows the line that contains ":JLEXE".  Change the command line to 
     correspond to the examples below:
     
         
     logonID,password - Enter logon ID and password separated by a
          comma.  This enables Jepp/Link to use the command line
          information instead of asking you for the ID and password
          each time you log on to Jepp/Link.

     /bw - Use with two-color "color" displays (i.e. gas plasma portable
          displays).  Specify this parameter to receive a more readable
          display in Jepp/Link Access.  Do not use this parameter for
          pure monochrome displays.

     /g - This parameter immediately connects to the JEPP/LINK service.
          Combine it with "logonID,password" to begin dialing into
          Jepp/Link as soon as you enter the JL command.  If you use the
          START command, you will need to choose "START JEPP/LINK ACCESS"
          at the menu.

     
               Command line example: jl /g /bw 12345678,flyinghi

               This command line enables Jepp/Link Access to use the 
               two-color display scheme, enter the specified logon ID 
               and password, and start dialing into the Jepp/Link service.  


     /p - This parameter permits you to enter modem specific information 
          on the command line.  The parameter consists of five entries 
          as shown and described below:


            1   2   3   4   5 
            v   v   v   v   v
            
          /p3=0x3e8=13=0x20=5
            |   |   |   |   |
            |   |   |   |   - IRQ
            |   |   |   |
            |   |   |   - Address of 8259a interrupt controller
            |   |   |
            |   |   - Interrupt number
            |   |
            |   - COM port address (8250)
            |
            - COM port (1 - 16)


            1 - Specifies the COM port to use.  This number must be
                between 1 and 16 (decimal).

            2 - Specifies the address to be used by DOS for accessing the
                8250 chip's port.  Each port must have a unique address.

            3 - Specifies the interrupt number to use for this port.
                Interrupts 0x8 - 0xf are assigned to IRQ's 0 - 7.
                Interrupts 0x70 - 0x77 are assigned to IRQ's 8 - 15.

            4 - Specifies the address of the 8259a controller.  XT class
                computers have only one controller chip.  AT class have
                two controller chips.  Typically, the first controller chip
                has an address of 0x20 and references IRQ's 0 - 7.  The
                second controller chip has an address of 0xa0 and
                references IRQ's 8 - 15.

            5 - Specifies the IRQ number to be used by this port.  XT
                class machines normally have only IRQ's 0 - 7.  AT class
                machines normally have IRQ's 0 - 7 and 8 - 15.

     The entries are all required and may be specified as hexadecimal
     (hexadecimal entries are prefixed by 0x).  Please refer to your modem
     manual for the correct entries prior to making any changes.  Below are
     examples of command line parameters which include modem specific 
     information for COM3 or COM4:

                  /p3=0x3e8=12=0x20=4     Most common for COM3
                  /p3=0x3e8=13=0x20=5     Alternate for COM3
                  /p3=0x3e8=11=0x20=3     Alternate for COM3

                  /p4=0x2e8=11=0x20=3     Most common for COM4
                  /p4=0x2e8=15=0x20=7     Alternate for COM4
                  /p4=0x2e8=12=0x20=4     Alternate for COM4

     For more information regarding the format of the /p parameter, please
     contact Jepp/Link Customer Service.

*.7. ADDITIONAL FEATURES
  ----------------------

     There are a number of additional features in Jepp/Link Access.

*.   A. DEBUGGING COMMUNICATION PROBLEMS

     Press ALT-D prior to accessing the service to turn on the debug mode 
     during a communication session.  The primary reason for debugging a 
     session is to get low-level information about the connection/
     disconnection commands to Jeppesen DataPlan's Jepp/Link service.  If 
     you are familiar with ASCII coding on a PC, this may be beneficial in
     diagnosing a communications problem.  If you need further assistance,
     call Customer Service with the information presented on the screen.

     The following description of the screen output provides technical
     explanations:

     [Tx]  followed by data in reversed colors indicates data transmitted
           from the PC.

     [Rx]  followed by data in reversed colors indicates data received
           by the PC.

     [In]  followed by a statement is a description of an internal command
           generated by Jepp/Link Access.

     Since all Tx'd data is full-duplexed and echoed during communication,
     one should always see transmitted data returned with any command
     responses.  All characters, including carriage returns and linefeeds,
     are shown in their native ASCII representation.

*.   B. JEPP/LINK ACCESS SOFTWARE VERSION IDENTIFICATION

     Press ALT-V at the Jepp/Link Access menu to display the code version
     for approximately three seconds.  This may be useful when describing
     situations to Customer Service.

*.   C. MULTIPLE USER JEPP/LINK ACCESS SOFTWARE

     A switch can be set within Jepp/Link Access to facilitate a
     multiple-user turnkey environment.  If your FBO or flying club would
     would like to run Jepp/Link Access software in this fashion, contact
     Customer Service at (408)379-JEPP or (408)379-5377 for more
     information.

*.
*.GLOSSARY OF TERMS

Business Prefix - any dialing sequence required to get an outside phone
     line.  These prefixes are most often found in business offices
     using PBX systems.

COM1, COM2, COM3 and COM4 - the serial ports supported for access to the
     modem and the phone lines.

F1-HELP - the F1 function key on the PC's keyboard.   When using Jepp/Link
     Access, press F1 for additional information regarding the displayed
     prompt.

First Service/Second Service - the dial-up data communication services
     Jeppesen DataPlan uses to provide access to Jepp/Link through
     local access numbers.  "First Service" refers to CompuServe.
     "Second Service" refers to Tymnet.

Foreground/Background Maps - Color maps are split into two separate
     images.  The images are combined and presented together on your
     screen.  This minimizes transmission time.  The portion of the map
     resident on your hard drive or your PROGRAM disk is the "background".
     The portion of the color map downloaded from Jepp/Link contains only
     weather information and is called the "foreground".  Normally, only
     foreground maps are downloaded to the PC.  As additional weather maps
     are offered or background maps become outdated, new background maps
     will be available for downloading from the Jepp/Link service.
     Jepp/Link keeps you informed through the on-line bulletin of any need
     to update your background files.

Graphics Capable Printer - Currently, Jepp/Link Access supports specific
     IBM and EPSON dot matrix printers and HP LaserJet series printers
     (or printers which emulate them) for printing Jeppesen DataPlan's
     weather maps.  Unless you have one of these printers, you cannot
     print Jeppesen DataPlan's graphic weather maps.  Any standard LPT1-
     directed printer can print the non-graphic information.

Jepp/Link Access software - the 5 1/4" floppy distribution diskette
     containing the tutorial, the user guides, JLVIEW, JED, the graphics
     processors, and the communications program.

LPT1 - the standard IBM PC port for printers.  Jepp/Link Access directly
     supports only printers attached to LPT1.  LPT2 and above are not
     supported.

Modem - Modem stands for "MOdulate/DEModulate" and converts digital
     signals from the computer into analog signals on the phone line.
     Modems are required to facilitate computer communications over a
     phone line.  Jeppesen DataPlan has a modem at its end and the user
     must also have a modem.  Without a modem, access to Jepp/Link is
     impossible.

"*.pic" Image Maps - color graphic maps offered by Jeppesen DataPlan's
     Jepp/Link service.  Jepp/Link contains the routines to display and
     print these maps (EGA/VGA systems only).  When a color map is 
     printed, the exact image seen on the video display will be sent to
     the printer.  .pic is the format used to store the map image.  
     Many PC "Paint" packages can manipulate and print these .pic images.

Raster Image Maps - black and white graphic maps available through
     Jeppesen DataPlan's Jepp/Link service.  These maps can be displayed
     and/or printed using the required hardware.

Timeouts - Jepp/Link Access maintains a number of timeout variables.
     These include a timeout that determines whether a command response
     has occurred and a "deadman" timeout that disconnects a user
     who has not responded to a prompt from the mainframe:
     "*** WAITING FOR RESPONSE, PLEASE CONTINUE YOUR INPUT ***".

Tymnet/CompuServe PDN's - the dial-up data communication services used by
     Jeppesen DataPlan's Jepp/Link service for local access by users.
     PDN stands for "Public Data Network".

*.
*.ERROR DESCRIPTION AND RESOLUTION

error #   description/resolution

5    User err - initialization files bad.
     res:  JLLOG.??? probably corrupted.  Reinstall Jepp/Link Access.

9    Modem err - carrier detect signal lost during session.
     res:  Phone comm session was electronically interrupted while in
     Jepp/Link.  Redial and try again.

13   Modem err - no carrier signal detected.
     res:  Never got a carrier (required for communications).  Check
     modem, make sure it is ON, check connections, and try again.

14   Modem err - illegal HAYES modem command.
     res:  Should never occur unless JLLOG.??? edited or corrupted.
     Reinstall Jepp/Link Access.

16   Modem err - no dial tone from the phone.
     res:  Check modem/phone connections and try again.

17   Modem err - phone line busy.
     res:  Try again.

18   Modem err - no answer detected.
     res:  Jepp/Link or service connection probably out-of-order or
     wrong phone number.  Correct, and try again.

22   Sys timeout - while waiting for output.
     res:  Jepp/Link mainframe not responding within time period.
     Redial and try again.

23   Sys timeout - during logon process.
     res:  Comm service or Jepp/Link unavailable.  Try again later.

24   Sys timeout - no activity by user (deadman timeout).
     res:  Jepp/Link service has had no activity by the user for some
     time.  Session dropped.  Dial back in.

31   File err - unable to find correct JLLOG file.
     res:  Can't find needed comm file.  Must have been inadvertently
     deleted.  Reinstall Jepp/Link Access.

32   File err - no free space for non-graphic file.
     res:  No space left for JLDATA.OUT.  Correct and retry.

34   File err - can't open graphic/text map file.
     res:  Could not find necessary files to process map.  Probably
     deleted inadvertently.  Get another map from Jepp/Link.

36   Tx err - bad cksum, f=999 c=999, must re-request map!!
     res:  Indicates a transmitted map did not make it intact from
     the Jeppesen DataPlan mainframe, probably because of a "noisy"
     phone line.  This should only occur with colored maps.  Get another
     map from Jepp/Link.  If this continues, try a different phone number.

38   File err - io error, hardware or disk full.
     res:  Check for adequate disk space.  Correct and try
     again.

40   Hardware err - unexpected comm error, interrogate SCRERR.FIL.
     res:  Write down error number in message and any information found
     in the file SCRERR.FIL.  Call Customer Service.

42   Hardware err - specified datacomm port out of range.
     res:  Suspect corrupted JLSET.DAT.  Reinstall Jepp/Link.

43   Hardware err - datacomm port in use by another process.
     res:  Other software is already using this comm port.  Correct
     and retry.

45   Memory err - too little memory for comm buffers.
     res:  Not enough memory available to do communications.  Remove any
     memory resident routines, reboot system, and retry.

54   Hardware err - specified datacomm port not installed.
     res:  Specified COM port doesn't exist on this machine.  Change the
     port at the SYSTEM CONFIGURATION screen.

70   Video err - not enough memory for image.
     res:  Not enough memory to display map.  Remove any memory-resident
     routines, reboot system, and retry.

71   Video err - specified mode and hardware don't match.
     res:  Go into SYSTEM CONFIGURATION and correct.

73   File err - .pic file cannot be opened or found.
     res:  Unable to find color map image.  Get another map from Jepp/Link.

74   File err - file read error.
75   Video err - .pic file has bad header information.
78   Video err - .p file has bad block during decompress.
     res:  Corrupted .pic file.  Get another map from Jepp/Link.

76   Video err - map background needs to be updated.
     res:  Download a new background.  See errors 85-88.

77   Video err - foreground/background video modes are incompatible.
     res:  The two images of the color map are video-mode incompatible.
     Call Customer Service for assistance.

79   File err - .p file cannot be opened.
     res:  Interim .pic file missing.  Get another map from Jepp/Link.

80   File err - unable to open targeted .pic.
81   File err - io error or disk full - .p to .pic
84   File err - io error or disk full - .pic/.bic to .pic
     res:  Probably not enough space on disk.  Correct and retry.

82   File err - io error reading .p file.
     res:  Possible hardware problem.

83   File err - name of .p file bad.
     res:  Call Customer Service.

85   Video err - background file has bad data block.
86   File err - background .pic file cannot be opened or found.
87   File err - background file read error.
88   Video err - background .pic file has bad header information.
     res:  Color maps consist of two images (see glossary).  These errors
     indicate that a PC resident background map cannot be found or is
     corrupted.  To correct, find or reload the background file or
     download a new background file.

91   User err - bad JLLOG.FIL construction.
     res:  Comm file probably corrupted.  Reinstall Jepp/Link.

94   Modem err - not responding to command or bad configuration.
     res:  Corrupted comm file JLLOG.???.  Call Customer Service.

200  JL Access must be executed out of drive a: or a hard drive.
     res:  Correct and retry.

202  Can't OPEN the JLLOG communication command file.
     res:  Comm command file missing.  Reinstall Jepp/Link Access.

203  Can't OPEN internal file, check config.sys for FILES statement.
     res:  Out of file handles or out of disk space.  Correct and retry.

204  Can't OPEN map file.
     res:  Map file missing.  Get another map from Jepp/Link.

206  Unable to determine display hardware, set to Monochrome!!
     res:  If this is incorrect for your computer, go into SYSTEM
     CONFIGURATION and try setting it to what you think it should be.

207  Your hardware CAN'T support the DISPLAY or PRINT of maps!!!
     res:  Check the Jepp/Link user guides for the hardware required
     to display and print maps.

208  Modem and Port must be set first, see SYSTEM CONFIGURATION!!
     res:  Use SYSTEM CONFIGURATION to specify settings.
