
;
;                          TIMER FAST
;
;
;    This program demonstrates how to get interrupt control 
;    at frequency higher than the normal 18 times a second, by
;    speeding up system timer 0.  In this example, interrupts 
;    occur at 50 times normal, or 910 times per second.
;
;    (c) Copyright 1994  Frank van Gilluwe  All Rights Reserved.

include undocpc.inc

NEWRATE equ     50                 ; number of times to increase
                                   ;  the interrupt rate

cseg    segment para public
        assume  cs:cseg, ds:cseg, ss:tsrstk

countdown       dw      NEWRATE    ; countdown timer
old_int_8       dd      0          ; old pointer saved here
    
; 
; This is the resident handler for handling interrupt 8

int_8_hook    proc    far
        pushf

; code which occurs at fast rate inserted here in place
;   of demo_two_char

        call    demo_two_char      ; demo program


; Upon completion of the fast rate code call the old 
;   interrupt 8 routine ONLY at the original 18.2 times 
;   per second rate.

        dec     cs:[countdown]
        jnz     int_8_exit         
        mov     cs:[countdown], NEWRATE   ; reload counter
        popf
        jmp     cs:[old_int_8]     ; process old interrupt 8

int_8_exit:
        cli                        ; disable interrupts
        push    ax
        mov     al, 20h            ; end-of-interrupt command
        out     20h, al            ; issue command to controller
        pop     ax
        popf
        iret
int_8_hook    endp


;
; This demo program quickly alternates between the "/" character
;    and letters of the alphabet to give the visual appearance
;    of strike-through.  Any two characters could be 
;    "overlapped" using this routine.  Also notice three colors
;    appear in a single text cell (black, white and green).

democount       dw      0
demochar        db      'A'       ; character to display
SLASH_ATTRB     equ     0Fh       ; attribute, bright white
CHAR_ATTRB      equ     0Ah       ; attribute, green

demo_two_char   proc    near
        push    ax
        push    di
        push    es

        mov     ax, 40h
        mov     es, ax             ; point to BIOS memory area
        mov     ax, 0B800h         ; assume color text video area
        cmp     byte ptr es:[49h], 7  ; mono video mode ?
        jne     demo1              ; jump if not
        mov     ax, 0B000h         ; use monochrome segment
demo1:
        mov     es, ax             ; load screen segment
        mov     di, 79 * 2         ; point to end of first line
        mov     al, '/'            ; strike-through character
        mov     ah, SLASH_ATTRB    ; attribute
        test    cs:[democount], 1  ; toggle between chars
        jz      demo2              ;  depending on count 
        mov     al, cs:[demochar]
        mov     ah, CHAR_ATTRB     ; character attribute
demo2:
        cld
        stosw                      ; store AX to screen at es:[di]
        inc     cs:[democount]
        mov     ax, cs:[democount]
        cmp     ax, 182*(NEWRATE/10) ; 1 second elapsed ?
        jb      demo3              ; jump if not
        mov     cs:[democount], 0  ; reset democount
        inc     cs:[demochar]      ; use a different char
demo3:
        pop     es
        pop     di
        pop     ax
        ret
demo_two_char   endp



;===============================================================
; Start of non-resident installation portion

tmrfast proc    far

start:
        push    cs
        pop     ds

; get the current interrupt 8 vector and save
        
        mov     al, 8         
        mov     ah, 35h
        int     21h                ; get current int 8 pointer
        mov     word ptr old_int_8, bx
        mov     word ptr old_int_8+2, es

; install our new interrupt 8 routine

        mov     dx, offset int_8_hook
        mov     al, 8
        mov     ah, 25h
        int     21h                ; install our interrupt 

        OUTMSG  installmsg         ; display installed message

; now reset timer 0 to the faster rate

        cli                        ; disable interrupts
        mov     al, 36h            ; command for 16-bit, 
        out     43h, al            ;  mode 3, binary operation
        IODELAY
        mov     ax, 65532/NEWRATE  ; counter value
        out     40h, al            ; load timer 0 count LSB
        IODELAY
        mov     al, ah             ; get most significant byte
        out     40h, al            ; load timer 0 count MSB
        sti                        ; enable interrupts

; now determine the size to remain resident (paragraphs) 
;   and become a TSR

        mov     dx, (offset start - offset countdown) SHR 4
        add     dx, 11h            ; add PSP size + 1 paragraph
        mov     ax, 3100h          ; exit to DOS as tsr 
        int     21h
tmrfast endp


installmsg db   CR, LF
        db      'TIMER FAST Installed - Demonstrates fast '
        db      'interrupt 8 handler.', CR, LF
        db      '   Makes the top right corner of screen '
        db      'overlap two colors and characters.', CR, LF, '$'

cseg    ends


;==================================================== stack ====

tsrstk  segment para stack

        db      150 dup (0)

tsrstk  ends

        end     start




