



        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Command Shell Data Structures and Definitions          ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Real Time Dos Data Structure Definitions                     ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Data Structure Definitions                                   ;
        ;                                                               ;
        ;                                                               ;
        ;  (c) Copyright 1990, 1994. Api Software and Mike Podanoffsky  ;
        ;      All Rights Reserved Worldwide.                           ;
        ;                                                               ;
        ;  This product is protected under copyright laws and  may not  ;
        ;  be reproduced  in whole  or in part, in any form  or media,  ;
        ;  included but not limited to source listing, facimilie, data  ;
        ;  transmission, cd-rom, or  floppy disk without the expressed  ;
        ;  written consent of the author.                               ;
        ;                                                               ;
        ;  Licence for distribution in commercial use:                  ;
        ;                                                               ;
        ;  Api Software                                                 ;
        ;  12 South Walker Street                                       ;
        ;  Lowell,  MA   01851                                          ;
        ;                                                               ;
        ;  internet: mikep@world.std.com                                ;
        ;                                                               ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Switches                                                     ;
        ;...............................................................;

        SWITCHENTRY struc

swChar                          db ?
swFlags                         dw ?
swMinValue                      dw ?
swMaxValue                      dw ?
swActualValue                   dw ?

        SWITCHENTRY ends

SW_MINMAXVALUE                  equ 0001h
SW_LETTERCHOICE                 equ 0002h

SW_SWITCHSET                    equ 8000h
sizeSWITCHENTRY                 equ size SWITCHENTRY

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Sprintf flags                                                ;
        ;...............................................................;

SPRINTF_COMMADELIM              equ 8000h
SPRINTF_LONGFLAG                equ 4000h
SPRINTF_LEFTALIGN               equ 2000h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Internal Int21 Emulation call                                ;
        ;...............................................................;

Int21   macro arg1, arg2

    ifnb < arg2 >
      if ( arg1 GT 00ffh )
        mov ax, arg1 + arg2
        else
        mov ax, ( arg1 * 256 + arg2 )
        endif
        endif

    ifb < arg2 >
      if ( arg1 GT 00ffh )
        mov ax, arg1
        else
        mov ah, arg1
        endif
        endif

     ;; int 80h                                         ;** debug
        int 21h                                         ;** DOS
        endm

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Replace Macro                                                ;
        ;...............................................................;

Translate macro c1, c2, goto

        mov ah, c2
        cmp al, c1
        jz goto 
        endm

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Define Date/Time Template                                    ;
        ;...............................................................;

intldate macro country, template

        dw country
        db template, 0
        endm

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  For Argument List                                            ;
        ;...............................................................;

        FORARGS struc

forVarIdent                     dw ?
forVarLetter                    dw ?
forInArg                        dw ?
forInStartParen                 dw ?

        FORARGS ends

_IN                             equ 0
_DO                             equ 1

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Expanded Filename                                            ;
        ;...............................................................;

        EXPANDEDNAME struc

expDrive                        db   2 dup(?)
expPath                         db 129 dup(?)
expFilename                     db   9 dup(?)
expExtension                    db   5 dup(?)

        EXPANDEDNAME ends

sizeExpandedName                equ size EXPANDEDNAME

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Date Control Block                                           ;
        ;...............................................................;

        DATE struc

_DAY                            dw ?
_MONTH                          dw ?
_YEAR                           dw ?

        DATE ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Time Control Block                                           ;
        ;...............................................................;

        TIME struc

_HOURS                          dw ?
_MINUTES                        dw ?
_SECONDS                        dw ?
_HUNDREDTHS                     dw ?

        TIME ends

sizeDATE                        equ size DATE
sizeTIME                        equ size TIME        
        
