



        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Data Structures and Definitions                              ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Real Time Dos Data Structure Definitions                     ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Data Structure Definitions                                   ;
        ;                                                               ;
        ;                                                               ;
        ;  (c) Copyright 1990, 1994. Api Software and Mike Podanoffsky  ;
        ;      All Rights Reserved Worldwide.                           ;
        ;                                                               ;
        ;  This product is protected under copyright laws and  may not  ;
        ;  be reproduced  in whole  or in part, in any form  or media,  ;
        ;  included but not limited to source listing, facimilie, data  ;
        ;  transmission, cd-rom, or  floppy disk without the expressed  ;
        ;  written consent of the author.                               ;
        ;                                                               ;
        ;  Licence for distribution in commercial use:                  ;
        ;                                                               ;
        ;  Api Software                                                 ;
        ;  12 South Walker Street                                       ;
        ;  Lowell,  MA   01851                                          ;
        ;                                                               ;
        ;  internet: mikep@world.std.com                                ;
        ;                                                               ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Default Configuration Parameters                             ;
        ;...............................................................;

DEFAULT_FILES                   equ 8           ; MS DOS default is 8
DEFAULT_FCBS                    equ 4           ; MS DOS default is 4
DEFAULT_BUFFERS                 equ 10          ; MS DOS default is 2
DEFAULT_LASTDRIVE               equ 'E'         ; MS DOS default is e:
DEFAULT_FCBOPENMODE             equ 2           ; change only if you want read-only
DEFAULT_STACKS                  equ 9           ;

DEFAULT_MINENVIRONMENT          equ 400         ; bytes default environment space

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Max Configuration Parameters Allowable                       ;
        ;...............................................................;

        ;; max allowed values, not actual values

CONFIGMAX_FILES                 equ 255         ; MS DOS default is 8 (value is max allowed)
CONFIGMAX_BUFFERS               equ 99          ; MS DOS default is 2 (value is max allowed)
CONFIGMAX_FCBS_X                equ 255         ; MS DOS default is 4 (value is max allowed)
CONFIGMAX_FCBS_Y                equ 255         ; MS DOS default is 0 (value is max allowed)

CONFIGMIN_STACKS_X              equ  8          ; MS DOS default is 9
CONFIGMAX_STACKS_X              equ 64

CONFIGMIN_STACKS_Y              equ 32          ; MS DOS default is 128
CONFIGMAX_STACKS_Y              equ 512

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  DOS Functions                                                ;
        ;...............................................................;

ProgramTerminate                equ 00h         ; Program Terminate
KeyboardInput                   equ 01h         ; Keyboard Input
DisplayOutput                   equ 02h         ; Display Output
AuxInput                        equ 03h         ; Aux Input
AuxOutput                       equ 04h         ; Aux Output
PrinterOutput                   equ 05h         ; Printer Output
DirectConsole                   equ 06h         ; Direct Console
DirectConsoleInputNoEcho        equ 07h         ; Direct Console Input NoEcho
ConsoleInputNoEcho              equ 08h         ; Console Input NoEcho
DisplayString                   equ 09h         ; Display String
BufferedKeyboardInput           equ 0Ah         ; Buffered keyboard input
GetLine                         equ BufferedKeyboardInput
CheckKeyboardInput              equ 0Bh         ; Check keyboard input
ClearBufferedKeyboardInput      equ 0Ch         ; Clear Buffered keyboard input
DiskReset                       equ 0Dh         ; Disk reset
SelectDisk                      equ 0Eh         ; Select disk
OpenFileFCB                     equ 0Fh         ; Open file FCB
CloseFileFCB                    equ 10h         ; Close file FCB
SearchFirstFileFCB              equ 11h         ; Search first file FCB
SearchNextFileFCB               equ 12h         ; Search next file FCB
DeleteFileFCB                   equ 13h         ; Delete file FCB
SeqReadFileFCB                  equ 14h         ; Seq read file FCB
SeqWriteFileFCB                 equ 15h         ; Seq write file FCB
CreateFileFCB                   equ 16h         ; Create file FCB
RenameFileFCB                   equ 17h         ; Rename file FCB
CurrentDisk                     equ 19h         ; Current disk
SetDiskTransferAddress          equ 1Ah         ; Set disk transfer address
SetDTA                          equ SetDiskTransferAddress
GetDefaultDriveData             equ 1Bh         ; Get Default Drive Data
GetDriveData                    equ 1Ch         ; Get Drive Data
GetDefaultDriveParameterBlock   equ 1Fh         ; Get Default Drive Parameter Block
ReadFileFCB                     equ 21h         ; Read file FCB
WriteFileFCB                    equ 22h         ; Write file FCB
FileSizeFCB                     equ 23h         ; File size FCB
SetRelativeRecordFCB            equ 24h         ; Set relative record FCB
SetIntVector                    equ 25h         ; Set interrupt vector
CreateNewProgramSeg             equ 26h         ; Create new program seg
RandomBlockReadFCB              equ 27h         ; Random block read FCB
RandomBlockWriteFCB             equ 28h         ; Random block write FCB
ParseFilenameFCB                equ 29h         ; Parse filename FCB
GetDate                         equ 2Ah         ; Get date 
SetDate                         equ 2Bh         ; Set date
GetTime                         equ 2Ch         ; Get time
SetTime                         equ 2Dh         ; Set time
SetVerifySwitch                 equ 2Eh         ; Set verify switch
GetDiskTransferAddress          equ 2Fh         ; Get disk transfer address
GetDTA                          equ GetDiskTransferAddress
GetDOSVersion                   equ 30h         ; Get DOS version
TerminateStayResident           equ 31h         ; Terminate stay resident
GetDriveParameterBlock          equ 32h         ; Undocumented (Get Drive Parameter Block)
CtrlBreakCheck                  equ 33h         ; Ctrl break check
GetINDOSFlagAddress             equ 34h         ; Get INDOS Flag Address
GetIntVector                    equ 35h         ; Get interrupt vector
GetFreeDiskSpace                equ 36h         ; Get free disk space
GetSetSwitchChar                equ 37h         ; Get/set switch char
CountryDependentInfo            equ 38h         ; Country dependent info
CreateSubdirectory              equ 39h         ; Create subdirectory
RemoveSubdirectory              equ 3Ah         ; Remove subdirectory
ChangeSubdirectory              equ 3Bh         ; Change subdirectory
CreateFile                      equ 3Ch         ; Create file
OpenFile                        equ 3Dh         ; Open file
CloseFile                       equ 3Eh         ; Close file
ReadFile                        equ 3Fh         ; Read file
WriteFile                       equ 40h         ; Write file
DeleteFile                      equ 41h         ; Delete file
MoveFilePointer                 equ 42h         ; Move file pointer
ChangeFileMode                  equ 43h         ; Change file mode
IoControl                       equ 44h         ; Io Control
DuplicateFileHandle             equ 45h         ; Duplicate file handle
ForceFileHandle                 equ 46h         ; Force file handle
GetCurrentDirectory             equ 47h         ; Get current directory
AllocateMemory                  equ 48h         ; Allocate memory
FreeAllocatedMemory             equ 49h         ; Free allocated memory
ModifyAllocatedMemory           equ 4Ah         ; Modify allocated memory
ExecuteProgram                  equ 4Bh         ; ExecuteProgram
TerminateProcess                equ 4Ch         ; Terminate process
TerminateProgram                equ TerminateProcess
GetReturnCode                   equ 4Dh         ; Get return code
FindFirstFile                   equ 4Eh         ; Find first file
FindNextFile                    equ 4Fh         ; Find next file
SetPSPAddress                   equ 50h         ; Set PSP Address
GetPSPAddress                   equ 51h         ; Get PSP Address
GetDosDataTablePtr              equ 52h         ; Undocumented (Get DOS Data Table)
GetVerify                       equ 54h         ; Get verify
DuplicatePSP                    equ 55h         ; Duplicate PSP
RenameFile                      equ 56h         ; Rename file
SetFileDateTime                 equ 57h         ; Set file date time
GetAllocationStrategy           equ 5800h       ; Get allocation strategy
SetAllocationStrategy           equ 5801h       ; Set allocation strategy
GetExtendedError                equ 59h         ; Get extended error
CreateUniqueFile                equ 5Ah         ; Create unique file
CreateNewFile                   equ 5Bh         ; Create new file
LockFileAccess                  equ 5Ch         ; Lock file access
GetMachineName                  equ 5Eh         ; Get machine name
GetRedirectionList              equ 5Fh         ; Get redirection list
GetActualFileName               equ 60h         ; Undocumented (Get Actual FileName)
GetProgramSegmentPrefix         equ 62h         ; Get program segment prefix
CapitalizeFunctions             equ 65h         ; Country Dependent Capitalization
SetHandlesCount                 equ 67h         ;
CommitFile                      equ 68h         ;
GetDiskSerialNumber             equ 69h         ;
ExtendedOpenCreate              equ 6Ch         ;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Network Redirector (2F11) Functions                          ;
        ;...............................................................;

IFSInstallCheck                 equ 00h         ; Install Check
IFSRemoveDirectory              equ 01h         ; Remove Directory
IFSMakeDirectory                equ 03h         ; Make Directory
IFSChangeDirectory              equ 05h         ; Change Directory
IFSCloseFile                    equ 06h         ; Close File
IFSCommitFile                   equ 07h         ; Commit File
IFSReadFile                     equ 08h         ; Read File
IFSWriteFile                    equ 09h         ; Write File
IFSLockRegion                   equ 0Ah         ; Lock Region
IFSUnlockRegion                 equ 0Bh         ; Unlock Region
IFSGetDiskSpace                 equ 0Ch         ; Get Disk Space
IFSSetFileAttributes            equ 0Eh         ; Set File Attributes
IFSGetFileAttributes            equ 0Fh         ; Get File Attributes
IFSRenameFile                   equ 11h         ; Rename File
IFSDeleteFile                   equ 13h         ; Delete File
IFSOpenFile                     equ 16h         ; Open File
IFSCreateFile                   equ 17h         ; Create File
IFSFindFirst                    equ 1Bh         ; Find First
IFSFindNext                     equ 1Ch         ; Find Next
IFSCloseAllFiles                equ 1Dh         ; Close All Files
IFSSetRedirection               equ 1Eh         ; Set Redirection
IFSPrinterSetup                 equ 1Fh         ; Printer Setup
IFSFlushBuffers                 equ 20h         ; Flush Buffers
IFSSeekFromEnd                  equ 21h         ; Seek From End
IFSTerminateProcess             equ 22h         ; Terminate Process
IFSQualifyFilename              equ 23h         ; Qualify Filename
IFSPrinterMode                  equ 25h         ; Printer Mode
IFSPrinterOnOff                 equ 26h         ; Printer On/Off
IFSCopy                         equ 27h         ; Copy
IFSIOCTL                        equ 2Bh         ; IOCTL
IFSExpandedOpen                 equ 2Eh         ; Expanded Open/Create
IFSGetSegment                   equ 30h         ; Get NFS Segment

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Interrupt Definitions                                        ;
        ;...............................................................;

intTERMINATEAPP                 equ 22h         ; terminate app 
intCONTROLC                     equ 23h         ; control-c handler
intCRITICALERROR                equ 24h         ; critical error

intIDLELOOP                     equ 28h         ; let other applications run

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Standard I/O Definitions                                     ;
        ;...............................................................;

STDIN                           equ 00
STDOUT                          equ 01
STDERR                          equ 02
STDAUX                          equ 03
STDPRN                          equ 04

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Seek Definitions                                             ;
        ;...............................................................;

SEEK_BEG                        equ 00
SEEK_CUR                        equ 01
SEEK_END                        equ 02

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Open Modes                                                   ;
        ;...............................................................;

OPEN_ACCESS_READONLY            equ 00h
OPEN_ACCESS_WRITEONLY           equ 01h
OPEN_ACCESS_READWRITE           equ 02h
OPEN_ACCESS_NOINHERIT           equ 80h

OPEN_SHARE_COMPATABILITY        equ 00h
OPEN_SHARE_DENYREADWRITE        equ 10h
OPEN_SHARE_DENYREAD             equ 20h
OPEN_SHARE_DENYWRITE            equ 30h
OPEN_SHARE_DENYNONE             equ 40h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Extended Open / Create Actions                               ;
        ;...............................................................;

EXTENDEDACTION_CREATE           equ 0001h               ; fail if exists
EXTENDEDACTION_OPEN             equ 0010h
EXTENDEDACTION_TRUNCATE         equ 0020h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  FCB Parse                                                    ;
        ;...............................................................;

FCBPARSE_IGNORELEADSEPARATOR     equ 01
FCBPARSE_LEAVEDRIVEUNCHANGED     equ 02
FCBPARSE_LEAVEFILENAMEUNCHANGED  equ 04
FCBPARSE_LEAVEEXTENSIONUNCHANGED equ 08

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Control Check Definitions                                    ;
        ;...............................................................;

getControlC                     equ 00h         ; Get ControlC Check Flag                                ;
setControlC                     equ 01h         ; Set ControlC Check Flag                                ;
getStartupDrive                 equ 05h         ; Get Startup Drive                                      ;
getExtDosVersion                equ 06h         ; Get DOS Version                                        ;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Load and Exec Subfunctions                                   ;
        ;...............................................................;

execLoadAndExecute              equ 00h         ; load and execute
execLoadAndReturnDebug          equ 01h         ; load and return to debugger
execLoadOverlay                 equ 03h         ; load overlay
execSetExecuteMode              equ 05h         ; set execution mode

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Terminate Codes                                              ;
        ;...............................................................;

TERMINATE_NORMAL                equ 00h         ; process completed with a 4C 
TERMINATE_CONTROLC              equ 01h         ; process was cancelled
TERMINATE_DEVICEERROR           equ 02h         ; abort in device handler
TERMINATE_TSR                   equ 03h         ; terminated but stayed resident

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  65h Country Dependent Capitalization                         ;
        ;...............................................................;

_CapCharacter                   equ  20h        ; character capitalization
_CapLengthDefString             equ  21h        ; length defined string capitalization
_CapString                      equ  22h        ; ASCIZ capitalization
_CountryDepYesNo                equ  23h        ; does character represent Yes/No response
_CapFnCharacter                 equ 0A0h        ; filename character capitalization
_CapFnLengthDefString           equ 0A1h        ; filename length defined string capitalization
_CapFnString                    equ 0A2h        ; filename ASCIZ capitalization                    ;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Swappable Data Area Styles                                   ;
        ;...............................................................;

DOS3_SDASTYLE                   equ 0
DOS4_SDASTYLE                   equ 1
DOS5_SDASTYLE                   equ 1
DOS6_SDASTYLE                   equ 1

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Structure Definitions                                        ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Country Info                                                 ;
        ;...............................................................;

        COUNTRYINFO struc

intlDateFormat          db ?                    ; date format
intlCurrency            db  5 dup(?)            ; currency symbol (asciz)
intlThousands           db  2 dup(?)            ; thousands
intlDecimal             db  2 dup(?)            ; decimal 
intlDateSep             db  2 dup(?)            ; date
intlTimeSep             db  2 dup(?)            ; time
intlBitField            db  ?                   ; currency format (before or after)
intlCurrencyPlaces      db  ?                   ; places after decimal point
intlTimeFormat          db  ?                   ; 12-hour or 24-hour format
intlCaseMap             dd  ?                   ; address of case-mapping routine
intlDataSep             db  2 dup(?)            ; data-list ...
intlReserved            db 10 dup(?)            ; reserved

        COUNTRYINFO ends 

intlCurrency_MASK       equ 0001h
intlCurrencyPreceeds    equ 0
intlCurrencyFollows     equ 1

intlSpace_MASK          equ 0002h
intlNoSpaceinAmount     equ 0
intlSpaceinAmount       equ 1

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  File Name                                                    ;
        ;...............................................................;

        FILENAME struc

fnName                  db '????????'
fnExtension             db '???'

        FILENAME ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Directory Entries                                            ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;  See Functions                                                ;
        ;                                                               ;
        ;       _SearchFirstFileFCB           11h                       ;
        ;       _SearchNextFileFCB            12h                       ;
        ;...............................................................;

        DIRENTRY struc

deName                  db '????????'
deExtension             db '???'
deAttributes            db ?
deReserved              db 10 dup (?)
deTime                  dw ?                    ; Time Format
                                                ;   0 - 4 Two second intervals
                                                ;   5 -10 Minutes (0 - 59)
                                                ;  11 -15 Hours (0 - 23)

deDate                  dw ?                    ; Date Format
                                                ;   0 - 4 Day (1 - 31)
                                                ;   5 - 8 Month (1 - 12)
                                                ;   9 -15 Year since 1980

deStartCluster          dw ?
deFileSize              dd ?

        DIRENTRY ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Attribute bits
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ATTR_NORMAL             equ 00h
ATTR_READONLY           equ 01h
ATTR_HIDDEN             equ 02h
ATTR_SYSTEM             equ 04h
ATTR_VOLUME             equ 08h
ATTR_DIRECTORY          equ 10h
ATTR_ARCHIVE            equ 20h
ATTR_SETTABLE           equ (ATTR_READONLY + ATTR_HIDDEN + ATTR_SYSTEM + ATTR_ARCHIVE)
ATTR_MASK               equ 1Fh

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Special Characters
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DIRENTRY_NEVERUSED      equ 00h
SPECIAL_CHAR            equ 05h
DIRENTRY_DELETED        equ 0E5h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Find First/ Find Next                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;  See Functions                                                ;
        ;                                                               ;
        ;       _FindFirstFile           4Eh                            ;
        ;       _FindNextFile            4Fh                            ;
        ;...............................................................;

        FINDENTRY struc

findSrchDrive           db ?
findSrchName            db '????????'           ; name to search
findSrchExtension       db '???'
findSrchAttributes      db ?
findDirEntry            dw ?                    ; dir entry (;** Not Double !!)
findDirBegCluster       dw ?                    ; dir beg cluster
findDirCurrCluster      dw ?                    ; dir curr cluster
findCCBPointer          dw ?                    ; ccb pointer

findFileAttribute       db ?
findFileTime            dw ?
findFileDate            dw ?
findFileSize            dd ?
findFileName            db 13 dup (?)           ; null terminated name

        FINDENTRY ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  File Tables                                                  ;
        ;...............................................................;

        FT struc

nextFTPointer           dd ?
numberSFTEntries        dw ?

        FT ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  System File Tables                                           ;
        ;...............................................................;

        SFT struc

sftRefCount             dw ?
sftMode                 dw ?
sftFileAttrib           db ?
sftDevInfo              dw ?                    ; device info
sftDCB                  dd ?                    ; file DCB address or driver address
sftBegCluster           dw ?                    ; start address of file
sftTime                 dw ?
sftDate                 dw ?
sftFileSize             dd ?
sftFilePosition         dd ?
sftRelCluster           dw ?
sftCurCluster           dw ?                    ; 0000 if never read/ written
sftDirSector            dd ?                    ; dir sector containing entry
sftDirIndex             db ?                    ; used in search next
sftFileName             db '????????'
sftFileExtension        db '???'
sftShareSftPointer      dd ?                    ; points to other shared file
sftOwnerMachine         dw ?                    ; virtual machine id #
sftOwnerPSP             dw ?                    ; owner process
sftShareRecordPtr       dw ?                    ; share record pointer

        SFT ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Mode
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sftENTRY_ISFCB          equ 8000h               ; RxDOS specific
sftDENY_NONE            equ 0040h
sftDENY_READ            equ 0030h
sftDENY_WRITE           equ 0020h
sftEXCLUSIVE            equ 0010h
sftNET_FCB              equ 0070h
sftWRITE                equ 0001h
sftREAD                 equ 0000h

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  sftDevInfo
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

sftShared               equ 8000h
sftDateset              equ 4000h
sftIoctl                equ 4000h
sftNoInherit            equ 2000h
sftIsDevice             equ 0080h
sftWritten              equ 0040h
sftEof                  equ 0040h
sftBinary               equ 0020h
sftSpecial              equ 0010h
sftIsclock              equ 0008h
sftIsnul                equ 0004h
sftIsstdout             equ 0002h
sftIsstdin              equ 0001h
sftDrivemask            equ 003Fh

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  File Control Blocks                                          ;
        ;...............................................................;

        FCB struc

fcbDrive                db ?
fcbName                 db '????????'
fcbExtension            db '???'
fcbCurrBlockNo          dw ?
fcbRecordSize           dw ?
fcbFileSize             dd ?
fcbDate                 dw ?
fcbTime                 dw ?
fcbSFN                  db ?                    ; handle to sft system
fcbFlags                db ?                    ; modified flags
fcbDHD                  dd ?                    ; device header/DCB
fcbBegClusterNo         dw ?                    ; start of file cluster number
fcbCurrRecNo            db ?
fcbRandomRecNo          dd ?

        FCB ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Extended FCB Header                                          ;
        ;...............................................................;

        ExtendedFCBHdr struc

extSignature            db ?
                        db '?????'
extAttribute            db ?

        ExtendedFCBHdr ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Disk I/O Structure                                           ;
        ;...............................................................;

        DISKIO struc

diskioStartSector       dd ?                    ; sector number
diskioSectors           dw ?                    ; # sectors
diskioBuffer            dd ?                    ; buffer pointer

        DISKIO ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  System Access Control Block                                  ;
        ;...............................................................;

        DISKACCESS struc

diskAcDrive             dw ?                    ;*
diskAcBegCluster        dw ?                    ;* (cluster #)
diskAcFileSize          dd ?                    ;* file size in bytes
diskAcPosition          dd ?                    ;* read request (access position)
diskAcCurCluster        dw ?                    ;* (cluster #)
diskAcCurSector         dd ?                    ;  (LSN  #)
diskAcOffAtBegCluster   dd ?                    ;* (file offset )
diskAcOffAtBegBuffer    dd ?                    ;  (file offset )
diskAcBufferPtr         dd ?                    ;  dynamically assigned
diskAcOptions           dw ?                    ;  optimize options

        DISKACCESS ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Options
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DISKAC_OPTIMIZEDWRITE   equ 8000h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Directory Access Block                                       ;
        ;...............................................................;

        DIRACCESS struc

fileAcDrive             dw ?                    ; which drive file is located
fileAcCluster           dw ?                    ; which cluster file is located
fileAcDirCluster        dw ?                    ; which dir cluster
fileAcDirSector         dd ?                    ; which dir sector
fileAcDirOffset         dw ?                    ; offset in directory sector
fileAcBufferPtr         dd ?                    ; pointer to directory buffer
fileAcDevicePtr         dd ?                    ; if device, device driver address
fileAcNameOffset        dw ?                    ; offset in Expanded Name
fileAcExpandedName      db 128 dup (?)

        DIRACCESS ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Flags for file parsing
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

FILEIS_FCB              equ 0001h               ; file passed is an FCB
FILE_NODEVICENAME       equ 0002h               ; path may not contain a device name
FILEHAS_WILDCHARS       equ 0004h               ; path may contain wild characters
FILEHAS_NOFILENAME      equ 0008h               ; path may not contain filename
FILECANNOT_BEDEFINED    equ 0010h               ; filename must not exist
FILECANNOT_BEDIRECTORY  equ 0020h               ; filename cannot be directory
FILEMAY_EXIST           equ 0040h               ; file may exist (cluster not -1 )
FILE_ORDEVICE           equ 0000h               ; file or device must exist

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Std Character I/O Redirection Table                          ;
        ;...............................................................;

        STDREDIREC struc

stdDriverName           db '????????'           ; driver name
stdIOHandle             dw ?                    ; handle assigned, if any
stdDevInfo              dw ?                    ; device assign bits

        STDREDIREC ends

stdRedirec_Aux          equ 0
stdRedirec_Con          equ 1
stdRedirec_Prn          equ 2

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Drive Parameter Block                                        ;
        ;...............................................................;

        DPB struc

_dpbDrive               db ?
_dpbUnit                db ?
_dpbBytesPerSector      dw ?
_dpbClusterSizeMask     db ?
_dpbClusterSizeShift    db ?
_dpbFirstFAT            dw ?
_dpbNumCopiesFAT        db ?
_dpbMaxAllocRootDir     dw ?
_dpbFirstDataSector     dw ?
_dpbMaxClusterNumber    dw ?

_dpbSectorsPerFat       dw ?                    ; in DOS ver 5 this became a word
_dpbFirstDirSector      dw ?
_dpbptrDeviceDriver     dd ?
_dpbMediaDescriptor     db ?
_dpbAccessFlag          db ?                    ; -1 if must be rebuilt
_dpbNextDPB             dd ?
_dpbNextFree            dw ?                    ; cluster where to search for next free
_dpbFreeCount           dw ?                    ; number of free clusters remaining

        DPB ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  BIOS Parameter Block                                         ;
        ;...............................................................;

        BPB struc

_bpbBytesPerSector      dw ?
_bpbSectorsPerCluster   db ?
_bpbResSectors          dw ?
_bpbNumCopiesFAT        db ?
_bpbMaxAllocRootDir     dw ?
_bpbMaxSectors          dw ?                    ; if zero, see huge sectors
_bpbMediaDescriptor     db ?
_bpbSectorsPerFat       dw ?
_bpbSectorsPerTrack     dw ?
_bpbHeads               dw ?
_bpbHiddenSectors       dd ?
_bpbHugeSectors         dd ?

        BPB ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Boot Sector Parameter Block                                  ;
        ;...............................................................;

        BOOTSECTOR struc

_bsJump                 db 3 dup(?)
_bsOemName              db 8 dup(?)
_bsBytesPerSector       dw ?                    ; (start of BPB)
_bsSectorsPerCluster    db ?
_bsResSectors           dw ?
_bsNumCopiesFAT         db ?
_bsMaxAllocRootDir      dw ?
_bsMaxSectors           dw ?                    ; if zero, see huge sectors
_bsMediaDescriptor      db ?
_bsSectorsPerFat        dw ?
_bsSectorsPerTrack      dw ?
_bsHeads                dw ?
_bsHiddenSectors        dd ?
_bsHugeSectors          dd ?                    ; (end of BPB)

_bsDriveNumber          db ?
                        db ?
_bsBootSignature        db ?                    ; 29h if extended boot sector
_bsVolumeId             dd ?
_bsVolumeLabel          db 11 dup(?)            ; not same as DOS Volume Id
_bsFileSystemType       db 8 dup(?)

        BOOTSECTOR ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Partition Table Record                                       ;
        ;...............................................................;

        PARTITION struc

_ptBootable             db ?                    ; 80h = bootable, 00h = nonbootable
_ptBeginHead            db ?                    ; begin head address
_ptBeginSector          db ?                    ; begin sector address
_ptBeginCylinder        db ?                    ; begin cylinder address
_ptFileSystemName       db ?                    ; file system identifier (see below)
_ptEndHead              db ?                    ; end head address
_ptEndSector            db ?                    ; end sector address
_ptEndCylinder          db ?                    ; end cylinder address
_ptStartSector          dd ?                    ; start sector (relative to beg of disk)
_ptSectors              dd ?                    ; number of sectors in partition

        PARTITION ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;  File System ID Codes
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

FILESYSID_12FAT         equ 01h                 ; 12-bit FAT (max 10 MBytes)
FILESYSID_16FAT         equ 04h                 ; 16-bit FAT (max 32 MBytes)
FILESYSID_EXTENDED      equ 05h                 ; Extended DOS partition
FILESYSID_LARGE16FAT    equ 06h                 ; 16-bit FAT (greater than 32 MBytes)

RxDOS_PARTITIONSIGNATURE equ 0AA55h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Parameter Block                                       ;
        ;...............................................................;

        DEVPB struc

_dpSpecialFunc          db ?
_dpDevType              db ?                    ; device type
_dpDevAttr              dw ?                    ; device attributes
_dpCylinders            dw ?                    ; number of cylinders
_dpMediaType            db ?                    ; media type

      ; always followed by a BPB

        DEVPB ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Current Directory Entries                                    ;
        ;...............................................................;

        CDS struc

_cdsActualDirectory     db 67 dup (?)           ; asciz name
_cdsFlags               dw ?
_cdsPtrToDPB            dd ?
_cdsStartClusterDir     dw ?                    ; 
                        dw ?                    ; padding for network record
_cdsNetwParameter       dw ?                    ; padding for network record
_cdsNonSubstOffset      dw ?

                        db ?                    ; compatability byte
_cdsPtrtoIFSDriver      dd ?
                        dw ?                    ; compatability word

        CDS ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Redirection for IFS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_cdsRedirectIFSPtr      equ _cdsStartClusterDir

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Flags
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_CDS_NETWORKEDDRIVE     equ 8000h
_CDS_PHYSICALDRIVE      equ 4000h
_CDS_JOINEDDRIVE        equ 2000h
_CDS_SUBSTDRIVE         equ 1000h
_CDS_NONETLISTING       equ 0080h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Memory Management Blocks                                     ;
        ;...............................................................;

        MEMBLOCK struc

_memSignature           db ?                    ; always 4D
_memParent              dw ?                    ; seg address of owner
_memAlloc               dw ?                    ; allocated size
_memReserved            db '???'
_memPgmName             db 8 dup (?)            ; program name or null

        MEMBLOCK ends

_RxDOS_MEMSIGNATURE     equ 4Dh
_RxDOS_ENDSIGNATURE     equ 5Ah
_RxDOS_PARENT_SIGNATURE equ 0008h               ; mem parent signature
_RxDOS_FREE_MEMBLOCK    equ 0000h               ; mem block is free
_RxDOS_HIGHMEMBLOCK     equ 0A000h - 1          ; start mem block for high mem

_MIN_RxDOS_ALLOC_PARAS  equ 2

_MEM_FIRSTFIT_STRATEGY  equ 0003h               ; masks for allocation test
_MEM_BESTFIT_STRATEGY   equ 0001h
_MEM_LASTFIT_STRATEGY   equ 0002h

_MEM_FIRSTFIT_LOW       equ 0000h		; strategy requests
_MEM_BESTFIT_LOW        equ 0001h
_MEM_LASTFIT_LOW        equ 0002h

_MEM_FIRSTFIT_HIGH      equ 0080h
_MEM_BESTFIT_HIGH       equ 0081h
_MEM_LASTFIT_HIGH       equ 0082h

_MEM_FIRSTFIT_HIGHONLY  equ 0040h
_MEM_BESTFIT_HIGHONLY   equ 0041h
_MEM_LASTFIT_HIGHONLY   equ 0042h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Buffers (Cache) Block                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Compatability note:                                          ;
        ;                                                               ;
        ;  This buffer's definition is slightly different from MSDOS    ;
        ;  but appears to function in exactly the same way.             ;
        ;                                                               ;
        ;...............................................................;

        CCB struc

ccbNext                 dw ?                    ; next cache control block 
ccbPrev                 dw ?                    ; prev cache control block 
ccbDrive                db ?                    ; drive
ccbStatus               db ?                    ; status flags
ccbLBN                  dd ?                    ; block number (sector)
ccbNumCopies            db ?                    ; number of FAT copies (*)
ccbSectorOffsets        dw ?                    ; offset between FAT sectors (*)
ccbDPB                  dd ?                    ; pointer to drive parameter block
ccbCount                dw ?                    ; count if remote
ccbSFTIdent             db ?                    ; system sft Handle
ccbData                 db 512 dup ( ? )        ; data
                                                ; (*) unused by RxDOS

        CCB ends

ccbChecksum             equ ccbSectorOffsets    ; checksum protection

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Flags
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

ccb_isFAT               equ 02h
ccb_isDIR               equ 04h
ccb_isDATA              equ 08h
ccb_isVALID             equ 20h                 ; contains valid data 
ccb_isDIRTY             equ 40h
ccb_isREMOTE            equ 80h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Program Segment Prefix (PSP)                                 ;
        ;...............................................................;

        PSP struc

pspInt20                dw ?                    ; Int 20 instruction
pspNextParagraph        dw ?                    ; seg address of next paragraph
                        db ?                    ; not used
pspDispatcher           db   5 dup ( ? )        ; long call to MS-DOS
pspTerminateVect        dd ?                    ; Terminate Vector (Int 22h)
pspControlCVect         dd ?                    ; Control-C Vector (Int 23h)
pspCritErrorVect        dd ?                    ; CritError Vector (Int 24h)
pspParentId             dw ?                    ; PSP seg of parent
pspHandleTable          db  20 dup ( ? )        ; Allocated Handle Table
pspEnvironment          dw ?                    ; seg address of environment block
pspUserStack            dd ?                    ; user stack
pspFileHandleCount      dw ?                    ; handles allocated
pspFileHandlePtr        dd ?                    ; pointer to handle table
pspShareChain           dd ?                    ; Share chain pointer
                        db   4 dup ( ? )        ; unused
pspVersion              dw ?                    ; Major, Minor version (VERS)
                        db  14 dup ( ? )        ; unused
pspDosCall              db   3 dup ( ? )        ; int 21/ retf
                        db   9 dup ( ? )        ; unused
pspFCB_1                db  16 dup ( ? )        ; FCB 1
pspFCB_2                db  16 dup ( ? )        ; FCB 2
                        db   4 dup ( ? )
pspCommandTail          db 128 dup ( ? )        ; command tail (also default DTA )

        PSP ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Exe File Header                                              ;
        ;...............................................................;

        EXEHEADER struc

exeSignature            dw ?                    ; .EXE file signature
exeExtraBytes           dw ?                    ; number of bytes in last partial page
exePages                dw ?                    ; number of whole and partial pages
exeRelocItems           dw ?                    ; number of pointers in reloc table
exeHeaderSize           dw ?                    ; size of header, in paragraphs
exeMinAlloc             dw ?                    ; minimum allocation (parag)
exeMaxAlloc             dw ?                    ; maximum allocation (parag)
exeInitSS               dw ?                    ; initial ss value
exeInitSP               dw ?                    ; initial sp value
exeChecksum             dw ?                    ; complemented checksum
exeInitIP               dw ?                    ; initial ip value
exeInitCS               dw ?                    ; initial cs value
exeRelocTable           dw ?                    ; byte offset to reloc table
exeOverlay              dw ?                    ; overlay number
                        dw 16 dup( ? )          ; reserved (unused)
exeNewExe               dd ?                    ; pointer to new EXE header

        EXEHEADER ends

EXE_SIGNATURE           equ 5A4DH               ; 'MZ'

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Execution State                                              ;
        ;...............................................................;

        EXECSTATE struc
                        dw ?
execFlags               dw ?
execProgName            dd ?
execPSP                 dw ?
execStartAddr           dd ?
execProgSize            dd ?

        EXECSTATE ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Load and Execute                                             ;
        ;...............................................................;

        EXEC struc

lexecEnvironment         dw ?
lexecCommandTail         dd ?
lexecFCB_1               dd ?
lexecFCB_2               dd ?

        EXEC ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Load Program                                                 ;
        ;...............................................................;

        LOADPROG struc

lprogEnvironment         dw ?
lprogCommandTail         dd ?
lprogFCB_1               dd ?
lprogFCB_2               dd ?
lprogSSSP                dd ?                   ; starting stack address
lprogCSIP                dd ?                   ; starting code address

        LOADPROG ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Load Overlay                                                 ;
        ;...............................................................;

        LOADOVERLAY struc

loverSegLoadAddress      dw ?
loverRelocFactor         dw ?                   ; .EXE files only

        LOADOVERLAY ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Get Buffered Input Line Structure                            ;
        ;...............................................................;

        BUFLINE struc

bufMaxLength            db ?                    ; max bytes
bufActualLength         db ?                    ; actual bytes read
bufData                 db 128 dup(?)           ; actual bytes (any length)

        BUFLINE ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Line Editor Structure                                        ;
        ;...............................................................;

        LINEEDITOR struc

editCursor              dw ?                    ; cursor offset
editMaxAvail            dw ?                    ; max characters in buffer
editMaxBuffer           dw ?                    ; max characters allowed
editFlags               dw ?                    ; flags
editPhysCursorRow       db ?                    ; beg of edit phys cursor pos
editPhysCursorCol       db ?                    ; beg of edit phys cursor pos
editBufPointer          dd ?                    ; pointer to client buffer

        LINEEDITOR ends

editInsertFlag          equ 8000h               ; insert mode
editSearchFlag          equ 4000h               ; search mode

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Clock Data                                                   ;
        ;...............................................................;

        CLOCKDATA struc

cl_daysSince            dw ?                    ; since Jan 1
cl_minutes              db ?
cl_hours                db ?
cl_hseconds             db ?
cl_seconds              db ?

        CLOCKDATA ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  DOS Error Messages                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  All error messages are defined here.                         ;
        ;                                                               ;
        ;                                                               ;
        ;...............................................................;

errInvalidFunction      equ 0001h
errFileNotFound         equ 0002h
errPathNotFound         equ 0003h
errIllegalName          equ ( errPathNotFound )

errNoHandlesAvailable   equ 0004h
errAccessDenied         equ 0005h
errInvalidHandle        equ 0006h
errArenaTrashed         equ 0007h
errNotEnoughMemory      equ 0008h
errInvalidBlock         equ 0009h

errInvalidAccess        equ 000Ch
errInvalidDrive         equ 000Fh
errCurrentDirectory     equ 0010h

errFCBSizeTooLarge      equ 0002h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Critical Error Flags                                         ;
        ;...............................................................;

CRITERROR_IGNORE        equ 00
CRITERROR_RETRY         equ 01
CRITERROR_TERMINATE     equ 02
CRITERROR_FAIL          equ 03

CRITERROR_IGNOREALLOWED equ 0008h               ; ignore allowed bit
CRITERROR_RETRYALLOWED  equ 0010h               ; retry allowed bit
CRITERROR_FAILALLOWED   equ 0020h               ; fail allowed bit

CRITERROR_STDRETRIES    equ 03                  ; retry three times.

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  BIOS Parameters                                              ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  These definitions are part of the common BIOS access area    ;
        ;  at seg 40:xxxx                                               ;
        ;                                                               ;
        ;...............................................................;

_BIOS_Memory            equ 0013h
_BIOS_KeyboardFlags     equ 0017h
_BIOS_BreakFlag         equ 0071h
_BIOS_NumFixedDrives    equ 0075h

_BIOS_KB_NumLock        equ 20h                 ; used to set/ alter numlock in init
_BIOS_BREAK_STATE       equ 80h                 ; used to detect Break state

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  SYSINIT Parameters                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  These parameters are passed between rxdosbio.com and rxdos   ;
        ;  at startup.                                                  ;
        ;                                                               ;
        ;...............................................................;

        SYSINIT struc

initBootDrive           db ?                    ; unit code
initTotalDrives         db ?                    ; detected by IO.SYS
initLowMemSegment       dw ?                    ; low memory segment
initMemParagraphs       dw ?                    ; memory size
initDeviceChain         dd ?

initRelocHighBegAddress dd ?
initRelocHighSize       dw ?                    ; bytes to relocate
initRelocHighNotify     dw ?                    ; call back function address

initRelocLowBegAddress  dd ?                    ; only used if IO.SYS reloc to HMA
initRelocLowSize        dw ?                    ; bytes to relocate
initRelocLowNotify      dw ?                    ; call back function address

        SYSINIT ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Disk Parameter Block                                         ;
        ;...............................................................;

        DISKPARAM struc

_dptControlTimers    dw ?                               ; see below for definition
_dptMotorOffDelay    db ?                               ; clock ticks
_dptBytesPerSector   db ?                               ; 00 = 128, 01 = 256, ...
_dptSectorsPerTrack  db ?                               ; 
_dptGapLength        db ?                               ; gap between sectors
                                                        ;  2Ah = 5.25"
                                                        ;  1Bh = 3.5"
_dptDataLength       db ?                               ;
_dptFormatGapLength  db ?                               ; gap length when formatting
_dptFormatFillerByte db ?                               ; default F6h.
_dptHeadSettleTime   db ?                               ; in milliseconds.
_dptMotorStartTime   db ?                               ; in 1/8 seconds.

        DISKPARAM ends

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Control Timers
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

DPT_STEPRATEMASK                equ 0F000h              ; bits 15-12
DPT_HEADUNLOADTIME              equ 00F00h              ; bits 11-08 (0fh = 240 ms)

DPT_HEADLOADTIME                equ 00FEh               ; bits 07-01 (01h = 4 ms)
DPT_NONDMA_MODE                 equ 0001h               ; bit 0 (always 0)

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Drivers Data Structures                               ;
        ;...............................................................;

DEVICEINIT              equ 00h
MEDIAREQUEST            equ 01h
BUILDBPB                equ 02h
IOCTLREAD               equ 03h
DEVICEREAD              equ 04h
NONDESTRREAD            equ 05h
INPUTSTATUS             equ 06h
INPUTFLUSH              equ 07h
DEVICEWRITE             equ 08h
DEVICEWRITEVERIFY       equ 09h
OUTPUTSTATUS            equ 0ah
OUTPUTFLUSH             equ 0bh
IOCTLWRITE              equ 0ch
OPENDEVICE              equ 0dh
CLOSEDEVICE             equ 0eh
REMOVABLEMEDIA          equ 0fh
OUTPUTTILLBUSY          equ 10h
GENERICIOCTL            equ 13h
GETLOGICALDEVICE        equ 17h
SETLOGICALDEVICE        equ 18h
IOCTLQUERY              equ 19h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Internal Device Service Table                                ;
        ;...............................................................;

        DEVSERVICETABLE  struc

devsrvEntries           db ?
devsrvBranches          dw ?

        DEVSERVICETABLE  ends


        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  General Request Header Definition                            ;
        ;...............................................................;

        DEVReqHeader struc

rhLength                db ?
rhUnit                  db ?
rhFunction              db ?
rhStatus                dw ?
rhReserved              db 8 dup ( ? )

; extended definition
rhMedia                 db ?                    ; Media id

        DEVReqHeader ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Init Request Header Definition                               ;
        ;...............................................................;

        INITReqHeader struc

irLength                db ?
irUnit                  db ?
irFunction              db ?
irStatus                dw ?
irReserved              db 8 dup ( ? )

irUnits                 db ?                    ; number of units
irEndAddress            dd ?                    ; end driver resident code
irParamAddress          dd ?                    ;  input: config.sys device= line
                                                ; output: BPB pointer array
irDriveNumber           db ?                    ;  input: first drive number
irMessageFlag           dw ?                    ; output: error-message flag

        INITReqHeader ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Media Request Header Definition                              ;
        ;...............................................................;

        MEDIAReqHeader struc

mrLength                db ?
mrUnit                  db ?
mrFunction              db ?
mrStatus                dw ?
mrReserved              db 8 dup ( ? )

mrMediaID               db ?                    ;
mrReturn                db ?                    ; Return value
mrVolumeID              dd ?                    ; volume identifier

        MEDIAReqHeader ends

MEDIA_HASCHANGED        equ -1
MEDIA_UNCHANGED         equ  1
MEDIA_UNKNOWN           equ  0

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  DPB Request Header Definition                                ;
        ;...............................................................;

        BUILDBPBReqHeader struc

bbrLength               db ?
bbrUnit                 db ?
bbrFunction             db ?
bbrStatus               dw ?
bbrReserved             db 8 dup ( ? )

bbrMediaID              db ?                    ;
bbrFATSector            dd ?                    ; buffer with first FAT sector
bbrBPBAddress           dd ?                    ; DPB address

        BUILDBPBReqHeader ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Read/ Write Request Header Definition                        ;
        ;...............................................................;

        READReqHeader struc

rwrLength               db ?
rwrUnit                 db ?
rwrFunction             db ?
rwrStatus               dw ?
rwrReserved             db 8 dup ( ? )

rwrMediaID              db ?                    ;
rwrBuffer               dd ?                    ;
rwrBytesReq             dw ?                    ;
rwrStartSec             dw ?                    ; 
rwrVolumeID             dd ?                    ; volume identifier
rwrHugeStartSec         dd ?                    ; 32 bit sector

        READReqHeader ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  NonDestructive LookAhead Read Definition                     ;
        ;...............................................................;

        NONDESTREADReqHeader struc

ndrLength               db ?
ndrUnit                 db ?
ndrFunction             db ?
ndrStatus               dw ?
ndrReserved             db 8 dup ( ? )

ndrCharRead             db ?                    ; character available

        NONDESTREADReqHeader ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Definition Header                                     ;
        ;...............................................................;

        DEVICEHEADER struc

devLink                 dd ?
devAttributes           dw ?
devStrategy             dw ?
devInterrupt            dw ?
devName                 db '????????'           ; character devices

; extended definition ( non-standard )
devTablePtr             dw ?
devLogicalUnit          dw ?

        DEVICEHEADER ends

devUnits                equ devName             ; block devices

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Definition Flags                                      ;
        ;...............................................................;

DEV_STDINPUT            equ 0001h
DEV_STDOUTPUT           equ 0002h
DEV_NULL                equ 0004h
DEV_CLOCK               equ 0008h

DEV_FASTCHARIO          equ 0010h               ; supports int 29 fast i/o
DEV_LOGICALMAPPING      equ 0040h               ; supports logical dev mapping
DEV_IOCTL               equ 0080h               ; supports IOCTL

DEV_REMOVABLEMEDIA      equ 0800h               ; supports removable media calls

DEV_OUTPUTTILLBUSY      equ 2000h               ; supports output till busy
DEV_IOCTL_RW            equ 4000h               ; supports IOCTL read/write
DEV_CHAR                equ 8000h               ; character mode device

DEV_BLOCKEXTNADDRESS    equ 0002h               ; block device support 32 bit extended address
DEV_REQUIRESFATSECTOR   equ 2000h               ; requires FAT sector address

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Device Errors And Status                                     ;
        ;...............................................................;

OP_ERROR                equ 8000h
OP_NODATA               equ 0300h
OP_BUSY                 equ 0200h
OP_DONE                 equ 0100h
OP_EXITERROR            equ 8100h

devErrWriteProtectViol  equ  0
devErrUnknownUnit       equ  1
devErrDeviceNotReady    equ  2
devErrUnknownCommand    equ  3
devErrCRCerr            equ  4
devErrBadDriveReq       equ  5
devErrSeekError         equ  6
devErrUnknownMedia      equ  7
devErrSectorNotFound    equ  8
devErrPrinterOutPaper   equ  9
devErrWriteFault        equ 10
devErrReadFault         equ 11
devErrGeneralFailure    equ 12
devErrInvalidDiskChange equ 15

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Con Definitions                                              ;
        ;...............................................................;

BIOS_ConRead            equ 00h
BIOS_ConStatus          equ 01h
BIOS_ConReadFlags       equ 02h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Comm Definitions                                             ;
        ;...............................................................;

BIOS_ComInit            equ 00h                 ; returns line status/ modem status
BIOS_ComWrite           equ 01h                 ; returns line status/ modem status
BIOS_ComRead            equ 02h                 ; returns line status/ modem status
BIOS_ComStatus          equ 03h                 ; returns line status/ modem status

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Comm Line Status Register
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
CommLS_TimeOut          equ 8000h
CommLS_ShiftRegEmpty    equ 4000h
CommLS_HoldRegEmpty     equ 2000h
CommLS_BreakDetect      equ 1000h

CommLS_FE               equ 0800h
CommLS_PE               equ 0400h
CommLS_OE               equ 0200h
CommLS_DataAvail        equ 0100h

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Comm Modem Status Register
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
CommMS_RLSD             equ 0080h
CommMS_RING             equ 0040h
CommMS_DSR              equ 0020h
CommMS_CTS              equ 0010h

CommMS_ChgRLSD          equ 0008h
CommMS_ChgRING          equ 0004h
CommMS_ChgDSR           equ 0002h
CommMS_ChgCTS           equ 0001h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Prn Definitions                                              ;
        ;...............................................................;

BIOS_PrnWrite           equ 00h                 ; returns status
BIOS_PrnInit            equ 01h
BIOS_PrnStatus          equ 02h

Prn_RetryCount          equ 03

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Print Status
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Prn_NotBusy             equ 8000h
Prn_Ack                 equ 4000h
Prn_OutOfPaper          equ 2000h
Prn_Selected            equ 1000h

Prn_IOError             equ 0800h
Prn_TimeOut             equ 0100h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Define Structure Sizes                                       ;
        ;...............................................................;

sizedevName             equ 8
sizefnName              equ 8
sizefnExtension         equ 3
sizeFILENAME            equ sizefnName + sizefnExtension
sizeTempFILENAME        equ sizeFILENAME + 1
sizeTempExpandedFCBNAME equ sizeFILENAME + 4    ; drive: + null

sizeCCB                 equ size CCB
sizeCCBData             equ 512     
sizeDIRENTRY            equ size DIRENTRY 
maskDIRINDEX            equ (sizeCCBData / sizeDIRENTRY) - 1

sizeFT                  equ size FT
sizeSFT                 equ size SFT
sizeFCB                 equ size FCB 
sizeBPB                 equ size BPB
sizeExtendedFCBHdr      equ size ExtendedFCBHdr
sizeCLOCKDATA           equ size CLOCKDATA

sizeDISKACCESS          equ size DISKACCESS
sizeDIRACCESS           equ size DIRACCESS
sizeFINDENTRY           equ size FINDENTRY
sizeDPB                 equ size DPB 
sizeCDS                 equ size CDS 
sizeMEMBLOCK            equ size MEMBLOCK 
sizePSP                 equ size PSP
sizePSPHandleTable      equ 20

sizeSector              equ 512
sizePage                equ 512
sizeParagraph           equ 16
sizeParasPerPage        equ (sizePage/ sizeParagraph )
sizeCOUNTRYINFO         equ size COUNTRYINFO
sizeDISKPARAM           equ size DISKPARAM

sizeVolumeLabel         equ 11
sizePARTITION           equ size PARTITION

sizeEXPANDNAME          equ 128
sizeCmdLine             equ 128
sizeCmdLineStruct       equ (sizeCmdLine + 3)
sizeLINEEDITOR          equ size LINEEDITOR
sizeStdRedirec          equ size STDREDIREC

sizeEXECSTATE           equ size EXECSTATE
sizeEXEHEADER           equ size EXEHEADER
sizeEXEC                equ size EXEC
sizeLOADPROG            equ size LOADPROG
sizeSYSINIT             equ size SYSINIT

        ;  Device Headers

sizeDEVReqHeader        equ size DEVReqHeader
sizeREADReqHeader       equ size READReqHeader
sizeMEDIAReqHeader      equ size MEDIAReqHeader
sizeBUILDBPBReqHeader   equ size BUILDBPBReqHeader
sizeMaxReqHeader        equ sizeREADReqHeader
sizeDEVICEHEADER        equ size DEVICEHEADER

