        TITLE   'dev - device interface and search support'
        PAGE 59, 132
        .LALL

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  DEV Device Interface for RxDOS                               ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Real Time Dos                                                ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  This material  was created as a published version  of a DOS  ;
        ;  equivalent product.   This program  logically  functions in  ;
        ;  the same way as  MSDOS functions and it  is  internal  data  ;
        ;  structure compliant with MSDOS 5.0                           ;
        ;                                                               ;
        ;  This product is distributed  AS IS and contains no warranty  ;
        ;  whatsoever,   including  warranty  of   merchantability  or  ;
        ;  fitness for a particular purpose.                            ;
        ;                                                               ;
        ;                                                               ;
        ;  (c) Copyright 1990, 1994. Api Software and Mike Podanoffsky  ;
        ;      All Rights Reserved Worldwide.                           ;
        ;                                                               ;
        ;  This product is protected under copyright laws and  may not  ;
        ;  be reproduced  in whole  or in part, in any form  or media,  ;
        ;  included but not limited to source listing, facimilie, data  ;
        ;  transmission, cd-rom, or  floppy disk without the expressed  ;
        ;  written consent of the author.                               ;
        ;                                                               ;
        ;  Licence for distribution in commercial use:                  ;
        ;                                                               ;
        ;  Api Software                                                 ;
        ;  12 South Walker Street                                       ;
        ;  Lowell,  MA   01851                                          ;
        ;                                                               ;
        ;  internet: mikep@world.std.com                                ;
        ;                                                               ;
        ;...............................................................;

        include rxdosmac.asm
        include rxdosdef.asm

RxDOS   SEGMENT PUBLIC 'CODE'
        assume cs:RxDOS, ds:RxDOS, es:RxDOS, ss:RxDOS

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Driver Support                                               ;
        ;...............................................................;

        public checkforDeviceType
        public checkforDeviceName
        public maxBlockDevices
        public DevMediaRequest
        public DevBuildBPB
        public DevRead
        public DevWrite
        public devCharRead
        public devCharWrite
        public devCharReadLine
        public devCharWriteLine
        public initReqBlock
        public BlockedDevRequest
        public getDPB
        public DefineDPB
        public initDriveParameters
        public getSysDate
        public setSysDate
        public getExpandedDateTime

        public readStdin
        public writeStdout
        public CharDevRequest

        extrn upperCase                         : near
        extrn _bitShiftTable                    : near
        extrn sizeShiftTable                    : abs
        extrn _RxDOS_NULLDev                    : dword
        extrn _RxDOS_pCDS                       : dword
        extrn _RxDOS_pCLOCKdriver               : dword
        extrn _RxDOS_pCONdriver                 : dword
        extrn _RxDOS_Verify                     : word

        extrn RxDOS_StackProtect                : word
        extrn RxDOS_StackTop                    : word
        extrn _RxDOS_CurrentInstance            : word
        extrn _RxDOS_CurrentPSP                 : word
        extrn invalidateDriveBuffers            : near
        extrn _RetCallersStackFrame             : near

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Default Stdin Access                                         ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   es:bx  buffer address.                                      ;
        ;   cx     length.                                              ;
        ;                                                               ;
        ;...............................................................;

readStdin:

        or cx, cx
        jz readStdin_08

        mov di, bx
        push word ptr ss:[ _RxDOS_pCONdriver. _segment ]
        push word ptr ss:[ _RxDOS_pCONdriver. _pointer ]
        call devCharReadLine                            ; read til cr or eof.

readStdin_08:
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Default Stdout Access                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   es:bx  buffer address.                                      ;
        ;   cx     length.                                              ;
        ;                                                               ;
        ;...............................................................;

writeStdout:

        or cx, cx
        jz writeStdout_08

        mov di, bx
        push word ptr ss:[ _RxDOS_pCONdriver. _segment ]
        push word ptr ss:[ _RxDOS_pCONdriver. _pointer ]
        call devCharWrite

writeStdout_08:
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Locate Device Driver By Type                                 ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   ax     type to match.  must match all bits set.             ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   es:bx  pointer to driver header block                       ;
        ;...............................................................;

checkforDeviceType:

        push es
        currSegment es                                  ; point to NULL device
        mov bx, offset _RxDOS_NULLDev                   ; get start of chain

chkDevType_08:
        cmp bx, -1                                      ; end of list ?
        stc                                             ; set error
        jz chkDevType_16                                ; if end of list -->

        mov cx, word ptr es:[ devAttributes ][ bx ]
        and cx, ax                                      ; strip away only mask bits 
        cmp cx, ax                                      ; all bits match ?
        jnz chkDevType_14                               ; no, go to next -->

        add sp, 2                                       ; pop old es:
        push es                                         ; save current es: for return
        jmp short chkDevType_16                         ; return -->

chkDevType_14:
        les bx, dword ptr es:[ devLink ][ bx ]
        jmp chkDevType_08                               ; go to next ->

chkDevType_16:
        pop es
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Locate Device Driver By Name                                 ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   es:di  name to match.  character devices only.              ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   es:bx  pointer to driver header block                       ;
        ;   cy     driver was not located                               ;
        ;...............................................................;

checkforDeviceName:

        Entry
        defbytes _tempdevname, sizedevName

        push ds
        push di
        push si
        push es

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  init by creating a blank filled upper case mask
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        mov si, di
        lea di, offset _tempdevname [ bp ]
        mov cx, sizedevName

chkDevName_08:
        mov al, byte ptr es:[ si ]
        call upperCase

        cmp al, ' '+1                                   ; null or special character ?
        jle chkDevName_12
        cmp al, ':'                                     ; colon ?
        jz chkDevName_12

        mov byte ptr ss:[ di ], al                      ; store character
        inc si
        inc di
        loop chkDevName_08

chkDevName_12:
        or cx, cx
        jz chkDevName_14

        mov byte ptr ss:[ di ], ' '                     ; blank fill
        inc di
        loop chkDevName_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  match against all known driver names
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

chkDevName_14:
        setDS ss        
        currSegment es
        mov bx, offset _RxDOS_NULLDev                   ; get start of chain

chkDevName_20:
        cmp bx, -1                                      ; end of list ?
        stc                                             ; set error
        jz chkDevName_26                                ; if end of list -->

        test word ptr es:[ devAttributes ][ bx ], ( DEV_CHAR )
        jz chkDevName_24                                ; not a character device ->

        lea si, offset _tempdevname [ bp ]
        lea di, offset [ devName ][ bx ]
        mov cx, sizedevName
        rep cmpsb                                       ; compare names
        jnz chkDevName_24                               ; if not equal, go to next -->

        clc                                             ; no carry means we have a valid device
        pop si                                          ; remove old es:
        push es                                         ; return this es:
        jmp short chkDevName_26

chkDevName_24:
        les bx, dword ptr es:[ devLink ][ bx ]
        jmp chkDevName_20                               ; go to next ->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

chkDevName_26:
        pop es
        pop si
        pop di
        pop ds
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Locate Blocked Devices                                       ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;  Input:                                                       ;
        ;   al     drive                                                ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   dx:cx  pointer to driver header block                       ;
        ;...............................................................;

findInstalledBlockDevice:

        Entry
        def  _drive, ax

        push es
        push bx
        call maxBlockDevices                            ; get number of blocked devices

        currSegment es
        mov bx, offset _RxDOS_NULLDev                   ; get start of chain
        getarg ax, _drive

findBlockedDev_08:
        cmp bx, -1                                      ; end of list ?
        stc                                             ; set error
        jz findBlockedDev_16                            ; if end of list -->

        test word ptr es:[ devAttributes ][ bx ], ( DEV_CHAR )
        jnz findBlockedDev_14                           ; if a character device -->

        sub cl, es:[ devUnits ][ bx ]                   ; # units suported
        cmp al, cl                                      ; compare against drive code
        jl findBlockedDev_14                            ; if not device of interest -->

        or ax, ax
        jmp short findBlockedDev_16                     ; return -->

findBlockedDev_14:
        les bx, dword ptr es:[ devLink ][ bx ]
        jmp findBlockedDev_08                           ; go to next ->

findBlockedDev_16:
        mov cx, es
        mov dx, bx
        getarg ax, _drive
        pop bx
        pop es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Report Max Block Devices Available                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   cx     number of blocked devices                            ;
        ;...............................................................;

maxBlockDevices:

        push es
        currSegment es
        mov bx, offset _RxDOS_NULLDev                   ; get start of chain
        xor cx, cx                                      ; # blocked devices

maxBlockDev_08:
        cmp bx, -1                                      ; end of list ?
        jz maxBlockDev_16                               ; if end of list -->

        test word ptr es:[ devAttributes ][ bx ], ( DEV_CHAR )
        jnz maxBlockDev_14                              ; if a character device -->

        add cl, byte ptr es:[ devName ][ bx ]

maxBlockDev_14:
        les bx, dword ptr es:[ devLink ][ bx ]
        jmp maxBlockDev_08                              ; go to next ->

maxBlockDev_16:
        pop es
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Driver Media Request                                         ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   al     drive to check                                       ;
        ;   ah     media type expected                                  ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   cy     if abort/ not ready                                  ;
        ;   ax     error if not zero                                    ;
        ;   ch     new media type                                       ;
        ;   cl     if changed flags                                     ;
        ;...............................................................;

DevMediaRequest:

        Entry
        defbytes volumeID, sizevolumeLabel
        defbytes reqBlock, sizeMaxReqHeader

        push es
        push bx
        push di
        push ax

        mov ah, MEDIAREQUEST
        lea di, offset reqBlock [ bp ]
        call initReqBlock

        lea ax, offset volumeID [ bp ]
        mov word ptr [ reqBlock. mrVolumeID. _pointer ][ bp ], ax
        mov word ptr [ reqBlock. mrVolumeID. _segment ][ bp ], ss

        mov byte ptr [ reqBlock. mrMediaID  ][ bp ], ah
        mov byte ptr [ reqBlock. mrLength   ][ bp ], sizeMEDIAReqHeader
        mov byte ptr [ reqBlock. mrFunction ][ bp ], MEDIAREQUEST
        call BlockedDevRequest                          ; call blocked device

        mov ch, byte ptr [ reqBlock. mrMediaID ][ bp ]
        mov cl, byte ptr [ reqBlock. mrReturn  ][ bp ]

        pop ax
        pop di
        pop bx
        pop es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Driver Bios Parameter Block                                  ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   al     drive to check                                       ;
        ;   ah     media type expected                                  ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   cy     if abort/ not ready                                  ;
        ;...............................................................;

DevBuildBPB:

        Entry
        defbytes reqBlock, sizeMaxReqHeader

        push es
        push bx
        push di
        push si
        push ax

        mov ah, BUILDBPB
        lea di, offset reqBlock [ bp ]
        call initReqBlock

        call BlockedDevRequest                          ; call blocked device
        jc DevBuildBPB_08

        pop ax
        push ax                                         ; restore drive unit
        push word ptr es:[ bbrBPBAddress. _segment ][ bx ]
        push word ptr es:[ bbrBPBAddress. _pointer ][ bx ]

        call getAddrDPB                                 ; address of Dev Par Block
        push es
        push bx
        call DefineDPB                                  ; translate

DevBuildBPB_08:
        pop ax
        pop si
        pop di
        pop bx
        pop es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Driver READ                                                  ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   al     drive to check                                       ;
        ;   bx     # sectors to read                                    ;
        ;   cx:dx  sector to read                                       ;
        ;   es:di  buffer to read                                       ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   cy     if abort/ not ready                                  ;
        ;...............................................................;

DevRead:

        Entry
        def _sectors, bx
        ddef _bufferPtr, es, di
        ddef _sector, cx, dx
        defbytes volumeID, sizevolumeLabel
        defbytes reqBlock, sizeMaxReqHeader

        push es
        push bx
        push di
        push ax
        call getAddrDPB                                 ; (es:bx) Device Parameter Block
        push word ptr es:[ _dpbMediaDescriptor ][ bx ]

        mov ah, DEVICEREAD
        lea di, offset reqBlock [ bp ]
        call initReqBlock

        getarg ax, _sectors
        mov word ptr [ reqBlock.rwrBytesReq ][ bp ], ax

        pop ax                                          ; media descriptor
        mov byte ptr [ reqBlock.rwrMediaID ][ bp ], al

        mov dx, word ptr [ _bufferPtr. _segment ][ bp ]
        mov ax, word ptr [ _bufferPtr. _pointer ][ bp ]
        mov word ptr [ reqBlock.rwrBuffer. _segment ][ bp ], dx
        mov word ptr [ reqBlock.rwrBuffer. _pointer ][ bp ], ax

        lea ax, offset volumeID [ bp ]
        mov word ptr [ reqBlock. rwrVolumeID. _pointer ][ bp ], ax
        mov word ptr [ reqBlock. rwrVolumeID. _segment ][ bp ], ss

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  if address is huge, store in huge request area
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        getdarg cx, dx, _sector
        or cx, cx                                       ; if huge address
        jz DevRead_08                                   ; must save in huge, else skip -->

        mov word ptr [ reqBlock. rwrHugeStartSec. _high ][ bp ], cx
        mov word ptr [ reqBlock. rwrHugeStartSec. _low  ][ bp ], dx
        mov dx, -1

DevRead_08:
        mov word ptr [ reqBlock.rwrStartSec ][ bp ], dx ; sector (or -1 if huge)
        call BlockedDevRequest                          ; call blocked device

        pop ax
        pop di
        pop bx
        pop es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Driver CHAR READ LINE                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Reads until CR or end of buffer                              ;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   cx     characters to read                                   ;
        ;   es:di  buffer to read                                       ;
        ;   stack  driver to read from                                  ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   cx     characters actually returned                         ;
        ;   cy     if abort/ not ready                                  ;
        ;...............................................................;

DevCharReadLine:

        Entry 2
        darg _device

        ddef _clockticks        
        ddef _bufferPtr, es, di
        defbytes _tempBuffer, 8
        defbytes _lineEdit, sizeLINEEDITOR
        defbytes reqBlock, sizeMaxReqHeader

        push es
        push bx
        push di
        push ax
        push cx                                         ; max characters

        mov ah, NONDESTRREAD
        lea di, offset reqBlock [ bp ]
        call initReqBlock

        call ClockTimer                                 ; dx: ax
        stordarg _clockticks, dx, ax

        pop cx
        push di
        lea di, offset _lineEdit [ bp ]
        mov dx, word ptr [ _bufferPtr. _segment ][ bp ]
        mov ax, word ptr [ _bufferPtr. _pointer ][ bp ]
        call _lineEditorInit                            ; init line editor control block

        lea di, offset _tempBuffer [ bp ]
        mov word ptr [ reqBlock.rwrBuffer. _segment ][ bp ], ss
        mov word ptr [ reqBlock.rwrBuffer. _pointer ][ bp ], di
        mov word ptr [ reqBlock.rwrBytesReq         ][ bp ], 1
        pop di

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  wait for character
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DevCharReadLine_12:
        mov byte ptr [ reqBlock.rwrFunction ][ bp ], NONDESTRREAD
        mov word ptr [ reqBlock.rwrStatus   ][ bp ], 0000

        push word ptr [ _device. _segment ][ bp ]
        push word ptr [ _device. _pointer ][ bp ]
        call CharDevRequest                             ; test for character

        test word ptr [ reqBlock.rwrStatus ][ bp ], OP_DONE
        jz DevCharReadLine_16                           ; time out -->
        test word ptr [ reqBlock.rwrStatus ][ bp ], OP_BUSY
        jz DevCharReadLine_20                           ; we have a character -->

DevCharReadLine_16:
        call ClockTimer                                 ; dx: ax
        sub ax, word ptr [ _clockticks. _low  ][ bp ]
        sbb dx, word ptr [ _clockticks. _high ][ bp ]
        cmp ax, 255                                     ; cycled 255 ticks ?
        jle DevCharReadLine_12                          ; continue looping -->

        int intIDLELOOP                                 ; let other applications run
        call ClockTimer                                 ; dx: ax
        stordarg _clockticks, dx, ax

        jmp DevCharReadLine_12                          ; continue looping -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  get character, see if end of buffer or cr
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DevCharReadLine_20:
        push di
        mov byte ptr [ reqBlock.rwrFunction ][ bp ], DEVICEREAD
        push word ptr [ _device. _segment ][ bp ]
        push word ptr [ _device. _pointer ][ bp ]
        call CharDevRequest                             ; get character

        mov ax, word ptr [ _tempBuffer ][ bp ]          ; get character
        or al, al
        jz DevCharReadLine_22
        mov ah, 0

DevCharReadLine_22:
        lea di, offset _lineEdit [ bp ]
        call _lineEditor                                ; store character/ line editor
        mov cx, word ptr ss:[ editMaxAvail  ][ di ]     ; get max chars
        cmp cx, word ptr ss:[ editMaxBuffer ][ di ]     ; at max end of line ?
        pop di
        jz DevCharReadLine_26                           ; if exit -->

     ;  cmp ax, 'C'-40h                                 ; control C ?
     ;  jz DevCharReadLine_26                           ; yes, exit -->
        cmp ax, 'Z'-40h                                 ; end of file ?
        jz DevCharReadLine_26                           ; yes, exit -->
        cmp ax, 'M'-40h                                 ; return character ?
        ifnz DevCharReadLine_12                         ; no -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  exit
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DevCharReadLine_26:
        getdarg es, di, _bufferPtr
        mov cx, word ptr [ _lineEdit. editMaxAvail  ][ bp ] ; get chars entered

        pop ax
        pop dx

        pop ax
        pop di
        pop bx
        pop es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Driver CHAR READ                                             ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   cx     characters to read                                   ;
        ;   es:di  buffer to read                                       ;
        ;   stack  driver to read from                                  ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   cy     if abort/ not ready                                  ;
        ;...............................................................;

DevCharRead:

        Entry 2
        darg _device

        def  _count, cx
        def  _origcount, cx
        ddef _clockticks
        ddef _bufferPtr, es, di
        defbytes reqBlock, sizeMaxReqHeader

        push es
        push bx
        push di
        push ax

        mov ah, NONDESTRREAD
        lea di, offset reqBlock [ bp ]
        call initReqBlock

        call ClockTimer                                 ; dx: ax
        stordarg _clockticks, dx, ax

        mov dx, word ptr [ _bufferPtr. _segment ][ bp ]
        mov ax, word ptr [ _bufferPtr. _pointer ][ bp ]
        mov word ptr [ reqBlock.rwrBuffer. _segment ][ bp ], dx
        mov word ptr [ reqBlock.rwrBuffer. _pointer ][ bp ], ax
        mov word ptr [ reqBlock.rwrBytesReq         ][ bp ], 1

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  wait for character
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DevCharRead_12:
        mov byte ptr [ reqBlock.rwrFunction ][ bp ], NONDESTRREAD
        mov word ptr [ reqBlock.rwrStatus ][ bp ], 0000

        push word ptr [ _device. _segment ][ bp ]
        push word ptr [ _device. _pointer ][ bp ]
        call CharDevRequest                             ; call device

        test word ptr [ reqBlock.rwrStatus ][ bp ], OP_DONE
        jz DevCharRead_16                               ; time out -->
        test word ptr [ reqBlock.rwrStatus ][ bp ], OP_BUSY
        jz DevCharRead_20                               ; we have a character -->

DevCharRead_16:
        call ClockTimer                                 ; dx: ax
        sub ax, word ptr [ _clockticks. _low  ][ bp ]
        sbb dx, word ptr [ _clockticks. _high ][ bp ]
        cmp ax, 255                                     ; cycled 255 ticks ?
        jle DevCharRead_12                              ; continue looping -->

        int intIDLELOOP                                 ; let other applications run
        call ClockTimer                                 ; dx: ax
        stordarg _clockticks, dx, ax

        jmp DevCharRead_12                              ; continue looping -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  get character, see if end of buffer or cr
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DevCharRead_20:
        mov byte ptr [ reqBlock.rwrFunction ][ bp ], DEVICEREAD
        push word ptr [ _device. _segment ][ bp ]
        push word ptr [ _device. _pointer ][ bp ]
        call CharDevRequest                             ; call device (get character)

        push es
        push di
        les di, dword ptr [ reqBlock.rwrBuffer  ][ bp ]
        mov ah, 0
        mov al, byte ptr es:[ di ]                      ; get character
        pop di
        pop es
        cmp ax, 'Z'-40h                                 ; end of file ?
        jz DevCharRead_24
        cmp al, 'M'-40h
        jz DevCharRead_24

        inc word ptr [ reqBlock.rwrBuffer. _pointer ][ bp ]
        dec word ptr [ _count ][ bp ]
        jnz DevCharRead_12

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  exit
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DevCharRead_24:
        mov cx, word ptr [ _origcount ][ bp ]
        sub cx, word ptr [ _count ][ bp ]

        pop ax
        pop dx

        pop ax
        pop di
        pop bx
        pop es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Driver WRITE OR WRITE/VERIFY                                 ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   al     drive to write to                                    ;
        ;   bx     # sectors to read                                    ;
        ;   cx:dx  sector to write                                      ;
        ;   es:di  buffer to write                                      ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   cy     if abort/ not ready                                  ;
        ;...............................................................;

DevWrite:

        Entry
        def _sectors, bx
        ddef _bufferPtr, es, di
        ddef _sector, cx, dx
        defbytes volumeID, sizevolumeLabel
        defbytes reqBlock, sizeMaxReqHeader

        push es
        push bx
        push di
        push ax

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  ok to write
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DevWrite_02:
        call getAddrDPB                                 ; (es:bx) Device Parameter Block
        push word ptr es:[ _dpbMediaDescriptor ][ bx ]

        mov ah, DEVICEWRITE
        cmp byte ptr ss:[ _RxDOS_Verify ], 00           ; non-zero means verify
        jz DevWrite_06                                  ; if not verify -->
        mov ah, DEVICEWRITEVERIFY                       ; if verify writes

DevWrite_06:
        lea di, offset reqBlock [ bp ]
        call initReqBlock                               ; al contains [logcl unit]

        getarg ax, _sectors
        mov word ptr [ reqBlock.rwrBytesReq ][ bp ], ax

        pop ax                                          ; media descriptor
        mov byte ptr [ reqBlock.rwrMediaID ][ bp ], al

        mov dx, word ptr [ _bufferPtr. _segment ][ bp ]
        mov ax, word ptr [ _bufferPtr. _pointer ][ bp ]
        mov word ptr [ reqBlock.rwrBuffer. _segment ][ bp ], dx
        mov word ptr [ reqBlock.rwrBuffer. _pointer ][ bp ], ax

        lea ax, offset volumeID [ bp ]
        mov word ptr [ reqBlock. rwrVolumeID. _pointer ][ bp ], ax
        mov word ptr [ reqBlock. rwrVolumeID. _segment ][ bp ], ss

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  if address is huge, store in huge request area
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        getdarg cx, dx, _sector
        or cx, cx
        jz DevWrite_08

        mov word ptr [ reqBlock. rwrHugeStartSec. _high ][ bp ], cx
        mov word ptr [ reqBlock. rwrHugeStartSec. _low  ][ bp ], dx
        mov dx, -1

DevWrite_08:
        mov word ptr [ reqBlock.rwrStartSec ][ bp ], dx
        call BlockedDevRequest                          ; call blocked device

DevWrite_36:
        pop ax
        pop di
        pop bx
        pop es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Driver CHAR WRITE                                            ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   cx     characters to write                                  ;
        ;   es:di  buffer to write                                      ;
        ;   stack  driver address to write to                           ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   cy     if abort/ not ready                                  ;
        ;...............................................................;

DevCharWrite:
DevCharWriteLine:                               ; intentional alias

        Entry 2
        darg _device

        def _count, cx
        ddef _bufferPtr, es, di
        defbytes volumeID, sizevolumeLabel
        defbytes reqBlock, sizeMaxReqHeader

        push es
        push bx
        push di
        push ax

        les di, dword ptr ss:[ _RxDOS_pCONdriver ]
        stordarg _device, es, di

        mov ah, DEVICEWRITE
        lea di, offset reqBlock [ bp ]
        call initReqBlock

        mov dx, word ptr [ _bufferPtr. _segment ][ bp ]
        mov ax, word ptr [ _bufferPtr. _pointer ][ bp ]
        mov word ptr [ reqBlock.rwrBuffer. _segment ][ bp ], dx
        mov word ptr [ reqBlock.rwrBuffer. _pointer ][ bp ], ax

        lea ax, offset volumeID [ bp ]
        mov word ptr [ reqBlock. rwrVolumeID. _pointer ][ bp ], ax
        mov word ptr [ reqBlock. rwrVolumeID. _segment ][ bp ], ss

        getarg cx, _count
        mov word ptr [ reqBlock.rwrBytesReq        ][ bp ], cx

        push word ptr [ _device. _segment ][ bp ]
        push word ptr [ _device. _pointer ][ bp ]
        call CharDevRequest                             ; call device

        pop ax
        pop di
        pop bx
        pop es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Get System Date and Time                                     ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   es:di  points to date structure                             ;
        ;...............................................................;

getSysDate:

        Entry
        defbytes reqBlock, sizeMaxReqHeader

        saveRegisters es, di, dx, cx

        push es
        push di

        mov ah, DEVICEREAD
        lea di, offset reqBlock [ bp ]
        call initReqBlock

        mov word ptr [ reqBlock.rwrBytesReq ][ bp ], sizeCLOCKDATA
        pop word ptr [ reqBlock.rwrBuffer. _pointer ][ bp ]     ; di
        pop word ptr [ reqBlock.rwrBuffer. _segment ][ bp ]     ; es

        push word ptr [ _RxDOS_pCLOCKdriver. _segment ]
        push word ptr [ _RxDOS_pCLOCKdriver. _pointer ]
        call CharDevRequest

        restoreRegisters cx, dx, di, es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Set System Date and Time                                     ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   es:di  points to date structure                             ;
        ;...............................................................;

setSysDate:

        Entry
        defbytes reqBlock, sizeMaxReqHeader

        saveRegisters es, di, dx, cx

        push es
        push di

        mov ah, DEVICEWRITE
        lea di, offset reqBlock [ bp ]
        call initReqBlock

        mov word ptr [ reqBlock.rwrBytesReq ][ bp ], sizeCLOCKDATA
        pop word ptr [ reqBlock.rwrBuffer. _pointer ][ bp ]      ; di
        pop word ptr [ reqBlock.rwrBuffer. _segment ][ bp ]      ; es

        push word ptr [ _RxDOS_pCLOCKdriver. _segment ]
        push word ptr [ _RxDOS_pCLOCKdriver. _pointer ]
        call CharDevRequest

        restoreRegisters cx, dx, di, es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Convert Integer Time to Registers.                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   ax     time of day in integer form                          ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   ch     hours                                                ;
        ;   cl     minutes                                              ;
        ;   dh     seconds                                              ;
        ;   dl     hundredths of seconds                                ;
        ;...............................................................;

getExpandedDateTime:

        Entry
        defbytes _datedef, sizeCLOCKDATA

        saveRegisters es, di

        setES ss
        lea di, offset _datedef [ bp ]
        call getSysDate                                 ; get system date

        mov cx, word ptr [ _datedef. cl_minutes   ][ bp ]
        mov dx, word ptr [ _datedef. cl_hseconds  ][ bp ]
        mov ax, word ptr [ _datedef. cl_daysSince ][ bp ]

        restoreRegisters di, es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Call Character Device Strategy /Interrupt Routines           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   es:bx  request block                                        ;
        ;   stack  device                                               ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   cy     abort requested on error                             ;
        ;...............................................................;

CharDevRequest:

        Entry 2
        darg _device

        ddef _strategy
        ddef _interrupt
        ddef _packet, es, bx

        saveSegments bp, bx, ax

        getdarg es, bx, _device                         ; get device
        mov ax, es
        or ax, bx                                       ; if no device address
        jz CharDevRequest_12                            ; error exit -->

        mov ax, word ptr es:[ devStrategy  ][ bx ]
        stordarg _strategy, es, ax

        mov ax, word ptr es:[ devInterrupt ][ bx ]
        stordarg _interrupt, es, ax

        push bp
        getdarg es, bx, _packet
        call dword ptr [ _strategy ][ bp ]              ; strategy
        call dword ptr [ _interrupt ][ bp ]             ; interrupt
        pop bp

     ;  getdarg es, bx, _packet
        cmp word ptr es:[ mrStatus ][ bx ], 0
        jz CharDevRequest_12
        test word ptr es:[ mrStatus ][ bx ], OP_ERROR
        jz CharDevRequest_16

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  time out, other error exit.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

CharDevRequest_12:
        stc

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  exit
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

CharDevRequest_16:
        restoreSegments ax, bx, bp
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Call Blocked Device Strategy /Interrupt Routines             ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   es:bx  request block                                        ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   cy     abort requested on error                             ;
        ;...............................................................;

BlockedDevRequest:

        Entry
        def  _retries, CRITERROR_STDRETRIES             ; # retries
        ddef _strategy
        ddef _interrupt
        ddef _packet, es, bx

        saveSegments bp, bx, ax

        xor ax, ax
        mov al, byte ptr es:[ rhUnit ][ bx ]
        call getAddrDPB                                 ; (es:bx) Device Parameter Block
        
        cmp word ptr es:[ _dpbptrDeviceDriver. _segment ][ bx ], 0000
        ifz BlockedDevRequest_28                        ; no device info -->

        les bx, dword ptr es:[ _dpbptrDeviceDriver ][ bx ]
        mov ax, word ptr es:[ devStrategy  ][ bx ]
        stordarg _strategy, es, ax

        mov ax, word ptr es:[ devInterrupt ][ bx ]
        stordarg _interrupt, es, ax

BlockedDevRequest_06:
        getdarg es, bx, _packet                         ; restore packet address
        mov word ptr es:[ rhStatus ][ bx ], 0000        ; (kill prev error code)
        call dword ptr [ _strategy ][ bp ]              ; strategy
        call dword ptr [ _interrupt ][ bp ]             ; interrupt

        getdarg es, bx, _packet                         ; restore packet address
        cmp word ptr es:[ rhStatus ][ bx ], 0
        jz BlockedDevRequest_08
        test word ptr es:[ rhStatus ][ bx ], OP_ERROR
        jz BlockedDevRequest_32

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;     Abort, Retry, Ignore ?
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
BlockedDevRequest_08:
        dec word ptr [ _retries ][ bp ]                 ; # retries
        jnz BlockedDevRequest_06                        ; auto retry -->

        mov word ptr [ _retries ][ bp ], CRITERROR_STDRETRIES
        call _callCriticalError                         ; switch context stack

        Goto CRITERROR_IGNORE       , BlockedDevRequest_32
        Goto CRITERROR_RETRY        , BlockedDevRequest_06
        Goto CRITERROR_TERMINATE    , BlockedDevRequest_16
        Goto CRITERROR_FAIL         , BlockedDevRequest_28
        jmp short BlockedDevRequest_28

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  terminate application
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
BlockedDevRequest_16:
        int 22h

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  exit
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
BlockedDevRequest_28:
        stc

BlockedDevRequest_32:
        restoreSegments ax, bx, bp
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Init Request Block                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   ax     drive                                                ;
        ;   cx     bytes requested                                      ;
        ;   ss:di  request block offset on stack                        ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   es:bx  request block                                        ;
        ;...............................................................;

initReqBlock:

        push ax
        push di

        setES ss        
        xor al, al
        mov cx, sizeMaxReqHeader
        rep stosb                                       ; init request block

        pop di
        mov al, sizeMaxReqHeader
        cmp ah, sizeDevDefaultLength
        jnc initReqBlock_08

        mov bl, ah
        xor bh, bh
        mov al, byte ptr ss:[ devDefaultLength ][ bx ]

initReqBlock_08:
        mov byte ptr es:[ rwrLength   ][ di ], al

        pop ax
        mov byte ptr es:[ rwrUnit     ][ di ], al           ; set unit
        mov byte ptr es:[ rwrFunction ][ di ], ah           ; set function
        mov bx, di
        ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  default length table
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
devDefaultLength:
        db sizeMaxReqHeader                             ; device init
        db sizeMEDIAReqHeader                           ; media request
        db sizeBUILDBPBReqHeader                        ; build dpb
        db sizeMaxReqHeader                             ; ioctl read
        db sizeREADReqHeader                            ; device read
        db sizeREADReqHeader                            ; non destr read
        db sizeMaxReqHeader                             ; input status
        db sizeMaxReqHeader                             ; input flush
        db sizeMaxReqHeader                             ; device write
        db sizeMaxReqHeader                             ; device write verify
        db sizeMaxReqHeader                             ; output status
        db sizeMaxReqHeader                             ; output flush
        db sizeMaxReqHeader                             ; ioctl write
        db sizeMaxReqHeader                             ; open device 
        db sizeMaxReqHeader                             ; close device 
        db sizeMaxReqHeader                             ; removable media
        db sizeMaxReqHeader                             ; output till busy
        db sizeMaxReqHeader                             ; generic ioctl
        db sizeMaxReqHeader                             ; get logical device
        db sizeMaxReqHeader                             ; set logical device
        db sizeMaxReqHeader                             ; ioctl query

sizeDevDefaultLength    equ ($ - devDefaultLength)

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Get Address of Device Parameter Block                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   ax     drive                                                ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   ax     drive                                                ;
        ;   es:bx  address of device parameter block for drive          ;
        ;...............................................................;

getAddrDPB:

        push ax
        push cx

        les bx, dword ptr ss:[ _RxDOS_pCDS ]            ; point to CDS
        or ax, ax                                       ; optimize for drive A:
        jz getAddrDPB_08                                ; if true -->

        mov cl, sizeCDS
        mul cl                                          ; create CDS offset
        add bx, ax

getAddrDPB_08:
        mov ax, word ptr es:[ _cdsPtrToDPB. _segment ][ bx ]
        or ax, word ptr es:[ _cdsPtrToDPB. _pointer ][ bx ]
        stc
        jz getAddrDPB_12

        clc
        les bx, dword ptr es:[ _cdsPtrToDPB ][ bx ]

getAddrDPB_12:
        pop cx
        pop ax
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Get Device Parameter Block                                   ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   ax     drive                                                ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   ax     drive                                                ;
        ;   es:bx  address of device parameter block for drive          ;
        ;...............................................................;

getDPB:

        call getAddrDPB

        saveAllRegisters
        cmp byte ptr es:[ _dpbAccessFlag ][ bx ], -1
        jz getDPB_10

        mov ah, byte ptr es:[ _dpbMediaDescriptor ][ bx ]
        call DevMediaRequest                            ; rebuild Media ID if removable
        jc getDPB_22                                    ; if error -->

        cmp cl, MEDIA_UNCHANGED                         ; if media has changed, 
        jz getDPB_22                                    ; if not changed -->
        call invalidateDriveBuffers                     ; else invalidate drive buffers

getDPB_10:
        call initDriveParameters                        ; and rebuild drive parameters

getDPB_22:
        restoreAllRegisters
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Translate BIOS Parameter Block to DPB                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   arg    pointer to bios parameter block                      ;
        ;   arg    pointer to drive parameter block                     ;
        ;                                                               ;
        ;...............................................................;

DefineDPB:                                              ; aka BuildDPB:

        Entry 4
        darg  _biosParamBlock
        darg  _dosDiskParamBlock

        SaveSegments 

        getdarg ds, di, _biosParamBlock
        getdarg es, bx, _dosDiskParamBlock

        mov ax, word ptr [ _bpbBytesPerSector    ][ di ]
        mov  word ptr es:[ _dpbBytesPerSector    ][ bx ], ax

        mov ax, word ptr [ _bpbResSectors        ][ di ]
        mov  word ptr es:[ _dpbFirstFAT          ][ bx ], ax

        mov al, byte ptr [ _bpbNumCopiesFAT      ][ di ]
        mov  byte ptr es:[ _dpbNumCopiesFAT      ][ bx ], al

        mov al, byte ptr [ _bpbMediaDescriptor   ][ di ]
        mov  byte ptr es:[ _dpbMediaDescriptor   ][ bx ], al

        mov ax, word ptr [ _bpbSectorsPerFat     ][ di ]
        mov  word ptr es:[ _dpbSectorsPerFat     ][ bx ], ax

     ; compute shift and mask factors for sectors/cluster

        mov al, byte ptr [ _bpbSectorsPerCluster ][ di ] 

        push di
        push es
        currSegment es
        mov di, offset _bitShiftTable
        mov cx, sizeShiftTable
        repnz scasb

        sub cx, sizeShiftTable - 1
        neg cx                                          ; proper sense

        pop es
        mov  byte ptr es:[ _dpbClusterSizeShift  ][ bx ], cl

        dec al
        mov  byte ptr es:[ _dpbClusterSizeMask   ][ bx ], al

        pop di
        push cx                                         ; save shift

     ; compute reserved/ max sectors

        mov ax, word ptr [ _bpbSectorsPerFat     ][ di ]
        mul byte ptr [ _bpbNumCopiesFAT ][ di ]
        add ax, word ptr [ _bpbResSectors        ][ di ]
        mov  word ptr es:[ _dpbFirstDirSector    ][ bx ], ax

        xor dx, dx
        mov ax, word ptr [ _bpbMaxAllocRootDir   ][ di ]
        mov  word ptr es:[ _dpbMaxAllocRootDir   ][ bx ], ax

        mov cx, sizeDIRENTRY
        mul cx

        add ax, word ptr [ _bpbBytesPerSector    ][ di ]
        dec ax
        div word ptr [ _bpbBytesPerSector    ][ di ]    ;** convert to div 32

        add ax, word ptr es:[ _dpbFirstDirSector ][ bx ]
        mov  word ptr es:[ _dpbFirstDataSector   ][ bx ], ax

        xor dx, dx
        mov ax, word ptr [ _bpbMaxSectors        ][ di ]
        or ax, ax
        jnz DefineDPB_08                                ; value is legitimate
        mov dx, word ptr [ _bpbHugeSectors. _high ][ di ]
        mov ax, word ptr [ _bpbHugeSectors. _low  ][ di ]

DefineDPB_08:
        sub ax, word ptr es:[ _dpbFirstDataSector   ][ bx ]
        sbb dx, 0000
        pop cx                                          ; restore shift value

DefineDPB_12:
        or cx, cx
        jz DefineDPB_14
        shr dx, 1
        rcr ax, 1
        loop DefineDPB_12

DefineDPB_14:
        inc ax
        mov  word ptr es:[ _dpbMaxClusterNumber  ][ bx ], ax

        or ax, ax
        mov byte ptr es:[ _dpbAccessFlag ][ bx ], 00
        RestoreSegments
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Init Drive Parameters                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   ax     drive to check                                       ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   ax     drive to check                                       ;
        ;   cy     if drive is invalid or contains no media             ;
        ;...............................................................;

initDriveParameters:

        push ax
        call getAddrDPB                                 ; (es:bx) Device Parameter Block

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  init DPB if device not init or is removable
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        cmp byte ptr es:[ _dpbAccessFlag ][ bx ], -1
        clc                                             ; not really an error
        jnz initDriveParameters_22                      ; if already initialized -->

        mov dx, word ptr es:[ _dpbptrDeviceDriver. _pointer ][ bx ]
        or dx, word ptr es:[ _dpbptrDeviceDriver. _segment ][ bx ]
        jnz initDriveParameters_10

        call findInstalledBlockDevice
        jc initDriveParameters_22
        mov word ptr es:[ _dpbptrDeviceDriver. _pointer ][ bx ], dx
        mov word ptr es:[ _dpbptrDeviceDriver. _segment ][ bx ], cx

initDriveParameters_10:
        call DevMediaRequest                            ; rebuild Media ID if removable
        jc initDriveParameters_22                       ; if error -->

        cmp cl, MEDIA_HASCHANGED                        ; if media has changed, 
        jnz initDriveParameters_12                      ; if not changed -->
        call invalidateDriveBuffers                     ; else invalidate parameters 

initDriveParameters_12:
        call DevBuildBPB                                ; rebuild DPB
        jc initDriveParameters_22                       ; if error -->

initDriveParameters_22:
        pop ax
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Call User's Critical Error Handler                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   es:di  pointer to current device header                     ;
        ;...............................................................;

_callCriticalError:

        push bx
        push bp
        push es
        push ds

        push word ptr cs:[ _callCriticalError_CurrStack. _segment ]
        push word ptr cs:[ _callCriticalError_CurrStack. _pointer ]
        push ax                                         ; allowed options

        mov dl, CRITERROR_RETRY
      ; mov dl, CRITERROR_TERMINATE
        cmp word ptr ss:[ _RxDOS_CurrentPSP ], 0000
        jz _callCriticalError_32                        ; if no valid PSP -->

        mov bp, es                                      ; point to driver's header
        mov si, bx                                      ; es:bx --> bp:si

        mov bx, word ptr ss:[ _RxDOS_CurrentInstance ]  ; base address of current stack
        les bx, dword ptr ss:[ _pointer ][ bx ]

        cli
        mov word ptr cs:[ _callCriticalError_CurrStack. _segment ], ss
        mov word ptr cs:[ _callCriticalError_CurrStack. _pointer ], sp

        mov dx, es
        mov ss, dx
        mov sp, bx
        sub sp, sizeStackFrame                          ; adjust user stack ptr
        sti

        push word ptr es:[ _DataSegment ][ bx ]
        push word ptr es:[ _ExtraSegment ][ bx ]
        pop es
        pop ds

        Int intCRITICALERROR                            ; perform int 24h

        cli
        mov dl, al                                      ; save value returned
        mov ss, word ptr cs:[ _callCriticalError_CurrStack. _segment ]
        mov sp, word ptr cs:[ _callCriticalError_CurrStack. _pointer ]
        sti

;  fix-up returned codes if conflict between allowed and returned

        pop ax
        push ax                                         ; get options
        cmp dl, CRITERROR_IGNORE                        ; ignore returned ?
        jnz _callCriticalError_12                       ; no -->
        test ax, CRITERROR_IGNOREALLOWED                ; ignore allowed ?
        jnz _callCriticalError_32                       ; yes -->
        mov dl, CRITERROR_FAIL                          ; otherwise default to fail

_callCriticalError_12:
        cmp dl, CRITERROR_RETRY                         ; retry returned ?
        jnz _callCriticalError_14                       ; no -->
        test ax, CRITERROR_RETRYALLOWED                 ; retry allowed ?
        jnz _callCriticalError_32                       ; yes -->
        mov dl, CRITERROR_FAIL                          ; otherwise default to fail

_callCriticalError_14:
        cmp dl, CRITERROR_FAIL                          ; fail returned ?
        jnz _callCriticalError_32                       ; no -->
        test ax, CRITERROR_FAILALLOWED                  ; fail allowed ?
        jnz _callCriticalError_32                       ; yes -->
        mov dl, CRITERROR_TERMINATE                     ; otherwise default to terminate 

_callCriticalError_32:
        pop ax
        pop word ptr cs:[ _callCriticalError_CurrStack. _pointer ]
        pop word ptr cs:[ _callCriticalError_CurrStack. _segment ]

        pop ds
        pop es
        pop bp
        pop bx
        mov al, dl
        ret

_callCriticalError_CurrStack:   dd 0

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Clock Tick Counter                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Returns:                                                     ;
        ;   dx:ax  clock ticks                                          ;
        ;                                                               ;
        ;...............................................................;

ClockTimer:

        push ds
        push bx

        xor bx, bx
        mov ds, bx
        mov ax, word ptr [ bx + 46Ch ]
        mov dx, word ptr [ bx + 46Eh ]

        pop bx
        pop ds
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Line Editor Control Block Init                               ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   ss:di  pointer to editor control block                      ;
        ;   dx:ax  pointer to client buffer                             ;
        ;   cx     max characters                                       ;
        ;...............................................................;

_lineEditorInit:

        push ax
        push bx
        push cx
        push dx
        push di
        push es
        setES ss

        xor ax, ax
        mov cx, sizeLINEEDITOR
        rep stosb

        mov ax, 0F00h                                   ; read current mode
        int 10h                                         ; get page into BH

        mov ax, 0300h                                   ; get current cursor position
        int 10h                                         ; get page into BH

        pop es
        pop di
        mov byte ptr ss:[ editPhysCursorRow ][ di ], dh
        mov byte ptr ss:[ editPhysCursorCol ][ di ], dl

        pop dx
        pop cx
        pop bx
        pop ax

        mov word ptr ss:[ editBufPointer. _low  ][ di ], ax
        mov word ptr ss:[ editBufPointer. _high ][ di ], dx
        mov word ptr ss:[ editMaxBuffer         ][ di ], cx
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Line Editor                                                  ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   ss:di  pointer to editor control block                      ;
        ;   ax     character to process                                 ;
        ;           (see table in _lineEditorDispatchTable for action)  ;
        ;...............................................................;

_lineEditor:

        Entry
        def  _DisplayPage, 0000
        ddef _lineEditControlBlock, es, di

        push es
        push di
        push bx
        push ax

        mov ax, 0F00h
        int 10h                                         ; get current display page
        mov byte ptr [ _DisplayPage ][ bp ], bh

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  lookup character
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        pop ax
        push ax                                         ; restore character
        mov bx, offset _lineEditorDispatchTable         ; see if in dispatch table

_lineEditor_08:
        cmp word ptr cs:[ bx ], 0000
        jz _lineEditor_16                               ; if not special -->
        cmp ax, word ptr cs:[ bx ]
        jz _lineEditor_12                               ; if found, dispatch -->
        add bx, 4
        jmp _lineEditor_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  dispatch service
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_lineEditor_12:
        push word ptr cs:[ bx + 2 ]
        les bx, dword ptr ss:[ editBufPointer ][ di ]
        add bx, word ptr ss:[ editCursor ][ di ]
        ret                                             ; performs a jump

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  just store character
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_lineEditor_16:
        or al, al                                       ; null insert character ?
        jz _lineEditor_32                               ; yes, ignore insert -->

        les bx, dword ptr ss:[ editBufPointer ][ di ]
        add bx, word ptr ss:[ editCursor ][ di ]
        test word ptr ss:[ editFlags ][ di ], editInsertFlag
        jz _lineEditor_24                               ; if not insert mode -->

        mov cx, word ptr ss:[ editMaxAvail ][ di ]      ; get max chars
        sub cx, word ptr ss:[ editCursor   ][ di ]      ; at max end of line ?
        jz _lineEditor_24                               ; yes, can't go right -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; if insert
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        push ax
        push bx

_lineEditor_20:
        xchg al, byte ptr es:[ bx ]                     ; ripple insert character
        inc bx                                          ; point to next column 
        loop _lineEditor_20                             ; loop thru all characters -->

        inc word ptr ss:[ editMaxAvail ][ di ]          ; cursor is max length
        pop bx
        pop ax

_lineEditor_24:
        mov byte ptr es:[ bx ], al
        cmp al, 'M'-40h                                 ; return character ?
        jz _lineEditor_32                               ; yes -->

        inc word ptr ss:[ editCursor    ][ di ]         ; increment cursor
        mov cx, word ptr ss:[ editCursor ][ di ]
        cmp cx, word ptr ss:[ editMaxAvail ][ di ]      ; is cursor past max length ?
        jc _lineEditor_26                               ; no -->
        mov word ptr ss:[ editMaxAvail ][ di ], cx      ; cursor is max length

_lineEditor_26:
        call _lineEditor_EchoLine

_lineEditor_28:
        mov dh, byte ptr ss:[ editPhysCursorRow ][ di ]
        mov dl, byte ptr ss:[ editPhysCursorCol ][ di ]
        add dl, byte ptr ss:[ editCursor        ][ di ]
        mov bh, byte ptr [ _DisplayPage ][ bp ]
        mov ax, 0200h
        int 10h

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_lineEditor_32:
        pop ax
        pop bx
        pop di
        pop es
        Return

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Backspace/ Delete
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_editorBackspaceDelete:
        cmp word ptr ss:[ editCursor ][ di ], 0000      ; at start of line ?
        jz _editorDelete_08                             ; yes, can't go backwards -->
        dec word ptr ss:[ editCursor ][ di ]
        dec bx

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Delete
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_editorDelete:
        mov cx, word ptr ss:[ editMaxAvail ][ di ]      ; get max chars
        sub cx, word ptr ss:[ editCursor   ][ di ]      ; at max end of line ?
        jz _editorDelete_08                             ; yes, can't go right -->
        dec word ptr ss:[ editMaxAvail ][ di ]          ; adjust max chars

_editorDelete_06:
        mov al, byte ptr es:[ bx + 1 ]
        mov byte ptr es:[ bx ], al                      ; copy characters
        inc bx                                          ; point to next column 
        loop _editorDelete_06                           ; loop thru all characters -->

   ;     cmp word ptr ss:[ editMaxAvail ][ di ], 0000    ; if count is zero
   ;     jz _editorDelete_08                             ; we'll not do the echo -->
        call _lineEditor_EchoLine                       ; echo line

_editorDelete_08:
        mov bh, byte ptr [ _DisplayPage ][ bp ]
        mov ax, 0E20h                                   ; space filler
        int 10h
        jmp _lineEditor_26

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Insert
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_editorInsert:
        xor word ptr ss:[ editFlags  ][ di ], editInsertFlag
        jmp _lineEditor_32

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Home
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_editorHome:
        mov word ptr ss:[ editCursor   ][ di ], 0000    ; set end pointer
        jmp _lineEditor_28

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  End
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_editorEnd:
        mov cx, word ptr ss:[ editMaxAvail ][ di ]      ; get max chars
        mov word ptr ss:[ editCursor   ][ di ], cx      ; set end pointer
        jmp _lineEditor_28

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Left
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_editorLeft:
        cmp word ptr ss:[ editCursor ][ di ], 0000      ; at start of line ?
        jz _editorLeft_08                               ; yes, can't go backwards -->
        dec word ptr ss:[ editCursor ][ di ]

_editorLeft_08:
        jmp _lineEditor_28

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Right
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_editorRight:
        mov cx, word ptr ss:[ editMaxAvail ][ di ]      ; get max chars
        cmp cx, word ptr ss:[ editCursor   ][ di ]      ; at max end of line ?
        jz _editorRight_08                              ; yes, can't go right -->
        inc word ptr ss:[ editCursor ][ di ]

_editorRight_08:
        jmp _lineEditor_28

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Exit, No Text
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_editorControlC:
        mov word ptr ss:[ editMaxAvail ][ di ], 0000    ; cursor is max length
        les bx, dword ptr ss:[ editBufPointer ][ di ]
        mov byte ptr es:[ bx ], 00                      ; null out line
        jmp _lineEditor_32                              ; yes -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Copy Template
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_editorF3CopyTemplate:
_editorF2SearchTemplate:
_editorTab:
        jmp _lineEditor_32

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Line Editor Echo Line                                        ;
        ;...............................................................;

_lineEditor_EchoLine:

        Entry
        def  _charsCount
        ddef _bufferPtr
        ddef _lineEditControlBlock, es, di

        push es
        push di
        push si
        mov cx, word ptr ss:[ editMaxAvail      ][ di ]
        les si, dword ptr ss:[ editBufPointer   ][ di ]
        stordarg _bufferPtr, es, si
        storarg  _charsCount, cx

        mov ax, 0F00h
        int 10h                                         ; get current display page

        mov ax, 0200h
        mov dh, byte ptr ss:[ editPhysCursorRow ][ di ]
        mov dl, byte ptr ss:[ editPhysCursorCol ][ di ]
        int 10h                                         ; set cursor position

        getdarg es, si, _bufferPtr
        cmp word ptr ss:[ _charsCount          ][ bp ], 0000
        jz _lineEditor_EchoLine_22                      ; if no characters -->

_lineEditor_EchoLine_08:
        mov al, byte ptr es:[ si ]                      ; get character
        mov ah, 0Eh                                     ; write character only
        int 10h

        inc si
        dec word ptr ss:[ _charsCount          ][ bp ]
        jnz _lineEditor_EchoLine_08

_lineEditor_EchoLine_22:
        getdarg es, di, _lineEditControlBlock
     ;  mov dh, byte ptr ss:[ editPhysCursorRow ][ di ]
     ;  mov dl, byte ptr ss:[ editPhysCursorCol ][ di ]
     ;  add dl, byte ptr ss:[ editCursor        ][ di ]
     ;  mov ax, 0200h
     ;  int 10h

        pop si
        pop di
        pop es
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Line Editor Dispatch Table                                   ;
        ;...............................................................;

_lineEditorDispatchTable:

    ;   dw 0003h, _editorControlC
        dw 0008h, _editorBackspaceDelete
        dw 0009h, _editorTab
        dw 4B00h, _editorLeft
        dw 4D00h, _editorRight
        dw 5200h, _editorInsert
        dw 5300h, _editorDelete
        dw 4700h, _editorHome
        dw 4F00h, _editorEnd
        dw 3C00h, _editorF2SearchTemplate
        dw 3D00h, _editorF3CopyTemplate
        dw 0h

RxDOS   ENDS
        END
