        TITLE   'INI - RxDOS Initialize'
        PAGE 59, 132
        .LALL

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  INI - RxDOS Initialize                                       ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Real Time Dos                                                ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  This material  was created as a published version  of a DOS  ;
        ;  equivalent product.   This program  logically  functions in  ;
        ;  the same way as  MSDOS functions and it  is  internal  data  ;
        ;  structure compliant with MSDOS 5.0                           ;
        ;                                                               ;
        ;  This product is distributed  AS IS and contains no warranty  ;
        ;  whatsoever,   including  warranty  of   merchantability  or  ;
        ;  fitness for a particular purpose.                            ;
        ;                                                               ;
        ;                                                               ;
        ;  (c) Copyright 1990, 1994. Api Software and Mike Podanoffsky  ;
        ;      All Rights Reserved Worldwide.                           ;
        ;                                                               ;
        ;  This product is protected under copyright laws and  may not  ;
        ;  be reproduced  in whole  or in part, in any form  or media,  ;
        ;  included but not limited to source listing, facimilie, data  ;
        ;  transmission, cd-rom, or  floppy disk without the expressed  ;
        ;  written consent of the author.                               ;
        ;                                                               ;
        ;  Licence for distribution in commercial use:                  ;
        ;                                                               ;
        ;  Api Software                                                 ;
        ;  12 South Walker Street                                       ;
        ;  Lowell,  MA   01851                                          ;
        ;                                                               ;
        ;  internet: mikep@world.std.com                                ;
        ;                                                               ;
        ;...............................................................;

        include rxdosmac.asm
        include rxdosdef.asm

RxDOS   SEGMENT PUBLIC 'CODE'
        assume cs:RxDOS, ds:RxDOS, es:RxDOS, ss:RxDOS

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  INI - RxDOS Initialize                                       ;
        ;...............................................................;

        public RxDOS_initialize

        extrn _RxDOS_bNumBlockDev               : byte
        extrn _RxDOS_BufferList                 : near
        extrn _RxDOS_CurrentDrive               : byte
        extrn _RxDOS_BootDrive                  : byte

        extrn _RxDOS_CommandShell               : near
        extrn _RxDOS_Buffers                    : dword
        extrn _RxDOS_bLastDrive                 : byte
        extrn _RxDOS_bSwitchChar                : byte
        extrn _RxDOS_bCtrlBreakCheck            : byte
        extrn _RxDOS_MaxMemory                  : word
        extrn _RxDOS_NULLDev                    : dword
        extrn _RxDOS_pCDS                       : dword
        extrn _RxDOS_pDPB                       : dword
        extrn _RxDOS_pFT                        : dword
        extrn _RxDOS_pStartMemBlock             : word

        extrn _RxDOS_CurrentSeg                 : word
        extrn _RxDOS_SharedBuffer               : near
        extrn _RxDOS_pDTA                       : near
        extrn _RxDOS_EnvironmentSize            : near
        extrn _RxDOS_CurrentPSP                 : near
        extrn _RxDOS_pCONdriver                 : near
        extrn _RxDOS_pCLOCKdriver               : near

        extrn RxDOS_StackTop                    : near
        extrn RxDOS_StackTemp                   : near
        extrn _RxDOS_CurrentStackTop            : near
        extrn RxDOS_start                       : near

        extrn _CallDOS                          : far
        extrn _Interrupt_20                     : near
        extrn _Interrupt_21                     : near
        extrn _Interrupt_23                     : near
        extrn _Interrupt_24                     : near
        extrn _Interrupt_25                     : near
        extrn _Interrupt_26                     : near
        extrn _Interrupt_27                     : near
        extrn _Interrupt_28                     : near

        extrn maxBlockDevices                   : near
        extrn FindAvailableSFTHandle            : near
        extrn checkforDeviceType                : near
        extrn checkforDeviceName                : near
        extrn stdDeviceAssignTable              : near

        extrn scanDirectory                     : near
        extrn initdiskAccess                    : near
        extrn lowerCase                         : near
        extrn upperCase                         : near
        extrn CopyString                        : near
        extrn readLine                          : near
        extrn _initializeMemoryBlock            : near
        extrn SDAExtendedSwapArea               : near

     ;  extrn msgUnknownCommandinConfig         : near
     ;  extrn _RxDOS_ConfigKeywords             : near

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  CONFIG Switches                                              ;
        ;...............................................................;

F5_SkipConfigProcessing dw 0000                 ; non-zero if skipping
F8_PromptRequired       dw 0000                 ; non-zero if prompt required

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  CONFIGSTMT structure                                         ;
        ;...............................................................;

        CONFIGSTMT struc

cStmtType               dw ?                    ; config statement type
cStmtName               db ?                    ; statement starts here

        CONFIGSTMT ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  CONFIGLINE Buffer                                            ;
        ;...............................................................;

        CONFIGLINE struc

configType              dw ?                    ; config statement type
configLength            dw ?                    ; config line length
configFlags             dw ?                    ; config statement line number
configLineNumber        dw ?                    ; config statement line number
configStatement         db ?                    ; statement starts here

        CONFIGLINE ends

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  CONFIG Statement Types                                       ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  WARNING: These values cannot be changed without also         ;
        ;  changing the dispatch table.                                 ;
        ;                                                               ;
        ;...............................................................;

CONFIGTYPE_ENDOFARGS    equ 0000h               ; last entry
CONFIGTYPE_DOS          equ 0001h               ; dos = umb, high
CONFIGTYPE_NUMLOCK      equ 0002h               ; numlock = on | off
CONFIGTYPE_BREAK        equ 0003h               ; break = on | off
CONFIGTYPE_SET          equ 0004h               ; set

CONFIGTYPE_COUNTRY      equ 0005h               ; contry = 
CONFIGTYPE_DEVICE       equ 0006h               ; device devicename [ options ]
CONFIGTYPE_DEVICEHIGH   equ 0007h               ; devicehigh devicename [ options ]
CONFIGTYPE_DRIVPARAM    equ 0008h               ; driveparam
CONFIGTYPE_MULTITRACK   equ 0009h               ; multitrack
CONFIGTYPE_SWITCHES     equ 0010h               ; switches

CONFIGTYPE_BUFFERS      equ 0011h               ; buffers =
CONFIGTYPE_FILES        equ 0012h               ; files =
CONFIGTYPE_FCBS         equ 0013h               ; fcbs = x [, y ]
CONFIGTYPE_LASTDRIVE    equ 0014h               ; lastdrive = x
CONFIGTYPE_SHELL        equ 0015h               ; shell specifypath
CONFIGTYPE_STACKS       equ 0016h               ; stacks

CONFIGTYPE_INSTALL      equ 0017h               ; install progname
CONFIGTYPE_INSTALLHIGH  equ 0018h               ; installhigh progname

CONFIGTYPE_MENUDEFAULT  equ 0019h               ; blockname [, timeout ]
CONFIGTYPE_MENUITEM     equ 001Ah               ; itemname [, text ]
CONFIGTYPE_MENUCOLOR    equ 001Bh               ; x [, y]
CONFIGTYPE_SUBMENU      equ 001Ch               ; itemname [, text ]
CONFIGTYPE_INCLUDE      equ 001Dh               ; itemname
CONFIGTYPE_MENUBLOCK    equ 001Eh               ; [...]

CONFIGTYPE_SWITCHCHAR   equ 0020h               ; char
CONFIGTYPE_COMMENTS     equ 0021h               ; comments
CONFIGTYPE_REM          equ 0022h               ; remarks

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  CONFIG Flags And Options                                     ;
        ;...............................................................;

CONFIGFLAG_ENABLED      equ 0001h
CONFIGFLAG_PROCESSED    equ 0002h

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Config File Processing                                       ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  This module reads the entire  Config.sys  file from  a par-  ;
        ;  tially initialized system.  It expects  minimally  buffers,  ;
        ;  CDS, and other  DOS  data  structures.   Config  processing  ;
        ;  happens in two phases:  pass one gathers facts and pass two  ;
        ;  reconfigures data structures and loads drivers.              ;
        ;                                                               ;
        ;  Returns:                                                     ;
        ;  ds/es   both will point to ss                                ;
        ;  ax      current drive                                        ;
        ;...............................................................;

configProcessing:

        Entry
        ddef  _configStatements, es, di
        ddef  _configNextLine, es, di

        def  _comment    , ';'                          ; default comment character
        def  _charsread
        def  _linenumber , 0000
        def  _dosFlags,    0000

        defbytes _diskAccess, sizeDISKACCESS
        defbytes _linebuffer, 255

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  find/ open config.sys 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        setDS cs
        setES cs
        xor dx, dx
        mov al, byte ptr [ _RxDOS_CurrentDrive ]        ; startup drive
        mov di, offset _RxDOS_ConfigFile                ; search config file
        call scanDirectory                              ; open config.sys
        ifc configProcessing_Return                     ; if none found -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  find/ open config.sys 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        push word ptr es:[ deFileSize. _low  ][ si ]
        push word ptr es:[ deFileSize. _high ][ si ]

        setES ss
        lea bx, _diskAccess [ bp ]                      ; build access control block
        call initdiskAccess                             ; [ax] is drive, [dx] is cluster

        pop word ptr ss:[ diskAcFileSize. _high ][ bx ]
        pop word ptr ss:[ diskAcFileSize. _low  ][ bx ]

configProcessing_12:
        getdarg es, di, _configNextLine
        mov word ptr es:[ configType   ][ di ], CONFIGTYPE_ENDOFARGS
        mov word ptr es:[ configLength ][ di ], 0000

        setES ss
        mov cx, 254
        lea di, offset _linebuffer [ bp ]
        lea bx, _diskAccess [ bp ]                      ; build access control block
        call readLine                                   ; read a line
        ifz configProcessing_36                         ; at end, reconfigure system -->

        inc word ptr [ _linenumber ][ bp ]              ; lines read
        lea di, offset _linebuffer [ bp ]

        getarg ax, _comment                             ; parse out comments
        call configRemoveComments                       ; remove comments
        jz configProcessing_12                          ; if nothing left on line -->
        mov word ptr [ _charsread ][ bp ], cx           ; characters read

        setES ss
        cmp byte ptr ss:[ di ], ':'                     ; comment line ?
        jz configProcessing_12                          ; yes, ignore -->
        cmp byte ptr ss:[ di ], '['                     ; block item specifier ?
        jz configProcessing_16                          ; yes -->

        mov si, offset _RxDOS_ConfigKeywords
        call _findCommand
        jnc configProcessing_20

      ; typeout msgUnknownCommandinConfig
        jmp configProcessing_12

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  [ blockitem_name ]
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
configProcessing_16:
        inc di
        call _skipSpaces                                ; skip any leading spaces

        push di
        call _scanToEndofName                           ; find terminating space
        mov byte ptr ss:[ di ], 0                       ; set a terminator

        pop di
        mov dx, CONFIGTYPE_MENUBLOCK                    ; menu block 

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  go save statement
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
configProcessing_20:
        cmp dx, CONFIGTYPE_REM                          ; remark statement ?
        jz configProcessing_12                          ; ignore -->

        cmp dx, CONFIGTYPE_COMMENTS                     ; if comment, go process
        jz configProcessing_26                          ; process comment -->

        lea si, offset _linebuffer [ bp ]
        getarg cx, _charsread
        sub cx, di
        add cx, si                                      ; length difference to remember
        mov si, di                                      ; source pointer

        getdarg es, di, _configNextLine
        mov word ptr es:[ configType   ][ di ], dx      ; save type

        mov ax, word ptr [ _linenumber ][ bp ]          ; get line number
        mov word ptr es:[ configLineNumber ][ di ], ax

        mov word ptr es:[ configLength ][ di ], cx
        add word ptr es:[ configLength ][ di ], (size CONFIGLINE)

     ; copy statement

        lea di, offset [ configStatement   ][ di ]      ; offset to statement
        rep movsb
        
        xor ax, ax
        stosb                                           ; null terminate

        mov di, word ptr [ _configNextLine ][ bp ]
        add di, word ptr es:[ configLength  ][ di ]     ; advance beyond type
        mov word ptr [ _configNextLine ][ bp ], di
        jmp configProcessing_12

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  process menu
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
configProcessing_26:
        call _skipSpaces                                ; skip any leading spaces

        mov ax, word ptr es:[ di ]                      ; get comment character
        cmp ah, ' ' + 1                                 ; space or other control ?
        jnc configProcessing_28                         ; no -->
        mov ah, 0

configProcessing_28:
        storarg _comment, ax                            ; save comment character(s)
        jmp configProcessing_12                         ; continue

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  process menu
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
configProcessing_36:
        getdarg es, di, _configStatements
        call configMenu

        getdarg es, di, _configStatements
        call removeUnusedBlocks

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  reconfigure system
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        getdarg es, di, _configStatements

        call processSwitchChar                          ; SwitchChar = 
        call processNumLock                             ; NumLock = on | off
        call processDOS                                 ; dos =
        storarg _dosFlags, ax                           ; save flags
        call RxDOSini_MemorySubSystem                   ; re-initialize memory subsystem

        call processBreak                               ; break = on | off
        call processCountry                             ; country = 

        getdarg es, di, _configStatements
        call processDevice                              ; device devicename [ options ]

        getarg ax, _dosFlags                            ; option flags
        call RxDOSini_LinkUpperMemory                   ; attempt link upper memory

        getdarg es, di, _configStatements
        call processDeviceHigh                          ; device devicename [ options ]

        call processDrivParam                           ; drivparam = 
        call processMultiTrack                          ; multitrack = 
        call processSwitches                            ; switches =

        call processBuffers                             ; buffers =
        call processFCBS                                ; fcbs =
        call processFiles                               ; files = 
        call processLastDrive                           ; lastdrive =
        call processShell                               ; shell =
        call processStack                               ; stacks =

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
configProcessing_Return:

        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process Unsupported Commands                                 ;
        ;...............................................................;

RxDOSini_LinkUpperMemory:

processCountry:
processDrivParam:
processMultiTrack:
processSwitches:

        ret                                             ; ignores entire line

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process Break Statement                                      ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processBreak:

        Entry
        ddef _ConfigStatements, es, di
        def  _break, _OFF                               ; 0 is off; 1 is on.

processBreak_08:
        mov ax, CONFIGTYPE_BREAK
        call _findStatementType                         ; find statement type
        jc processBreak_24                              ; if no more -->

        push es
        push di
        lea di, offset [ configStatement ][ di ]
        call ConfigPrompt                               ; check for ?= or F8 case
        jc processBreak_12                              ; ignore statement -->
        
        mov si, offset _RxDOS_ConfigOnOff
        call _findCommand                               ; locate on or off
        jc processBreak_12                              ; if none of the above -->
        storarg _break, dx                              ; else ok to save

processBreak_12:
        pop di
        pop es
        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processBreak_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processBreak_24:
        getarg ax, _break                               ; get break
        mov byte ptr [ _RxDOS_bCtrlBreakCheck ], al

        getdarg es, di, _ConfigStatements               ; 
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process Buffer Statements                                    ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processBuffers:

        Entry
        ddef _ConfigStatements, es, di
        ddef _buffers, 0, DEFAULT_BUFFERS

processBuffers_08:
        mov ax, CONFIGTYPE_BUFFERS
        call _findStatementType                         ; find statement type
        jc processBuffers_24                            ; if no more -->

        push es
        push di
        lea di, offset [ configStatement ][ di ]
        call ConfigPrompt                               ; check for ?= or F8 case
        jc processBuffers_16                            ; ignore statement -->
        
        mov cx, 1
        mov dx, CONFIGMAX_BUFFERS
        call _getNumber
        jc processBuffers_16                            ; if beyond range -->
        mov word ptr [ _buffers. _low  ][ bp ], ax      ; else ok to save

        mov cx, 0
        mov dx, ax                                      ; highest cannot exceed prev number
        call _getNumber
        jc processBuffers_16                            ; if beyond range -->
        mov word ptr [ _buffers. _high ][ bp ], ax      ; else ok to save

processBuffers_16:
        pop di
        pop es
        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processBuffers_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processBuffers_24:
        getdarg dx, ax, _buffers
        mov word ptr [ _RxDOS_Buffers. _low  ], ax
        mov word ptr [ _RxDOS_Buffers. _high ], dx
        call RxDOSini_CCBSubSystem                      ; configure

        getdarg es, di, _ConfigStatements               ; 
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process Device Statement(s)                                  ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processDevice:
        mov ax, CONFIGTYPE_DEVICE
        jmp processAnyDevice

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process DeviceHigh Statement(s)                              ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processDeviceHigh:

        Entry
        ddef _ConfigStatements, es, di
        def  _memorystrategy

        Int21 GetAllocationStrategy                     ; get current allocation scheme
        storarg _memorystrategy, ax

        mov bx, _MEM_FIRSTFIT_HIGH
        Int21 SetAllocationStrategy

        mov ax, CONFIGTYPE_DEVICEHIGH
        getdarg es, di, _ConfigStatements
        call processAnyDevice

        getarg bx, _memorystrategy
        Int21 SetAllocationStrategy
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Common Device Load                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processAnyDevice:

        Entry
        ddef _ConfigStatements, es, di
        def  _type, ax

processAnyDevice_08:
        getarg ax, _type
        call _findStatementType                         ; find statement type
        jc processAnyDevice_24                          ; if no more -->

        push es
        push di
        lea di, offset [ configStatement ][ di ]
        call ConfigPrompt                               ; check for ?= or F8 case
        jc processAnyDevice_12                          ; if ignore -->

        push ds
        setDS es
        mov dx, di                                      ; strip any switches before '='
     ;  Int21 ExecuteProgram, 03h                       ; load overlay
        pop ds

processAnyDevice_12:
        pop di
        pop es
        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processAnyDevice_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processAnyDevice_24:
        getdarg es, di, _ConfigStatements               ; return
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process DOS Statement                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processDOS:

        Entry
        ddef _ConfigStatements, es, di
        def  _DOS, 0000                                 ; no UMB, no HMA

processDOS_08:
        mov ax, CONFIGTYPE_DOS
        call _findStatementType                         ; find statement type
        jc processDOS_24                                ; if no more -->

        push es
        push di
        lea di, offset [ configStatement ][ di ]
        call ConfigPrompt                               ; check for ?= or F8 case
        jc processDOS_12                                ; ignore statement -->

processDOS_10:
        mov si, offset _RxDOS_ConfigDOSOptions
        call _findCommand                               ; locate options like high and umb
        jc processDOS_12                                ; if none of the above -->
        or word ptr [ _DOS ][ bp ], dx                  ; or options

        call _nextArgument                              ; point to next argument
        jnc processDOS_10                               ; go porcess -->

processDOS_12:
        pop di
        pop es
        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processDOS_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processDOS_24:
        getarg ax, _DOS                                 ; get DOS
        getdarg es, di, _ConfigStatements               ; 
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process FCBS Statement(s)                                    ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processFCBS:

        Entry
        ddef _ConfigStatements, es, di
        ddef _FCBS, 0, DEFAULT_FCBS

processFCBS_08:
        mov ax, CONFIGTYPE_FCBS
        call _findStatementType                         ; find statement type
        jc processFCBS_24                              ; if no more -->

        push es
        push di
        lea di, offset [ configStatement ][ di ]
        call ConfigPrompt                               ; check for ?= or F8 case
        jc processFCBS_16                               ; if ignore -->

        mov cx, 1
        mov dx, CONFIGMAX_FCBS_X
        call _getNumber
        jc processFCBS_16                              ; if beyond range -->
        mov word ptr [ _FCBS. _low  ][ bp ], ax        ; else ok to save

        mov cx, 0
        mov dx, CONFIGMAX_FCBS_Y
        call _getNumber
        jc processFCBS_16                              ; if beyond range -->
        mov word ptr [ _FCBS. _high ][ bp ], ax        ; else ok to save

processFCBS_16:
        pop di
        pop es
        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processFCBS_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processFCBS_24:
        getdarg dx, ax, _FCBS                           ; return FCBS
        getdarg es, di, _ConfigStatements               ; 
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process Files Statement(s)                                   ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processFiles:

        Entry
        ddef _ConfigStatements, es, di
        def _files, DEFAULT_FILES
        def  _fcbs, ax 

processFiles_08:
        mov ax, CONFIGTYPE_FILES
        call _findStatementType                         ; find statement type
        jc processFiles_24                              ; if no more -->

        push es
        push di
        lea di, offset [ configStatement ][ di ]
        call ConfigPrompt                               ; check for ?= or F8 case
        jc processFiles_12                              ; if ignore -->

        mov cx, 1
        mov dx, CONFIGMAX_FILES
        call _getNumber
        jc processFiles_12                              ; if beyond range -->
        storarg _files, ax                              ; else ok to save

processFiles_12:
        pop di
        pop es
        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processFiles_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processFiles_24:
        getarg ax, _files                               ; return files
        add ax, word ptr [ _fcbs ][ bp ]
        call RxDOSini_SFTSubSystem                      ; init SFTs

        getdarg es, di, _ConfigStatements               ; 
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process Last Drive                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processLastDrive:

        Entry
        ddef _ConfigStatements, es, di
        def  _LastDrive, DEFAULT_LASTDRIVE   

processLastDrive_08:
        mov ax, CONFIGTYPE_LASTDRIVE
        call _findStatementType                         ; find statement type
        jc processLastDrive_24                          ; if no more -->

        push es
        push di
        lea di, offset [ configStatement ][ di ]
        call ConfigPrompt                               ; check for ?= or F8 case
        jc processLastDrive_12                          ; if ignore -->

        xor ax, ax
        mov al, byte ptr es:[ di ]
        call upperCase
        cmp al, 'A'
        jc processLastDrive_12
        cmp al, 'Z'+1
        jnc processLastDrive_12
        storarg _LastDrive, ax

processLastDrive_12:
        pop es
        pop di
        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processLastDrive_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processLastDrive_24:
        getarg ax, _LastDrive                           ; get last drive info, if any
        and ax, 1Fh
        mov byte ptr [ _RxDOS_bLastDrive ], al          ; save in DOS

        call RxDOSini_DPBSubSystem                      ; (order important)
        call RxDOSini_CDSSubSystem                      ; init drives/current dirs

        getdarg es, di, _ConfigStatements               ; 
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process NumLock Statement                                    ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processNumLock:

        Entry
        ddef _ConfigStatements, es, di
        def  _numlock, -1                               ; 0 is off; 1 is on.

processNumLock_08:
        mov ax, CONFIGTYPE_NUMLOCK
        call _findStatementType                         ; find statement type
        jc processNumLock_24                            ; if no more -->

        push es
        push di
        lea di, offset [ configStatement ][ di ]
        call ConfigPrompt                               ; check for ?= or F8 case
        jc processNumLock_12                            ; if ignore -->

        mov si, offset _RxDOS_ConfigOnOff
        call _findCommand                               ; locate on or off
        jc processNumLock_12                            ; if none of the above -->
        storarg _numlock, dx                            ; else ok to save

processNumLock_12:
        pop di
        pop es
        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processNumLock_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processNumLock_24:
        push es
        getarg ax, _numlock                             ; get numlock
        cmp ax, -1                                      ; any change ?
        jz processNumLock_46                            ; if no change -->

        mov bx, 40h
        mov es, bx                                      ; BIOS communications area
        mov bx, offset _BIOS_KeyboardFlags              ; keyboard status flags
        or ax, ax                                       ; set num lock ?
        jnz processNumLock_32                           ; if set -->

        and byte ptr es:[ bx ], NOT ( _BIOS_KB_NumLock )
        jmp short processNumLock_46

processNumLock_32:
        or byte ptr es:[ bx ], _BIOS_KB_NumLock

processNumLock_46:
        pop es
        getdarg es, di, _ConfigStatements
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process Shell Statement                                      ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processShell:

        Entry
        ddef _ConfigStatements, es, di

processShell_08:
        mov ax, CONFIGTYPE_SHELL
        call _findStatementType                         ; find statement type
        jc processShell_24                              ; if no more -->

        push es
        push di
        lea di, offset [ configStatement ][ di ]
        call ConfigPrompt                               ; check for ?= or F8 case
        jc processShell_12                              ; if ignore -->

        push es
        push di
        push ds
        mov bx, offset _RxDOS_CommandShell
        push bx
        call CopyString

processShell_12:
        pop di
        pop es
        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processShell_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processShell_24:
        getdarg es, di, _ConfigStatements               ; 
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process Stack Statement(s)                                   ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processStack:

        Entry
        ddef _ConfigStatements, es, di
        ddef _stacks, 0, DEFAULT_STACKS

processStack_08:
        mov ax, CONFIGTYPE_STACKS
        call _findStatementType                         ; find statement type
        jc processStack_24                              ; if no more -->

        push es
        push di
        lea di, offset [ configStatement ][ di ]
        call ConfigPrompt                               ; check for ?= or F8 case
        jc processStack_16                              ; if ignore -->

        mov cx, CONFIGMIN_STACKS_X
        mov dx, CONFIGMAX_STACKS_X
        call _getNumber
        jc processStack_16                              ; if beyond range -->
        mov word ptr [ _stacks. _low  ][ bp ], ax       ; else ok to save

        mov cx, CONFIGMIN_STACKS_Y
        mov dx, CONFIGMAX_STACKS_Y
        call _getNumber
        jc processStack_16                              ; if beyond range -->
        mov word ptr [ _stacks. _high ][ bp ], ax       ; else ok to save

processStack_16:
        pop di
        pop es
        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processStack_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processStack_24:
        getdarg dx, ax, _stacks                         ; return stacks
        getdarg es, di, _ConfigStatements               ; 
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process Switch Char                                          ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es:di  start of statements in saved config buffer            ;
        ;...............................................................;

processSwitchChar:

        Entry
        ddef _ConfigStatements, es, di
        def  _SwitchChar, '/'

processSwitchChar_08:
        mov ax, CONFIGTYPE_SWITCHCHAR
        call _findStatementType                         ; find statement type
        jc processSwitchChar_24                         ; if no more -->

        xor ax, ax
        mov al, byte ptr es:[ configStatement ][ di ]
        storarg _SwitchChar, ax                         ; save last drive info

        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_PROCESSED
        add di, word ptr es:[ configLength ][ di ]
        jmp processSwitchChar_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
processSwitchChar_24:
        getarg ax, _SwitchChar                          ; get last drive info, if any
        mov byte ptr [ _RxDOS_bSwitchChar ], al

        getdarg es, di, _ConfigStatements               ; 
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Count devices to be loaded later                             ;
        ;...............................................................;

_Config_InstallHigh:
_Config_Install:
_Config_Devices:
      ; inc word ptr [ _devices ][ bp ]
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Remove Comments, Leading Blanks, Blank Lines                 ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  ax     comment character(s)                                  ;
        ;  cx     current line count                                    ;
        ;  ss:di  line read from disk                                   ;
        ;                                                               ;
        ;  This reads through blocks and changes each block to a REM    ;
        ;  block that was not selected as a menu option.                ;
        ;...............................................................;

configRemoveComments:

        call _skipSpaces

        push di                                         ; save buffer pointer
        cmp ah, 0                                       ; double character comments ?
        jnz configRemoveComments_12                     ; yes -->
        
configRemoveComments_06:
        cmp al, byte ptr ss:[ di ]                      ; is it comment character ?
        jz configRemoveComments_20                      ; yes -->
        inc di
        loop configRemoveComments_06
        jmp short configRemoveComments_20

configRemoveComments_12:
        cmp ax, word ptr ss:[ di ]                      ; is it comment character ?
        jz configRemoveComments_20                      ; yes -->
        inc di
        loop configRemoveComments_12

configRemoveComments_20:
        mov cx, di
        pop di
        sub cx, di                                      ; new length
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Find Statement Type                                          ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  ax     config item type                                      ;
        ;  es:di  configure table.                                      ;
        ;...............................................................;

_findStatementType:
        cmp word ptr es:[ configType ][ di ], CONFIGTYPE_ENDOFARGS
        jnz _findStatementType_08
        stc
        ret

_findStatementType_08:
        cmp ax, word ptr es:[ configType ][ di ]        ; is it menu type ?
        jnz _findStatementType_12                       ; if not, goto next -->
        or di, di
        ret

_findStatementType_12:
        add di, word ptr es:[ configLength ][ di ]
        jmp _findStatementType
        
        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Config Statement Prompt                                      ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  ax     statement type                                        ;
        ;  es:di  pointer to first non-space after keyword              ;
        ;...............................................................;

ConfigPrompt:

        Entry
        ddef _configTextPtr, es, di

        cmp word ptr es:[ di ], '=?'                    ; is it ?= 
        jz ConfigPrompt_12                              ; yes, go prompt -->
        cmp word ptr cs:[ F8_PromptRequired ], 0000     ; F8_prompt required ?
        jz ConfigPrompt_24                              ; no, go skip = if set -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;  prompt statement
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
ConfigPrompt_12:

        push ds
        setDS cs
        mov dx, offset msgProcessCommandYesNo
        Int21 DisplayString

ConfigPrompt_16:
        xor ax, ax
        int 16h

        call upperCase
        cmp al, 'Y'                                     ; check for Yes
        jz ConfigPrompt_20                              ; 
        cmp al, 'N'                                     ; check for No
        jnz ConfigPrompt_16

ConfigPrompt_20:
        mov dl, al
        Int21 DisplayOutput                             ; echo character

        mov dx, offset msgNewLine
        Int21 DisplayString

        pop ds
        getdarg es, di, _configTextPtr
        cmp al, 'N'                                     ; if No
        stc                                             ; set carry if No
        jz ConfigPrompt_36                              ; exit -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;  Skip ? and ?= and any spaces which follow
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
ConfigPrompt_24:
        cmp word ptr es:[ di ], '=?'                    ; '?=' in prompt ?
        jnz ConfigPrompt_26                             ; no -->
        inc di                                          ; skip over question mark

ConfigPrompt_26:
        cmp byte ptr es:[ di ], '='                     ; '=' in prompt ?
        jnz ConfigPrompt_28                             ; no -->
        inc di                                          ; skip over equal sign

ConfigPrompt_28:
        cmp byte ptr es:[ di ], ' ' + 1                 ; space follows ?
        jnz ConfigPrompt_32                             ; no, return -->
        inc di                                          ; skip over equal sign
        jmp ConfigPrompt_28                             ; loop through all spaces -->

ConfigPrompt_32:
        clc                                             ; clear carry

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;  Skip ? and ?= if 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
ConfigPrompt_36:
        Return
        
        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Skip To Next Argument                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;  es:di   points to line buffer                                ;
        ;...............................................................;

_nextArgument:

        cmp byte ptr es:[ di ], ' '                     ; ignore spaces
        jz _nextArgument_06
        cmp byte ptr es:[ di ], '='                     ; ignore equal signs
        jz _nextArgument_06
        cmp byte ptr es:[ di ], ','                     ; ignore commas
        jnz _nextArgument_08

_nextArgument_06:
        inc di
        jmp _nextArgument

_nextArgument_08:
        cmp byte ptr es:[ di ], ' '                     ; carry means end of line
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Process Menus                                                ;
        ;...............................................................;

configMenu:
        Entry
        ddef _ConfigStatements, es, di

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  identify all common components as enabled.
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

configMenu_04:
        mov ax, CONFIGTYPE_MENUBLOCK
        mov bx, offset Config_CommonSelector
        call _findConfigMenuStatement                   ; identify common components
        jc configMenu_08                                ; if none left -->

        or word ptr es:[ configFlags ][ di ], CONFIGFLAG_ENABLED
        add di, word ptr es:[ configLength ][ di ]
        jmp configMenu_04

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  search for menu starter
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

configMenu_08:
        mov ax, CONFIGTYPE_MENUBLOCK
        mov bx, offset Config_MenuSelector
        getdarg es, di, _ConfigStatements
        call _findConfigMenuStatement
        jc configMenu_68

     ; ...

configMenu_68:
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Remove Unused Blocks                                         ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  ES:DI  Configure Table.                                      ;
        ;                                                               ;
        ;  This reads through blocks and changes each block to a REM    ;
        ;  block that was not selected as a menu option.                ;
        ;...............................................................;

removeUnusedBlocks:
        mov ax, CONFIGTYPE_MENUBLOCK
        call _findStatementType                         ; find start of block
        jc removeUnusedBlocks_32                        ; if none left -->

removeUnusedBlocks_08:
        test word ptr es:[ configFlags ][ di ], CONFIGFLAG_ENABLED
        jz removeUnusedBlocks_12                        ; if disabled, delete -->
        add di, word ptr es:[ configLength ][ di ]
        jmp removeUnusedBlocks                          ; if enabled, we'll keep ->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  remove disabled blocks
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
removeUnusedBlocks_12:
        mov word ptr es:[ configType ][ di ], CONFIGTYPE_REM
        add di, word ptr es:[ configLength ][ di ]

        cmp word ptr es:[ configType ][ di ], CONFIGTYPE_ENDOFARGS
        jz removeUnusedBlocks_32                        ; if none left -->
        cmp word ptr es:[ configType ][ di ], CONFIGTYPE_MENUBLOCK
        jz removeUnusedBlocks_08                        ; if next block -->
        jmp removeUnusedBlocks_12                       ; go remove -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
removeUnusedBlocks_32:
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Find Menu Statement                                          ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  ax     config item type                                      ;
        ;  bx     menu name                                             ;
        ;  es:di  configure table.                                      ;
        ;...............................................................;

_findConfigMenuStatement:

        cmp word ptr es:[ configType ][ di ], CONFIGTYPE_ENDOFARGS
        jnz _findConfigMenuStatement_08
        stc
        ret

_findConfigMenuStatement_08:
        cmp ax, word ptr es:[ configType ][ di ]        ; is it menu type ?
        jnz _findConfigMenuStatement_32                 ; if not, goto next -->

        push di
        push bx
        push ax
        lea di, offset [ configStatement ][ di ]
        
_findConfigMenuStatement_12:
        mov al, byte ptr [ bx ]                         ; get character
        call upperCase                                  ; upper case

        mov ah, al
        mov al, byte ptr es:[ di ]
        call upperCase                                  ; upper case

        inc bx
        inc di
        cmp ah, al                                      ; compare strings
        jnz _findConfigMenuStatement_28                 ; if not equal -->

        or al, al                                       ; both null terminators ?
        jnz _findConfigMenuStatement_12                 ; not yet -->

        pop ax
        pop bx
        pop di
        or di, di
        ret

_findConfigMenuStatement_28:
        pop ax
        pop bx
        pop di

_findConfigMenuStatement_32:
        add di, word ptr es:[ configLength ][ di ]
        jmp _findConfigMenuStatement
        
        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Get Number                                                   ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;  cx      min acceptable number                                ;
        ;  dx      max acceptable number                                ;
        ;  es:di   points to line buffer                                ;
        ;                                                               ;
        ;  Returns:                                                     ;
        ;  ax      number, if any                                       ;
        ;  di      pointer to argument past command                     ;
        ;  cy      not a number                                         ;
        ;...............................................................;

_getNumber:
        push cx
        xor ax, ax

_getNumber_08:
        cmp byte ptr es:[ di ], '0'                     ; valid digit ?
        jc  _getNumber_26                               ; no longer -->
        cmp byte ptr es:[ di ], '9' +  1                ; valid digit ?
        jnc _getNumber_26                               ; no longer -->

        mov cx, ax
        add ax, ax                                      ; 2
        add ax, ax                                      ; 4
        add ax, cx                                      ; 5
        add ax, ax                                      ; 10

        mov cl, byte ptr es:[ di ]                      ; get digit
        and cx, 15
        add ax, cx

        inc di
        jmp _getNumber_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  check for error
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_getNumber_26:
        pop cx
        or ax, ax
        pushf                                           ; save current status
        cmp ax, cx                                      ; is it at least as large as ...
        jc _getNumber_32                                ; no -->
        cmp ax, dx                                      ; is it greater than ...
        jle _getNumber_36                               ; if within range -->

_getNumber_32:
        popf
        stc
        pushf                                           ; change status

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  skip to next argument
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_getNumber_36:
        cmp byte ptr es:[ di ], ' '
        jc _getNumber_48                                ; if control character 
        jz _getNumber_38                                ; if space -->

        cmp byte ptr es:[ di ], ':'                     ; ignore colons
        jz _getNumber_38
        cmp byte ptr es:[ di ], '='                     ; ignore equal signs
        jz _getNumber_38
        cmp byte ptr es:[ di ], ','                     ; ignore commas
        jnz _getNumber_48

_getNumber_38:
        inc di
        jmp _getNumber_36

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_getNumber_48:
        popf
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Find Command                                                 ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;  es:di   points to line buffer                                ;
        ;  cs:si   table to search                                      ;
        ;                                                               ;
        ;  Returns:                                                     ;
        ;  dx      command type                                         ;
        ;  di      pointer to argument past command                     ;
        ;  cy      command not found                                    ;
        ;...............................................................;

_findCommand:
        cmp word ptr cs:[ si ], -1
        jnz _findCommand_12                             ; if not end of table ->
        cmp word ptr cs:[ si + 2 ], 0
        jz _findCommand_Error                           ; if end -->

_findCommand_12:
        push word ptr cs:[ cStmtType ][ si ]            ; if item matches
        lea si, offset cStmtName [ si ]                 ; skip to name

        xor bx, bx

_findCommand_18:
        mov al, byte ptr es:[ di + bx ]                 ; get character
        call lowerCase                                  ; lower case character
        cmp al, byte ptr cs:[ si + bx ]                 ; this command ?
        jnz _findCommand_32                             ; not this command -->

        inc bx
        cmp byte ptr cs:[ si + bx ], 0                  ; end of string ?
        jnz _findCommand_18                             ; not yet -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  if command match is made, skip to next argument
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        add di, bx                                      ; offset

_findCommand_22:
        cmp byte ptr es:[ di ], 0
        jz  _findCommand_26
        cmp byte ptr es:[ di ], ' ' + 1                 ; skip spaces
        jnc _findCommand_26

        inc di
        jmp _findCommand_22

_findCommand_26:
        pop dx                                          ; statement type
        or dx, dx
        ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  if not a match, try next command in table
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_findCommand_32:
        inc si                                          ; increment past 
        cmp byte ptr cs:[ si - 1 ], 0                   ; end of string ?
        jnz _findCommand_32                             ; loop -->

        pop ax                                          ; ignore saved stmt type
        jmp _findCommand                                ; continue -->

_findCommand_Error:
        stc
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Skip Leading Spaces                                          ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;  ss:di   points to line buffer                                ;
        ;...............................................................;

_skipSpaces:
        cmp byte ptr ss:[ di ], 0
        jz  _skipSpaces_08
        cmp byte ptr ss:[ di ], ' ' + 1
        jnc _skipSpaces_08

        inc di
        jmp _skipSpaces

_skipSpaces_08:
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Skip To Next Space                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;  ss:di   points to line buffer                                ;
        ;...............................................................;

_scanToEndofName:
        cmp byte ptr ss:[ di ], 0
        jz  _scanToEndofName_08

        mov al, byte ptr ss:[ di ]
        cmp al, ' ' + 1
        jc _scanToEndofName_08
        call upperCase
        cmp al, 'Z' + 1
        jnc _scanToEndofName_08

        inc di
        jmp _scanToEndofName

_scanToEndofName_08:
        cmp byte ptr ss:[ di ], 0
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Memory Subsystem Initialize                            ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  No Parameters Required.                                      ;
        ;                                                               ;
        ;  The memory subsystem used by RxDOS is initialized.  All      ;
        ;  previous memory allocations are lost.                        ;
        ;                                                               ;
        ;...............................................................;

RxDOSini_MemorySubSystem:

        saveSegments
        mov ax, 40h
        mov es, ax                                      ; BIOS communications area

        xor bx, bx
        mov ax, word ptr es:[ _BIOS_Memory ][ bx ]
        shl ax, 1                                       ; multiply * 64k
        shl ax, 1                                       ;
        shl ax, 1                                       ;
        shl ax, 1                                       ;
        shl ax, 1                                       ;
        shl ax, 1                                       ; max segment
        sub ax, word ptr [ _RxDOS_pStartMemBlock ]      ; available memory
        push ax

        mov bx, _RxDOS_PARENT_SIGNATURE                 ; system block
        mov cx, word ptr [ _RxDOS_pStartMemBlock ]      ; available memory
        mov es, cx                                      ; create memory system.
        call _initializeMemoryBlock                     ; initialize memory block.

        xor cx, cx
        mov ax, word ptr es:[ _memAlloc ][ di ]
        dec ax
        mov word ptr es:[ _memAlloc ][ di ], cx         ; original now is allocate 1 block
        mov byte ptr es:[ _memSignature ][ di ], _RxDOS_MEMSIGNATURE

        mov dx, es
        inc dx
        mov es, dx                                      ; where to allocate next
        xor bx, bx                                      ; system block
        call _initializeMemoryBlock                     ; initialize memory block.
        mov byte ptr es:[ _memSignature ][ di ], _RxDOS_ENDSIGNATURE

        pop ax                                          ; memory available
        restoreSegments
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Sub Allocate System Space                                    ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;   ax     space in bytes to sub allocate                       ;
        ;                                                               ;
        ;  Output:                                                      ;
        ;   es:di  pointer to allocated space                           ;
        ;   ax     space in bytes allocated                             ;
        ;   cx     (same as ax)                                         ;
        ;...............................................................;

AllocateSystemSpace:

        push bx
        push ax                                         ; save bytes to allocate
        xor di, di

        add ax, (sizeMEMBLOCK) - 1                      ; round up to next block
        shr ax, 1
        shr ax, 1
        shr ax, 1
        shr ax, 1                                       ; create para address

        mov es, word ptr [ _RxDOS_pStartMemBlock ]      ; get start sys memory
        mov bx, es
        add bx, word ptr es:[ _memAlloc ][ di ]         ; point to end segment
        add word ptr es:[ _memAlloc ][ di ], ax         ; add new allocation bytes
        mov dx, word ptr es:[ _memAlloc ][ di ]

        inc bx
        mov es, bx                                      ; point to free segment
        sub ax, word ptr es:[ _memAlloc ][ di ]         ; get free segments
        neg ax

        inc dx
        add dx, word ptr [ _RxDOS_pStartMemBlock ]      ; get start sys memory
        mov es, dx                                      ; where new allocation

        push bx                                         ; segment address available
        xor bx, bx
        call _initializeMemoryBlock                     ; puts end block at es:bx
        mov byte ptr es:[ _memSignature ][ di ], _RxDOS_ENDSIGNATURE

        pop es                                          ; segment address available
        pop cx                                          ; space allocated ( bytes )
        push cx                                         ; save
        xor di, di
        clearMemory                                     ; clear area

        pop cx                                          ; space allocated ( bytes )
        pop bx                                          ; original bx
        xor di, di
        mov ax, cx
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Disk Parameter Blocks SubSystem Initialize             ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  No Parameters Required.                                      ;
        ;...............................................................;

RxDOSini_DPBSubSystem:

        push ds
        setDS cs
        setES cs

        mov al, sizeDPB
        mul byte ptr [ _RxDOS_bLastDrive ]              ; number of logical devices
        call AllocateSystemSpace                        ; allocate dpb's for all 26 devices.

        mov word ptr [ _RxDOS_pDPB. _pointer ], di 
        mov word ptr [ _RxDOS_pDPB. _segment ], es

        xor ax, ax
        xor cx, cx
        mov cl, byte ptr [ _RxDOS_bLastDrive ]
        setDS es                                        ; point to PDB area

    ; values are defaults w/o special meaning 
    ; actual values are assigned later by calling driver

RxDOS_DPBinit_12:
        mov byte ptr [ _dpbDrive            ][ di ], al
        mov byte ptr [ _dpbUnit             ][ di ], al
        mov word ptr [ _dpbBytesPerSector   ][ di ], 512
        mov byte ptr [ _dpbClusterSizeMask  ][ di ], 0FEh
        mov byte ptr [ _dpbClusterSizeShift ][ di ], 0
        mov word ptr [ _dpbFirstFAT         ][ di ], 0001
        mov byte ptr [ _dpbNumCopiesFAT     ][ di ], 2
        mov word ptr [ _dpbMaxAllocRootDir  ][ di ], 64
        mov word ptr [ _dpbFirstDataSector  ][ di ], 9
        mov word ptr [ _dpbMaxClusterNumber ][ di ], 352

        mov word ptr [ _dpbSectorsPerFat    ][ di ], 2
        mov word ptr [ _dpbFirstDirSector   ][ di ], 5
        mov word ptr [ _dpbptrDeviceDriver. _segment ][ di ], NULL
        mov word ptr [ _dpbptrDeviceDriver. _pointer ][ di ], NULL
        mov byte ptr [ _dpbMediaDescriptor  ][ di ], 0
        mov byte ptr [ _dpbAccessFlag       ][ di ], -1         ; UNACCESSED

        lea bx, sizeDPB [ di ]
        mov word ptr [ _dpbNextDPB. _segment ][ di ], ds
        mov word ptr [ _dpbNextDPB. _pointer ][ di ], bx
        mov word ptr [ _dpbNextFree          ][ di ], 0000
        mov word ptr [ _dpbFreeCount         ][ di ], -1

        inc ax
        mov di, bx
        loop RxDOS_DPBinit_12

    ;  set end marker at last DPB

        mov word ptr [ _dpbNextDPB. _segment - sizeDPB ][ di ], -1
        mov word ptr [ _dpbNextDPB. _pointer - sizeDPB ][ di ], -1

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  loop through DPB's and assign drivers
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        setES cs
        mov bx, offset _RxDOS_NULLDev                   ; get start of chain
        mov ax, sizeDPB
        mul byte ptr cs:[ _RxDOS_bNumBlockDev ]
        add ax, word ptr cs:[ _RxDOS_pDPB. _pointer ] 
        mov di, ax                                      ; points nth + 1 entry

RxDOS_DPBinit_08:
        cmp bx, -1                                      ; end of list ?
        jz RxDOS_DPBinit_22                             ; if end of list -->

        test word ptr es:[ devAttributes ][ bx ], ( DEV_CHAR )
        jnz RxDOS_DPBinit_14                            ; if a character device -->

        xor cx, cx
        mov cl, byte ptr es:[ devUnits ][ bx ]          ; # logical devices

RxDOS_DPBinit_10:
        sub di, sizeDPB
        mov word ptr [ _dpbptrDeviceDriver. _segment ][ di ], es
        mov word ptr [ _dpbptrDeviceDriver. _pointer ][ di ], bx
        loop RxDOS_DPBinit_10

RxDOS_DPBinit_14:
        les bx, dword ptr es:[ devLink ][ bx ]
        jmp RxDOS_DPBinit_08                            ; go to next ->

RxDOS_DPBinit_22:
        pop ds
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Disk Parameter Blocks SubSystem Initialize             ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  No Parameters Required.                                      ;
        ;...............................................................;

RxDOSini_CDSSubSystem:

        setDS cs
        mov al, sizeCDS
        mul byte ptr [ _RxDOS_bLastDrive ]              ; ax contains offset to current drive
        call AllocateSystemSpace
        mov word ptr [ _RxDOS_pCDS. _segment ], es
        mov word ptr [ _RxDOS_pCDS. _pointer ], di

        mov al, 'A'
        xor cx, cx
        mov cl, byte ptr [ _RxDOS_bLastDrive ]
        lds si, dword ptr [ _RxDOS_pCDS ]

        mov bx, word ptr [ _RxDOS_pDPB. _segment ]
        mov dx, word ptr [ _RxDOS_pDPB. _pointer ]

RxDOS_CDSinit_04:
        mov byte ptr es:[ _cdsActualDirectory ][ si ], al
        mov byte ptr es:[ _cdsActualDirectory + 1 ][ si ], ':'
        mov byte ptr es:[ _cdsActualDirectory + 2 ][ si ], '\'
        mov byte ptr es:[ _cdsActualDirectory + 3 ][ si ], 0
        mov byte ptr es:[ _cdsNonSubstOffset ][ si ], 3

        inc al
        add si, sizeCDS
        loop RxDOS_CDSinit_04

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  init DPB values for each CDS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        setDS cs
        xor cx, cx
        les di, dword ptr [ _RxDOS_pCDS ]
        mov ax, word ptr [ _RxDOS_pDPB. _pointer ] 
        mov dx, word ptr [ _RxDOS_pDPB. _segment ]
        mov cl, byte ptr [ _RxDOS_bNumBlockDev ]

RxDOS_CDSinit_06:
        mov word ptr es:[ _cdsPtrToDPB. _pointer ][ di ], ax
        mov word ptr es:[ _cdsPtrToDPB. _segment ][ di ], dx
        add ax, sizeDPB
        add di, sizeCDS
        loop RxDOS_CDSinit_06

        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Disk Parameter Blocks SubSystem Initialize             ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  ax  number of files to initialize.                           ;
        ;...............................................................;

RxDOSini_SFTSubSystem:

        setDS cs
        push ax                                         ; files
        mov cx, sizeSFT
        mul cx                                          ; total bytes for SFT's
        add cx, sizeFT

        call AllocateSystemSpace
        mov word ptr [ _RxDOS_pFT. _segment ], es 
        mov word ptr [ _RxDOS_pFT. _pointer ], di

        mov word ptr es:[ nextFTPointer. _pointer ], -1
        pop word ptr es:[ numberSFTEntries ][ di ]
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Disk Parameter Blocks SubSystem Initialize             ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  ax  number of cache buffers to initialize.                   ;
        ;...............................................................;

RxDOSini_CCBSubSystem:

        push ax                                         ; buffers
        mov cx, sizeCCB
        mul cx                                          ; total bytes for cache blocks

        call AllocateSystemSpace
        mov word ptr [ _RxDOS_BufferList. _segment ], es
        mov word ptr [ _RxDOS_BufferList. _pointer ], di

        pop cx                                          ; # buffers
        dec cx                                          ; no like last one
        mov dx, -1                                      ; previous

RxDOS_CCBinit_10:
        lea ax, offset sizeCCB [ di ]
        mov word ptr es:[ ccbNext ][ di ], ax           ; next
        mov word ptr es:[ ccbPrev ][ di ], dx           ; previous
        mov byte ptr es:[ ccbDrive ][ di ], -1          ; unitialized

        mov dx, di                                      ; current becomes previous
        mov di, ax                                      ; go to next
        loop RxDOS_CCBinit_10                           ; go to next -->

        mov di, dx                                      ; at end set end marker
        mov word ptr es:[ ccbNext ][ di ], -1
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Disk Parameter Blocks SubSystem Initialize             ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  ax  number of cache buffers to initialize.                   ;
        ;...............................................................;

RxDOSini_Drivers:

        mov ax, ( DEV_STDINPUT + DEV_STDOUTPUT )
        call checkforDeviceType
        jc RxDOS_DRIVERinit_10

        mov word ptr [ _RxDOS_pCONdriver. _pointer ], bx
        mov word ptr [ _RxDOS_pCONdriver. _segment ], es

RxDOS_DRIVERinit_10:
        mov ax, ( DEV_CLOCK )
        call checkforDeviceType
        jc RxDOS_DRIVERinit_12

        mov word ptr [ _RxDOS_pCLOCKdriver. _pointer ], bx
        mov word ptr [ _RxDOS_pCLOCKdriver. _segment ], es

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  allocate STDIN, STDOUT, STDERR, STDAUX, STDPRN
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RxDOS_DRIVERinit_12:
        setDS cs
        mov di, offset stdDeviceAssignTable

RxDOS_DRIVERinit_14:
        setES ds
        call checkforDeviceName                         ; locate device
        jc RxDOS_DRIVERinit_22                          ; if can't be located -->

        push bx
        push es                                         ; save pointer to driver
        call FindAvailableSFTHandle                     ; allocate an available SFT entry (es:bx)
        mov word ptr [ stdIOHandle ][ di ], ax          ; save handle assigned

        mov ax, word ptr [ stdDevInfo ][ di ]
        mov word ptr es:[ sftDevInfo ][ bx ], ax

        push di
        push bx
        mov cx, sizeFnName

RxDOS_DRIVERinit_16:
        mov al, byte ptr [ stdDriverName ][ di ]        ; copy name
        mov byte ptr es:[ sftFileName ][ bx ], al
        inc bx
        inc di
        loop RxDOS_DRIVERinit_16

        pop bx
        pop di
        pop word ptr es:[ sftDCB. _segment ][ bx ]
        pop word ptr es:[ sftDCB. _pointer ][ bx ]

RxDOS_DRIVERinit_22:
        add di, sizeStdRedirec
        cmp word ptr [ di ], -1
        jnz RxDOS_DRIVERinit_14

        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Config.sys keywords                                          ;
        ;...............................................................;

_RxDOS_ConfigFile:      db 'CONFIG  SYS', 0

_RxDOS_ConfigKeywords:  dw CONFIGTYPE_BREAK             ; on | off
                        db 'break', 0

                        dw CONFIGTYPE_BUFFERS           ; n
                        db 'buffers', 0

                        dw CONFIGTYPE_COUNTRY           ; option
                        db 'country', 0

                        dw CONFIGTYPE_COMMENTS          ; option
                        db 'comments', 0

                        dw CONFIGTYPE_DEVICEHIGH        ; path and switches
                        db 'devicehigh', 0

                        dw CONFIGTYPE_DEVICE            ; path and switches
                        db 'device', 0

                        dw CONFIGTYPE_DOS               ; umb, high, low, ...
                        db 'dos', 0

                        dw CONFIGTYPE_DRIVPARAM         ; options
                        db 'drivparm', 0

                        dw CONFIGTYPE_FCBS              ; x, y
                        db 'fcbs', 0

                        dw CONFIGTYPE_FILES             ; n
                        db 'files', 0

                        dw CONFIGTYPE_INCLUDE           ; section name
                        db 'include', 0

                        dw CONFIGTYPE_INSTALLHIGH       ; program name and cmd line
                        db 'installhigh', 0

                        dw CONFIGTYPE_INSTALL           ; program name and cmd line
                        db 'install', 0

                        dw CONFIGTYPE_LASTDRIVE         ; letter
                        db 'lastdrive', 0

                        dw CONFIGTYPE_MENUCOLOR         ; = x, y
                        db 'menucolor', 0

                        dw CONFIGTYPE_MENUDEFAULT       ; section name. timeout
                        db 'menudefault', 0

                        dw CONFIGTYPE_MENUITEM          ; section name [, comment ]
                        db 'menuitem', 0

                        dw CONFIGTYPE_MULTITRACK        ; unsupported
                        db 'multitrack', 0

                        dw CONFIGTYPE_NUMLOCK           ; on, off
                        db 'numlock', 0

                        dw CONFIGTYPE_REM               ; always !
                        db 'rem', 0

                        dw CONFIGTYPE_SET               ; always !
                        db 'set', 0

                        dw CONFIGTYPE_SHELL             ; path and switches
                        db 'shell', 0

                        dw CONFIGTYPE_STACKS            ; x, y
                        db 'stacks', 0

                        dw CONFIGTYPE_SUBMENU           ; menu section [, comment ]
                        db 'submenu', 0

                        dw CONFIGTYPE_SWITCHCHAR        ; char
                        db 'switchar', 0

                        dw CONFIGTYPE_SWITCHES          ; not supported
                        db 'switches', 0

                        dw -1, 0

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  True/ False Table                                            ;
        ;...............................................................;

_RxDOS_ConfigTrueFalse: dw TRUE                         ; not really a command
                        db 'true', 0

                        dw FALSE                        ; not really a command
                        db 'false', 0

                        dw -1, 0

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  DOS options                                                  ;
        ;...............................................................;

_RxDOS_ConfigDOSOptions:dw 1                            ; not really a command
                        db 'umb', 0  

                        dw -1                           ; not really a command
                        db 'noumb', 0

                        dw 2                            ; not really a command
                        db 'high', 0

                        dw -2                           ; not really a command
                        db 'low', 0

                        dw -1, 0

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Numlock options                                              ;
        ;...............................................................;

_RxDOS_ConfigOnOff:     dw _ON                          ; not really a command
                        db 'on', 0

                        dw _OFF                         ; not really a command
                        db 'off', 0

                        dw -1, 0

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Error Messages                                               ;
        ;...............................................................;

msgUnknownCommandinConfig: db 'Unrecognized command in config.sys', '$', 0
msgProcessCommandYesNo:    db ' [y,n]?', '$', 0
msgNewLine:                db ('M' - 40h), ('J' - 40h), '$', 0

Config_MenuSelector:       db 'MENU', 0
Config_CommonSelector:     db 'COMMON', 0

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Relocate Data Segment Low                                    ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  DX       where to relocate DS:                               ;
        ;                                                               ;
        ;  At the start of the program, the Data Segment is located at  ;
        ;  the low end of the current CS:.   The  Data  Segment  space  ;
        ;  begins at 0000 and ends at 'SDAExtendedSwapArea'             ;
        ;...............................................................;

relocateDataSegmentLow:

   IFE DEBUG - No                                       ; if NOT DEBUG
        mov es, dx                                      ; destination segment
        mov cx, offset SDAExtendedSwapArea              ; size

        xor di, di
        xor si, si
        shr cx, 1                                       ; words
        rep movsw                                       ; copy

    ; stack also moves with data segment

        mov ss, dx                                      ; but offset remains intact
        mov ds, dx                                      ; but offset remains intact
        mov word ptr [ _RxDOS_CurrentSeg ], ds          ; Current Segment.
   ENDIF

        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Initialize                                                   ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Expects from rxdosbio.sys:                                   ;
        ;                                                               ;
        ;  DL       unit code of startup disk                           ;
        ;  ES:DI    points to SYSINIT block                             ;
        ;...............................................................;

RxDOS_initialize:

        cli                                             ; disable interrupts
        cld                                             ; set direction
        mov ax, cs
        mov ds, ax
        mov ss, ax
        mov sp, offset RxDOS_StackTemp                  ; use temp stack
        mov word ptr [ _RxDOS_CurrentSeg ], ss          ; Current Segment.

        sti

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  initialize data segment
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        Entry 
        defbytes _execBlock, sizeEXEC
        ddef _InitBlockPtr, es, di
        mov dl, byte ptr es:[ initBootDrive ][ di ]
        mov byte ptr [ _RxDOS_BootDrive ], dl           ; boot drive 
        mov byte ptr [ _RxDOS_CurrentDrive ], dl        ; default to drive A:

        mov cl, byte ptr es:[ initTotalDrives ][ di ]   ; number of block devices
        mov byte ptr [ _RxDOS_bNumBlockDev ], cl        ; number of block devices
        mov byte ptr [ _RxDOS_bLastDrive ], cl          ; number of logical devices

        mov cx, 4
        mov ax, offset RxDOS_EndOfInitCode
        shr ax, cl
        mov cx, cs
        add cx, ax
        mov word ptr ss:[ _RxDOS_pStartMemBlock ], cx   ; allocate from here

        mov cx, 6
        mov ax, word ptr es:[ initMemParagraphs ][ di ] ; available memory size
        shl ax, cl                                      ; convert to segment address form
        mov word ptr [ _RxDOS_MaxMemory ], ax           ; memory available

        mov ax, word ptr es:[ initDeviceChain. _pointer ][ di ]
        mov dx, word ptr es:[ initDeviceChain. _segment ][ di ]
        mov word ptr [ _RxDOS_NULLDev. _pointer ], ax
        mov word ptr [ _RxDOS_NULLDev. _segment ], dx

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  set interrupt vectors for int 00, 21, 22, 23, 24, 25, 26, 28, 2f, ...
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        xor bx, bx
        mov ds, bx
        mov bx, ( 80h * 4 )                             ; int 80h
        mov word ptr _pointer [ bx ], offset _Interrupt_21
        mov word ptr _segment [ bx ], cs

        mov bx, ( 21h * 4 )                             ; int 21h
        mov word ptr _pointer [ bx ], offset _Interrupt_21
        mov word ptr _segment [ bx ], cs

        mov bx, ( 20h * 4 )                             ; int 20h
        mov word ptr _pointer [ bx ], offset _Interrupt_20
        mov word ptr _segment [ bx ], cs

        mov bx, ( 23h * 4 )                             ; int 23h
        mov word ptr _pointer [ bx ], offset _Interrupt_23
        mov word ptr _segment [ bx ], cs

        mov bx, ( 24h * 4 )                             ; int 24h
        mov word ptr _pointer [ bx ], offset _Interrupt_24
        mov word ptr _segment [ bx ], cs

        mov bx, ( 25h * 4 )                             ; int 25h
        mov word ptr _pointer [ bx ], offset _Interrupt_25
        mov word ptr _segment [ bx ], cs

        mov bx, ( 26h * 4 )                             ; int 26h
        mov word ptr _pointer [ bx ], offset _Interrupt_26
        mov word ptr _segment [ bx ], cs

        mov bx, ( 27h * 4 )                             ; int 27h
        mov word ptr _pointer [ bx ], offset _Interrupt_27
        mov word ptr _segment [ bx ], cs

        mov bx, ( 28h * 4 )                             ; int 28h
        mov word ptr _pointer [ bx ], offset _Interrupt_28
        mov word ptr _segment [ bx ], cs

        mov bx, ( 30h * 4 )                             ; jmp far 30h
        mov byte ptr [ bx ], 0EAh                       ; jmp far
        mov word ptr (1 + _pointer)[ bx ], offset _CallDOS
        mov word ptr (1 + _segment)[ bx ], cs
        
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  this code should move to IO.SYS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        setDS cs
        call maxBlockDevices 
        mov byte ptr [ _RxDOS_bNumBlockDev ], cl        ; number of block devices

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  initialized Environment Size
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        mov ax, offset _RxDOS_SharedBuffer
        mov word ptr [ _RxDOS_pDTA. _pointer ], ax
        mov word ptr [ _RxDOS_pDTA. _segment ], ds

        mov word ptr [ _RxDOS_EnvironmentSize ], (DEFAULT_MINENVIRONMENT / PARAGRAPH)
        mov word ptr [ _RxDOS_CurrentPSP      ], 0000

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  relocate data segment low
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        mov dx, word ptr [ _RxDOS_pStartMemBlock ]      ; where to relocate ds
        call relocateDataSegmentLow

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  initialize memory and other buffers
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        call RxDOSini_MemorySubSystem
        call RxDOSini_DPBSubSystem
        call RxDOSini_CDSSubSystem

        mov ax, DEFAULT_FILES
        call RxDOSini_SFTSubSystem                      ; open CON, AUX, PRN.

        mov ax, DEFAULT_BUFFERS
        call RxDOSini_CCBSubSystem
        call RxDOSini_Drivers

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  parse CONFIG.SYS file
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        xor di, di
        mov ax, word ptr [ _RxDOS_MaxMemory ]           ; available memory 
        sub ax, 64 * ( 1024 / 16 )                      ; segments 
        mov es, ax

        call configProcessing

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  load Command.Com and transfer control
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RxDOS_init_26:
        setDS cs
        setES ss
        lea di, offset _execBlock [ bp ]
        clearMemory sizeEXEC                            ; clear load exec block

        mov bx, di                                      ; exec block address to bx
        mov dx, offset _RxDOS_CommandShell
        Int21 ExecuteProgram, 00

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Display Error Message and STOP
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        push cs
        pop ds
        mov si, offset RxDOSmsg_CouldNotFindShell

RxDOS_init_32:
        lodsb
        or al, al
        jz RxDOS_init_38

        int 29h                                         ; display message
        jmp RxDOS_init_32

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Wait for CTRL+ALT+DEL
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RxDOS_init_38:
        xor ax, ax
        int 16h                                         ; this allows CTRL+ALT+DEL
        jmp RxDOS_init_38                               ; return not expected

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Error Message
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RxDOSmsg_CouldNotFindShell:
                        db 0Dh, 0Ah, 'Could not find command shell', 0

RxDOS_EndOfInitCode     equ $
RxDOS_EndOfInitCodePara equ ($+sizePARAGRAPH-1)/sizePARAGRAPH

RxDOS   ENDS
        END

