        TITLE   'mem - Memory Management Functions'
        PAGE 59, 132
        .LALL

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  MEM - Memory Management Functions                            ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Real Time Dos                                                ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  This material  was created as a published version  of a DOS  ;
        ;  equivalent product.   This program  logically  functions in  ;
        ;  the same way as  MSDOS functions and it  is  internal  data  ;
        ;  structure compliant with MSDOS 5.0                           ;
        ;                                                               ;
        ;  This product is distributed  AS IS and contains no warranty  ;
        ;  whatsoever,   including  warranty  of   merchantability  or  ;
        ;  fitness for a particular purpose.                            ;
        ;                                                               ;
        ;                                                               ;
        ;  (c) Copyright 1990, 1994. Api Software and Mike Podanoffsky  ;
        ;      All Rights Reserved Worldwide.                           ;
        ;                                                               ;
        ;  This product is protected under copyright laws and  may not  ;
        ;  be reproduced  in whole  or in part, in any form  or media,  ;
        ;  included but not limited to source listing, facimilie, data  ;
        ;  transmission, cd-rom, or  floppy disk without the expressed  ;
        ;  written consent of the author.                               ;
        ;                                                               ;
        ;  Licence for distribution in commercial use:                  ;
        ;                                                               ;
        ;  Api Software                                                 ;
        ;  12 South Walker Street                                       ;
        ;  Lowell,  MA   01851                                          ;
        ;                                                               ;
        ;  internet: mikep@world.std.com                                ;
        ;                                                               ;
        ;...............................................................;

        include rxdosmac.asm
        include rxdosdef.asm

RxDOS   SEGMENT PUBLIC 'CODE'
        assume cs:RxDOS, ds:RxDOS, es:RxDOS, ss:RxDOS

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  MEM - Memory Management Functions                            ;
        ;...............................................................;

        public allocateMemBlock
        public _freeMemBlock
        public _modifyMemBlock

        public _initializeMemoryBlock
        public _collectMemoryBlocks
        public _releaseOwnerMemoryBlocks
        public _allocateUpperMB
        public _allocateConvMB
        public _allocateMinMaxMemBlock
        public _getMemBlockSize

        extrn _RxDOS_CurrentPSP                 : word
        extrn _RxDOS_pStartMemBlock             : word
        extrn _RxDOS_DOSProgramName             : byte
        extrn _RxDOS_AllocStrategy              : word
        extrn _RetCallersStackFrame             : near

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Allocate Min Max Memory Block                                ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;  ax   minimum block                                           ;
        ;  dx   maximum block                                           ;
        ;                                                               ;
        ;  Returns:                                                     ;
        ;  es   segment address of allocated memory block               ;
        ;  ax   segment address of allocated memory block header        ;
        ;  cx   size of memory available                                ;
        ;...............................................................;

_allocateMinMaxMemBlock:

        Entry
        def  _minParag, ax
        def  _maxParag, dx

        mov cx, dx                                      ; try for max
        call allocateMemBlock                           ; will probably fail
        jnc _allocateMinMaxMemBlock_20                  ; if ok -->

        cmp cx, word ptr [ _minParag ][ bp ]            ; largest available will fit ?
        jnc _allocateMinMaxMemBlock_12                  ; yes, go for max -->
        SetError errNotEnoughMemory, _allocateMinMaxMemBlock_20

_allocateMinMaxMemBlock_12:
        call allocateMemBlock                           ; allocate largest available
        mov es, ax                                      ; segment address
        sub ax, (sizeMEMBLOCK/ PARAGRAPH)
        or ax, ax

_allocateMinMaxMemBlock_20:
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Initialize Memory Block                                      ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es    segment points to memory block to initialize           ;
        ;  ax    is size to initialize (paragraphs )                    ;
        ;  bx    parent                                                 ;
        ;         0000 block is free                                    ;
        ;         0008 (_RxDOS_PARENT_SIGNATURE) block belongs to RxDOS ;
        ;...............................................................;

_initializeMemoryBlock:
        push ax                                         ; init length (paragraphs )

        xor ax, ax
        xor di, di
        mov cx, (sizeMEMBLOCK)/2                        ; size of memory header (words )
        rep stosw

        pop ax
        xor di, di
        mov byte ptr es:[ _memSignature ], _RxDOS_ENDSIGNATURE
        mov word ptr es:[ _memAlloc ], ax
        mov word ptr es:[ _memParent ], bx

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  if valid PSP, copy program name to memory block
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        cmp bx, _RxDOS_PARENT_SIGNATURE                 ; RxDOS Block ?
        jnz _initMemory_20                              ; if not RxDOS -->

        push ds
        push si
        push di

        currSegment ds                                  ; point to data segment
        mov si, offset [ _RxDOS_DOSProgramName ]
        lea di, offset _memPgmName [ di ]
        mov cx, 4                                       ; (size _RxDOS_DOSProgramName)/2
        rep movsw                                       ; copy RxDOS name to memory block

        pop di
        pop si
        pop ds

_initMemory_20:
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Allocate Memory Block                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;  cx   # paragraphs of memory requested                        ;
        ;                                                               ;
        ;  Returns:                                                     ;
        ;  es   segment address of allocated memory block               ;
        ;  cx   size of largest block of memory available in            ;
        ;         paragraphs, if allocation fails.                      ;
        ;  cy   if error                                                ;
        ;...............................................................;

allocateMemBlock:

        Entry
        def  _allocation, cx

        mov bx, cx
        call _allocateUpperMB                           ; allocate upper mem blocks
        jnc allocateMemBlock_12                         ; if allocation made -->

        getarg bx, _allocation
        call _allocateConvMB                            ; allocate lower mem blocks

allocateMemBlock_12:
        mov es, ax                                      ; segment allocation
        mov cx, dx                                      ; largest block
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Collect Memory Blocks                                        ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  This routine will scan all memory blocks and merge all free  ;
        ;  memory blocks together.                                      ;
        ;...............................................................;

_collectMemoryBlocks:

        push ds
        push es
        mov ax, word ptr ss:[ _RxDOS_pStartMemBlock ]

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  is block free ?
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_collectMemoryBlocks_08:
        mov ds, ax                                      ; next in ax

_collectMemoryBlocks_12:
        cmp byte ptr ds:[ _memSignature ], _RxDOS_ENDSIGNATURE
        jz _collectMemoryBlocks_36                      ; done -->

        cmp word ptr ds:[ _memParent ], 0000            ; is block free ?
        jnz _collectMemoryBlocks_26                     ; no, go to next -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  is next also free ?
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        mov ax, ds                                      ; get current segment
        add ax, word ptr ds:[ _memAlloc ]               ; increment to next block
        inc ax
        mov es, ax
        cmp word ptr es:[ _memParent ], 0000            ; is next block free ?
        jnz _collectMemoryBlocks_08                     ; no, go to next -->

        mov ax, word ptr es:[ _memAlloc ]               ; get next allocation
        inc ax                                          ; kill interim Mem block as well
        add word ptr ds:[ _memAlloc ], ax               ; add to current block

        mov al, byte ptr es:[ _memSignature ]           ; last signature is passed to current block
        mov byte ptr ds:[ _memSignature ], al           ;
        jmp _collectMemoryBlocks_12

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  go to next
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_collectMemoryBlocks_26:
        mov ax, ds                                      ; get current segment
        add ax, word ptr ds:[ _memAlloc ]               ; increment to next block
        inc ax
        jmp _collectMemoryBlocks_08

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  done
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_collectMemoryBlocks_36:
        pop es
        pop ds
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  release all Mem blocks for owner                             ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   bx     PSP address of owner                                 ;
        ;...............................................................;

_releaseOwnerMemoryBlocks:

        push es
        mov ax, word ptr ss:[ _RxDOS_pStartMemBlock ]

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  does block belong to owner ?
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_releaseOwnerMemoryBlocks_08:
        mov es, ax                                      ; next block in ax
        cmp bx, word ptr es:[ _memParent ]              ; owner block ?
        jnz _releaseOwnerMemoryBlocks_12                ; no -->
        mov word ptr es:[ _memParent ], 0000            ; free up block

_releaseOwnerMemoryBlocks_12:
        cmp byte ptr es:[ _memSignature ], _RxDOS_ENDSIGNATURE
        jz _releaseOwnerMemoryBlocks_24                 ; if at end -->

        mov ax, es                                      ; get current segment
        add ax, word ptr es:[ _memAlloc ]               ; increment to next block
        inc ax
        jmp _releaseOwnerMemoryBlocks_08
        
_releaseOwnerMemoryBlocks_24:
        pop es
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Free Memory Block                                            ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   es     memory block                                         ;
        ;...............................................................;

_freeMemBlock:

        push es
        mov ax, es
        sub ax, ( sizeMEMBLOCK / PARAGRAPH )
        mov es, ax
        cmp byte ptr es:[ _memSignature ], _RxDOS_MEMSIGNATURE
        jz _freeMemBlock_12
        cmp byte ptr es:[ _memSignature ], _RxDOS_ENDSIGNATURE
        jnz _freeMemBlock_16

_freeMemBlock_12:
        mov word ptr es:[ _memParent ], 0000            ; free up block
        call _collectMemoryBlocks                       ; collect free blocks

_freeMemBlock_16:
        pop es
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Modify Block Size                                            ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  es   paragraph to free                                       ;
        ;  bx   new paragraph size                                      ;
        ;...............................................................;

_modifyMemBlock:

        mov ax, es
        sub ax, ( sizeMEMBLOCK / PARAGRAPH )
        mov es, ax
        cmp byte ptr es:[ _memSignature ], _RxDOS_MEMSIGNATURE
        jz _modifyMemBlock_12
        cmp byte ptr es:[ _memSignature ], _RxDOS_ENDSIGNATURE
        jz _modifyMemBlock_12

        SetError errInvalidBlock, _modifyMemBlock_66

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  are we expanding allocation ?
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_modifyMemBlock_12:
        cmp bx, word ptr es:[ _memAlloc ]
        jz _modifyMemBlock_66                           ; same size as now, ignore request -->
        jc _modifyMemBlock_32                           ; no, contracting allocation -->

        push es
        mov ax, es
        add ax, word ptr es:[ _memAlloc ]
        inc ax                                          ; point to next block
        mov es, ax
        cmp word ptr es:[ _memParent ], 0000            ; is next block free ?
        jz _modifyMemBlock_16                           ; yes, ok to try to expand -->

        pop es
        SetError errNotEnoughMemory, _modifyMemBlock_66

_modifyMemBlock_16:
        cmp bx, word ptr es:[ _memAlloc ]               ; is extra block enough to expand ?
        jle _modifyMemBlock_18                          ; yes, ok to try to expand -->

        pop es
        SetError errNotEnoughMemory, _modifyMemBlock_66

_modifyMemBlock_18:
        mov cx, word ptr es:[ _memAlloc ]               ; existing allocation
        mov dl, byte ptr es:[ _memSignature ]           ; existing signature

        pop es
        add word ptr es:[ _memAlloc ], bx               ; expanded allocation

        mov ax, es                                      ; current allocation
        add ax, word ptr es:[ _memAlloc ]               ; where next block will appear
        inc ax
        mov es, ax                                      ; create a block here 

        mov ax, cx                                      ; new allocation size
        sub ax, bx                                      ; part acquired by expansion
        xor bx, bx                                      ; parent of new remainder is free
        call _initializeMemoryBlock                     ; initialize memory block.
        mov byte ptr es:[ _memSignature ], dl           ; previous signature stays.

        clc
        ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  collapse allocated space
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_modifyMemBlock_32:
        mov cx, es                                      ; current segment
        add cx, bx
        inc cx                                          ; where to create next mem seg

        mov ax, word ptr es:[ _memAlloc ]               ; existing space
        sub ax, bx                                      ; size of remaining block
        dec ax                                          ; make room for mem header
        stc
        jz _modifyMemBlock_66                           ; not enough room -->

        mov byte ptr es:[ _memSignature ], _RxDOS_MEMSIGNATURE
        mov word ptr es:[ _memAlloc ], bx               ; re-allocate space

        mov es, cx
        xor bx, bx                                      ; free block
        call _initializeMemoryBlock                     ; initialize memory block.
        call _collectMemoryBlocks                       ; collect free blocks

        clc

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_modifyMemBlock_66:
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Allocate Upper Memory Blocks                                 ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  bx   # paragraphs of memory requested                        ;
        ;                                                               ;
        ;  Returns:                                                     ;
        ;  ax   segment address of allocated memory block               ;
        ;  dx   size of largest block of memory available in            ;
        ;         paragraphs, if allocation fails.                      ;
        ;...............................................................;

_allocateUpperMB:
        stc
        ret

        test word ptr [ _RxDOS_AllocStrategy ], (_MEM_FIRSTFIT_HIGH + _MEM_FIRSTFIT_HIGHONLY )
        jnz _allocateUpperMB_14                         ; if search upper memory blocks -->

_allocateUpperMB_12:
        xor dx, dx
        SetError errNotEnoughMemory
        ret

_allocateUpperMB_14:
        mov ax, _RxDOS_HIGHMEMBLOCK
        call _localAreaAllocateMemory
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Allocate Conventional Memory Blocks                          ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  bx   # paragraphs of memory requested                        ;
        ;                                                               ;
        ;  Returns:                                                     ;
        ;  ax   segment address of allocated memory block               ;
        ;  dx   size of largest block of memory available in            ;
        ;         paragraphs, if allocation fails.                      ;
        ;...............................................................;

_allocateConvMB:
        test word ptr [ _RxDOS_AllocStrategy ], (_MEM_FIRSTFIT_HIGHONLY )
        jz _allocateConvMB_14                           ; if search conv memory blocks -->

_allocateConvMB_12:
    ;   xor dx, dx
    ;   SetError errNotEnoughMemory
    ;   ret

_allocateConvMB_14:
        mov ax, word ptr ss:[ _RxDOS_pStartMemBlock ]
        call _localAreaAllocateMemory
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Local Zone Memory Allocation                                 ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  ax   paragraph to begin search                               ;
        ;  bx   # paragraphs of memory requested                        ;
        ;                                                               ;
        ;  Returns:                                                     ;
        ;  ax   segment address of allocated memory block               ;
        ;  bx   size of largest block of memory available in            ;
        ;         paragraphs, if allocation fails.                      ;
        ;...............................................................;

_localAreaAllocateMemory:

        Entry
        def _bestFit, 0000                              ; segment pointer to best fit
        def _lastFit, 0000                              ; segment pointer to last fit

        push ds
        push es                                         ; save segment registers
        or ax, ax                                       ; zero if no mem allocated 
        jnz _allocMem_10                                ; mem list available -->
        xor dx, dx                                      ; no memory available
        SetError errNotEnoughMemory, _allocMem_44       ; error -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  scan memory blocks
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_allocMem_10:
        cli                                             ; prevent interrupts
        xor dx, dx                                      ; largest available
        mov cx, 0ffffh                                  ; best fit

_allocMem_12:
        mov es, ax                                      ; point to memory seg
        cmp byte ptr es:[ _memSignature ], _RxDOS_MEMSIGNATURE
        jz _allocMem_14                                 ; if valid arena -->
        cmp byte ptr es:[ _memSignature ], _RxDOS_ENDSIGNATURE
        jz _allocMem_14                                 ; if valid arena -->
        SetError errInvalidBlock, _allocMem_44          ; else, if error -->

_allocMem_14:
        cmp word ptr es:[ _memParent ], 0000            ; 0000 for parent means its free
        jnz _allocMem_20                                ; not a free block -->

        mov si, word ptr es:[ _memAlloc ]               ; get available space
        sub si, bx                                      ; is block within allocation size ?
        jc _allocMem_16                                 ; no -->

        storarg _lastFit, ax                            ; seg address of last fit
        test word ptr [ _RxDOS_AllocStrategy ], _MEM_FIRSTFIT_STRATEGY
        jz _allocMem_30                                 ; ok to allocate this block ->

        cmp cx, si                                      ; is this block a better fit ?
        jc _allocMem_16                                 ; not a better strategy -->
        mov cx, si                                      ; else save fit
        storarg _bestFit, ax                            ; seg address of best fit

_allocMem_16:
        cmp dx, word ptr es:[ _memAlloc ]               ; larger block ?
        jnc _allocMem_20                                ; no -->
        mov dx, word ptr es:[ _memAlloc ]               ; get size

_allocMem_20:
        inc ax
        add ax, word ptr es:[ _memAlloc ]      
        cmp byte ptr es:[ _memSignature ], _RxDOS_ENDSIGNATURE
        jnz _allocMem_12                                ; not at end yet -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  available block not found or allocation deferred to here
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        getarg ax, _bestFit
        test word ptr [ _RxDOS_AllocStrategy ], _MEM_BESTFIT_STRATEGY
        jnz _allocMem_24                                ; if best fit -->

        getarg ax, _lastFit
        test word ptr [ _RxDOS_AllocStrategy ], _MEM_LASTFIT_STRATEGY
        jz _allocMem_26                                 ; if not last fit -->

_allocMem_24:
        or ax, ax                                       ; determine if no allocation
        jnz _allocMem_30                                ; if block available -->

_allocMem_26:
        SetError errNotEnoughMemory, _allocMem_44       ; error exit -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Allocate block.
;
;  assumes es: points to free block to allocate
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_allocMem_30:
        mov es, ax                                      ; 
        push es                                         ; segment to return
        push bx                                         ; size requested
        mov dl, byte ptr es:[ _memSignature ]           ; current block signature

        mov ax, word ptr es:[ _memAlloc ]               ; get allocation
        sub ax, bx                                      ; this is remaining alloc balance
        jz _allocMem_38                                 ; if exact fit -->

        dec ax                                          ; make room for second mem control block

        mov cx, es
        add cx, bx                                      ; space we'll need
        inc cx                                          ; where next block will be

        push dx                                         ; current block signature
        mov es, cx                                      ; create a block here 
        xor bx, bx                                      ; this block is free
        call _initializeMemoryBlock                     ; initialize memory block.
        pop dx
        mov byte ptr es:[ _memSignature ], dl           ; save real signature
        mov dl, _RxDOS_MEMSIGNATURE

; update old mem control block

_allocMem_38:
        pop bx                                          ; request size
        pop es                                          ; seg address (es: )

        mov cx, word ptr ss:[ _RxDOS_CurrentPSP ]
        mov word ptr es:[ _memParent ], cx              ; current owner
        mov word ptr es:[ _memAlloc ], bx               ; allocate what we need
        mov byte ptr es:[ _memSignature ], dl

        mov ax, es
        inc ax                                          ; seg address of data
        mov dx, word ptr es:[ _memAlloc ]               ; (was in bx)
        clc                                             ; no carry.

_allocMem_44:
        pop es                                          ; restore segment registers
        pop ds

        sti
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Get Mem Block Size                                           ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Input:                                                       ;
        ;  es   allocated block of memory (not header)                  ;
        ;                                                               ;
        ;  Returns:                                                     ;
        ;  ax   segment address of allocated memory block               ;
        ;  cx   size of memory block                                    ;
        ;...............................................................;

_getMemBlockSize:

        push es
        mov ax, es
        sub ax, ( sizeMEMBLOCK / PARAGRAPH )
        mov es, ax                                      ; point to memory seg
        cmp byte ptr es:[ _memSignature ], _RxDOS_MEMSIGNATURE
        jz _getMemBlockSize_12                          ; if valid arena -->
        cmp byte ptr es:[ _memSignature ], _RxDOS_ENDSIGNATURE
        jz _getMemBlockSize_12                          ; if valid arena -->

        SetError errInvalidBlock, _getMemBlockSize_20

_getMemBlockSize_12:
        mov cx, word ptr es:[ _memAlloc ]               ; get allocation size

_getMemBlockSize_20:
        pop es
        ret

RxDOS   ENDS
        END
