        TITLE   'Ren - RxDOS Command Shell Rename'
        PAGE 59, 132
        .LALL

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Command Shell Rename                                   ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Real Time Dos                                                ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  This material  was created as a published version  of a DOS  ;
        ;  equivalent product.   This program  logically  functions in  ;
        ;  the same way as  MSDOS functions and it  is  internal  data  ;
        ;  structure compliant with MSDOS 5.0                           ;
        ;                                                               ;
        ;  This product is distributed  AS IS and contains no warranty  ;
        ;  whatsoever,   including  warranty  of   merchantability  or  ;
        ;  fitness for a particular purpose.                            ;
        ;                                                               ;
        ;                                                               ;
        ;  (c) Copyright 1990, 1994. Api Software and Mike Podanoffsky  ;
        ;      All Rights Reserved Worldwide.                           ;
        ;                                                               ;
        ;  This product is protected under copyright laws and  may not  ;
        ;  be reproduced  in whole  or in part, in any form  or media,  ;
        ;  included but not limited to source listing, facimilie, data  ;
        ;  transmission, cd-rom, or  floppy disk without the expressed  ;
        ;  written consent of the author.                               ;
        ;                                                               ;
        ;  Licence for distribution in commercial use:                  ;
        ;                                                               ;
        ;  Api Software                                                 ;
        ;  12 South Walker Street                                       ;
        ;  Lowell,  MA   01851                                          ;
        ;                                                               ;
        ;  internet: mikep@world.std.com                                ;
        ;                                                               ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Command Shell                                          ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Programmer's Notes:                                          ;
        ;                                                               ;
        ;  Command Shell consists of  two parts bound  together into a  ;
        ;  single executable load.  There  exists  a  single  resident  ;
        ;  command shell which is accessible by an Int 2Eh.             ;
        ;                                                               ;
        ;...............................................................;

        include rxdosmac.asm
        include rxdosdef.asm
        include rxdoscin.asm

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Command Shell                                          ;
        ;...............................................................;

RxDOSCMD SEGMENT PUBLIC 'CODE'
         assume cs:RxDOSCMD, ds:RxDOSCMD, es:RxDOSCMD, ss:RxDOSCMD

        public _Rename
        public RXDOSLASTADDRESS

        extrn CmndError_FileAlreadyExists               : near
        extrn DisplayErrorMessage                       : near
        extrn DisplayLine                               : near
        extrn PreProcessCmndLine                        : near
        extrn RxDOS_DTA                                 : near
        extrn _CopyString                               : near
        extrn _lowerCase                                : near
        extrn _splitpath                                : near
        extrn _makePath                                 : near

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Rename filenameA filenameB                                   ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   ss:di  Arg Array                                            ;
        ;   ax     Number of arguments in array                         ;
        ;...............................................................;

_Rename:

        Entry
        def _filesRenamed                               ; how many renamed
        def __argarray, di                              ; args array
        defbytes _renamedFileName, 15
        defbytes _expandedname, sizeExpandedName

        mov cx, 2                                       ; must have two arguments
        mov dx, cx                                      ; must have two arguments
        xor bx, bx
        call PreProcessCmndLine                         ; make sure args are ok
        ifc _renameError                                ; if error -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  make sure second arg contains no drive or path info
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        mov di, word ptr [ __argarray ][ bp ]
        mov si, word ptr [ di + 2 ]                     ; second argument
        lea di, offset [ _expandedname ][ bp ]          ; test expansion
        call _splitpath                                 ; make sure second arg contains no drive, path

        cmp byte ptr [ _expandedname. expDrive ][ bp ], 0
        ifnz _renameError                               ; if error -->
        cmp byte ptr [ _expandedname. expPath  ][ bp ], 0
        ifnz _renameError                               ; if error -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  test for simple (no wild card case)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        mov di, word ptr [ __argarray ][ bp ]
        mov si, word ptr [ di ]                         ; first arg
        call _scanWildCharacters                        ; does filename contain wild characters 
        jz _rename_12                                   ; yes -->

        mov si, word ptr [ di + 2 ]                     ; second arg
        call _scanWildCharacters                        ; does filename contain wild characters 
        jz _rename_12                                   ; yes -->

        mov dx, word ptr [ di ]                         ; first arg
        mov di, word ptr [ di + 2 ]                     ; second arg
        Int21 RenameFile                                ; rename file
        jc _renameError                                 ; if error -->

        Return

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  split path name into [drive:] [path] [filename]
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_rename_12:
        mov cx, sizefnName
        lea si, offset [ _expandedname. expFilename ][ bp ]
        call _expandWildCharacters

        mov cx, sizefnExtension+1
        lea si, offset [ _expandedname. expExtension ][ bp ]
        call _expandWildCharacters

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  determine if files to rename
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        storarg _filesRenamed, 0000                     ; none renamed so far

        mov di, word ptr [ __argarray ][ bp ]
        mov dx, word ptr [ di ]                         ; first arg
        Int21 FindFirstFile                             ; locate file with name
        jc _rename_36                                   ; if no more -->

_rename_18:
        mov si, offset [ RxDOS_DTA. findFileName ]
        lea bx, offset [ _expandedname. expFilename ][ bp ]
        lea di, offset [ _renamedFileName   ][ bp ]
        call _renameCopy

        lea bx, offset [ _expandedname. expExtension ][ bp ]
        cmp byte ptr [ bx ], 0
        jz _rename_22

        push di
        mov al, '.'
        mov cx, (sizefnName+1)
        mov di, offset [ RxDOS_DTA. findFileName ]
        repnz scasb                                     ; locate '.'
        mov si, di
        pop di
        jnz _rename_22

        stosb                                           ; add period if one located
        inc bx                                          ; skip expansion period.
        call _renameCopy

_rename_22:
        mov dx, offset [ RxDOS_DTA. findFileName ]
        lea di, offset [ _renamedFileName   ][ bp ]
        Int21 RenameFile                                ; rename file
        jc _renameError                                 ; if error -->

        inc word ptr [ _filesRenamed ][ bp ]            ; number renamed
        Int21 FindNextFile                              ; more files to rename ?
        jnc _rename_18                                  ; if more -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  return
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_rename_36:
        cmp word ptr [ _filesRenamed ][ bp ], 0000      ; any files renamed ?
        jz _renameError                                 ; if none -->
        Return

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  error in rename command
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_renameError:
        mov dx, offset CmndError_FileAlreadyExists
        call DisplayErrorMessage
        Return

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Scan For Wild Characters                                     ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   ss:si  pointer to null terminated name                      ;
        ;...............................................................;

_scanWildCharacters:

        push si

_scanWildCharacters_08:
        lodsb
        or al, al
        jz _scanWildCharacters_16

        cmp al, '?'
        jz _scanWildCharacters_18
        cmp al, '*'
        jz _scanWildCharacters_18
        jmp _scanWildCharacters_08

_scanWildCharacters_16:
        cmp al, '?'
        
_scanWildCharacters_18:
        pop si
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Expand Wild Characters                                       ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   ss:si  pointer to null terminated name                      ;
        ;...............................................................;

_expandWildCharacters:

        lodsb
        or al, al
        jz _expandWildCharacters_10

        cmp al, '*'
        jz _expandWildCharacters_12
        loop _expandWildCharacters

_expandWildCharacters_10:
        ret

_expandWildCharacters_12:
        mov di, si
        dec di
        mov al, '?'
        rep stosb                                       ; fill with ? ...

        xor ax, ax
        stosb                                           ; add null terminator
        ret

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Create Renamed Name                                          ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  Usage:                                                       ;
        ;   ss:si  current name of file from find                       ;
        ;   ss:bx  wild character matching template                     ;
        ;   ss:di  output name field                                    ;
        ;...............................................................;

_renameCopy:

        mov al, byte ptr [ si ]
        or al, al
        jz _renameCopy_12
        cmp al, '.'
        jz _renameCopy_12

        mov al, byte ptr [ bx ]
        or al, al
        jz _renameCopy_12 
        cmp al, '?'
        jnz _renameCopy_08

        mov al, byte ptr [ si ]

_renameCopy_08:
        mov byte ptr [ di ], al

        inc si
        inc di
        inc bx
        jmp _renameCopy

_renameCopy_12:
        mov byte ptr [ di ], 00
        ret


RXDOSLASTADDRESS                EQU $

RxDOSCMD                        ENDS
                                END


