        TITLE   'RxDOS Boot Sector Program - 5 1/2 inch disks'
        PAGE 59, 132
        .LALL

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  RxDOS Boot Sector Program                                    ;
        ;...............................................................;

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Real Time Dos                                                ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  This material  was created as a published version  of a DOS  ;
        ;  equivalent product.   This program  logically  functions in  ;
        ;  the same way as  MSDOS functions and it  is  internal  data  ;
        ;  structure compliant with MSDOS 5.0                           ;
        ;                                                               ;
        ;  This product is distributed  AS IS and contains no warranty  ;
        ;  whatsoever,   including  warranty  of   merchantability  or  ;
        ;  fitness for a particular purpose.                            ;
        ;                                                               ;
        ;                                                               ;
        ;  (c) Copyright 1990, 1992. Api Software and Mike Podanoffsky  ;
        ;      All Rights Reserved Worldwide.                           ;
        ;                                                               ;
        ;  This product is protected under copyright laws and  may not  ;
        ;  be reproduced  in whole  or in part, in any form  or media,  ;
        ;  included but not limited to source listing, facimilie, data  ;
        ;  transmission, cd-rom, or  floppy disk without the expressed  ;
        ;  written consent of the author.                               ;
        ;                                                               ;
        ;  Licence for distribution in commercial use:                  ;
        ;                                                               ;
        ;  Api Software                                                 ;
        ;  12 South Walker Street                                       ;
        ;  Lowell,  MA   01851                                          ;
        ;                                                               ;
        ;  internet: mikep@world.std.com                                ;
        ;                                                               ;
        ;...............................................................;

        include rxdosmac.asm
        include rxdosdef.asm

RxDOSBOOT SEGMENT PUBLIC 'CODE'
        assume cs:RxDOSBOOT, ds:RxDOSBOOT, es:RxDOSBOOT, ss:RxDOSBOOT

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Stack Arguments
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

_diskParameterTable             db 12 dup(?)
_rootDirectory                  dd ?
_sizeRootDirectory              dw ?
_readDrive                      dw ?
_readTrack                      dw ?
_readSector                     dw ?
_readHead                       dw ?

_stackReserved                  equ ($ - _diskParameterTable) + 20h

ROMBIOS_DISKTABLE               equ ( 1Eh * 4 )

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; buffers start elsewhere
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

                                org 500h
RXDOS_READBUFFER:

                                org 700h
RXDOS_DOSLOADBUFFER:

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; assume starts at 0000:7C00
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

                                org 7C00h
RxDOS_START:                    jmp RxDOS_LOAD

; this information is standard for every boot sector

__bsOemName                     db 'RxDOS6.0'           ; 'RxDOS' if formatted by us
__bsBytesPerSector              dw ?                    ; 512 is default
__bsSectorsPerCluster           db ?
__bsResSectors                  dw ?
__bsNumCopiesFAT                db ?
__bsMaxAllocRootDir             dw ?
__bsMaxSectors                  dw ?                    ; if zero, see huge sectors
__bsMediaDescriptor             db ?
__bsSectorsPerFat               dw ?
__bsSectorsPerTrack             dw ?
__bsHeads                       dw ?
__bsHiddenSectors               dd ?
__bsHugeSectors                 dd ?

__bsDriveNumber                 db 0
                                db 0
__bsBootSignature               db 29h                  ; 29h if extended boot sector
__bsVolumeId                    dd 0                    ; unique disk ID
__bsVolumeLabel                 db sizeVolumeLabel dup(' '); not same as DOS Volume Id
__bsFileSystemType              db 'FAT12   '

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; the RxDOS boot process begins here
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RxDOS_LOAD:
        cli                                             ; no interrupts
        cld                                             ; all that we need to init

        mov ax, cs
        mov ds, ax                                      ; allow debugging
        mov es, ax                                      ; allow debugging
        mov ss, ax                                      ; allow debugging
        mov sp, 7C00h - _stackReserved
        mov bp, sp
        mov byte ptr [ _readDrive ][ bp ], dl

        mov bx, offset ROMBIOS_DISKTABLE                ; int 1E
        lds si, es:[ bx ]
        lea di, offset [ _diskParameterTable ][ bp ]
        mov word ptr es:[ _pointer ][ bx ], di
        mov word ptr es:[ _segment ][ bx ], cs
        mov cx, sizeDISKPARAM
        rep movsb

        push cs
        pop ds                                          ; allow debugging
        mov byte ptr [ _diskParameterTable. _dptHeadSettleTime ][ bp ], 15
        mov cx, word ptr [ __bsSectorsPerTrack ]
        mov byte ptr [ _diskParameterTable. _dptSectorsPerTrack ][ bp ], cl

        sti
        xor ax, ax
        int 13h                                         ; reset disk drive (ax = 0)
        jc RxDOSLOAD_Error                              ; if error -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; if no huge sectors, fix up huge sectors
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

        mov ax, word ptr [ __bsMaxSectors ]
        or ax, ax                                       ; not a huge address disk ?
        jz RxDOSLOAD_08                                 ; yes -->

        mov word ptr [ __bsHugeSectors ], ax

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; compute logical sector address of Root Directory
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RxDOSLOAD_08:
        mov bp, sp                                      ; restore stack frame.
        xor ax, ax
        mov al, byte ptr [ __bsNumCopiesFAT ]
        mul word ptr [ __bsSectorsPerFat ]
        add ax, word ptr [ __bsHiddenSectors. _low ]
        adc dx, word ptr [ __bsHiddenSectors. _high ]

        add ax, [ __bsResSectors ]
        adc dx, 0000

        mov word ptr [ _rootDirectory. _low  ][ bp ], ax
        mov word ptr [ _rootDirectory. _high ][ bp ], dx

    ; read first sector of Root Directory

        mov bx, offset RXDOS_READBUFFER
        call RxDOSPerformRead
        jc RxDOSLOAD_Error                              ; if error -->

        mov di, offset RXDOS_READBUFFER
        mov si, offset RxDOS_RXDOSBIOCOM
        mov cx, sizeFILENAME
        rep cmpsb                                       ; compare first name
        jnz RxDOSLOAD_Error                             ; if not a system disk -->

        mov di, offset (RXDOS_READBUFFER. sizeDIRENTRY)
        mov cx, sizeFILENAME
        rep cmpsb                                       ; compare second name
        jz RxDOSLOAD_LoadDOS                            ; if equal -->

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; can't load
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
RxDOSLOAD_Error:
        mov si, offset RxDOS_DISKERROR
        call RxDOSLOAD_DisplayMsg

        xor ax, ax
        int 16h                                         ; wait on any key
        int 19h                                         ; not expected to return
        jmp RxDOSLOAD_Error

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; load DOS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RxDOSLOAD_LoadDOS:
        mov ax, word ptr [ __bsMaxAllocRootDir ]
        add ax, (sizeCCBData / sizeDIRENTRY) - 1
        mov cl, 4
        shr ax, cl                                      ; sectors used by directory
        mov word ptr [ _sizeRootDirectory ][ bp ], ax   ; save size
        
        mov ax, word ptr [ RXDOS_READBUFFER. deStartCluster ]
        dec ax
        dec ax                                          ; subtract 2

        xor ch, ch
        mov cl, [ __bsSectorsPerCluster ]
        mul cx

        add ax, word ptr [ _rootDirectory. _low  ][ bp ]
        adc dx, word ptr [ _rootDirectory. _high ][ bp ]
        add ax, word ptr [ _sizeRootDirectory    ][ bp ]
        adc dx, 0000

        mov word ptr [ _rootDirectory. _low  ][ bp ], ax
        mov word ptr [ _rootDirectory. _high ][ bp ], dx

        mov bx, offset RXDOS_DOSLOADBUFFER              ; where to load
        mov cx, 3                                       ; read three sectors

RxDOSLOAD_LoadDOS_08:
        call RxDOSPerformRead
        jc RxDOSLOAD_Error                              ; if error -->

        add bx, word ptr [ __bsBytesPerSector ]
        add ax, 0001
        adc dx, 0000
        loop RxDOSLOAD_LoadDOS_08

        mov ch, byte ptr [ __bsMediaDescriptor ]
        mov dl, byte ptr [ _readDrive ][ bp ]
        mov bx, word ptr [ _rootDirectory. _low  ][ bp ]
        mov ax, word ptr [ _rootDirectory. _high ][ bp ]

        lea si, offset [ _diskParameterTable ][ bp ]
        JMP_FAR 70h, 0000h                              ; RXDOS_DOSLOADBUFFER

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Display Message, wait for ANY key
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
RxDOSLOAD_DisplayMsg:
        lodsb                                           ; get character (ds:si)
        or al, al                                       ; null terminator ?
        jz RxDOSLOAD_Return                             ; done -->

        push si
        mov ah, 0Eh
        mov bx, 0007h
        int 10h
        pop si
        jmp RxDOSLOAD_DisplayMsg

RxDOSLOAD_Return:
        ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; perform disk read
; ---------------------------------------------------------------
;  dx:ax logical sector to read
;  es:bx read buffer address
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
RxDOSPerformRead:
        push bp
        push dx
        push ax
        push cx

        div word ptr [ __bsSectorsPerTrack ]
        inc dl
        mov byte ptr [ _readSector ][ bp ], dl

        xor dx, dx
        div word ptr [ __bsHeads ]
      ; mov word ptr [ _readHead ][ bp ], ax            ; don't need to save heads
      ; mov byte ptr [ _readTrack ][ bp ], dl           ; dont need to save track
        mov dh, dl                                      ; track

        clc
        mov cl, 6
        shl ah, cl                                      ; move read head up
        or ah, byte ptr [ _readSector ][ bp ]           ; unused portion of sector
        mov cx, ax
        xchg ch, cl

        mov dl, byte ptr [ _readDrive ][ bp ]
        mov ax, 0201h                                   ; read one sector.
        int 13h

        pop cx
        pop ax
        pop dx
        pop bp
        ret

RxDOSLOAD_ErrReturn:
        stc
        ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; match entries
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
RxDOS_RXDOSBIOCOM:   db 'RXDOSBIOSYS'
RxDOS_RXDOSCOM:      db 'RXDOS   SYS'

RxDOS_DISKERROR:     db 'Not an RxDOS system disk or disk error', 0Dh, 0Ah
                     db 'Press any key to continue...', 0Dh, 0Ah, 00h

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; partition table
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

                     org RxDOS_START+200h-2
RxDOS_BootSignature: db 055h, 0AAh 

        ;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''';
        ;  Write Stub                                                   ;
        ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
        ;                                                               ;
        ;  The stub loads at the normal 100h load address and writes    ;
        ;  the boot sector to drive A:                                  ;
        ;...............................................................;

                org 100h

RxDOS_WRITESTUB:
        cli
        cld
        push cs
        pop ss
        mov sp, offset RxDOS_WRITESTUB_STACK
        sti

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; see if drive specified
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        Entry
        def _drive, 0000                                ; A:

        mov si, offset RxDOS_Welcome
        call RxDOSLOAD_DisplayMsg                       ; display welcome message

        mov si, offset 80h
        mov cl, byte ptr [ si ]
        or cl, cl
        jz RxDOS_WRITESTUB_12

RxDOS_WRITESTUB_06:
        inc si
        mov al, byte ptr [ si ]
        cmp al, ' '
        jnz RxDOS_WRITESTUB_08

        dec cl
        jnz RxDOS_WRITESTUB_06
        jmp short RxDOS_WRITESTUB_12

RxDOS_WRITESTUB_08:
        mov dl, al
        sub dl, '0'                                     ; allow 0 as A:
        jc RxDOS_WRITESTUB_12                           ; 
        cmp al, '9' + 1                                 ; allow number for drive
        jc RxDOS_WRITESTUB_10                           ; 

        mov dl, al
        sub dl, 'A'                                     ; A - Z 
        jc RxDOS_WRITESTUB_12                           ; 
        cmp al, 'Z' + 1                                 ; 
        jc RxDOS_WRITESTUB_10                           ; 

        mov dl, al
        sub dl, 'a'                                     ; a - z 
        jc RxDOS_WRITESTUB_12                           ; 
        cmp al, 'z' + 1                                 ; 
        jnc RxDOS_WRITESTUB_12                          ; 

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; get drive code
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
RxDOS_WRITESTUB_10:
        mov byte ptr [ _drive ][ bp ], dl

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Write message
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
RxDOS_WRITESTUB_12:
        mov dx, cs
        mov ds, dx
        mov es, dx

        mov dl, byte ptr [ _drive ][ bp ]
        add dl, 'A'
        mov byte ptr RxDOS_PressKeyWhenReady_Drive, dl

        mov si, offset RxDOS_PressKeyWhenReady
        call RxDOSLOAD_DisplayMsg

RxDOS_WRITESTUB_14:
        xor ax, ax
        int 16h                                         ; wait for keyboard command
        cmp al, 'M'-40h
        jz RxDOS_WRITESTUB_20
        cmp al, ' '
        jz RxDOS_WRITESTUB_20
        cmp al, 'n'
        jz RxDOS_WRITESTUB_60                           ; if no -->
        cmp al, 'N'
        jz RxDOS_WRITESTUB_60                           ; if no -->
        cmp al, 'C'-40h
        jz RxDOS_WRITESTUB_60                           ; if no -->
        jmp RxDOS_WRITESTUB_14

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; get drive parameters
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
RxDOS_WRITESTUB_20:
        push bp
        mov ah, 08h
        mov dl, byte ptr [ _drive ][ bp ]               
        int 13h                                         ; get type of drive/disk
        pop bp

        push cs
        pop es                                          ; restore es:
        xor bh, bh
        mov ax, bx                                      ; drive type
        dec ax                                          ; make it zero based
        mov cx, sizeBPB
        mul cx
        mov si, offset DriveDefaultData
        add si, ax
        mov di, offset __bsBytesPerSector
        rep movsb                                       ; copy correct BPB info
        
        xor ax, ax
        int 1Ah                                         ; get time of day
        mov word ptr [ __bsVolumeId. _low  ], dx
        mov word ptr [ __bsVolumeId. _high ], cx        ; set unique volume ID

        mov ax, 0301h
        mov bx, offset RxDOS_START

        push bp
        mov ch, 00                                      ; cylinder = 0
        mov cl, 01                                      ; sector = 1

        mov dh, 00                                      ; head = 0
        mov dl, byte ptr [ _drive ][ bp ]
        int 13h
        pop bp
        jnc RxDOS_WRITESTUB_36                          ; if everything is ok -->

        mov si, offset RxDOS_diskA_NotReadyOrError
        call RxDOSLOAD_DisplayMsg
        jmp short RxDOS_WRITESTUB_40                    ;

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; success. try again ?
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
RxDOS_WRITESTUB_36:
        mov si, offset RxDOS_diskA_WrittenSuccesfully
        call RxDOSLOAD_DisplayMsg

RxDOS_WRITESTUB_40:
        xor ax, ax
        int 16h                                         ; wait for keyboard command
        cmp al, 'n'
        jz RxDOS_WRITESTUB_60                           ; if no -->
        cmp al, 'N'
        jz RxDOS_WRITESTUB_60                           ; if no -->
        cmp al, 'C'-40h
        jz RxDOS_WRITESTUB_60                           ; if cancel -->
        jmp RxDOS_WRITESTUB_12                          ; else if retry -->

RxDOS_WRITESTUB_60:
        mov ax, 4c00h
        int 21h

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

RxDOS_Welcome:
        db 0Dh, 0Ah
        db 0Dh, 0Ah, 'RxDOS Write Boot Sector Utility. '
        db 0Dh, 0Ah, 'Usage: rxd_boot [drive]'
        db 0Dh, 0Ah, 0

RxDOS_PressKeyWhenReady:
        db 0Dh, 0Ah, 0Dh, 0Ah, 'Press Space to write boot sector on disk '

RxDOS_PressKeyWhenReady_Drive:
        db 'A. ', 0

RxDOS_diskA_WrittenSuccesfully:
        db 0Dh, 0Ah, 'Disk updated. Would you like to write another? ', 0

RxDOS_diskA_NotReadyOrError:
        db 0Dh, 0Ah, 'Disk error or drive not ready. Try again? ', 0

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  stack for stub
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

                        dw 400h dup(0)
RxDOS_WRITESTUB_STACK:  dw 0

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Drive Default Data
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
        
DriveDefaultData:

    ; 360k drive   **needs updating**

        dw sizeCCBData                          ; __bsBytesPerSector
        db 1                                    ; __bsSectorsPerCluster
        dw 1                                    ; __bsResSectors
        db 2                                    ; __bsNumCopiesFAT
        dw 00E0h                                ; __bsMaxAllocRootDir
        dw 0960h                                ; __bsMaxSectors
        db 0f9h                                 ; __bsMediaDescriptor
        dw 7                                    ; __bsSectorsPerFat
        dw 15                                   ; __bsSectorsPerTrack
        dw 2                                    ; __bsHeads
        dd 0                                    ; __bsHiddenSectors
        dd 0                                    ; __bsHugeSectors

    ; 1.2M drive

        dw sizeCCBData                          ; __bsBytesPerSector
        db 1                                    ; __bsSectorsPerCluster
        dw 1                                    ; __bsResSectors
        db 2                                    ; __bsNumCopiesFAT
        dw 00E0h                                ; __bsMaxAllocRootDir
        dw 0960h                                ; __bsMaxSectors
        db 0f9h                                 ; __bsMediaDescriptor
        dw 7                                    ; __bsSectorsPerFat
        dw 15                                   ; __bsSectorsPerTrack
        dw 2                                    ; __bsHeads
        dd 0                                    ; __bsHiddenSectors
        dd 0                                    ; __bsHugeSectors

    ; 720k drive  **needs updating**

        dw sizeCCBData                          ; __bsBytesPerSector
        db 1                                    ; __bsSectorsPerCluster
        dw 1                                    ; __bsResSectors
        db 2                                    ; __bsNumCopiesFAT
        dw 00E0h                                ; __bsMaxAllocRootDir
        dw 0960h                                ; __bsMaxSectors
        db 0f9h                                 ; __bsMediaDescriptor
        dw 7                                    ; __bsSectorsPerFat
        dw 15                                   ; __bsSectorsPerTrack
        dw 2                                    ; __bsHeads
        dd 0                                    ; __bsHiddenSectors
        dd 0                                    ; __bsHugeSectors

    ; 1.44M drive

        dw sizeCCBData                          ; __bsBytesPerSector
        db 1                                    ; __bsSectorsPerCluster
        dw 1                                    ; __bsResSectors
        db 2                                    ; __bsNumCopiesFAT
        dw 224                                  ; __bsMaxAllocRootDir
        dw 2880                                 ; __bsMaxSectors
        db 0f0h                                 ; __bsMediaDescriptor
        dw 9                                    ; __bsSectorsPerFat
        dw 18                                   ; __bsSectorsPerTrack
        dw 2                                    ; __bsHeads
        dd 0                                    ; __bsHiddenSectors
        dd 0                                    ; __bsHugeSectors

;;; sizeDriveDefaultData    equ (__bsHugeSectors + 4 - __bsBytesPerSector)

RxDOSBOOT            ENDS
                     END  RxDOS_WRITESTUB
