Listing for IRQUTIL.H
/**********************************************************************/
/*                   I R Q U T I L  . H                               */
/**------------------------------------------------------------------**/
/* task           : Constants and prototypes for  the interrupt       */
/*                  functions.                                        */
/**------------------------------------------------------------------**/
/* Author          : Michael Tischer / Bruno Jennrich                 */
/* developed on  : 3/12/1994                                          */
/* last update : 4/06/1995                                            */
/**------------------------------------------------------------------**/
/* COMPILER       : Borland C++ 3.1, Microsoft Visual C++  1.5        */
/**********************************************************************/
#ifndef __INC_IRQ_UTIL_H
#define __INC_IRQ_UTIL_H

#include "types.h"

/*- IRQ-Controller Port addresses --------------------------------------*/
#define MASTER_PIC          0x20       /* master-PIC base address*/
#define SLAVE_PIC           0xA0        /* slave-PIC base address*/
#define IRQ_MASK            0x01         /* offset to masking port */

/*- IRQ-commandos ----------------------------------------------------*/
#define EOI                 0x20 /* not specified End of Interrupt */

#define MASTER_FIRST_VECTOR 0x08   /* hardware software vectors- */
#define SLAVE_FIRST_VECTOR  0x70   /* interrupts                      */

/*- Prototypes -------------------------------------------------------*/
VOID irq_Enable ( INT iIRQ );
VOID irq_Disable( INT iIRQ );
VOID irq_SendEOI( INT iIRQ );
VOID ( _interrupt _FP *irq_SetHandler( INT iIRQ,
                       VOID (_interrupt _FP *lpHandler)() ) ) ();
BYTE irq_ReadMask( INT iController );
BYTE irq_ReadIRR ( INT iController );
BYTE irq_ReadISR ( INT iController );
#endif

