
 

/**********************************************************************/
/*                     S E R T R A N S . H                            */
/**------------------------------------------------------------------**/
/* Task        : Include file for SERTRANS.C                          */
/**------------------------------------------------------------------**/
/* Author          : Michael Tischer / Bruno Jennrich                 */
/* Developed on  : 04/08/1994                                         */
/* Last update : 04/07/1995                                           */
/**------------------------------------------------------------------**/
/* COMPILER       : Borland C++ 3.1, Microsoft Visual C++  1.5        */
/**********************************************************************/ 
#ifndef _INC_SERTRANS_H
#define _INC_SERTRANS_H

#include "types.h"

#define CCITT_POLYNOM 0x1021 /* = x^16 + x^12 + x^5 + x^0 == 0x11021! */

                                               /* Certain ASCII codes */
#define ASCII_SOH        0x01                 /* Start of header      */
#define ASCII_STX        0x02                 /* Start of text / data */
#define ASCII_EOT        0x03                 /* End of transmission  */
#define ASCII_ENQ        0x05                              /* Inquiry */
#define ASCII_ACK        0x06                 /* Positive acknowledge */
#define ASCII_NAK        0x15                 /* Negative acknowledge */
#define ASCII_SYN        0x16                 /* Synchronous idle     */

#define PACKET_DATASIZE 512

#define PACKET_FILEOPEN   0                 /* Random packet types */
#define PACKET_FILECLOSE  1
#define PACKET_FILEDATA   2

typedef struct tagPacket
{
  BYTE bType;                  /* Packet type (user-defined) */
  UINT uDataSize;               /* Valid data within packet */
  UINT uNr;                               /* Packet sequence number */
  BYTE bData[ PACKET_DATASIZE ];                              /* Data */
} PACKET;
typedef PACKET _far *LPPACKET;
typedef PACKET *PPACKET;
                                                   /* Error messages */
#define TRANS_SUCCESS        0
#define TRANS_TIMEOUT       -1
#define TRANS_TRANSERROR    -2
#define TRANS_PROTOCOL      -3
#define TRANS_CRC           -4
#define TRANS_NOFILE        -5

                                /* Action codes for trans_SendPacket() */
#define SEND_RECEIVER   0
#define SEND_SENDING    1
#define SEND_GETNAKLO   2
#define SEND_GETNAKHI   3
#define SEND_PUTCRCLO   4
#define SEND_PUTCRCHI   5
#define SEND_GETREPLY   6


                             /* Action codes for trans_ReceivePacket() */
#define RECEIVE_RECEIVE    0
#define RECEIVE_GETCRCLO   1
#define RECEIVE_GETCRCHI   2
#define RECEIVE_SIGNAL     3
#define RECEIVE_PUTACK     4
#define RECEIVE_PUTNAK     5
#define RECEIVE_PUTNAKLO   6
#define RECEIVE_PUTNAKHI   7

#define PACKET_SUCCESS   0
#define PACKET_SEQUENCE -10
#define PACKET_UNKNOWN  -11
#define PACKET_TIMEOUT  -12

#endif



