unit PD_DrawPrimitives;

{$UNDEF DEBUG}

interface

type
  graphmodes=(modex,vesa,mcga);
  {
  MODEX is a library I have,
  VESA is a BGI driver I found, and
  MCGA will be my own hand-written routines--if I get around to writing
  them.  I have everything working except a floodfill that doesn't
  overflow the stack.  :-P
  }
  line_thickness=(normal,thick,doublethick);

const
  graphmode:graphmodes=modex;
  vesa_multiplier:byte=2;

  thickness:line_thickness=normal;
  filling:boolean=false; {fills are mostly busted, so give the option}
  color:boolean=false;

  fill_pal_offset=10;
  apple_xmax=280;
  apple_ymax=192;
  apple_ymax_half=160;

procedure pd_graphinit;
procedure pd_graphshutdown;
procedure pd_draw_circle(radius:byte);
procedure pd_draw_line(x:word;y:byte);
procedure pd_draw_box(x:word;y:byte);
procedure pd_fill;
procedure pd_xor_character(ch:char);
procedure pd_put_character(ch:char);
procedure pd_plot_brush;

implementation

uses
  pd_opcodes,
  xlib2,
  graph;

procedure Set_Palette_Entry(idx,red,green,blue:byte);
begin
  case graphmode of
    mcga,
    modex,
    vesa:begin
      {vga palette is 6-bit, not 8-bit, so shift the colors down a bit}
      red:=red shr 2;
      green:=green shr 2;
      blue:=blue shr 2;
      xsetrgb(idx,red,green,blue);
    end;
  end;
end;

procedure pd_graphinit;
var
  _GraphMode, _GraphDriver, _GrErr : integer;
  fontdata:pointer;
  f:file;

begin
  case graphmode of
    modex:xsetmode(xmode320x200,320);
    vesa:begin
           _GraphDriver := InstallUserDriver('SVGA256',nil);
           if vesa_multiplier=1
             then _graphmode:=0 {2=480; 1 is 400}
             else _graphmode:=vesa_multiplier;
           InitGraph(_GraphDriver,_graphmode,'');
         end;
  end;
  {set the proper palette -- colors 0 through 7 must match the apple,
   and colors fill_pal_offset to fill_pal_offset+109 will match the 110 fill patterns}


  if color then begin
    {set line colors, taken directly from apple}
    Set_Palette_Entry(0,0,0,0);      {black}
    Set_Palette_Entry(1,60,168,60);  {green}
    Set_Palette_Entry(2,188,80,188); {violet}
    Set_Palette_Entry(3,255,255,255);{white}
    Set_Palette_Entry(4,0,0,0);      {black}
    Set_Palette_Entry(5,184,108,64); {orange}
    Set_Palette_Entry(6,64,140,184); {blue}
    Set_Palette_Entry(7,255,255,255);{white}

    {set fill colors, averaged by me}
    Set_Palette_Entry(10,248,248,248);
    Set_Palette_Entry(11,232,204,232);
    Set_Palette_Entry(12,188,192,156);
    Set_Palette_Entry(13,152,200,184);
    Set_Palette_Entry(14,124,124,124);
    Set_Palette_Entry(15,108,88,76);
    Set_Palette_Entry(16,0,0,0);
    Set_Palette_Entry(17,232,212,200);
    Set_Palette_Entry(18,216,180,156);
    Set_Palette_Entry(19,168,156,108);
    Set_Palette_Entry(20,92,52,32);
    Set_Palette_Entry(21,44,24,16);
    Set_Palette_Entry(22,120,140,60);
    Set_Palette_Entry(23,120,128,92);
    Set_Palette_Entry(24,60,68,28);
    Set_Palette_Entry(25,136,164,136);
    Set_Palette_Entry(26,136,172,108);
    Set_Palette_Entry(27,152,208,152);
    Set_Palette_Entry(28,108,180,136);
    Set_Palette_Entry(29,92,144,92);
    Set_Palette_Entry(30,76,104,76);
    Set_Palette_Entry(31,12,40,12);
    Set_Palette_Entry(32,60,152,120);
    Set_Palette_Entry(33,92,136,120);
    Set_Palette_Entry(34,200,228,200);
    Set_Palette_Entry(35,200,220,232);
    Set_Palette_Entry(36,188,180,216);
    Set_Palette_Entry(37,156,192,216);
    Set_Palette_Entry(38,140,160,172);
    Set_Palette_Entry(39,92,136,120);
    Set_Palette_Entry(40,108,176,168);
    Set_Palette_Entry(41,44,112,104);
    Set_Palette_Entry(42,12,32,44);
    Set_Palette_Entry(43,76,96,108);
    Set_Palette_Entry(44,92,132,152);
    Set_Palette_Entry(45,140,152,200);
    Set_Palette_Entry(46,128,108,188);
    Set_Palette_Entry(47,168,144,168);
    Set_Palette_Entry(48,220,164,220);
    Set_Palette_Entry(49,172,136,200);
    Set_Palette_Entry(50,160,104,160);
    Set_Palette_Entry(51,92,40,92);
    Set_Palette_Entry(52,112,84,108);
    Set_Palette_Entry(53,60,52,92);
    Set_Palette_Entry(54,204,132,176);
    Set_Palette_Entry(55,140,68,108);
    Set_Palette_Entry(56,124,116,156);
    Set_Palette_Entry(57,44,20,44);
    Set_Palette_Entry(58,156,108,124);
    Set_Palette_Entry(59,184,92,124);
    Set_Palette_Entry(60,204,136,140);
    Set_Palette_Entry(61,92,44,60);
    Set_Palette_Entry(62,252,252,252);
    Set_Palette_Entry(63,0,0,0);
    Set_Palette_Entry(64,232,212,204);
    Set_Palette_Entry(65,216,176,156);
    Set_Palette_Entry(66,172,152,140);
    Set_Palette_Entry(67,216,176,156);
    Set_Palette_Entry(68,168,152,140);
    Set_Palette_Entry(69,200,140,108);
    Set_Palette_Entry(70,184,108,64);
    Set_Palette_Entry(71,92,52,32);
    Set_Palette_Entry(72,92,52,32);
    Set_Palette_Entry(73,44,24,16);
    Set_Palette_Entry(74,204,224,232);
    Set_Palette_Entry(75,140,156,168);
    Set_Palette_Entry(76,156,196,216);
    Set_Palette_Entry(77,156,192,216);
    Set_Palette_Entry(78,112,168,200);
    Set_Palette_Entry(79,140,156,168);
    Set_Palette_Entry(80,64,140,184);
    Set_Palette_Entry(81,48,104,136);
    Set_Palette_Entry(82,32,68,92);
    Set_Palette_Entry(83,16,32,44);
    Set_Palette_Entry(84,76,96,108);
    Set_Palette_Entry(85,140,156,168);
    Set_Palette_Entry(86,124,124,124);
    Set_Palette_Entry(87,248,248,248);
    Set_Palette_Entry(88,236,208,236);
    Set_Palette_Entry(89,168,144,168);
    Set_Palette_Entry(90,0,0,0);
    Set_Palette_Entry(91,140,164,136);
    Set_Palette_Entry(92,140,168,140);
    Set_Palette_Entry(93,152,208,152);
    Set_Palette_Entry(94,140,168,136);
    Set_Palette_Entry(95,152,208,152);
    Set_Palette_Entry(96,108,188,108);
    Set_Palette_Entry(97,60,168,60);
    Set_Palette_Entry(98,92,148,92);
    Set_Palette_Entry(99,76,104,76);
    Set_Palette_Entry(100,92,148,92);
    Set_Palette_Entry(101,28,84,28);
    Set_Palette_Entry(102,12,40,12);
    Set_Palette_Entry(103,204,228,204);
    Set_Palette_Entry(104,192,188,192);
    Set_Palette_Entry(105,124,124,124);
    Set_Palette_Entry(106,124,124,128);
    Set_Palette_Entry(107,220,164,220);
    Set_Palette_Entry(108,220,164,220);
    Set_Palette_Entry(109,172,144,172);
    Set_Palette_Entry(110,204,124,204);
    Set_Palette_Entry(111,188,80,188);
    Set_Palette_Entry(112,96,40,96);
    Set_Palette_Entry(113,108,80,108);
    Set_Palette_Entry(114,156,100,156);
    Set_Palette_Entry(115,156,100,156);
    Set_Palette_Entry(116,92,40,92);
    Set_Palette_Entry(117,44,20,44);
    Set_Palette_Entry(118,0,0,0);
    Set_Palette_Entry(119,0,0,0);
  end else begin
    for _Grerr:=1 to 119 do Set_Palette_Entry(_grerr,0,0,0)
  end;

  {$IFDEF DEBUG}
  {set debugging colors}
  Set_Palette_Entry(253,0,255,0);
  Set_Palette_Entry(254,255,0,0);
  {$ENDIF}

  {set the last color, 255, to white, and clear the screen with it}
  Set_Palette_Entry(255,255,255,255);
  case graphmode of
    modex:begin
            xrectfill(0,0,scrnphysicalpixelwidth-1,scrnphysicalheight-1,visiblepageoffs,253);
            xrectfill(0,0,apple_xmax-1,apple_ymax_half-1,visiblepageoffs,255);
          end;
    vesa:begin
           setcolor(255);
           bar(0,0,(apple_xmax*vesa_multiplier)-1,(apple_ymax_half*vesa_multiplier)-1);
         end;
  end;

  {set clipping, just to be safe}
  case graphmode of
    modex:xsetcliprect(0,0,apple_xmax-1,apple_ymax-1);
  end;

  {initialize font system}
  case graphmode of
    modex:begin
      xtextinit;
      assign(f,'fixed6x8.fnt');
      reset(f,1);
      getmem(fontdata,filesize(f));
      blockread(f,fontdata^,filesize(f));
      close(f);
      xregisteruserfont(fontdata^);
      xsetfont(2);
    end;
  end;
end;

procedure pd_draw_circle(radius:byte);
{x and y are center of circle; radius is in dots}
begin
  case graphmode of
    modex:begin
            xcircle(current_point.x-radius,current_point.y-radius,radius*2,line_color,visiblepageoffs);
            if thickness=thick
              then xcircle(current_point.x-radius+1,current_point.y-radius,radius*2,line_color,visiblepageoffs);
            if thickness=doublethick
              then begin
                xcircle(current_point.x-radius+1,current_point.y-radius+1,radius*2,line_color,visiblepageoffs);
                xcircle(current_point.x-radius,current_point.y-radius+1,radius*2,line_color,visiblepageoffs);
              end;
          end;
    vesa:begin
      setcolor(line_color);
      circle(current_point.x*vesa_multiplier,current_point.y*vesa_multiplier,radius*vesa_multiplier);
    end;
  end;
end;

procedure pd_draw_line(x:word;y:byte);
{draws a line of color line_color from current_point to x,y}
begin
  case graphmode of
    modex:begin
            xline(current_point.x,current_point.y,x,y,line_color,visiblepageoffs);
            if thickness=thick
              then xline(current_point.x+1,current_point.y,x+1,y,line_color,visiblepageoffs);
            if thickness=doublethick
              then begin
                xline(current_point.x+1,current_point.y+1,x+1,y+1,line_color,visiblepageoffs);
                xline(current_point.x,current_point.y+1,x,y+1,line_color,visiblepageoffs);
              end;
          end;
    vesa:begin
           setcolor(line_color);
           line(current_point.x*vesa_multiplier,current_point.y*vesa_multiplier,x*vesa_multiplier,y*vesa_multiplier);
         end;
  end;
end;

procedure pd_draw_box(x:word;y:byte);
{draws a box of color line_color from current_point to x,y}
{should this be filled??  Ask Mark}
begin
  case graphmode of
    modex:xrectfill(current_point.x,current_point.y,x,y,visiblepageoffs,line_color);
  end;
end;

procedure pd_fill;
{fills at current_point with fill_color}
begin
  if filling then begin
    case graphmode of
      {$IFDEF DEBUG}
      modex:xputpix(current_point.x,current_point.y,visiblepageoffs,fill_color+fill_pal_offset);
      {$ELSE}
      modex:xfloodfill(current_point.x,current_point.y,visiblepageoffs,fill_color+fill_pal_offset);
      {$ENDIF}
      vesa:begin
             setcolor(fill_color);
             floodfill(current_point.x,current_point.y,fill_color);
           end;
    end;
  end;
end;

procedure pd_xor_character(ch:char);
{XOR's character ch at text_cursor}
begin
  case graphmode of
    modex:begin
      xcharput(ch,text_cursor.x,text_cursor.y,visiblepageoffs,line_color xor 7);
    end;
  end;
end;

procedure pd_put_character(ch:char);
{XOR's character ch at text_cursor}
begin
  case graphmode of
    modex:begin
      xcharput(ch,text_cursor.x,text_cursor.y,visiblepageoffs,line_color);
    end;
  end;
end;

procedure pd_plot_brush;

{$I brushes.inc}

{plot brush brush_number at currentpoint in fill_color}

  procedure modex_plot_brush;

  var
    x:word;
    y:byte;

  begin
    for y:=0 to 16-1 do
      for x:=0 to 14-1 do
        case brush_number of
          0:if brush0[(y*14)+x]=1 then xputpix(current_point.x+x,current_point.y+y,visiblepageoffs,fill_color);
          1:if brush1[(y*14)+x]=1 then xputpix(current_point.x+x,current_point.y+y,visiblepageoffs,fill_color);
          2:if brush2[(y*14)+x]=1 then xputpix(current_point.x+x,current_point.y+y,visiblepageoffs,fill_color);
          3:if brush3[(y*14)+x]=1 then xputpix(current_point.x+x,current_point.y+y,visiblepageoffs,fill_color);
          4:if brush4[(y*14)+x]=1 then xputpix(current_point.x+x,current_point.y+y,visiblepageoffs,fill_color);
          5:if brush5[(y*14)+x]=1 then xputpix(current_point.x+x,current_point.y+y,visiblepageoffs,fill_color);
          6:if brush6[(y*14)+x]=1 then xputpix(current_point.x+x,current_point.y+y,visiblepageoffs,fill_color);
          7:if brush6[(y*14)+x]=1 then xputpix(current_point.x+x,current_point.y+y,visiblepageoffs,fill_color);
        {else xrectfill(current_point.x,current_point.y,
                       current_point.x+14,current_point.y+16,
                       visiblepageoffs,254);}
        end;
  end;

begin
  case graphmode of
    modex:modex_plot_brush;
  end;
end;

procedure pd_graphshutdown;
begin
  asm
    mov  ax,0003h
    int  10h
  end
end;

end.