unit PD_Opcodes;

interface

type
  opcodetype=(unknown,reserved,end_of_picture,not_yet_implemented,
              set_text_cursor,set_line_color,
              set_brush_number,set_fill_color,set_point,
              color_text_character_at_cursor,XOR_text_character_at_cursor,
              draw_box,draw_line,draw_circle,plot_brush,wait,fill,
              unpack_region,set_max_region,set_region_size);

  coordinatepair=record
    x:word;
    y:byte;
  end;

{global variables used by Picdraw}

const
  line_color:byte=0; {black}
  fill_color:byte=7; {white}
  brush_number:byte=4; {"check this"}

var
  text_cursor:coordinatepair;
  current_point:coordinatepair;

Function Opcode(var p:pointer):opcodetype;

implementation

Function Opcode;
var
  result:opcodetype;
  b:^byte;
begin
  b:=p;

  case b^ of
    $00:result:=end_of_picture;
    $30:result:=xor_text_character_at_cursor;
    $50:result:=color_text_character_at_cursor;
    $60:result:=set_fill_color;
    $b0:result:=draw_circle;
    $d0:result:=wait;
    $f0:result:=not_yet_implemented;
  else
    case (b^ and $F0) shr 4 of
      $1:result:=set_text_cursor;
      $2:result:=set_line_color;
      $4:result:=set_brush_number;
      $7:result:=reserved;
      $8:result:=set_point;
      $9:result:=draw_box;
      $a:result:=draw_line;
      $c:result:=plot_brush;
      $e:result:=fill;
      $f:result:=not_yet_implemented;
    else
      result:=unknown;
    end;
  end;

  Opcode:=result;
end;

end.
