10 '
20 '     K L O N D I K E    S O L I T A I R E   V1.2
30 '     
40 '
50 '     Copyright 1984 (C)  Mouse Systems Corporation
60 '
70 '     Written by Daniel B. Gochnauer
80 '
90 '
100 DEFINT A-Z
110 KEY OFF
120 DATA " A"," 2"," 3"," 4"," 5"," 6"," 7"," 8"," 9","10"," J"," Q"," K"
130 DIM CRD$(13)
140 DIM OLDCRD(52),COLUMN(20,7),COLUCNT(7),COLDCNT(7)
150 DIM DDECK(52),UDECK(52),CNTR(4)
160 '
170 '    Determine Display Adapter Board Type
180 '
190 DEF SEG=64
200 IF (PEEK(16) AND &H30)=&H30 THEN GOTO 230	' Monochrome Board
210 FBLK=0: FBLU=1: FRED=4: FWHT=7: FBNK=FBLK: FFSH=FWHT: BBLK=0: BBLU=1: BGRN=2: BWHT=7: MONIT=1
220 GOTO 270
230 FBLK=0: FBLU=15: FRED=7: FWHT=7: FBNK=FWHT: FFSH=FWHT: BBLK=0: BBLU=15: BGRN=0: BWHT=7: MONIT=0
240 '
250 '   Get Mouse Interface Address
260 '
270 DEF SEG=0
280 MSEG=256*PEEK(51*4+3)+PEEK(51*4+2)
290 MOUSE=256*PEEK(51*4+1)+PEEK(51*4)+2
300 IF MSEG<>0 AND MOUSE<>2 THEN 320
310 PRINT "MSMOUSE Driver not Found":END
320 DEF SEG=MSEG
330 '
340 '   Initialize the Mouse
350 '
360 M1%=0
370 CALL MOUSE(M1%,M2%,M3%,M4%)
380 IF NOT(M1%) THEN PRINT "MSMOUSE driver not installed":END
390 '
400 '   Define the Software Cursor
410 '
420 M1%=10: M2%=0: M3%=&HFFFF: M4%=&H7700
430 IF MONIT=0 THEN M4%=&HF18:M3%=&H0
440 CALL MOUSE(M1%,M2%,M3%,M4%)
450 '
460 '   Position Cursor to middle of screen
470 '
480 M1%=4
490 M3%=320: M4%=99
500 CALL MOUSE(M1%,M2%,M3%,M4%)
510 FOR I=1 TO 13:READ CRD$(I):NEXT I
520 '
530 '   Process Help Screen
540 '
550 GOSUB 8700
560 '
570 '   Initialize Game Parameters
580 '
590 X=VAL(MID$(TIME$,2,4))
600 X=VAL(RIGHT$(TIME$,2))+(X*39)
610 RULES=3				'use normal Klondike Rules
620 DOLLARS=0				' initialize dollar totals
630 RANDOMIZE X
640 FOR I=1 TO 52:OLDCRD(I)=53-I:NEXT I
650 GOSUB 7210	' shuffle the card deck
660 '
670 '   Begin game
680 '
690 SCREEN 0,1
700 COLOR FBLK,BGRN,BGRN
710 WIDTH 80
720 CLS
730 CHEAT=0
740 TALCNT=0
750 UNDOTYP=0
760 FDCNTR=0
770 GOSUB 7210	' shuffle the card deck
780 GOSUB 7210	' shuffle the card deck again for sure
790 COLOR FBLU,BGRN
800 '
810 '   Setup Game Display
820 '
830 LOCATE 2,1: PRINT "PC Mouse";
840 IF RULES=3 THEN LOCATE 3,1: PRINT "Solitaire"; ' normal Klondike Game
850 IF RULES=1 THEN LOCATE 3,1: PRINT "  Vegas  "; ' Vegas Solitaire Rules
860 COLOR FBLK,BGRN
870 FOR I=1 TO 52
880 DDECK(I)=-DDECK(I): UDECK(I)=0	 ' create "down" deck
890 NEXT I
900 CNT=1
910 FOR I1=CNT TO 7			' deal out the Tableau
920 GOSUB 7120		' get the next card on deck
930 IF CNT=I1 THEN CARD=-CARD
940 COLUMN(CNT,I1)=CARD
950 ROW=2: COL=14+(I1-1)*8
960 GOSUB 7530		' display the card
970 NEXT I1
980 COLUCNT(CNT)=1			' initialize up card count
990 COLDCNT(CNT)=CNT-1	' initialize down card count
1000 CNT=CNT+1
1010 IF CNT<=7 THEN 910
1020 FOR I=1 TO 4			' setup foundation
1030 CNTR(I)=0: CARD=0: COL=74: ROW=2+(I-1)*6
1040 GOSUB 7530 	' display card (or card shell)
1050 NEXT I
1060 CARD=DDECK(1)			' get first down card
1070 ROW=5: COL=2
1080 GOSUB 7530 	' display the "stock" pile
1090 CARD=UDECK(1)			' get first up card
1100 ROW=11: COL=2
1110 GOSUB 7530 	' display up card
1120 DEALT=0		' clear card dealt flag
1130 DOLLARS=DOLLARS-52 		' new deck costs $52 in Vegas
1140 COLOR FBLK,BWHT
1150 LOCATE 21,1: PRINT "  Undo  ";
1160 LOCATE 23,1: PRINT " Redeal ";
1170 LOCATE 25,1: PRINT "  Quit  ";
1180 '
1190 '   Select a card with the Mouse
1200 '
1210 COLOR FBLU,BGRN
1220 LOCATE 17,1: PRINT "Select Card ";
1230 FOR I=1 TO 7			' update down card count in tableau
1240 LOCATE 1,16+(I-1)*8
1250 IF COLDCNT(I)>0 THEN COLOR FBNK,BGRN: PRINT COLDCNT(I);: GOTO 1270
1260 PRINT "   ";
1270 NEXT I
1280 COLOR FBNK,BGRN
1290 IF RULES=1 THEN LOCATE 25,74: PRINT "$";DOLLARS;  ' print Vegas Winnings
1300 IF RULES=3 THEN LOCATE 25,74: PRINT "      ";
1310 '
1320 '   Show the Software Cursor
1330 '
1340 M1%=1
1350 CALL MOUSE(M1%,M2%,M3%,M4%)
1360 '
1370 '   Get Mouse Button and Cursor Status
1380 '
1390 GOSUB 10390			' wait for Mouse button to be pressed
1400 IF M2% AND 1 THEN GOTO 1440	' if left button is down process it
1410 IF M2% AND 2 THEN GOTO 2790	' if right button down, process it
1420 IF M2% AND 4 THEN GOTO 3190	' if middle button down, process it
1430 GOTO 1390				' wait for Mouse button to be pushed
1440 '
1450 '   Left Button is Down - Check for Down Pile Hit
1460 '
1470 COLOR FBLK,BGRN
1480 M3%=M3%/8+1			' compute "character" position on screen
1490 M4%=M4%/8+1
1500 ROW=5: COL=2
1510 GOSUB 7870 			' check for down deck hit
1520 IF HSTAT THEN GOTO 1820		' down deck selected
1530 '
1540 '   Left Button is Down - Wait for it to be released
1550 '
1560 GOSUB 10590
1570 '
1580 '   Hide the Software Cursor
1590 '
1600 M1%=2
1610 CALL MOUSE(M1%,M2%,M3%,M4%)
1620 LOCATE 18,1:PRINT "          ";    ' clear cheating message
1630 LOCATE 19,1:PRINT "          ";
1640 GOSUB 6920 			' check for "redeal or quit" hits
1650 IF HSTAT>0 THEN GOTO 6440		' if button on "redeal or quit" - do it
1660 '
1670 '  Left Mouse button is released - check selection
1680 '
1690 ROW=11: COL=2
1700 GOSUB 7870 			' check for up deck hit
1710 IF HSTAT THEN GOTO 2390		' up deck selected
1720 IF M4%=1 THEN GOTO 1790		' don't allow hits on row 1
1730 FOR I=1 TO 7
1740 ROW=0: COL=14+(I-1)*8
1750 GOSUB 7870 			' check for tableau hit
1760 CSEL=I
1770 IF HSTAT THEN GOTO 2500
1780 NEXT I
1790 CSEL=0: UNDOTYP=0			' nothing selected
1800 SOUND 500,1			' nothing selected - sound the alarm
1810 GOTO 1180				' and start over with selection
1820 '
1830 '  Selected down deck - Deal out three cards to up deck
1840 '
1850 M1%=2
1860 CALL MOUSE(M1%,M2%,M3%,M4%)	' hide cursor
1870 LOCATE 18,1:PRINT "          ";    ' clear cheating message
1880 LOCATE 19,1:PRINT "          ";
1890 UNSEL=0
1900 IF DDECK(1)=0 THEN GOTO 2210	' if down deck empty - turn up deck over
1910 FOR I=1 TO RULES			' get cards needed
1920 GOSUB 7120 			' get a card from the deck
1930 CARD=-CARD 			' turn card over
1940 IF CARD=0 THEN GOTO 2020		' if no cards in deck - take what we get
1950 UNSEL=UNSEL+1			' compute cards copied
1960 FOR J=51 TO 1 STEP -1		' move up deck up 1 slot
1970 UDECK(J+1)=UDECK(J)		' move deck up a card
1980 NEXT J
1990 UDECK(1)=CARD			' put new card on top of up deck
2000 NEXT I
2010 UNDOTYP=1: UCHEAT=CHEAT		' put cards back on down deck for undo
2020 ROW=5: COL=2
2030 CARD=UDECK(1)			' get top card to display
2040 BLINK=1				' show up card on top of down deck
2050 GOSUB 7530 			' with blinkers
2060 BLINK=0
2070 GOSUB 10590
2080 '
2090 '  After button is released - move up card to up deck pile
2100 '
2110 ROW=5: COL=2
2120 CARD=DDECK(1)			' get new down deck card
2130 BLINK=0
2140 GOSUB 7530 			' display down card
2150 ROW=11: COL=2
2160 BLINK=0
2170 CARD=UDECK(1)			' get new up deck card
2180 GOSUB 7530 			' display last up deck card
2190 DEALT=1				' set the dealt flag
2200 GOTO 1180				' make another selection
2210 '
2220 '  Turn Down Deck Over
2230 '
2240 IF RULES = 1 THEN GOTO 2340       ' if vegas rules, can't turn deck over
2250 CNT=1
2260 UNDOTYP=2: UCHEAT=CHEAT		' put ddeck back on udeck for undo
2270 FOR I=52 TO 1 STEP -1
2280 IF UDECK(I)=0 THEN GOTO 2320
2290 DDECK(CNT)=-UDECK(I)
2300 CNT=CNT+1
2310 UDECK(I)=0
2320 NEXT I
2330 IF TALCNT<>0 THEN GOTO 2370	' where any cards taken from up deck?
2340 COLOR 16+FBLU,BGRN
2350 LOCATE 18,1: PRINT "  Y O U  ";    ' output you lose message
2360 LOCATE 19,1: PRINT " L O S E!";
2370 TALCNT=0				' clear card taken count
2380 GOTO 2080				' update card decks
2390 '
2400 '  Up Deck Selected - Make Up Deck Card Blink
2410 '
2420 ROW=11: COL=2
2430 CARD=UDECK(1)
2440 IF CARD=0 THEN GOTO 1790
2450 BLINK=1
2460 GOSUB 7530 			' display top up card - blinking
2470 BLINK=0
2480 CSEL=0: RSEL=1: NSEL=1		' setup selection data
2490 GOTO 4580				' Now we can move a card
2500 '
2510 '  A column has been selected - Check for card present
2520 '
2530 IF COLUCNT(CSEL)=0 THEN GOTO 2660	' if no cards "up" maybe turn down card over
2540 ROW=2
2550 FOR I=1 TO COLUCNT(CSEL)		' compute which card selected
2560 IF ROW<=M4% AND M4%<=ROW+1 THEN RSEL=COLDCNT(CSEL)+I:GOTO 2610
2570 ROW=ROW+2
2580 NEXT I
2590 IF M4%<=ROW+2 THEN RSEL=COLUCNT(CSEL)+COLDCNT(CSEL): GOTO 2610
2600 GOTO 1790				' not within range of this column
2610 NSEL=COLUCNT(CSEL)+COLDCNT(CSEL)-RSEL+1 ' compute column card count
2620 BLINK=1
2630 GOSUB 6650 			' output this column with blinkers
2640 BLINK=0
2650 GOTO 4580				' now move the card(s)
2660 '
2670 '  No up cards are in this column
2680 '
2690 IF COLDCNT(CSEL)=0 THEN 1790	' if no down cards, sound the alarm
2700 COLDCNT(CSEL)=COLDCNT(CSEL)-1	' decrement down card count
2710 COLUCNT(CSEL)=COLUCNT(CSEL)+1	' increment up card count
2720 COLUMN(COLDCNT(CSEL)+1,CSEL)=-COLUMN(COLDCNT(CSEL)+1,CSEL) ' turn card over
2730 RSEL=COLDCNT(CSEL)+COLUCNT(CSEL)
2740 NSEL=1
2750 UNDOTYP=3: UCHEAT=CHEAT		' allow player to turn card over again
2760 UCSEL=CSEL 			' save tableau column
2770 GOSUB 6650 			' display the new up card on tableau
2780 GOTO 1180				' select another card to move
2790 '
2800 '  Right button has been pushed - wait for it to be released
2810 '
2820 GOSUB 10590
2830 '
2840 '  Hide the Software Cursor
2850 '
2860 M1%=2
2870 CALL MOUSE(M1%,M2%,M3%,M4%)	' turn off cursor
2880 M3%=M3%/8+1			' compute character position on screen
2890 M4%=M4%/8+1
2900 GOSUB 6920 			' check for "redeal or quit" requests
2910 IF HSTAT>0 THEN GOTO 6440		' if "redeal or quit" - do it
2920 COLOR FBLK,BGRN
2930 UNDOTYP=0				' don't allow any undo's unless we say so
2940 LOCATE 18,1: PRINT "         ";    ' clear cheat messages
2950 LOCATE 19,1: PRINT "         ";
2960 ROW=11: COL=2
2970 GOSUB 7870 			' check for up card hit
2980 IF HSTAT THEN GOTO 3130		' yes - move up card to foundation if possible
2990 FOR I=1 TO 7
3000 ROW=0:COL=14+(I-1)*8
3010 GOSUB 7870 			' check for tableau hit
3020 CSEL=I
3030 IF HSTAT THEN GOTO 3060		' if tableau selected - move card to foundation
3040 NEXT I
3050 GOTO 1790				' anything else is cause for alarm!
3060 '
3070 '  Tableau Selected - Move last up card to Foundation if possible
3080 '
3090 RMOV=0
3100 RSEL=COLDCNT(CSEL)+COLUCNT(CSEL)	' compute which card to select
3110 NSEL=1
3120 GOTO 5740				' try to move the card to foundation
3130 '
3140 '  Up deck Selected - Move top card to Foundation if possible
3150 '
3160 RMOV=0
3170 CSEL=0: RSEL=1: NSEL=1		' set the selected card to move
3180 GOTO 5740				' and try to place on foundation
3190 '
3200 '  Middle Button Pushed - Undo last move
3210 '
3220 GOSUB 10590			' wait for buttons to be released
3230 '
3240 '  Hide the Software Cursor
3250 '
3260 M1%=2
3270 CALL MOUSE(M1%,M2%,M3%,M4%)	' turn off cursor
3280 '
3290 '  Go undo the appropriate thing
3300 '
3310 COLOR FBLK,BGRN
3320 LOCATE 18,1:PRINT "          ";    ' clear cheating message
3330 LOCATE 19,1:PRINT "          ";
3340 IF UNDOTYP=0 THEN GOTO 1790	' sound alarm if no undo allowed
3350 CHEAT=UCHEAT			' restore cheating to last state
3360 ON UNDOTYP GOTO 3380,3530,3660,3770,3950,4110,4280,4420
3370 GOTO 1790				' out of range - sound the alarm
3380 '
3390 '  Put Up Deck card(s) back on Down deck
3400 '
3410 FOR I=1 TO UNSEL			' put Up cards back
3420 CARD=UDECK(1)			' get top card of Up deck
3430 FOR J=2 TO 52
3440 UDECK(J-1)=UDECK(J)		' move rest of deck up one slot
3450 NEXT J
3460 FOR J=51 TO 1 STEP -1		' move down deck up 1 slot
3470 DDECK(J+1)=DDECK(J)		' move deck down a card
3480 NEXT J
3490 DDECK(1)=-CARD			' put new card on top of down deck
3500 NEXT I
3510 UNDOTYP=0				' don't allow this again
3520 GOTO 2080				' redisplay the cards
3530 '
3540 '  Put Down Deck back on Up Deck
3550 '
3560 CNT=1
3570 FOR I=52 TO 1 STEP -1
3580 IF DDECK(I)=0 THEN GOTO 3620
3590 UDECK(CNT)=-DDECK(I)		' take down deck card and put it on up deck
3600 CNT=CNT+1
3610 DDECK(I)=0
3620 NEXT I
3630 TALCNT=1				' make sure we don't get lose message
3640 UNDOTYP=0				' don't allow this again
3650 GOTO 2080				' redisplay the cards
3660 '
3670 '  Turn card back down on Tableau
3680 '
3690 COLUMN(COLDCNT(UCSEL)+1,UCSEL)=-COLUMN(COLDCNT(UCSEL)+1,UCSEL) ' turn card over again
3700 COLDCNT(UCSEL)=COLDCNT(UCSEL)+1	' increment down card count
3710 COLUCNT(UCSEL)=COLUCNT(UCSEL)-1	' decrement up card count
3720 RSEL=COLDCNT(CSEL)
3730 NSEL=1
3740 GOSUB 6650 			' display the new up card on tableau
3750 UNDOTYP=0				' don't allow this again
3760 GOTO 1180				' select another card to move
3770 '
3780 '  Put Tableau card back on Up deck
3790 '
3800 FOR J=51 TO 1 STEP -1		' move up deck up 1 slot
3810 UDECK(J+1)=UDECK(J)		' move deck up a card
3820 NEXT J
3830 CSEL=UCSEL
3840 RSEL=COLDCNT(CSEL)+COLUCNT(CSEL)
3850 COLUCNT(UCSEL)=COLUCNT(UCSEL)-1	' decrement up card count
3860 NSEL=1
3870 CARD=COLUMN(RSEL,CSEL)		' take card from bottom of column
3880 COLUMN(RSEL,CSEL)=0		' zap old card on tableau column
3890 UDECK(1)=CARD			' put new up card
3900 TALCNT=TALCNT-1			' decrement talon card count
3910 ROW=11: COL=2
3920 GOSUB 7530 			' display new up card
3930 UNDOTYP=0				' don't allow this again
3940 GOTO 5690				' display the column in the tableau
3950 '
3960 '  Put Tableau card(s) back on another Tableau column
3970 '
3980 NSEL=UNSEL 			' get number of cards to put back
3990 CSEL=UCSEL 			' get tableau column
4000 CMOV=UCMOV 			' get where cards got moved to
4010 COLUCNT(CMOV)=COLUCNT(CMOV)-NSEL	' decrement up card count
4020 RMOV=COLUCNT(CMOV)+COLDCNT(CMOV)+1 ' compute move from position
4030 RSEL=COLUCNT(CSEL)+COLDCNT(CSEL)+1 ' compute move to position
4040 FOR I=1 TO NSEL
4050 COLUMN(RSEL+I-1,CSEL)=COLUMN(RMOV+I-1,CMOV) ' move the cards
4060 COLUMN(RMOV+I-1,CMOV)=0		' and clear the old column
4070 NEXT I
4080 COLUCNT(CSEL)=COLUCNT(CSEL)+NSEL	' increment old column up count
4090 UNDOTYP=0				' don't allow this again
4100 GOTO 5640
4110 '
4120 '  Put Foundation Card back on Up Deck
4130 '
4140 FOR J=51 TO 1 STEP -1		' move up deck up 1 slot
4150 UDECK(J+1)=UDECK(J)		' move deck up a card
4160 NEXT J
4170 RMOV=UCMOV 			' get foundation number
4180 UDECK(1)=CNTR(RMOV)		' get card in foundation position
4190 CNTR(RMOV)=URCRD			' restore old contents of counter
4200 TALCNT=TALCNT-1			' decrement talon card count
4210 UNDOTYP=0				' don't allow this again
4220 DOLLARS=DOLLARS-5			' decrement $5 from total
4230 FDCNTR=FDCNTR-1			' decrement foundation counter
4240 ROW=11: COL=2
4250 CARD=UDECK(1)
4260 GOSUB 7530 			' display new up deck card
4270 GOTO 6330				' now go display foundation position
4280 '
4290 '  Put Foundation Card back on Tableau Column
4300 '
4310 CSEL=UCSEL 			' save tableau column
4320 CMOV=URMOV 			' save foundation number
4330 COLUCNT(CSEL)=COLUCNT(CSEL)+1	' increment up card count
4340 RSEL=COLDCNT(CSEL)+COLUCNT(CSEL)
4350 CARD=CNTR(RMOV)			' get card from Foundation position
4360 COLUMN(RSEL,CSEL)=CARD		' restore old tableau column
4370 CNTR(RMOV)=URCRD			' restore old contents of counter
4380 UNDOTYP=0				' allow player to put card back
4390 DOLLARS=DOLLARS-5			' decrement $5 from total
4400 FDCNTR=FDCNTR-1			' decrement foundation counter
4410 GOTO 6290				' redisplay Tableau column and counter
4420 '
4430 '  Undo a Rule Change
4440 '
4450 COLOR FBLU,BGRN
4460 IF RULES=3 THEN  LOCATE 3,1: PRINT "  Vegas  ";: RULES=1: GOTO 4480
4470 IF RULES=1 THEN  LOCATE 3,1: PRINT "Solitaire";: RULES=3
4480 UNDOTYP=0: CHEAT=UCHEAT		' reestablish original rules
4490 IF CSEL=0 THEN GOTO 4530		' if up deck - redraw without blinkers
4500 IF CSEL>7 THEN GOTO 1180		' check range of selected card
4510 GOSUB 6650 			' otherwise redraw tableau column
4520 GOTO 1180				' and start over again
4530 ROW=11: COL=2
4540 BLINK=0
4550 CARD=UDECK(1)			' get new up deck card
4560 GOSUB 7530 			' display last up deck card
4570 GOTO 1180				' and start over again
4580 '
4590 '  A Selection has been made - Now move the Card(s)
4600 '
4610 COLOR FBLU,BGRN
4620 LOCATE 17,1: PRINT " Move Card  ";
4630 UNDOTYP=0				' don't allow undo unless we say so
4640 '
4650 '  Show the Software Cursor
4660 '
4670 M1%=1
4680 CALL MOUSE(M1%,M2%,M3%,M4%)	' show cursor
4690 '
4700 '  Wait for Button to be pushed for selection
4710 '
4720 GOSUB 10390
4730 IF M2% AND 1 THEN GOTO 4870	' left button pushed
4740 IF M2% AND 2 THEN GOTO 4770	' right button pushed
4750 IF M2% AND 4 THEN GOTO 6600	' middle button pushed
4760 GOTO 4720				' nothing happened - wait for a button push
4770 '
4780 '  Right Button Pushed - Wait for it to be released
4790 '
4800 GOSUB 10590
4810 '
4820 '  Hide Software Cursor
4830 '
4840 M1%=2
4850 CALL MOUSE(M1%,M2%,M3%,M4%)	' hide cursor
4860 GOTO 5160				' redisplay selected cards
4870 '
4880 '  Left Button Pushed - Wait for it to be released
4890 '
4900 GOSUB 10590
4910 '
4920 '  Hide Software Cursor
4930 '
4940 M1%=2
4950 CALL MOUSE(M1%,M2%,M3%,M4%)	' hide cursor
4960 M3%=M3%/8+1			' compute character position on screen
4970 M4%=M4%/8+1
4980 GOSUB 6920 			' check for "redeal or quit" requests
4990 IF HSTAT>0 THEN GOTO 6530		' if "redeal or quit" - process it
5000 '
5010 '  Left Mouse Button has been released - Check Selection
5020 '
5030 FOR I=1 TO 7
5040 ROW=0: COL=14+(I-1)*8
5050 GOSUB 7870 			' check for column hit
5060 CMOV=I
5070 IF HSTAT THEN GOTO 5260		' tableau has been selected - move card there
5080 NEXT I
5090 COL=74				' check for foundation hit
5100 FOR I=1 TO 4
5110 ROW=2+(I-1)*6
5120 GOSUB 7870
5130 RMOV=I
5140 IF HSTAT THEN GOTO 5740		' foundation request - move card there if possible
5150 NEXT I
5160 BLINK=0
5170 UNDOTYP=0				' can't undo anything before this
5180 IF CSEL=0 THEN GOTO 5210		' if up deck - redraw without blinkers
5190 GOSUB 6650 			' otherwise redraw tableau column
5200 GOTO 1790				' and sound the alarm
5210 ROW=11: COL=2
5220 BLINK=0
5230 CARD=UDECK(1)			' get new up deck card
5240 GOSUB 7530 			' display last up deck card
5250 GOTO 1790				' and sound the alarm
5260 '
5270 '  Tableau selected - Move card to this column
5280 '
5290 IF CSEL<>0 THEN GOTO 5460		' if not up deck - go process tableau move
5300 CARD=UDECK(1)			' get top up deck card
5310 IF COLUCNT(CMOV)>=12 THEN 5850	' if too many cards on tableau - stop right now
5320 RMOV=COLUCNT(CMOV)+COLDCNT(CMOV)+1 ' compute new position
5330 GOSUB 8130 			' check for cheating
5340 COLUCNT(CMOV)=COLUCNT(CMOV)+1	' increment up card count
5350 FOR I=2 TO 52			' move up deck up one card
5360 UDECK(I-1)=UDECK(I)
5370 NEXT I
5380 TALCNT=TALCNT+1			' increment talon card count
5390 UNDOTYP=4: UCHEAT=CHEAT		' allow player to put card back
5400 COLUMN(RMOV,CMOV)=CARD		' place new card on bottom of column
5410 UCSEL=CMOV
5420 CARD=UDECK(1)			' get new up card
5430 ROW=11: COL=2
5440 GOSUB 7530 			' display new up card
5450 GOTO 5690				' display the column in the tableau
5460 '
5470 '  Move a card from one column to another in Tableau
5480 '
5490 IF CSEL=CMOV THEN GOTO 5700	' select and move the same ignore
5500 RMOV=COLUCNT(CMOV)+COLDCNT(CMOV)+1 ' compute move to position
5510 IF (COLUCNT(CMOV)+NSEL)>12 THEN SOUND 500,1:GOTO 5640 ' if too many - error
5520 UCHEAT=CHEAT			' save current cheat state
5530 CARD=COLUMN(RSEL,CSEL)		' get card from selected column
5540 GOSUB 8130 			' check for cheating
5550 IF NSEL<>COLUCNT(CSEL) AND NSEL<>1 THEN GOSUB 8290  ' not allowed to move split columns
5560 COLUCNT(CMOV)=COLUCNT(CMOV)+NSEL	' increment up card count
5570 FOR I=1 TO NSEL
5580 COLUMN(RMOV+I-1,CMOV)=COLUMN(RSEL+I-1,CSEL) ' move the cards
5590 COLUMN(RSEL+I-1,CSEL)=0		' and clear the old column
5600 NEXT I
5610 UNDOTYP=5				' allow player to put cards back
5620 UNSEL=NSEL: UCSEL=CSEL: UCMOV=CMOV ' save backup info for undo
5630 COLUCNT(CSEL)=COLUCNT(CSEL)-NSEL	' decrement old column up count
5640 BLINK=0				' no more blinkers
5650 RSEL=COLDCNT(CSEL)+1		' compute whole column
5660 NSEL=COLUCNT(CSEL)
5670 GOSUB 6650 			' display the old column
5680 GOTO 5690				' now do this for the column moved to
5690 CSEL=CMOV				' get column we moved cards to
5700 RSEL=COLDCNT(CSEL)+1		' compute cards to redisplay
5710 NSEL=COLUCNT(CSEL)
5720 GOSUB 6650 			' display this column without blinkers
5730 GOTO 1180				' start the select - move cycle over again
5740 '
5750 '  Move a Card to the Foundation
5760 '
5770 IF CSEL<>0 THEN GOTO 6040		' if card is from tableau - check the column
5780 CARD=UDECK(1)			' get top card of up deck
5790 I=RMOV
5800 FOR RMOV=1 TO 4			' go through all foundation positions
5810 IF I<>0 AND RMOV<>I THEN GOTO 5840 ' if specific move and not right position - wait
5820 IF (CNTR(RMOV)=0) AND (CARD-(INT(CARD/13)*13))=1 THEN GOTO 5870 ' does it work?
5830 IF CNTR(RMOV)<>0 AND CARD=CNTR(RMOV)+1 THEN GOTO 5870 ' move it if it works
5840 NEXT RMOV				' check all foundation positions
5850 SOUND 500,1			' cannot be moved to foundation - sound alarm
5860 GOTO 2080				' and repaint selected cards
5870 '
5880 '  Selected card fits in Foundation - move it there
5890 '
5900 URCRD=CNTR(RMOV)			' save old contents of counter
5910 CNTR(RMOV)=CARD			' put card in foundation position
5920 FOR I=1 TO 51			' move up deck up one card
5930 UDECK(I)=UDECK(I+1)
5940 NEXT I
5950 TALCNT=TALCNT+1			' increment talon card count
5960 FDCNTR=FDCNTR+1			' increment foundation counter
5970 DOLLARS=DOLLARS+5			' add $5 to total
5980 UNDOTYP=6: UCHEAT=CHEAT		' allow player to put card back
5990 UCMOV=RMOV 			' save foundation number
6000 ROW=11: COL=2
6010 CARD=UDECK(1)
6020 GOSUB 7530 			' display new up deck card
6030 GOTO 6330				' now go display foundation position
6040 '
6050 '  Selected card is from Tableau - check to see that it fits
6060 '
6070 CARD=COLUMN(RSEL+NSEL-1,CSEL)	' get card from Tableau
6080 IF CARD < 0 THEN GOTO 6150 	' down cards not allowed
6090 I=RMOV
6100 FOR RMOV=1 TO 4			' check all foundation positions
6110 IF I<>0 AND RMOV<>I THEN GOTO 6140 ' if specific request wait for right position
6120 IF (CNTR(RMOV)=0) AND (CARD-(INT(CARD/13)*13))=1 THEN GOTO 6170 ' does it fit?
6130 IF CNTR(RMOV)<>0 AND CARD=CNTR(RMOV)+1 THEN GOTO 6170 ' if so move it
6140 NEXT RMOV				' check all positions
6150 SOUND 500,1			' card does not fit - sound alarm
6160 GOTO 5700				' and redisplay column
6170 '
6180 '  Selected card fits in Foundation - move it there
6190 '
6200 URCRD=CNTR(RMOV)			' save old contents of counter
6210 CNTR(RMOV)=CARD			' put card on Foundation position
6220 COLUMN(RSEL+NSEL-1,CSEL)=0 	' zap old tableau column
6230 COLUCNT(CSEL)=COLUCNT(CSEL)-1	' decrement up card count
6240 DOLLARS=DOLLARS+5			' add $5 to total
6250 FDCNTR=FDCNTR+1			' increment foundation counter
6260 UNDOTYP=7: UCHEAT=CHEAT		' allow player to put card back
6270 UCSEL=CSEL 			' save tableau column
6280 UCMOV=RMOV 			' save foundation number
6290 NSEL=COLUCNT(CSEL) 		' compute cards to redisplay
6300 RSEL=COLDCNT(CSEL)+1		' get count to redisplay
6310 BLINK=0				' no blinkers
6320 GOSUB 6650 			' display tableau column
6330 COL=74: ROW=2+(RMOV-1)*6		' compute Foundation position to display
6340 CARD=CNTR(RMOV)			' get card to display
6350 GOSUB 7530 			' display new card on Foundation
6360 BACK$="  "+STR$(FDCNTR)            ' convert foundation card count
6370 LOCATE 1,76: COLOR FBNK,BGRN: PRINT RIGHT$(BACK$,2); ' display count of cards on foundation
6380 CARD=0				' check for end game
6390 FOR I=1 TO 4			' add up all cards on foundation
6400 CARD=CNTR(I)+CARD
6410 NEXT I
6420 IF CARD=130 THEN GOTO 8410 	' check for end game
6430 GOTO 1180				' otherwise - do another "select - move"
6440 '
6450 '  Process Bottom Line Commands
6460 '
6470 IF HSTAT=-1 THEN GOTO 1790 	' if not "redeal or quit" sound the bell
6480 IF HSTAT=1 THEN GOTO 660		' clear screen and redeal
6490 IF HSTAT=2 THEN GOTO 7980		' that's all folks
6500 IF HSTAT=3 THEN GOTO 3280		' process undo function
6510 IF HSTAT=4 THEN GOTO 1180		' ignore this key click
6520 GOTO 1790				' otherwise we sound the bell
6530 '
6540 '  Process bottom line commands for move phase
6550 '
6560 IF HSTAT=1 THEN GOTO 660		' clear screen and redeal "new game"
6570 IF HSTAT=2 THEN GOTO 7980		' That's all folks
6580 IF HSTAT=3 THEN GOTO 3280		' process undo function
6590 IF HSTAT=4 THEN GOTO 4640		' ignore this key click
6600 SOUND 500,1
6610 GOTO 4580				' start over again
6620 '
6630 '  Redisplay Selected Column of Tableau
6640 '
6650 COL=14+(CSEL-1)*8			' compute screen column
6660 IF COLUCNT(CSEL)=0 THEN GOTO 6750	' if no up cards - display down card
6670 IF NSEL>=12 THEN NSEL=12		' display only 12 cards
6680 ROW=((RSEL-COLDCNT(CSEL))*2)	' compute screen row
6690 FOR I=RSEL TO RSEL+NSEL-1
6700 CARD=COLUMN(I,CSEL)		' get card to display
6710 GOSUB 7530 			' display the card
6720 ROW=ROW+2				' get ready for next card in column
6730 NEXT I
6740 GOTO 6860				' clear out rest of column
6750 '
6760 '  Display a down card or card skeleton
6770 '
6780 ROW=2
6790 IF COLDCNT(CSEL)=0 THEN 6830
6800 CARD=COLUMN(COLDCNT(CSEL),CSEL)	' get top down card
6810 GOSUB 7530 			' display the down card
6820 GOTO 6850
6830 CARD=0				' get card skeleton
6840 GOSUB 7530 			' display the card skeleton
6850 ROW=ROW+2				' don't clear out the top position
6860 ROW=ROW+3				' move to first blank position
6870 COLOR FBLK,BGRN
6880 FOR I=ROW TO 25
6890 LOCATE I,COL: PRINT "      ";      ' blank out rest of column
6900 NEXT I
6910 RETURN
6920 '
6930 '  Check for Bottom Line hits
6940 '
6950 HSTAT=0
6960 IF M3%>8 THEN RETURN		' is this even a possibility
6970 IF M4%=3 THEN GOTO 7030		' change the rules
6980 IF M4%=21 THEN HSTAT=3:RETURN	' Undo Status
6990 IF M4%=23 THEN HSTAT=1:RETURN	' Redeal status
7000 IF M4%>=25 THEN HSTAT=2:RETURN	' Quit status
7010 HSTAT=-1				' nothing to process
7020 RETURN
7030 '
7040 '   Change The Rules of the Game
7050 '
7060 COLOR FBLU,BGRN
7070 IF RULES=3 THEN  LOCATE 3,1: PRINT "  Vegas  ";: RULES=1: GOTO 7090
7080 IF RULES=1 THEN  LOCATE 3,1: PRINT "Solitaire";: RULES=3
7090 HSTAT=4: UNDOTYP=8: UCHEAT=CHEAT	' put cards back on down deck for undo
7100 IF DEALT <> 0 THEN GOTO 8290	' it's cheating to switch in middle of game
7110 RETURN
7120 '
7130 '  Deal out the next card from Down Deck
7140 '
7150 CARD=DDECK(1)			' get top card of down deck
7160 FOR X=2 TO 52
7170 DDECK(X-1)=DDECK(X)		' move rest of deck up one slot
7180 NEXT X
7190 DDECK(52)=0			' and clear last card
7200 RETURN
7210 '
7220 '  Shuffle the Card Deck
7230 '
7240 CARD=52
7250 FOR J=1 TO 2			' shuffle the deck a few times
7260 FOR X=50+J TO J STEP -2		' by doing some magic scramble
7270 DDECK(CARD)=OLDCRD(X)
7280 CARD=CARD-1
7290 NEXT X
7300 NEXT J
7310 CARD=1
7320 FOR J=1 TO 4			' shuffle them up a little bit more
7330 FOR X=48+J TO J STEP -4		' by doing some magic scramble
7340 OLDCRD(CARD)=DDECK(X)
7350 CARD=CARD+1
7360 NEXT X
7370 NEXT J
7380 CARD=1: CARD$=""
7390 X=INT(RND*52)+1			' get a random number
7400 IF INSTR(CARD$,CHR$(X))>0 GOTO 7390  ' has this card been "shuffled" yet
7410 CARD$=CARD$+CHR$(X)		' put the card on the shuffle bin
7420 DDECK(CARD)=OLDCRD(X)		 ' and get that card into new deck
7430 CARD=CARD+1
7440 IF CARD<53 THEN GOTO 7390		' are we done yet?
7450 CARD=1
7460 FOR J=1 TO 13			' save this deck for next shuffle
7470 FOR X=39+J TO J STEP -13		' by doing some magic scramble
7480 OLDCRD(CARD)=DDECK(X)
7490 CARD=CARD+1
7500 NEXT X
7510 NEXT J
7520 RETURN
7530 '
7540 '  Display the card on the screen
7550 '
7560 '  The CARD is displayed at COL and ROW
7570 LOCATE ROW,COL			' position to place on screen
7580 IF CARD<0 THEN GOTO 8030		' if down card - display it
7590 IF CARD=0 THEN COLOR BLINK*16+FBNK,BGRN	' if card skeleton - setup
7600 IF CARD>0 THEN COLOR BLINK*16+FBLK,BWHT	' up cards
7610 PRINT CHR$(218) CHR$(196) CHR$(196) CHR$(196) CHR$(196) CHR$(191); ' display card outline
7620 LOCATE ROW+1,COL
7630 PRINT CHR$(179);
7640 IF CARD=0 THEN SUIT$=" ":CRD$="  ":GOTO 7710       ' skeletons have no suits
7650 IF CARD<14 THEN SUIT$=CHR$(3):COLR=FRED:CRD$=CRD$(CARD):GOTO 7690 ' is it a heart?
7660 IF CARD<27 THEN SUIT$=CHR$(4):COLR=FRED:CRD$=CRD$(CARD-13):GOTO 7690 ' is it a diamond?
7670 IF CARD<40 THEN SUIT$=CHR$(5):COLR=FBLK:CRD$=CRD$(CARD-26):GOTO 7690 ' is it a club?
7680 IF CARD<53 THEN SUIT$=CHR$(6):COLR=FBLK:CRD$=CRD$(CARD-39):GOTO 7690 ' is it a spade?
7690 COLOR BLINK*16+COLR,BWHT
7700 IF MONIT = 0 AND COLR = FRED THEN COLOR BLINK*16+COLR,BBLK
7710 PRINT CRD$ SUIT$ " ";
7720 IF CARD=0 THEN COLOR BLINK*16+FBNK,BGRN
7730 IF CARD>0 THEN COLOR BLINK*16+FBLK,BWHT
7740 PRINT CHR$(179);
7750 IF ROW>23 THEN RETURN		' check for end of screen
7760 LOCATE ROW+2,COL
7770 PRINT CHR$(179) "    " CHR$(179);  ' display rest of card
7780 IF ROW>22 THEN RETURN
7790 LOCATE ROW+3,COL
7800 PRINT CHR$(179) "    " CHR$(179);
7810 IF ROW>21 THEN RETURN
7820 LOCATE ROW+4,COL
7830 PRINT CHR$(192) CHR$(196) CHR$(196) CHR$(196) CHR$(196) CHR$(217);
7840 LOCATE ROW+5,COL
7850 COLOR FBLK,BGRN
7860 RETURN
7870 '
7880 '  Check for Screen hit
7890 '
7900 IF COL<=M3% AND M3%<=COL+5 THEN GOTO 7920	' are we in right column?
7910 HSTAT=0:RETURN			' no - don't bother with row
7920 IF ROW<>0 THEN GOTO 7950		' are we checking row position?
7930 HSTAT=1				' no - then it is a hit
7940 RETURN
7950 IF ROW<=M4% AND M4%<=ROW+4 THEN HSTAT=1:RETURN  ' proper row?
7960 HSTAT=0				' no - not a hit
7970 RETURN
7980 '
7990 '  Play is all over - cleanup and go away
8000 '
8010 COLOR 7,0,0			' go back to standard screen
8020 CLS: SYSTEM			' clear screen and quit
8030 '
8040 ' Special case of Card Painting routine for card backs
8050 '
8060 COLOR BLINK*16+FBLK,BBLU: BACK$ = CHR$(176)
8070 FOR DROW = 1 TO 5			' cards have 5 rows
8080 PRINT BACK$ BACK$ BACK$ BACK$ BACK$ BACK$; ' paint the card back
8090 LOCATE ROW+DROW,COL
8100 NEXT DROW
8110 COLOR FBLK,BGRN
8120 RETURN
8130 '
8140 '  Check for Cheating
8150 '
8160 IF (COLUCNT(CMOV)+COLDCNT(CMOV))=0 THEN GOTO 8240 ' only kings should go on void spaces
8170 CRD2=COLUMN(RMOV-1,CMOV)		' get other card
8180 IF CRD2<=0 THEN 8290		' no cards on down cards
8190 IF CRD2<27 AND CARD<27 THEN 8290	' two red cards are cheating
8200 IF CRD2>26 AND CARD>26 THEN 8290	' two black cards are cheating
8210 IF CRD2-(INT(CRD2/13)*13)=0 AND CARD-INT(CARD/13)*13=12 THEN RETURN ' queen on king
8220 IF (CRD2-(INT(CRD2/13)*13)) - (CARD-(INT(CARD/13)*13))<>1 THEN 8290 ' not number sequence
8230 RETURN
8240 '
8250 '  This is a blank column - Only Kings allowed
8260 '
8270 IF (CARD-INT(CARD/13)*13)<>0 THEN 8290  ' not a king
8280 RETURN
8290 '
8300 '  Player is Cheating - Output Cheating Message
8310 '
8320 COLOR 16+FBLU,BGRN
8330 LOCATE 18,1: PRINT " You are ";    ' output cheating message
8340 LOCATE 19,1: PRINT "Cheating!";
8350 CHEAT=1
8360 FOR I=1 TO 3
8370 SOUND 100,1
8380 SOUND 800,1
8390 NEXT I
8400 RETURN
8410 '
8420 '  End Game - See if player wants to play again
8430 '
8440 COLOR FBLU,BGRN
8450 LOCATE 10,20: PRINT "Congratulations - You won";
8460 LOCATE 12,20
8470 IF CHEAT<>0 THEN PRINT "But you did cheat!";
8480 IF CHEAT=0 THEN PRINT "And you didn't even cheat!";
8490 LOCATE 14,20: PRINT "Push Left Button to Play Another Game";
8500 LOCATE 16,20: PRINT "Push Right Button to Retire";
8510 IF CHEAT<>0 THEN GOTO 8580 	' don't play song if player cheated
8520 SOUND 275,3			' play a song when player wins
8530 SOUND 550,3
8540 SOUND 900,3
8550 SOUND 1100,4
8560 SOUND 900,3
8570 SOUND 1100,6
8580 '
8590 '  See what player wants to do
8600 '
8610 GOSUB 10390
8620 IF M2% AND 1 THEN GOTO 8650	' left button pushed - let's play
8630 IF M2% AND 2 THEN GOTO 7980	' right button pushed - that's it
8640 GOTO 8610				' wait for a button
8650 '
8660 '  Player wants to play again - Good, I think he is hooked
8670 '
8680 GOSUB 10590			' wait for button release
8690 GOTO 650				' redeal new game
8700 '
8710 '  Help Section
8720 '
8730 SCREEN 0,1
8740 COLOR FFSH,BBLK,BBLK
8750 WIDTH 80
8760 CLS
8770 LOCATE 4,28,0: PRINT "KLONDIKE SOLITAIRE";
8780 LOCATE 5,28: PRINT "";
8790 LOCATE 6,28: PRINT "   Version 1.2    ";
8800 LOCATE 8,28: PRINT "Copyright (C) 1984";
8810 LOCATE 10,28: PRINT "Mouse Systems Corp";
8820 IF MONIT<1 THEN GOTO 9080
8830 IF FFSH=FRED THEN GOTO 9080
8840 LOCATE 14,25: PRINT "Push Left Button for Color";
8850 LOCATE 16,25: PRINT "Push Right Button for B&W";
8860 '
8870 '  Wait for Player to decide Next Step
8880 '
8890 GOSUB 10390			' get button action
8900 IF M2% AND 1 THEN GOTO 8930	' left button pushed - leave it as is
8910 IF M2% AND 2 THEN GOTO 9020	' right button pushed - Player wants B&W
8920 GOTO 8890				' no button action - wait
8930 '
8940 '  Left button is down - wait for it to release
8950 '
8960 GOSUB 10590			' wait for buttons to be released
8970 FFSH=FRED				' let player know he has color
8980 GOTO 8700
8990 '
9000 '  Right Button is down - wait for it to be released
9010 '
9020 GOSUB 10590
9030 FBLK=0: FBLU=15: FRED=15: FWHT=15: FBNK=FWHT: BBLK=0: BBLU=15: BGRN=0: BWHT=7: MONIT=-1
9040 GOTO 8700				' restart help with new B&W attributes
9050 '
9060 '  Display Help or Play Menu
9070 '
9080 LOCATE 14,25: PRINT "Push Left Button to Play  ";
9090 LOCATE 16,25: PRINT "Push Right Button for Help";
9100 '
9110 '  Wait for Player to decide Next Step
9120 '
9130 GOSUB 10390			' get button action
9140 IF M2% AND 1 THEN GOTO 9170	' left button pushed - play the game
9150 IF M2% AND 2 THEN GOTO 9220	' right button pushed - Player needs help
9160 GOTO 9130				' no button action - wait
9170 '
9180 '  Left Button is down - wait for it to release
9190 '
9200 GOSUB 10590
9210 RETURN				' start the game
9220 '
9230 '  Right Button is down - wait for it to be released
9240 '
9250 GOSUB 10590
9260 '
9270 '  Setup Help Screen
9280 '
9290 COLOR FBLK,BGRN,BGRN		' restore "felt green" background
9300 CLS
9310 COLOR FBLU,BGRN
9320 LOCATE 2,1: PRINT "  Help  ";
9330 LOCATE 3,1: PRINT " Screen ";
9340 COLOR FBLK,BGRN
9350 CARD=5
9360 CNT=1
9370 FOR I1=CNT TO 7
9380 ROW=2: COL=14+(I1-1)*8
9390 GOSUB 7530
9400 CARD=CARD+15
9410 IF CARD>52 THEN CARD=CARD-52
9420 LOCATE ROW+3,COL+3
9430 COLOR FBLK,BWHT
9440 PRINT MID$("TABLEAU",I1,1);
9450 NEXT I1
9460 FOR I=1 TO 7
9470 LOCATE 1,16+(I-1)*8
9480 IF I>1 THEN COLOR FBNK,BGRN: PRINT I-1;: GOTO 9500
9490 COLOR FBNK,BGRN: PRINT "   ";
9500 NEXT I
9510 FOR I=1 TO 4
9520 CARD=0: COL=74: ROW=2+(I-1)*6
9530 GOSUB 7530
9540 NEXT I
9550 ROW=2: COL=74
9560 CARD=1
9570 GOSUB 7530
9580 COLOR FBLK,BWHT
9590 FOR I=1 TO 10
9600 ROW=I*2+3
9610 LOCATE ROW,76
9620 PRINT MID$("FOUNDATION",I,1);
9630 IF I=1 THEN COLOR FBNK,BGRN
9640 NEXT I
9650 CARD=-1
9660 ROW=5: COL=2
9670 GOSUB 7530
9680 COLOR FWHT,BBLU
9690 LOCATE 7,3
9700 PRINT "Stock";
9710 CARD=49
9720 ROW=11: COL=2
9730 GOSUB 7530
9740 COLOR FBLK,BWHT
9750 LOCATE 14,3
9760 PRINT "Talon";
9770 COLOR FBLK,BWHT
9780 LOCATE 25,6: PRINT "Left Button - Next Help Page";
9790 LOCATE 25,50: PRINT "Right Button - Play Klondike";
9800 ERRS=0
9810 ON ERROR GOTO 10340
9820 OPEN "CARDGAME.HLP" FOR INPUT AS #1        ' open Help file
9830 ON ERROR GOTO 0
9840 '
9850 '  Begin reading file one page at a time
9860 '
9870 COLOR FBNK,BGRN
9880 FOR I=8 TO 24			' display help data between row 8 and 24
9890 IF ERRS THEN GOTO 9920		' don't read file if error
9900 IF EOF(1) THEN GOTO 9920		' are we done with help file?
9910 LINE INPUT #1,LIN$ 		' get next line of help info
9920 LOCATE I,10
9930 PRINT "                                                                ";
9940 LOCATE I,10
9950 IF ERRS THEN GOTO 9980
9960 IF EOF(1) THEN GOTO 9980
9970 PRINT LIN$;			' print help line on screen
9980 NEXT I
9990 '
10000 '  Display state of Help file
10010 '
10020 IF ERRS THEN LOCATE 25,39: COLOR FBLU+16,BGRN: PRINT "Error";: GOTO 10050
10030 IF EOF(1) THEN LOCATE 25,39: COLOR FBLU,BGRN: PRINT " End  ";: GOTO 10050
10040 LOCATE 25,39: COLOR FBLU,BGRN: PRINT " More ";
10050 '
10060 '  See what player wants to do next
10070 '
10080 GOSUB 10390
10090 IF M2% AND 1 THEN GOTO 10130	' left button pressed - next page
10100 IF M2% AND 2 THEN GOTO 10200	' right button pressed - play game
10110 IF M2% AND 4 THEN GOTO 10270	' middle button pressed - start help over
10120 GOTO 10080 			' no button action - wait
10130 '
10140 '  Left Button is down - wait for it to release
10150 '
10160 GOSUB 10590
10170 IF ERRS THEN BEEP: GOTO 10080
10180 IF EOF(1) THEN BEEP: GOTO 10080
10190 GOTO 9840 			' get next page of help
10200 '
10210 '  Right button is down - wait for it to release
10220 '
10230 GOSUB 10590
10240 IF ERRS THEN RETURN		' don't close file not open
10250 CLOSE #1				' close help file
10260 RETURN				' play the game
10270 '
10280 '  Middle button is down - wait for it to release
10290 '
10300 GOSUB 10590
10310 IF ERRS THEN BEEP: GOTO 10050	' bypass closing file if error occurred
10320 CLOSE #1				' close help file
10330 GOTO 9800 			' and start all over again
10340 '
10350 '  Cannot open "Cardgame.hlp"
10360 '
10370 ERRS=1
10380 GOTO 9870
10390 '
10400 '  Process Mouse Button Actions
10410 '
10420 M1%=5
10430 M2%=0				' check left button already pressed
10440 CALL MOUSE(M1%,M2%,M3%,M4%)
10450 IF M2%=0 THEN GOTO 10480		' no left button presses
10460 M2%=1				' set mouse button mask for left button
10470 RETURN
10480 M1%=5
10490 M2%=1				' check right button already pressed
10500 CALL MOUSE(M1%,M2%,M3%,M4%)
10510 IF M2%=0 THEN GOTO 10540		' no right button presses
10520 M2%=2				' set mouse button mask for right button
10530 RETURN
10540 M1%=3
10550 CALL MOUSE(M1%,M2%,M3%,M4%)	' get regular status
10560 IF M2% AND 1 THEN GOTO 10420	' make sure we get the press status
10570 IF M2% AND 2 THEN GOTO 10480	' make sure we get press status
10580 RETURN
10590 '
10600 '  Check that the mouse buttons have been released
10610 '
10620 M1%=3
10630 CALL MOUSE(M1%,M2%,MD3%,MD4%)
10640 IF M2%<>0 THEN GOTO 10620 	' buttons are still down - wait
10650 RETURN
