'This program is designed to be used with the Mean18
'golf game by Accolade. It will allow you to have as
'many golf courses as you wish available to play rather
'than the limit of three imposed by Mean18.
'
'A special thanks to Fred Strobl for his programming
'help with the read.filename routine he wrote for me.
'
'written in March, 1987 by Ken Hopkins (WA9WCP)
'who only wishes he could play golf for real as well as
'he can with Mean18.
'
'Modified and debugged 2/14/88 by Terry Doerhoefer Atlanta, GA
'Corrected bug that caused failure if program encountered a file with .M18
'extension on first run, it would work on the second try.
'Corrected course selection that only allowed a one digit entry. (you could
'not select a course above "9")
'Modified to display courses in three columns and allow up to 45 courses. 
'

key off
defint A - Z          'Set up
dim file$(45)         'Allow up to 45 courses, sure is a lot of disk space
'
screen 0,0,0,1
gosub readdir         'Get files with ".M1?" extension
gosub menu            'Display available courses
screen 0,0,0,0
gosub choose          'Alllow course selection
shell "GOLF"          'Call the Mean18 Golf game
end
'
readdir:                         'Read directory - find all files
files "*.M1?"                    'with .M1? extension. If there are
r=1-(screen(1,2)=58)             'any .M18's, rename them to .M10
c=1                              'so that Mean18 can't find them
for I = 1 to ubound(file$)
file$(I) = space$(17)
call read.filename(file$(I),c,r)
if instr(file$(I),"<DIR>") or _
asc(file$(I)) <> 32 then
c = (c + 18)mod 72
r = r -(c=1)
else
max = I-1
i = ubound(file$)
end if
if mid$(file$(I),10,3)= "M18" then           'Rename left over *.M18
name file$(I) as left$(file$(I),8)+".M10"    'files from last game
file$(I)=(left$(file$(I),8)+".M10")
end if
next
'
sub read.filename(a$,col,row)       STATIC
for I=1 to len(a$)                           'Take the file names
mid$(a$,I)=chr$(screen(row,col+I-1))         'of off the screen
next
end sub
return
'
menu:
cls
print tab(20)"ͻ"
print tab(20)"     AVAILABLE  MEAN18  COURSES     "
print tab(20)"ͼ"
print
for a = 1 to max
if a < 16 then                    'Display courses in three columns
x=8 : y=4
locate (y+a),x
print using "##.";a;
print "  ";left$(file$(a),8);
end if
if a >15 and a<31 then
x=32 : y=-11
locate (y+a),x
print using "##.";a;
print "  ";left$(file$(a),8);
end if
if a >30 and a<46 then
x=56 : y=-26
locate (y+a),x
print using "##.";a;
print "  ";left$(file$(a),8);
end if
next
print:print
return
'
'
choose:
i=99
while (i < 1) or (i > max)
locate 22,69
print "          "
locate 22,6
input "Choose the number of the course you want to play (99 to EXIT): ",i$
i=val(i$)
if i = 99 then   ' Test for valid course number and allow EXIT
cls
end
end if
wend
name file$(I) as left$(file$(I),8)+".M18"  'rename the desired course
                                           'to the .M18 extension so that
                                           'Mean18 can find it
return
