
; MOV_ES macro
; this macro moves bytes/words/dwords from a specified segment to
; the extra segment [ES]
;
; example: mov_es word,cs        will move a WORD from CS:SI to ES:DI
;          mov_es byte,ss        will move a BYTE from SS:Si to ES:DI
;          repz mov_es byte,ss   will move CX BYTES from SS:SI to ES:DI


mov_es          macro   size,tseg

                ifidn   <tseg>,<ss>
                  db 00110110b
                endif

                ifidn   <tseg>,<cs>
                  db 00101110b
                endif

                ifidn   <tseg>,<ds>
                  db 00111110b
                endif

                ifidn <size>,<word>
                  movsw
                endif

                ifidn <size>,<byte>
                  movsb
                endif

                ifidn <size>,<dword>
                  db 066h,0a5h
                endif

                endm

; Standart EXE startupcode

                nosmart

stapel          segment para stack

                db 10  dup (0)

stapel          ends

code            segment para 'CODE'

                assume  cs:code ; es:stapel ; ss:stack ; ds;code

main            proc near

                push    es
                pop     bx
                push    cs
                pop     ax
                sub     ax,bx
                mov     cl,04h
                mov     bx,offset ecode
                mov     dx,bx
                shr     bx,cl
                and     dx,0000fh
                jz      oksize
                inc     bx
oksize:         add     bx,ax
                mov     ax,04a00h
                int     21h
                jnc     allright
                mov     ah,04ch
                int     21h
allright:  

; ************************************************************************
;
; Begin of main program
;
; ************************************************************************

                push    cs
                pop     ds

                assume  ds:code

                mov     ah,09h
                mov     dx,offset starttxt
                int     21h
                mov     ax,03d02h
                mov     dx,offset filename
                int     21h
                jnc     ok01
                mov     dx,offset filenotfound
goend:          mov     ah,09h
                int     21h
                mov     ax,04c00h
                int     21h
ok01:           mov     word ptr cs:[handle],ax
                mov     bx,ax

                mov     ax,04200h
                mov     cx,0007dh
                mov     dx,0d7d1h
                int     21h
                mov     ah,040h
                mov     cx,01h
                mov     dx,offset crbytes1
                int     21h
                mov     ax,04200h
                mov     cx,0007dh
                mov     dx,0d7d8h
                int     21h
                mov     ah,040h
                mov     cx,01h
                mov     dx,offset crbytes1
                int     21h
                mov     ax,04200h
                mov     cx,0007dh
                mov     dx,0d7dfh
                int     21h
                mov     ah,040h
                mov     cx,01h
                mov     dx,offset crbytes1
                int     21h

                mov     ah,03eh
                mov     bx,word ptr cs:[handle]
                int     21h
                mov     dx,offset alldone
                jmp     goend


handle          dw      0
crbytes1        db      69h
alldone         db      'File ATLANTIS.001 successfully patched. ',0ah,0dh,'$'
filenotfound    db      'Could not open file ATLANTIS.001. Exiting...',0ah,0dh,'$'
filename        db      'atlantis.001',0
starttxt        db      'Indiana Jones and the Fate of Atlantis.',0ah,0dh
                db      'Crack Patch made by ONYX at 23:30h 14th of June 1992',0ah,0dh
                db      'To make sure this works, run this patch from',0ah,0dh
                db      'your Fate of Atlantis directory. ',0ah, 0dh
                db      'North Wind: I can crack interpreters PROPERLY. ',0ah,0dh,0ah,0dh
                db      '$'

main            endp

ecode           db      0

code            ends

                end     main

