;my first tsr.  Chains into int 1c and displays a twirly in the upper right corner.
;jeff leyda
;
;
;
;
;How it works:
;  every 18.2 times per second, the CPU calls out Interrupt 1Ch to update the
;  system clock.  This program (and just about every other TSR) finds out
;  where the 1Ch interrupt starting code is (via Interrupt 21h function 35h)
;  and saves that address in memory.
;
;  Then using interrupt 21h function 25h it tells the CPU to look at a 
;  different area to do INT 1Ch.  Our code starts out, runs the "real" int
;  1Ch, then executes its own code, which displays the twirly in the
;  upper left hand corner, and returns to DOS with an IRET.  
;
;
;
;
;
;
;


ISR EQU 0fah            ;this is the ISR we are chaining into.




	cseg segment
	assume cs: cseg,ds:cseg,es:cseg,ss:cseg
	


	org 100h

main:      
	jmp start

new_int:
	

	;if we be here, we be checkin' the time!


	
	
	push ax                       ;retain whatever registers we played with
	push bx                       ;
	push cx                       ;
	push dx               
	push si                       
	push di
	push es
	push ds
	pushf

	mov ah,"e"
	mov si,9000h
	mov cx,1000h
	
	push cs
	pop es

findit:        

	lodsb
	cmp al,ah
	jz found
	loop findit
	jmp exit

found:
	push cx
	mov cx,10
	lea di,search
	repz cmpsb
	pop cx
	jcxz exit
	jnz findit 

      ;we have it!  

	add si,3
	mov cx,20
	mov ax,4141h
makea:        
	mov word ptr[si],ax
	mov word ptr[si+2],ax
	add si,5
	loop makea






	
	push ds               ;restore ES
	pop es
	
	
	
exit:

	popf               
	pop ds
	pop es
	pop di
	pop si               
	pop dx
	pop cx
	pop bx                        ;restore them registers we played with
	pop ax                        ;
				      
				      
				      
				      
				      
do_old_isr:                                      

;        pushf                         ;now do the real ISR
;        call dword ptr cs:keep_ofs    ;
				      
				      
	iret                          ;finish up with an IRET 

;this section is for misc data storage that we'll need to keep.
;
dummy1 db 90h                            ;storage location for real vector
keep_ofs dw 9090h                       ;and perhaps another variable or two
keep_seg dw 9090h                       ;made 'em NOPs so they don't do any
dummy2 db 90h,90h                          ;wierd things when initializing
search db "goGrabCart",0
dummy3 dw 9090h                          ;
finish  equ $                           ;finish flag so we know where the last
					;byte of our prgram is when we go TSR.
;
;This start section is the stuff that initializes the TSR and sets up the
;re-vectoring.
;
start:        
	mov ah,35h                        ;get vector function
	mov al,ISR                        ;place interrupt # here.
	int 21h                           ;

	mov keep_seg,es                   ;save the old vectors
	mov keep_ofs,bx                   ;
	lea dx,new_int                    ;load dx with the new routine
	mov ah,25h
	mov al,ISR                        ;place interrupt # here.
	int 21h                           ;set new vector

	
	xor dx,dx                         ;
	xor cx,cx                         ;
	lea ax,finish                     ;load dx with the number of paragraphs
	mov bx,16                         ;our program uses.  1 paragraph=16 bytes
	div bx                            ;
	inc ax                            ;
	mov dx,ax
	
	mov ax,3100h                      ;keep, exit with errorlevel 0
	int 21h                           ;to size memory with.
cseg ends
end main




