code	segment	'code'
	assume	cs:code,ds:code

	org	2ch
envseg	label	word			; pointer to environment segment

	org	100h
start:	jmp	init			; jump to install routine

old21	dd	0			; old INT 21 address
old25	dd	0			; old INT 25 address

new21:	cmp	ah,52h			; Get List of Lists function?
	je	list
	jmp	cs:old21		; jump to old handler
list:	pushf
	call	cs:old21		; call old handler
	mov	byte ptr es:[bx+20h],2	; 2 block devices installed
err:	iret

new25:	cmp	al,2			; C drive?
	jne	pass
	cmp	cx,0001h		; 1 sector?
	jne	pass
	cmp	dx,0			; Master Boot Record?
	jne	pass
	mov	word ptr [bx+1ch],1	; installer wants it non-zero
pass:	jmp	cs:old25

init:	mov	ax,3521h		; get old INT 21 address
	int	21h
	mov	word ptr old21,bx
	mov	word ptr old21+2,es

	mov	dx,offset new21		; hook new INT 21 handler
	mov	ah,25h
	int	21h

	mov	ax,3525h		; get old INT 25 address
	int	21h
	mov	word ptr old25,bx
	mov	word ptr old25+2,es

	mov	dx,offset new25		; hook new INT 25 handler
	mov	ah,25h
	int	21h

	mov	es,envseg		; free env seg
	mov	ah,49h
	int	21h

	mov	dx,0014h		; terminate with DX paras resident
	mov	ax,3100h
	int	21h

code	ends

	end	start
