10 REM Maze game by Michael Gordon
20 REM For PC Magazine readers
40 DEFINT A-Y
50 DIFF = 5
60 MAZE = 1
70 CLS:SCREEN 1:COLOR 0,3,1
80 KEY OFF
90 PRINT "You are about to play a game of maze."
100 PRINT "To win a round, you must have the"
110 PRINT "best (least) time."
120 PRINT "Maze numbers are from 0 (zero) to 32000."
130 PRINT "Difficulty is 1-10 with 5 being assumed."
140 PRINT
150 PRINT "Difficulty? (1-10) [";DIFF;"]"
160 INPUT IN:IF IN = 0 GOTO 200
170 DIFF = IN
180 IF DIFF = 0 THEN DIFF = 5:GOTO 200
190 IF DIFF < 1 OR DIFF > 10 GOTO 150
200 Z1 = .9-(DIFF/20)
210 Z2 = .9-(DIFF/20)
220 PRINT:PRINT "If you pick 8, 9, or 10, the maze"
230 PRINT "might not have a solution."
240 PRINT "Hit the space bar to make a new one."
250 PRINT "But the clock runs on, so think quickly!":PRINT
260 PRINT "Enter the maze sequence number 1-32000"
270 PRINT "or return to use: [";MAZE;"]"
280 INPUT IN:IF IN = 0 GOTO 300
290 MAZE = IN:IF IN < -32000 OR IN > 32000 GOTO 260
300 IF MAZE > 32000 THEN MAZE = 32000
310 RANDOMIZE MAZE
320 SCREEN 1:COLOR 0,3,1
330 CLS
340 FOR X = 10 TO 300 STEP 10
350    FOR Y = 0 TO 190 STEP 10
360 PSET (X,Y),3
370       IF RND(1) > Z1 THEN DRAW "d10"
380       IF RND(1) > Z2 THEN DRAW "r10"
390 NEXT Y,X
400 REM make a box for the timer
410 LINE (0,0)-(320,200),3,B
420 LINE (1,0)-(80,10),0,BF
430 LINE (1,10)-(80,10),3
440 LINE (80,1)-(80,10),3
450 IF RESTART = 0 THEN TIME$ = "00:00:00":REM reset timer
460 RESTART = 0
470 REM ----- part two -----
480 PX = 5:PY = 95:REM initial position
490 CIRCLE (PX,PY),3,3
500 D$ = INKEY$:IF D$ = "" THEN 510 ELSE 530
510 LOCATE 1,2:PRINT TIME$
520 REM Was space bare hit? If so, make a new maze.
530 IF D$ = CHR$(32) THEN RESTART = 1:GOTO 320
540 D = LEN(D$)
550 IF D = 2 THEN 560 ELSE GOTO 500
560 D = ASC(MID$(D$,2,1))
570 IF D = 72 GOTO 620:REM go up
580 IF D = 75 GOTO 670:REM go left
590 IF D = 77 GOTO 720:REM go right
600 IF D = 80 GOTO 770:REM go down
610 GOTO 500:REM try again, nitwit!
620 Y = POINT (PX,PY-5):REM move up
630 IF Y = 3 GOTO 500: REM no can do!
640 GOSUB 830
650 PY = PY-10:IF PY < 0 THEN PY = 5
660 GOTO 490:REM move up performed ok
670 Y = POINT (PX-5,PY):REM move left
680 IF Y = 3 GOTO 500
690 GOSUB 830
700 PX = PX-10:IF PX < 0 THEN PX = 5
710 GOTO 490:REM move left performed ok
720 Y = POINT (PX+5,PY):REM move right
730 IF Y = 3 GOTO 500
740 GOSUB 830
750 PX = PX+10:IF PX > 300 GOTO 860:REM you've won!
760 GOTO 490:REM move right performed ok
770 Y = POINT (PX, PY+5):REM move down
780 IF Y = 3 GOTO 500
790 GOSUB 830
800 PY = PY+10:IF PY>200 THEN PY=195
810 GOTO 490
820 REM circles subroutine
830 CIRCLE (PX,PY),3,0
840 CIRCLE (PX,PY),2,1:RETURN
850 REM winner subroutine
860 LINE (100,0)-(300,10),0,BF
870 LINE (100,0)-(100,10),3
880 LINE (100,10)-(300,10),3
890 LOCATE 1,15
900 PRINT "Success! ";
910 INPUT "Another game ? [y]",ANS$
920 IF ANS$ = "" OR ANS$ = "y" GOTO 70
930 CLS:SCREEN 0,1:CHAIN "menu.bas"
