1 '**                POLYMAZE.BAS
2 '**               by Dan Rollins
3 '**                  04/05/83
4 '**
5 '**    Requires IBM-PC, color/graphics, BASICA
6 '**
7 '**       Draws and solves polygonal mazes
8 '**
10 DEFINT A-Z
20 DIM MZ(61,18), T(5)
30 DIM CIR.SIN!(61),CIR.COS!(61), XC(61,18),YC(61,18)
40 DIM STACK(1000),SOLUTION.LIST(1,1000)
50 DIM Y.DELTA(3), X.DELTA(3)
60  Y.DELTA(0)=-1 :X.DELTA(1)=1 :Y.DELTA(2)=1 :X.DELTA(3)=-1
70 DIM PWR2(3)
80  PWR2(0)=1 :PWR2(1)=2 :PWR2(2)=4 :PWR2(3)=8
90  LA$=CHR$(0)+CHR$(75) :RA$=CHR$(0)+CHR$(77)   '** arrow keys for
100 UA$=CHR$(0)+CHR$(72) :DA$=CHR$(0)+CHR$(80)   '**   manual solving
110 FALSE = 0 :TRUE = NOT FALSE
120 RANDOMIZE VAL(RIGHT$(TIME$,2))               '** create a random seed
130 DEF FN CENTER.X=INT((XC(X,Y)+XC(X+1,Y+1))/2) '** center of room X,Y
140 DEF FN CENTER.Y=INT((YC(X,Y)+YC(X+1,Y+1))/2) '**  for PAINT command
197 '**
198 '** PolyMaze menu
199 '**
200 SCREEN 1,0 :COLOR 0,1 :CLS :KEY OFF
210 PRINT TAB(16) "PolyMaze"
220 PRINT TAB(13) "by Dan Rollins"
230 PRINT :PRINT:PRINT "options:"
240 PRINT :PRINT TAB(8) "1) You solve the maze."
250 PRINT :PRINT TAB(8) "2) Computer solves the maze."
260 PRINT :PRINT TAB(8) "3) Random maze display."
270 PRINT :PRINT :PRINT TAB(8) "0) Quit"
280 LOCATE 23,1 :INPUT "Your choice";OPT$
290 OPT = VAL(OPT$)
300 IF OPT <0 OR OPT > 3 THEN BEEP :GOTO 280
310 CLS :ON OPT GOTO 400,410,600
320 SCREEN 0,0,0,0 :WIDTH 80 :END               '** option 0, Quit
400 PRINT "You solve the maze" :GOTO 420
410 PRINT "Computer solves the maze"
420 PRINT :PRINT :INPUT "Number of vertices (3 to 61)";H
430 IF H<3 OR H>61 THEN BEEP :GOTO 420
440 PRINT :PRINT :INPUT "Number of levels   (2 to 18)";V
450 IF V<2 OR V>18 THEN BEEP :GOTO 440
460 H=H-1 :V=V-1                             '** include the 0th element
470 CLS :GOSUB 1000                          '** generate the maze
480 EX=INT(H/2) :MZ(EX,V)=MZ(EX,V) OR 4      '** place maze exit
490 GOSUB 2000                               '** calculate the corner points
500 GOSUB 3000                               '** display the maze
510 IF OPT=2 THEN GOSUB 5000 :GOTO 200       '** computer solves the maze
520 GOSUB 4000                               '** player solves the maze
530 GOSUB 6000                               '** colorful wrap-up
540 LOCATE 1,1 :PRINT "press any";
550 LOCATE 2,1 :PRINT "key"
560 WHILE INKEY$="" :WEND :GOTO 200          '** back to menu
597 '**
598 '**       random generate and display loop
599 '**
600 H=INT(RND*58)+3 :V=INT(RND*15)+3 :EX=INT(H/2)
610   GOSUB 1000 :MZ(EX,V)=MZ(EX,V) OR 4
620   GOSUB 2000 :CLS :GOSUB 6000
630   IF INKEY$ <> "" THEN GOTO 200          '** any key to get to menu
640 GOTO 600
993 '**
994 '**    ---- Maze generation subroutine ----
995 '** expects: H=horizontal size (number of polygon edges)
996 '**          V=vertical size (number of levels)
997 '**          X.DELTA(dir), Y.DELTA(dir) = motion vectors for 4 directions
998 '**          PWR2() = powers of 2 ie, 1,2,4,8
999 '**
1000 FOR J=0 TO H :FOR K=0 TO V :MZ(J,K)=0 :NEXT :NEXT '** "close" all doors
1010 RC=0 :TR=(H+1)*(V+1)-1 :X=INT(RND*H) :Y=INT(RND*V)
1014 LOCATE 1,1 :PRINT"generating"; :LOCATE 2,1 :PRINT "the maze:";
1016 LOCATE 25,1 :PRINT TR;"to go";
1018 '**
1019 '** ---- Main maze generation loop ---- **
1020 Q=0 :IF RC = TR THEN RETURN   '** if Room Count = Total Rooms then done
1030   IF Y>0 THEN IF MZ(X,Y-1)=0 THEN Q=Q+1 :T(Q)=0        '** OUT
1040   IF X<H THEN IF MZ(X+1,Y)=0 THEN Q=Q+1 :T(Q)=1        '** CW
1050   IF Y<V THEN IF MZ(X,Y+1)=0 THEN Q=Q+1 :T(Q)=2        '** IN
1060   IF X>0 THEN IF MZ(X-1,Y)=0 THEN Q=Q+1 :T(Q)=3        '** CCW
1070   IF X=0 THEN IF MZ(H,Y)=0   THEN Q=Q+1 :T(Q)=3        '** CCW
1080   IF X=H THEN IF MZ(0,Y)=0   THEN Q=Q+1 :T(Q)=1        '** CW
1090   IF Q=0 GOTO 1200                                     '** no move
1097   '**
1098   '** open the doors and move into new room
1099   '**
1100   D=INT(RND*Q)+1 :DIR=T(D)                '** choose randomly from list
1110   MZ(X,Y)=MZ(X,Y) OR PWR2(DIR)            '** door in current room
1120   Y=Y+Y.DELTA(DIR) :X=X+X.DELTA(DIR)      '** move to new room
1130   IF X>H THEN X=0 ELSE IF X<0 THEN X=H
1140   MZ(X,Y)=MZ(X,Y) OR PWR2((DIR+2) AND 3)  '** door in new room
1150   RC=RC+1
1160   LOCATE 25,1 :PRINT TR-RC;               '** display count
1170 GOTO 1020
1197   '**
1198   '** Trapped! Scan for unvisited room neighboring visited room.
1199   '**
1200   Y=Y+1 :IF Y>V THEN Y=0 :X=X+1 :IF X>H THEN X=0
1210   IF MZ(X,Y)=0 THEN 1200        '** if empty, keep scanning, else....
1220 GOTO 1020                       '** see if neighbor has been visited
1230 '** ---------------------------------------------------------------------
1996 '**
1997 '** subroutine calculates the points of the corners of each room
1998 '** expects: H,V are horizontal,vertical sizes
1999 '**
2000 LOCATE 1,1 :PRINT "calculating"; :LOCATE 2,1 :PRINT "corners  ";
2010 Z=-1 :PI!=3.14159  :XY.ADJ!=1.603015   '** adjustment for x,y screen size
2020 FOR J!=PI! TO -PI! STEP -2*PI!/(H+1)
2030   Z=Z+1
2040   CIR.SIN!(Z)=SIN(J!)        '** avoid repeated use of
2050   CIR.COS!(Z)=COS(J!)        '** transcendental functions
2060 NEXT
2070 SCALE!=(17/(V+1))*7.5        '** factor enlarges small mazes
2080 FOR Y=0 TO V+1
2090   RADIUS=(V+1-Y)*SCALE!+30   '** 30 minimum radius
2100   FOR X=0 TO H
2110     XC(X,Y)= CIR.SIN!(X) * RADIUS + 159
2120     YC(X,Y)=(CIR.COS!(X) * RADIUS + 159)/XY.ADJ!
2130   NEXT
2140   XC(H+1,Y)=XC(0,Y) :YC(H+1,Y)=YC(0,Y) '** link edges
2150 NEXT
2160 RETURN
2997 '**
2998 '** draw the maze (spiral from outside to inside)
2999 '**
3000 SCREEN 1 :COLOR 0,1 :CLS :KEY OFF
3010 FOR Y=0 TO V
3020   FOR X=0 TO H
3030     C=3 :GOSUB 9000       '** draw room with doors
3040   NEXT
3050 NEXT
3060 LINE (159,99)-(XC(EX,V+1),YC(EX,V+1)),3      '** inverted "V" at maze exit
3070 LINE (159,99)-(XC(EX+1,V+1),YC(EX+1,V+1)),3
3080 RETURN
3997 '**
3998 '** subroutine for player to solve the maze
3999 '**
4000  X=0 :Y=0 :SP=0 :DONE=FALSE          '** start in room 0,0
4010  C=2 :GOSUB 9100                     '** outline current room w/o doors
4020  PAINT (FN CENTER.X,FN CENTER.Y),2,2 '** paint current room blue
4030  C=0 :GOSUB 9100                     '** outline in black w/o doors
4040  C=3 :GOSUB 9000                     '** draw room with doors (white)
4050  GOSUB 4200                          '** make a move (returns TX and TY)
4060  IF TX=X AND TY=Y THEN C=0 :GOSUB 9000 :GOTO 4040 '** no move, blink walls
4070  C=0 :GOSUB 9100                    '** outline room in black
4080  PAINT(FN CENTER.X,FN CENTER.Y),0,0 '** paint room black (leave the room)
4090  C=3 :GOSUB 9000                    '** redraw room as before (with doors)
4100  X=TX :Y=TY                         '** adjust to point to new room
4110 IF NOT DONE THEN 4010               '** repeat until finished
4120 RETURN                         '<-- return when at maze exit -----------
4197 '**
4198 '** get a key, determine if valid move, alter TX,TY if so
4199 '**
4200 TX=X :TY=Y
4210 K$=INKEY$ :IF K$="" THEN RETURN
4220 IF K$=LA$ THEN IF MZ(X,Y) AND 8 THEN TX=X-1 :GOTO 4300
4230 IF K$=RA$ THEN IF MZ(X,Y) AND 2 THEN TX=X+1 :GOTO 4300
4240 IF K$=UA$ THEN IF MZ(X,Y) AND 1 THEN TY=Y-1 :GOTO 4300
4250 IF K$=DA$ THEN IF MZ(X,Y) AND 4 THEN TY=Y+1 :GOTO 4300
4260 IF K$<>"S" AND K$<>"s" THEN 4280
4270 STACK(SP)=X :STACK(SP+1)=Y :SP=SP+2 :RETURN      '** [S] to Save position
4280 IF K$<>"R" AND K$<>"r" THEN RETURN
4285 IF SP=0 THEN BEEP :RETURN                        '** stack is empty!
4290 SP=SP-1 :TY=STACK(SP) :SP=SP-1 :TX=STACK(SP):RETURN '** [R] to Retrieve
4297 '**
4298 '** adjust for connection of edges and test for finished
4299 '**
4300 IF TX>H THEN TX=0 ELSE IF TX<0 THEN TX=H
4310 IF TY > V  THEN DONE = TRUE
4320 RETURN
4997 '**
4998 '**  computer solves the maze
4999 '**
5000 SP=0 :SLPTR=0               '** init Stack Pointer, Solution List PoinTeR
5010 LOCATE 1,1 :PRINT"solving";
5020 X=0 :Y=0 :DIR=0             '** starting room, starting DIRection
5030 WHILE X<>EX OR Y<>V         '** do until at maze exit
5040   T.DIR=(DIR+1) AND 3       '** turn one notch
5050   WHILE T.DIR <> DIR        '** do until back at starting direction
5059                             '** if there's an open door in this direction,
5060     IF (MZ(X,Y) AND PWR2(T.DIR)) > 0 THEN GOSUB 5500        '** then PUSH
5070     T.DIR=(T.DIR+1) AND 3   '** look to the next direction
5080   WEND                      '**  until all directions examined
5090   GOSUB 5600                '** POP data from stack
5100   SOLUTION.LIST(0,SLPTR)=X  '** store current room in solution list
5110   SOLUTION.LIST(1,SLPTR)=Y
5120   GOSUB 5700                '** paint the current room blue
5130   GOSUB 5800                '** restore room to normal
5140 WEND
5197   '**
5198   '** The maze is solved.  Display each room of the solution.
5199   '**
5200 LOCATE 1,1 :PRINT"solution:";
5210 FOR J=0 TO SLPTR
5220   X=SOLUTION.LIST(0,J) :Y=SOLUTION.LIST(1,J)
5230    GOSUB 5700
5240 NEXT
5250 LOCATE 24,1 :PRINT"Press"; :LOCATE 25,1 :PRINT"any key";
5260 WHILE INKEY$="" :WEND
5270 RETURN
5500 TX=X+X.DELTA(T.DIR) :IF TX>H THEN TX=0 ELSE IF TX<0 THEN TX=H
5510 TY=Y+Y.DELTA(T.DIR) :IF TY>V THEN TY=0 ELSE IF TY<0 THEN TY=V
5520          STACK(SP) = TX
5530 SP=SP+1 :STACK(SP) = TY
5540 SP=SP+1 :STACK(SP) = (T.DIR+2) AND 3
5550 SP=SP+1 :STACK(SP) = SLPTR + 1
5560 SP=SP+1
5570 RETURN
5597 '**
5598 '** POP the data from the stack
5599 '**
5600 SP=SP-1 :SLPTR = STACK(SP)
5610 SP=SP-1 :DIR   = STACK(SP)
5620 SP=SP-1 :Y     = STACK(SP)
5630 SP=SP-1 :X     = STACK(SP)
5640 RETURN
5697   '**
5698   '** routine paints the current room BLUE (displays position)
5699   '**
5700 C=2 :GOSUB 9100
5710 PAINT (FN CENTER.X,FN CENTER.Y),2,2
5720 C=3 :GOSUB 9000
5730 RETURN
5797   '**
5798   '** routine paints the room BLACK (return to normal)
5799   '**
5800 C=0 :GOSUB 9100
5810 PAINT (FN CENTER.X,FN CENTER.Y),0,0
5820 C=3 :GOSUB 9000
5830 RETURN
5997 '**
5998 '** colorful wrap-up,  PAINTs maze various colors
5999 '**
6000 GOSUB 3010                  '** redraw the lines so paint won't escape
6010 X=EX :Y=V                   '** set up X,Y for FN calls
6020 FOR C=0 TO 1
6030   COLOR 0,C
6040   PAINT (FN CENTER.X,FN CENTER.Y)  ,C+1,3
6050   PAINT (FN CENTER.X,FN CENTER.Y)  ,0,3
6060 NEXT
6070 C1=0 :COLOR 0,0                       '** spiral alternating colors
6080 FOR Y=0 TO V
6090  FOR X=H TO 0 STEP -1
6100   C=3 :GOSUB 9100                     '** draw w/o doors
6110   PAINT (FN CENTER.X,FN CENTER.Y),C1,3
6120   C1=C1+1 :IF C1=4 THEN C1=0
6130 NEXT :NEXT
6140 RETURN
8997 '**
8998 '** subroutine draws room (X,Y) with doors
8999 '**
9000 IF (MZ(X,Y) AND 1)=1 THEN 9020
9010  LINE (XC(X,Y),YC(X,Y))-(XC(X+1,Y),YC(X+1,Y)),C
9020 IF (MZ(X,Y) AND 8)=8 THEN 9040
9030  LINE(XC(X,Y),YC(X,Y))-(XC(X,Y+1),YC(X,Y+1)),C
9040 IF (MZ(X,Y) AND 4)=4 THEN 9060
9050  LINE (XC(X,Y+1),YC(X,Y+1))-(XC(X+1,Y+1),YC(X+1,Y+1)),C
9060 IF (MZ(X,Y) AND 2)=2 THEN 9080
9070  LINE(XC(X+1,Y),YC(X+1,Y))-(XC(X+1,Y+1),YC(X+1,Y+1)),C
9080 RETURN
9097 '**
9098 '** subroutine draws the room without doors (color C)
9099 '**
9100 LINE (XC(X,Y),YC(X,Y))-(XC(X+1,Y),YC(X+1,Y)),C
9110 LINE -(XC(X+1,Y+1),YC(X+1,Y+1)),C
9120 LINE -(XC(X,Y+1),YC(X,Y+1)),C
9130 LINE -(XC(X,Y),YC(X,Y)),C
9140 RETURN
