(*-------------------------------------------------------*)
(*   THIS CODE IS THE PROPERTY OF A.I.SOFTWARE, IT MAY   *)
(*   NOT BE PUBLICLY DISTRIBUTED IN ANY FORM AND IT      *)
(*   MAY ONLY BE COPIED AND/OR MODIFIED FOR PERSONAL USE *)
(*-------------------------------------------------------*)
(* Chester, the intelligent chinese checkers program.    *)
(*                                                       *)
(* (C) Copyright 1985 A.I.SOFTWARE                       *)
(*                                                       *)
(* ------------------------------------------------------*)
(*                      Main module.                     *)
(*-------------------------------------------------------*)



PROGRAM CHESTER_GAME;
CONST

  RET                = 13;
  BKS                = 8;
  MAX_MOVES_RECORDED = 170;
                 (* if more memory is available, *)
                 (* range can be increased.      *)

TYPE

  BYTE      = 0..255;

  CODE_NAME = PACKED ARRAY[1..2] OF CHAR;

  NODE      = RECORD

                NAME   :CODE_NAME;
                XCOORD :INTEGER;
                YCOORD :INTEGER;
                COLOR  :BYTE;
                NW     :BYTE;
                NE     :BYTE;
                SW     :BYTE;
                SE     :BYTE;
                CR     :BYTE;
                CL     :BYTE;
                DIST   :ARRAY[1..6] OF BYTE;

              END;

  FAKE_NODES = RECORD

                  FROM_N,
                  TO_N,
                  LCT,
                  S      :BYTE;

                END;

  END_MVS   = RECORD

                FN,
                TN,
                LOCON :BYTE;

              END;

  ENDING_MOVES = RECORD

                   MOVES_LEFT:ARRAY[1..40] OF END_MVS;
                   FINNISH   :BOOLEAN;
                   NUM_LEFT  :BYTE;
                   MOVES_DONE:BYTE;

                 END;

  PLAYER    = ARRAY[0..11] OF BYTE;

  QUE_REC   = RECORD

                ND   :BYTE;
                LNGTH:BYTE;

              END;

  IN_PLAY   = RECORD

                CT:BYTE;
                OP:BYTE;

              END;

  PLAY_MODES= (NEW_GAME,REASSUME,HUMAN);


  REGISTERS = RECORD

                AX,BX,CX,DX,BP,SI,DI,DS,ES,FLAGS :INTEGER;

              END;

  MSGS      = PACKED ARRAY[1..13] OF CHAR;

  INF       = PACKED ARRAY[1..6 ] OF CHAR;

  SETS      = SET OF BYTE;

  GOOD_MOVES = RECORD

                C,O:BYTE;

              END;

  SAMPLE_MOVE = RECORD

                 FN,TN :BYTE;

              END;

  SAMPLE_GAME = PACKED ARRAY[1..67] OF SAMPLE_MOVE;

  STATE     = RECORD

                  SMODE          :BYTE;
                  SBEFORE        :ARRAY[1..6  ] OF GOOD_MOVES;
                  SCOLORS        :ARRAY[1..121] OF BYTE;
                  SPLAYERS       :ARRAY[1..6] OF PLAYER;
                  SPLAY_SETS     :ARRAY[1..3] OF IN_PLAY;
                  SCT_LAST_F     :BYTE;
                  SCT_LAST_T     :BYTE;
                  SOP_LAST_F     :BYTE;
                  SOP_LAST_T     :BYTE;

               END;


VAR

  END_MOVES     :ARRAY[1..6] OF ENDING_MOVES;
  FRONT         :ARRAY[1..6,1..5] OF BYTE;
  BEFORE        :ARRAY[1..6  ] OF GOOD_MOVES;
  MOVE_PATH     :ARRAY[0..30 ] OF BYTE;
  PATH          :ARRAY[1..121] OF BYTE;
  SAVED_GAME    :PACKED ARRAY[1..11] OF CHAR;
  LAND1_NODES   :ARRAY[0..100] OF QUE_REC;
  LAND2_NODES   :ARRAY[0..100] OF BYTE;
  FIXED_LOC     :ARRAY[1..6] OF PLAYER;
  FIRST_LINE    :ARRAY[1..6] OF SETS;
  PLAY_MODE     :PLAY_MODES;
  CHESTER_SET,
  OPPONENT_SET,
  LNSP1,
  LNSP2,
  PATH_LENGTH   :BYTE;
  MOVED_YET,
  BACKING,
  RESTART,
  TERMINATE,
  PLAN_END,
  FINNISHING,
  CHEAT,
  ME_FIRST,
  BEEPON        :BOOLEAN;
  SAVED_FILE    :FILE;

(*---------------------  Block of variables saved to disk -------------*)

  GUARD,
  NUM_PLAYERS,
  NUM_MOVES,
  DEG_DIFFICULTY,
  PL,
  BG,
  NUM_SETS,
  MODE,
  STARTER,
  CT_LAST_F,
  CT_LAST_T,
  OP_LAST_F,
  OP_LAST_T     :BYTE;
  PLAY_SETS     :ARRAY[1..3] OF IN_PLAY;
  PLAYERS       :ARRAY[1..6] OF PLAYER;
  BOARD         :ARRAY[0..122] OF NODE;
  THE_GAME      :ARRAY[0..MAX_MOVES_RECORDED] OF STATE;
  DUMMY         :ARRAY[1..60] OF BYTE;

(*------------------------------------------------------------------------*)

{$I SEARCH.PAS}
{$I CHIOSYS.PAS}


(*--------------------- Initialization module ------------------------*)
(* (C) copyright A.I.SOFTWARE                                         *)



PROCEDURE INIT;
VAR

  I,J    :BYTE;

BEGIN

  INIT_BOARD;
  FOR I := 62  TO 71  DO BEGIN

      PLAYERS[1][I-61]    :=I;
      FIXED_LOC[1][I-61]  :=I;

  END;
  FOR I := 72  TO 81  DO BEGIN

    PLAYERS[2][I-71]    :=I;
    FIXED_LOC[2][I-71]  :=I;

  END;
  FOR I := 82  TO 91  DO BEGIN

    PLAYERS[3][I-81]    :=I;
    FIXED_LOC[3][I-81]  :=I;

  END;
  FOR I := 92  TO 101 DO BEGIN

    PLAYERS[4][I-91]    :=I;
    FIXED_LOC[4][I-91]  :=I;

  END;
  FOR I := 102 TO 111 DO BEGIN

    PLAYERS[5][I-101]   :=I;
    FIXED_LOC[5][I-101] :=I;

  END;
  FOR I := 112 TO 121 DO BEGIN

    PLAYERS[6][I-111]   :=I;
    FIXED_LOC[6][I-111] :=I;

  END;
  BEEPON      := TRUE;
  CT_LAST_F   := 0;
  CT_LAST_T   := 0;
  OP_LAST_F   := 0;
  OP_LAST_T   := 0;
  STARTER     := 0;
  NUM_SETS    := 0;
  NUM_PLAYERS := 0;
  PL          := 1;
  BG          := 0;
  MOVED_YET   := FALSE;
  FOR I:= 1 TO 6 DO  END_MOVES[I].FINNISH := FALSE;
  DEG_DIFFICULTY := 0;

END; (* INIT *)


(*--------------------- Get Opponent moves module ---------------------*)
(* (C) copyright  A.I.SOFTWARE                                         *)


PROCEDURE GET_MOVE(VAR FROM_NODE,TO_NODE,LOC,ST:BYTE);
VAR

  CODE_FROM_NODE,
  CODE_TO_NODE    :CODE_NAME;
  OK,
  CHANGE_MIND,
  FINE            :BOOLEAN;
  I,J             :BYTE;


  PROCEDURE TRADE_SETS;
  VAR

    I,TEMPST :BYTE;

  BEGIN

    FOR I:= 1 TO NUM_SETS DO BEGIN

      TEMPST          := PLAY_SETS[I].CT;
      PLAY_SETS[I].CT := PLAY_SETS[I].OP;
      PLAY_SETS[I].OP := TEMPST;

    END;

  END; (* TRADE_SETS *)


  PROCEDURE BACK_UP(NUM:BYTE);
  VAR

    I :BYTE;

  BEGIN

    MESSAGE(7);
    BACKING   := TRUE;
    NUM_MOVES := NUM_MOVES - NUM;
    WITH THE_GAME[NUM_MOVES] DO BEGIN

      MODE      := SMODE;
      MOVE(SBEFORE[1].C,BEFORE[1].C,12);
      FOR I:= 1 TO 121 DO BOARD[I].COLOR := SCOLORS[I];
      MOVE(SPLAYERS[1][0],PLAYERS[1][0],72);
      MOVE(SPLAY_SETS[1].CT,PLAY_SETS[1].CT,6);
      MOVE(SCT_LAST_F,CT_LAST_F,4);

    END;
    DRAWBOARD;
    IF NUM_PLAYERS = 0 THEN MESSAGE(4)
    ELSE MESSAGE(5);
    IF NUM_PLAYERS = 0
    THEN SING_DISPLAY(CT_LAST_F,CT_LAST_T,OP_LAST_F,OP_LAST_T)
    ELSE BEGIN

      IF MODE = 1
      THEN MULT_DISPLAY(CT_LAST_F,CT_LAST_T,OP_LAST_F,OP_LAST_T,NUM_PLAYERS)
      ELSE MULT_DISPLAY(CT_LAST_F,CT_LAST_T,OP_LAST_F,OP_LAST_T,MODE - 1);

    END;

  END; (* BACK_UP *)


  PROCEDURE CHECK_FOR_CHEATING;
  VAR

    L,D  :BYTE;      (* DUMMIES *)

  BEGIN

    CHEAT := TRUE;
    SEARCH_BOARD(FALSE,TRUE,OPPONENT_SET,FROM_NODE,LOC,2,
                 FROM_NODE,TO_NODE,LOC,L,D);
    IF FROM_NODE = TO_NODE THEN CHEAT:=TRUE;
    IF CHEAT THEN BEGIN

      ERROR(5);
      GET_MOVE(FROM_NODE,TO_NODE,LOC,ST);

    END;

  END; (* CHECK_FOR_CHEATING *)



  PROCEDURE READ_CODE(TF:BYTE);
  VAR

    BL,AL,T,
    TL,S,
    ND,LCT   :BYTE;
    CH,CH2   :CHAR;
    J        :BYTE;
    NUM      :BYTE;
    TCD      :PACKED ARRAY[1..3] OF CHAR;

  BEGIN

    TCD[1]      :='@';
    TCD[2]      :='@';
    TCD[3]      :='@';
    J           := 1;
    PROMPT(8 + TF);
    GOTOXY(7,5);
    REPEAT

      READCHR(CH);
      WRITECHR(CH);
      TCD[J] := CH;

      CASE CH OF
      'O'    :BEGIN

                 BEEPON := NOT BEEPON;

              END;
      'S'    :BEGIN

                PROMPT(11);
                GET_FILE_NAME;
                IF SAVED_GAME[1] <> ' ' THEN SAVE_THE_GAME;
                J := 4;

              END;
      'Q'    :BEGIN

                PROMPT(12);
                READER(7,CH2);
                IF CH2  = 'Y' THEN TERMINATE := TRUE
                ELSE J := 4;

              END;

      'M'    :CHANGE_MIND := TRUE;

      'H'    :BEGIN

                S  := ST;
                BEFORE_AFTER(2,2,BL,AL,T,S,TL,ND,LCT);
                IF AL > 0 THEN REPORT_HINT(ND,S,LCT)
                ELSE MESSAGE(6);
                J := 4;

              END;

      'U'    :BEGIN

                IF ((DEG_DIFFICULTY IN [4,5]) AND ( END_MOVES[1].FINNISH
                       OR  END_MOVES[2].FINNISH OR END_MOVES[3].FINNISH
                       OR  END_MOVES[4].FINNISH OR END_MOVES[5].FINNISH
                       OR  END_MOVES[6].FINNISH ))
                OR (NUM_MOVES = 0) OR (NUM_MOVES > MAX_MOVES_RECORDED)
                THEN BEGIN

                  MESSAGE(32);
                  J := 4;

                END
                ELSE BEGIN

                  PROMPT(13);
                  READNUM(NUM);
                  IF (NUM > 0)AND(NUM <= NUM_MOVES ) THEN BACK_UP(NUM)
                  ELSE J := 4;

                END;

              END;

      'N'    :CHANGE_COLORS;

      'T'    :BEGIN


                IF NUM_PLAYERS = 0 THEN BEGIN

                  IF (DEG_DIFFICULTY IN [4,5]) AND ( END_MOVES[1].FINNISH
                       OR  END_MOVES[2].FINNISH OR END_MOVES[3].FINNISH
                       OR  END_MOVES[4].FINNISH OR END_MOVES[5].FINNISH
                       OR  END_MOVES[6].FINNISH )
                  THEN BEGIN

                    MESSAGE(33);
                    J := 4;

                  END
                  ELSE BEGIN

                    MESSAGE(8);
                    BACKING  := TRUE;
                    MODE     := 1;
                    ME_FIRST := NOT ME_FIRST;
                    TRADE_SETS;
                    MESSAGE(4);

                  END;

                END;

              END

         ELSE BEGIN

                IF CH = CHR(BKS)   (* back space      *)
                THEN BACK_SPACE(J)
                ELSE J := J + 1;

              END;
      END; (* Case ch *)

    UNTIL (J > 3) OR  TERMINATE OR (ORD(CH) = RET) OR BACKING OR CHANGE_MIND;

    IF (NOT TERMINATE) AND (NOT BACKING) AND (ORD(CH) = RET) THEN BEGIN

      CASE TF OF
        1:BEGIN

           CODE_FROM_NODE[1] := TCD[1];
           CODE_FROM_NODE[2] := TCD[2];

          END;
        2:BEGIN

           CODE_TO_NODE[1]   := TCD[1];
           CODE_TO_NODE[2]   := TCD[2];

          END;
      END;
      FINE := TRUE;

    END;
    IF (CODE_FROM_NODE[1] IN ['1'..'9'])AND
       (NOT (CODE_FROM_NODE[2] IN ['0'..'9']))
    THEN BEGIN

      CODE_FROM_NODE[2] := CODE_FROM_NODE[1];
      CODE_FROM_NODE[1] := '0';

    END;
    IF (CODE_TO_NODE[1] IN ['1'..'9'])AND
       (NOT (CODE_TO_NODE[2] IN ['0'..'9']))
    THEN BEGIN

      CODE_TO_NODE[2]   := CODE_TO_NODE[1];
      CODE_TO_NODE[1]   := '0';

    END;

  END; (* READ_CODE *)

BEGIN

  OK      := FALSE;
  BACKING := FALSE;
  WHILE NOT OK AND (NOT TERMINATE) AND (NOT BACKING) DO BEGIN

    FROM_NODE := 1;
    TO_NODE   := 1;
    REPEAT

      CHANGE_MIND := FALSE;
      FINE        := FALSE;
      REPEAT

        READ_CODE(1);

      UNTIL FINE OR TERMINATE OR BACKING;

      FINE := FALSE;
      IF (NOT TERMINATE)AND(NOT BACKING) THEN
      REPEAT

        READ_CODE(2);

      UNTIL CHANGE_MIND OR FINE OR TERMINATE OR BACKING;

    UNTIL FINE OR TERMINATE OR BACKING;

    IF (NOT TERMINATE) AND (NOT BACKING) THEN BEGIN

      WHILE (BOARD[FROM_NODE].NAME <> CODE_FROM_NODE)AND(FROM_NODE <= 121)
      DO FROM_NODE := FROM_NODE + 1;

      WHILE (BOARD[TO_NODE  ].NAME <> CODE_TO_NODE  )AND(TO_NODE   <= 121)
      DO TO_NODE := TO_NODE + 1;

      IF (BOARD[TO_NODE].COLOR <> 7) OR (FROM_NODE > 121) OR (TO_NODE > 121)
      THEN ERROR(4)
      ELSE BEGIN

        IF NUM_PLAYERS = 0 THEN BEGIN

          I := 1;
          WHILE I <= NUM_SETS DO BEGIN

            LOC := 1;
            WHILE (PLAYERS[PLAY_SETS[I].OP][LOC] <> FROM_NODE) AND (LOC <= 10)
            DO  LOC := LOC + 1;
            IF LOC > 10 THEN I := I + 1
            ELSE BEGIN

              OPPONENT_SET := PLAY_SETS[I].OP;
              I            := NUM_SETS + 1;
              CHECK_FOR_CHEATING;
              OK           := TRUE;
              ST           := OPPONENT_SET;

            END;

          END;

        END
        ELSE BEGIN

          LOC := 1;
          WHILE (PLAYERS[ST][LOC] <> FROM_NODE) AND (LOC <= 10)
          DO  LOC := LOC + 1;
          IF LOC <= 10 THEN BEGIN

            OPPONENT_SET := ST;
            CHECK_FOR_CHEATING;
            OK           := TRUE;

          END;

        END;
        IF NOT OK THEN ERROR(6);

      END;

    END;

  END;

END; (* GET_MOVE *)



(*-------------------------- Brain module ----------------------------*)
(* (C) copyright A.I.SOFTWARE                                         *)




PROCEDURE THINK(VAR FROM_NODE,TO_NODE,LOC,ST:BYTE);
TYPE

  MVS = RECORD

          FROM:BYTE;
          T   :BYTE;
          LN  :BYTE;
          LC  :BYTE;

        END;

VAR

  MOV          :ARRAY[1..3] OF MVS;
  OK           :BOOLEAN;
  I,J          :BYTE;
  LONGEST      :BYTE;
  AT_THE_END   :BOOLEAN;
  T1,T2,T3,T4,
  T5,T6        :BYTE;



  PROCEDURE LANDING_NODES(STK:BYTE;DEFAULTING:BOOLEAN; PASS,FROM_ND:BYTE;
                          VAR TO_ND:BYTE);
  VAR

     K          :BYTE;
     HOLE       :BYTE;
     FIRST,LAST :BYTE;

  BEGIN

     CASE DEFAULTING OF
       TRUE:BEGIN
              TO_ND := 0;
              CASE PASS OF
                1 : BEGIN
                      FIRST := 2;
                      LAST  := 1;
                    END;
                2 : BEGIN
                      FIRST := 4;
                      LAST  := 3;
                    END;
              END;
            END;
      FALSE:BEGIN
              FIRST := 4;
              LAST  := 1;
            END;
     END;
     FOR K:= FIRST DOWNTO LAST  DO BEGIN

       HOLE := 255;
       CASE CHESTER_SET OF

         1:CASE K OF
           1,2:CASE K OF
                 1:IF BOARD[BOARD[FROM_ND].SE].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].SE;
                 2:IF BOARD[BOARD[FROM_ND].SW].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].SW;
               END;
           3,4:CASE K OF
                 3:IF BOARD[BOARD[FROM_ND].CR].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].CR;
                 4:IF BOARD[BOARD[FROM_ND].CL].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].CL;
               END;
           END;

         2:CASE K OF
           1,2:CASE K OF
                 1:IF BOARD[BOARD[FROM_ND].SW].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].SW;
                 2:IF BOARD[BOARD[FROM_ND].CL].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].CL;
               END;
           3,4:CASE K OF
                 3:IF BOARD[BOARD[FROM_ND].SE].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].SE;
                 4:IF BOARD[BOARD[FROM_ND].NW].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].NW;
               END;
           END;

         6:CASE K OF
           1,2:CASE K OF
                 1:IF BOARD[BOARD[FROM_ND].SE].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].SE;
                 2:IF BOARD[BOARD[FROM_ND].CR].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].CR;
               END;
           3,4:CASE K OF
                 3:IF BOARD[BOARD[FROM_ND].SW].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].SW;
                 4:IF BOARD[BOARD[FROM_ND].NE].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].NE;
               END;
           END;

         3:CASE K OF
           1,2:CASE K OF
                 1:IF BOARD[BOARD[FROM_ND].CL].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].CL;
                 2:IF BOARD[BOARD[FROM_ND].NW].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].NW;
               END;
           3,4:CASE K OF
                 3:IF BOARD[BOARD[FROM_ND].NE].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].NE;
                 4:IF BOARD[BOARD[FROM_ND].SW].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].SW;
               END;
           END;

         4:CASE K OF
           1,2:CASE K OF
                 1:IF BOARD[BOARD[FROM_ND].NW].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].NW;
                 2:IF BOARD[BOARD[FROM_ND].NE].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].NE;
               END;

           3,4:CASE K OF
                 3:IF BOARD[BOARD[FROM_ND].CL].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].CL;
                 4:IF BOARD[BOARD[FROM_ND].CR].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].CR;
               END;
           END;

         5:CASE K OF
            1,2:CASE K OF
                  1:IF BOARD[BOARD[FROM_ND].NE].COLOR = 7
                    THEN HOLE:=BOARD[FROM_ND].NE;
                  2:IF BOARD[BOARD[FROM_ND].CR].COLOR = 7
                    THEN HOLE:=BOARD[FROM_ND].CR;
                END;

           3,4:CASE K OF
                 3:IF BOARD[BOARD[FROM_ND].NW].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].NW;
                 4:IF BOARD[BOARD[FROM_ND].SE].COLOR = 7
                   THEN HOLE:=BOARD[FROM_ND].SE;
               END;
           END;
       END;     (* case chester_set *)

       IF HOLE <> 255 THEN BEGIN

         IF NOT DEFAULTING THEN
          CASE STK OF
            1:PUSH_LN1(HOLE,100);
            2:PUSH_LN2(HOLE);
          END
         ELSE TO_ND := HOLE;

       END;

     END;       (* for loop *)

  END; (* LANDING_NODES *)


  PROCEDURE MINIMAX(PASS       :BYTE;
                    DEFAULTING :BOOLEAN;
                    FROM_ND,LOC,
                    OBL,OTBL,
                    TPND,TPLCT,
                    TPST,CBL,
                    CTBL,CBLOC :BYTE;
                VAR TO_ND,LENTH:BYTE);
(* Determines the best possible move from given marble.           *)
(* Uses the following heuristics to evaluate moves:               *)
(*    - How much can the opponent's best move be blocked.         *)
(*    - How many rows can be taken/given to the opponents moves.  *)
(*    - The absolute number of parallel rows advanced by move.    *)
(*    - The number of parallel rows between the front and         *)
(*      contemplated marble.                                      *)
(*    - The maximum number of parallel rows that can be advanced  *)
(*      in the next turn as result of making contemplated move.   *)
(*    - The number of parallel rows between the marble giving     *)
(*      the previous heuristic's value and the front marble.      *)


  VAR

    TL,OTAL      :BYTE;
    NAL ,NL      :BYTE;
    BL,AL        :BYTE;
    FAKED_MOVES  :ARRAY[0..15] OF FAKE_NODES;
    FMSP         :BYTE;
    I,J          :BYTE;
    NODE ,LTH    :BYTE;
    ND ,TF,LCT,ST:BYTE;
    DFROM_ND,
    DTO_ND,
    DLOC,
    DLNG,DDEST   :BYTE;
    OAL          :BYTE;


    PROCEDURE INIT_FAKED_MOVES;
    BEGIN

      FMSP                 := 0;
      FAKED_MOVES[0].FROM_N:= 0;
      FAKED_MOVES[0].TO_N  := 0;
      FAKED_MOVES[0].LCT   := 0;
      FAKED_MOVES[0].S     := 0;

    END; (* INIT_FAKED_MOVES *)


    PROCEDURE PUSH_FM(F,T,L,S:BYTE);
    BEGIN

      IF FMSP <= 14 THEN BEGIN

        FMSP                     := FMSP + 1;
        FAKED_MOVES[FMSP].FROM_N := F;
        FAKED_MOVES[FMSP].TO_N   := T;
        FAKED_MOVES[FMSP].LCT    := L;
        FAKED_MOVES[FMSP].S      := S;

      END;

    END; (* PUSH_FM *)

   PROCEDURE POP_FM(VAR F,T,L,S:BYTE);
   BEGIN

     F := FAKED_MOVES[FMSP].FROM_N;
     T := FAKED_MOVES[FMSP].TO_N;
     L := FAKED_MOVES[FMSP].LCT;
     S := FAKED_MOVES[FMSP].S;
     IF FMSP > 0 THEN FMSP:=FMSP - 1;

   END; (* POP_FM *)


   PROCEDURE FAKE_MOVE( S,T,LC:BYTE);
   BEGIN

     PUSH_FM(PLAYERS[S][LC],T,LC,S);
     BOARD[PLAYERS[S][LC]].COLOR := 7;
     PLAYERS[S][LC]              := T;
     BOARD[T].COLOR              := S;

   END; (* FAKED_MOVE *)


   PROCEDURE RESTORE_MOVE;
   VAR

     F,T,L,S:BYTE;

   BEGIN

     POP_FM(F,T,L,S);
     PLAYERS[S][L]             := F;
     BOARD[T].COLOR            := 7;
     BOARD[F].COLOR            := S;

   END; (* RESTORE_MOVE *)


  BEGIN  (* MINIMAX *)

    ST   := CHESTER_SET;
    IF DEFAULTING THEN LANDING_NODES(1,DEFAULTING,PASS,FROM_ND,TO_ND)
    ELSE BEGIN

      LENTH := 100;
      INIT_FAKED_MOVES;
      INIT1_LAND_NODES;
      LANDING_NODES(1,DEFAULTING,PASS,FROM_ND,TO_ND);

(* This call makes search_board build the stack of possible landing nodes *)

      SEARCH_BOARD(TRUE,TRUE,CHESTER_SET,FROM_ND ,LOC,1,
                  DFROM_ND,DTO_ND,DLOC,DLNG,DDEST);
      REPEAT

        POP_LN1(NODE,LTH);

      UNTIL NODE IN [0..61,
                     FIXED_LOC[CHESTER_SET][1]..FIXED_LOC[CHESTER_SET][10],
                     FIXED_LOC[OPPONENT_SET][1]..FIXED_LOC[OPPONENT_SET][10]];


      WHILE NODE <> 0 DO BEGIN

        LTH := 100;

(* Make the longest possible move        *)
(* Absolute jump length.                 *)
(* Add distance of the contemplated move *)

        LTH := (LTH +  BOARD[FROM_ND].DIST[CHESTER_SET]) -
                       BOARD[NODE   ].DIST[CHESTER_SET];

        FAKE_MOVE(CHESTER_SET, NODE, LOC);
        OTAL      := 0;
        OAL       := 0;
        IF (NOT FINNISHING) AND (DEG_DIFFICULTY IN [3,4,5])  THEN BEGIN

          BEFORE_AFTER(2,2,BL,OAL,TF,ST,OTAL,ND,LCT);
          LTH         := ((LTH - OTAL) - OAL) + OBL + OTBL;

        END;
        BEFORE_AFTER(1,2,BL,AL,TF,ST,TL,ND,LCT);


(* Credit moves that help others  *)
(* Credit only moves that don't help the opponent.       *)


        IF AL >= CBL THEN
        IF (TL > CTBL) AND (OAL <= OBL) AND (OTAL <= (OTBL + 2)) AND
           ((LCT <> CBLOC) OR (CBL = 0) OR ((LCT = CBLOC)AND((AL - CBL) > 1)))
        THEN BEGIN

(* Do it by making the longest posible move              *)

          LTH := LTH + ( BOARD[PLAYERS[ST][LCT]].DIST[ST] -
                         BOARD[ND              ].DIST[ST] );

(* and by favoring the back marbles for the planned move *)

          LTH := LTH + ( BOARD[PLAYERS[ST][LCT]].DIST[ST] -
                         BOARD[PLAYERS[ST][10 ]].DIST[ST] );

        END;

(* favor the farthest  one back and any move more than one jump long       *)
(* by adding  distance between the first and the last of chester's marbles.*)

        IF (LOC = 1) OR (BOARD[FROM_ND].DIST[CHESTER_SET] >
                         BOARD[NODE   ].DIST[CHESTER_SET] + 2 ) THEN

          LTH := LTH + ( BOARD[FROM_ND                 ].DIST[CHESTER_SET] -
                         BOARD[PLAYERS[CHESTER_SET][10]].DIST[CHESTER_SET] );

        RESTORE_MOVE;

        IF LTH > LENTH THEN BEGIN

          TO_ND := NODE;
          LENTH := LTH;

        END;

        REPEAT

          POP_LN1(NODE,LTH);

        UNTIL NODE IN [0..61,
                   FIXED_LOC[CHESTER_SET][1]..FIXED_LOC[CHESTER_SET][10],
                   FIXED_LOC[OPPONENT_SET][1]..FIXED_LOC[OPPONENT_SET][10]];

      END; (* While NODE <> 0 *)

    END; (* If not defaulting *)

  END; (* MINIMAX *)


  PROCEDURE PLAN_A_MOVE(VAR FROM_ND,TO_ND,LOC,LONGEST_PLAN:BYTE);
  (* Controls move selection *)
  VAR

    I,X,HOLE,BEST_SO_FAR,
    BL,AL,TF,ST,TL,ND,
    LCT,CBLOC,TPST,TPND,
    TPLCT,OBL,CBL,OTBL,
    CTBL                :BYTE;

  BEGIN

    OTBL        := 0;
    OBL         := 0;
    TPND        := 0;
    TPLCT       := 0;
    TPST        := 0;
    BEFORE_AFTER(2,2,BL,OBL,TF,TPST,OTBL,TPND,TPLCT);
    BEFORE_AFTER(1,2,BL,CBL,TF,ST,CTBL,ND,LCT);

    IF FINNISHING OR (DEG_DIFFICULTY = 2) THEN X := 10
    ELSE X := DEG_DIFFICULTY + 5;
    LONGEST_PLAN:= 100;
    TO_ND       := 0;
    I           := 1;
    WHILE  I <= X DO BEGIN

      IF CBL > 0 THEN CBLOC := LCT ELSE CBLOC := I;
      HOLE := 0;
      MINIMAX(0,FALSE, PLAYERS[CHESTER_SET][I],I,
            OBL,OTBL,TPND,TPLCT,TPST,CBL,CTBL,CBLOC,HOLE,BEST_SO_FAR);

      IF (LONGEST_PLAN < BEST_SO_FAR) THEN BEGIN

        FROM_ND     := PLAYERS[CHESTER_SET][I];
        TO_ND       := HOLE;
        LOC         := I;
        LONGEST_PLAN:= BEST_SO_FAR;

      END;
      I := I + 1;

    END;(* I loop      *)
    I := 1;

    WHILE (TO_ND = 0) AND (I < 11) DO BEGIN

        HOLE := 0;
        MINIMAX(1,TRUE, PLAYERS[CHESTER_SET][I],I,
              OBL,OTBL,TPND,TPLCT,TPST,CBL,CTBL,CBLOC,HOLE,BEST_SO_FAR);
        IF (HOLE <> 0) THEN BEGIN

          FROM_ND     := PLAYERS[CHESTER_SET][I];
          TO_ND       := HOLE;
          LOC         := I;

        END;
        I := I + 1;

    END;
    I := 1;
    WHILE (TO_ND = 0 )AND(I < 11) DO BEGIN

      HOLE := 0;
      MINIMAX(2,TRUE, PLAYERS[CHESTER_SET][I],I,
              OBL,OTBL,TPND,TPLCT,TPST,CBL,CTBL,CBLOC,HOLE,BEST_SO_FAR);
      IF (HOLE <> 0) THEN BEGIN

        FROM_ND     := PLAYERS[CHESTER_SET][I];
        TO_ND       := HOLE;
        LOC         := I;

      END;
      I := I + 1;

    END;

  END;  (* PLAN_A_MOVE *)


  PROCEDURE SORT;
  (* Sorts chester's marbles in order of position to break ties of   *)
  (* moves by giving preference to the one furthest back.            *)
  TYPE

    LINE = SET OF BYTE;

  VAR

    LINES   :ARRAY[1..9] OF LINE;
    HOME    :LINE;
    I,J     :BYTE;
    L,Q,P,K :BYTE;
    TEMP    :BYTE;
    PASS    :BYTE;
    IX      :ARRAY[1..9] OF BYTE;

  BEGIN

    PASS := 1;
    HOME := [FIXED_LOC[CHESTER_SET][1]..FIXED_LOC[CHESTER_SET][10] ];
    IF CHESTER_SET IN [1,2,6] THEN FOR I:= 1 TO 9 DO IX[I] := I
    ELSE                           FOR I:= 1 TO 9 DO IX[I] := 10 - I;
    CASE CHESTER_SET OF
      1,4:BEGIN


          LINES[IX[1]] := [1,2,3,4,5];
          LINES[IX[2]] := [6,7,8,9,10,11];
          LINES[IX[3]] := [12,13,14,15,16,17,18];
          LINES[IX[4]] := [19,20,21,22,23,24,25,26];
          LINES[IX[5]] := [27,28,29,30,31,32,33,34,35];
          LINES[IX[6]] := [36,37,38,39,40,41,42,43];
          LINES[IX[7]] := [44,45,46,47,48,49,50];
          LINES[IX[8]] := [51,52,53,54,55,56];
          LINES[IX[9]] := [57,58,59,60,61];

        END;
      2,5:BEGIN

          LINES[IX[1]] := [5,11,18,26,35];
          LINES[IX[2]] := [4,10,17,25,34,43];
          LINES[IX[3]] := [3,9,16,24,33,42,50];
          LINES[IX[4]] := [2,8,15,23,32,41,49,56];
          LINES[IX[5]] := [1,7,14,22,31,40,48,55,61];
          LINES[IX[6]] := [6,13,21,30,39,47,54,60];
          LINES[IX[7]] := [12,20,29,38,46,53,59];
          LINES[IX[8]] := [19,28,37,45,52,58];
          LINES[IX[9]] := [27,36,44,51,57];

        END;
      3,6:BEGIN

          LINES[IX[1]] := [1,6,12,19,27];
          LINES[IX[2]] := [2,7,13,20,28,36];
          LINES[IX[3]] := [3,8,14,21,29,37,44];
          LINES[IX[4]] := [4,9,15,22,30,38,45,51];
          LINES[IX[5]] := [5,10,16,23,31,39,46,52,57];
          LINES[IX[6]] := [11,17,24,32,40,47,53,58];
          LINES[IX[7]] := [18,25,33,41,48,54,59];
          LINES[IX[8]] := [26,34,42,49,55,60];
          LINES[IX[9]] := [35,43,50,56,61];

        END;

    END;

    WHILE PASS < 3 DO BEGIN

      PLAYERS[CHESTER_SET][0] := 0;
      FOR J:=2 TO 10 DO BEGIN

        I    := J - 1;
        TEMP := PLAYERS[CHESTER_SET][J];
        CASE PASS OF

          1:WHILE TEMP < PLAYERS[CHESTER_SET][I] DO BEGIN

              PLAYERS[CHESTER_SET][I + 1] := PLAYERS[CHESTER_SET][I];
              I := I -1;

            END;
          2:WHILE (TEMP IN HOME)AND(NOT (PLAYERS[CHESTER_SET][I] IN HOME))
            AND(I > 0)
            DO BEGIN

              PLAYERS[CHESTER_SET][I + 1] := PLAYERS[CHESTER_SET][I];
              I := I -1;

            END;
        END;
        PLAYERS[CHESTER_SET][I + 1] := TEMP;

      END;

      IF PASS = 1 THEN BEGIN

        L := 1;
        Q := 1;
        WHILE L < 10 DO BEGIN

          K := Q;
          WHILE K < 11 DO BEGIN

            P := K;
            WHILE (NOT (PLAYERS[CHESTER_SET][P] IN LINES[L]))AND(P < 11)
            DO P := P + 1;
            IF P < 11 THEN BEGIN

              TEMP                    := PLAYERS[CHESTER_SET][Q];
              PLAYERS[CHESTER_SET][Q] := PLAYERS[CHESTER_SET][P];
              PLAYERS[CHESTER_SET][P] := TEMP;
              Q := Q + 1;
              K := K + 1;

            END
            ELSE K := 11;

          END;
          L := L + 1;

        END;

      END;
      PASS := PASS + 1;

    END;

  END; (* SORT *)


  OVERLAY PROCEDURE INIT_DATA;
  VAR

    I :BYTE;

  BEGIN

    FOR I:= 1 TO 6 DO  END_MOVES[I].FINNISH := FALSE;
    AT_THE_END    := FALSE;
    FIRST_LINE[1] := [1 ,2 ,3 ,4 ,5 ];
    FIRST_LINE[2] := [5 ,11,18,26,35];
    FIRST_LINE[3] := [35,43,50,56,61];
    FIRST_LINE[4] := [61,60,59,58,57];
    FIRST_LINE[5] := [57,51,44,36,27];
    FIRST_LINE[6] := [27,19,12,6 ,1 ];

    FOR I := 1   TO 6 DO BEGIN

      BEFORE[I].C := 0;
      BEFORE[I].O := 0;

    END;

    FRONT[1][1] := 5;FRONT[1][2]  := 4;
    FRONT[1][3] := 3;FRONT[1][4]  := 2;FRONT[1][5] := 1;
    FRONT[2][1] := 35;FRONT[2][2] := 26;
    FRONT[2][3] := 18;FRONT[2][4] := 11;FRONT[2][5] := 5;
    FRONT[3][1] := 61;FRONT[3][2] := 56;
    FRONT[3][3] := 50;FRONT[3][4] := 43;FRONT[3][5] := 35;
    FRONT[4][1] := 57;FRONT[4][2] := 58;
    FRONT[4][3] := 59;FRONT[4][4] := 60;FRONT[4][5] := 61;
    FRONT[5][1] := 27;FRONT[5][2] := 36;
    FRONT[5][3] := 44;FRONT[5][4] := 51;FRONT[5][5] := 57;
    FRONT[6][1] := 1;FRONT[6][2]  := 6;
    FRONT[6][3] := 12;FRONT[6][4] := 19;FRONT[6][5] := 27;

    MOVED_YET := TRUE;

  END; (* OVERLAY INIT_DATA *)


  OVERLAY PROCEDURE START;
  BEGIN

    STARTER := RANDOM(3);
    CASE STARTER OF
      0:CASE RANDOM(NUM_SETS+1)  OF
       0,1:BEGIN
             FROM_NODE := 68;
             TO_NODE   := 2;
             LOC       := 7;
             ST        := 1;
           END;
         2:BEGIN
             FROM_NODE := 78;
             TO_NODE   := 11;
             LOC       := 7;
             ST        := 2;
           END;
         3:BEGIN
             FROM_NODE := 118;
             TO_NODE   := 19;
             LOC       := 7;
             ST        := 6;
           END;
        END;
      1:CASE RANDOM(NUM_SETS + 1)  OF
         0,1:BEGIN
             FROM_NODE := 71;
             TO_NODE   := 4;
             LOC       := 10;
             ST        := 1;
           END;
         2:BEGIN
             FROM_NODE := 81;
             TO_NODE   := 26;
             LOC       := 10;
             ST        := 2;
           END;
         3:BEGIN
             FROM_NODE := 121;
             TO_NODE   := 6;
             LOC       := 10;
             ST        := 6;
           END;
        END;
    END;

  END; (* OVERLAY START *)



  OVERLAY PROCEDURE ENDING;
  (* Contains the knowledge to take care of ending moves occuring   *)
  (* along the front row when nothing else is possible.             *)
  (* Prevents chester from getting hung up in a back and forth loop *)
  VAR

    STE,
    K   :BYTE;
    IS  :BOOLEAN;

  BEGIN

    STE := 0;
    IS  := FALSE;
    FOR K:= 1 TO 6 DO

      IF (FROM_NODE IN FIRST_LINE[K])AND(TO_NODE IN FIRST_LINE[K])
      AND(ST = (K + 3) MOD 6)
      THEN BEGIN

        STE := K;
        IS  := TRUE;

      END;

    IF IS THEN BEGIN

      IF FROM_NODE = FRONT[STE][1] THEN BEGIN

          IF (BOARD[FIXED_LOC[OPPONENT_SET][8 ]].COLOR = 7)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][6 ]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][10]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][9 ]].COLOR = CHESTER_SET)
          THEN BEGIN

            FROM_NODE := FIXED_LOC[OPPONENT_SET][10];
            TO_NODE   := FIXED_LOC[OPPONENT_SET][8 ];

          END;

      END
      ELSE IF FROM_NODE = FRONT[STE][2] THEN BEGIN

          IF (BOARD[FIXED_LOC[OPPONENT_SET][10]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][5 ]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][9 ]].COLOR = CHESTER_SET)
          THEN BEGIN

            IF (BOARD[FIXED_LOC[OPPONENT_SET][8]].COLOR = 7)  THEN BEGIN

              FROM_NODE := FIXED_LOC[OPPONENT_SET][10];
              TO_NODE   := FIXED_LOC[OPPONENT_SET][8];

            END
            ELSE
            IF (BOARD[FIXED_LOC[OPPONENT_SET][7]].COLOR = 7) THEN BEGIN

              FROM_NODE := FIXED_LOC[OPPONENT_SET][9];
              TO_NODE   := FIXED_LOC[OPPONENT_SET][7];

            END

          END
          ELSE IF (BOARD[FRONT[STE][3]].COLOR = 7)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][10]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][9 ]].COLOR = CHESTER_SET)
          THEN TO_NODE := FRONT[STE][3];

      END
      ELSE IF FROM_NODE = FRONT[STE][3] THEN BEGIN

          IF (BOARD[FIXED_LOC[OPPONENT_SET][7]].COLOR  = 7)
          AND(BOARD[FRONT[STE][4]].COLOR = 7)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][9]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][8]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][4]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][6]].COLOR = CHESTER_SET)
          THEN TO_NODE := FRONT[STE][4]
          ELSE IF (BOARD[FRONT[STE][2]].COLOR = 7)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][9]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][8]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][4]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][6]].COLOR = CHESTER_SET)
          THEN TO_NODE := FRONT[STE][2];

      END
      ELSE IF FROM_NODE = FRONT[STE][4] THEN BEGIN

          IF (BOARD[FIXED_LOC[OPPONENT_SET][8 ]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][7 ]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][5 ]].COLOR = CHESTER_SET)
          THEN BEGIN

            IF (BOARD[FIXED_LOC[OPPONENT_SET][9 ]].COLOR = CHESTER_SET)
            AND(BOARD[FIXED_LOC[OPPONENT_SET][10]].COLOR = 7)  THEN BEGIN

              FROM_NODE := FIXED_LOC[OPPONENT_SET][8];
              TO_NODE   := FIXED_LOC[OPPONENT_SET][10];

            END
            ELSE IF (BOARD[FIXED_LOC[OPPONENT_SET][9]].COLOR = 7) THEN BEGIN

              FROM_NODE := FIXED_LOC[OPPONENT_SET][7];
              TO_NODE   := FIXED_LOC[OPPONENT_SET][9];

            END;

          END
          ELSE IF (BOARD[FRONT[STE][3]].COLOR = 7)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][7]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][8]].COLOR = CHESTER_SET)
          THEN TO_NODE := FRONT[STE][3];

      END
      ELSE IF FROM_NODE = FRONT[STE][5] THEN BEGIN

          IF (BOARD[FIXED_LOC[OPPONENT_SET][7]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][8]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][4]].COLOR = CHESTER_SET)
          AND(BOARD[FIXED_LOC[OPPONENT_SET][9]].COLOR = 7)  THEN BEGIN

            FROM_NODE := FIXED_LOC[OPPONENT_SET][7];
            TO_NODE   := FIXED_LOC[OPPONENT_SET][9];

          END;

      END;
      LOC := 1;
      WHILE PLAYERS[ST][LOC] <> FROM_NODE DO LOC := LOC + 1;

    END;

  END; (* OVERLAY ENDING *)


  PROCEDURE MAXIMUM;  (* Determines which set has the best move *)
                      (* Meaningful when playing with more than *)
                      (* one set.                               *)
  VAR

    J,I,F:BYTE;

  BEGIN

    LONGEST := 100;
    FOR I:=1 TO NUM_SETS DO
      IF MOV[I].LN >= LONGEST THEN BEGIN

        FROM_NODE:= MOV[I].FROM;
        TO_NODE  := MOV[I].T;
        LOC      := MOV[I].LC;
        ST       := PLAY_SETS[I].CT;
        LONGEST  := MOV[I].LN;

      END;

  END; (* MAXIMUM *)


  PROCEDURE IS_IT_FINNISHING;
  (* Determines when the opponent doesn't interferes any more *)
  VAR
    K :BYTE;
  BEGIN

    FINNISHING := TRUE;
    K          := 1;
    WHILE (K < 11) AND FINNISHING DO BEGIN

     IF
     (BOARD[PLAYERS[CHESTER_SET ][K]].DIST[CHESTER_SET ] > DEG_DIFFICULTY + 1)
     OR (BOARD[PLAYERS[OPPONENT_SET][K]].DIST[OPPONENT_SET] > 11)
     THEN FINNISHING :=  FALSE;
     K := K + 1;

    END;

  END; (* IS_IT_FINNISHING *)


  PROCEDURE PLAN_ENDING(PLAY_ST:BYTE);
  VAR

    FAKED_MOVES  :ARRAY[0..50] OF FAKE_NODES;
    FMSP         :BYTE;
    I,J          :BYTE;
    NODE,M       :BYTE;
    FND,TND,LC,LNST,
    DDEST        :BYTE;
    SHORTEST_M   :BYTE;
    EM           :ENDING_MOVES;
    TEMP_PLAYERS :ARRAY[1..10] OF BYTE;
    ch:char;

    PROCEDURE INIT_FAKED_MOVES;
    BEGIN

      FMSP                  := 0;
      FAKED_MOVES[0].FROM_N := 0;
      FAKED_MOVES[0].TO_N   := 0;
      FAKED_MOVES[0].LCT    := 0;
      FAKED_MOVES[0].S      := 0;

    END; (* INIT_FAKED_MOVES *)


    PROCEDURE PUSH_FM(F,T,L,S:BYTE);
    BEGIN

      IF FMSP <= 49 THEN BEGIN

        FMSP                     := FMSP + 1;
        FAKED_MOVES[FMSP].FROM_N := F;
        FAKED_MOVES[FMSP].TO_N   := T;
        FAKED_MOVES[FMSP].LCT    := L;
        FAKED_MOVES[FMSP].S      := S;

      END;

    END; (* PUSH_FM *)

    PROCEDURE POP_FM(VAR F,T,L,S:BYTE);
    BEGIN

      F := FAKED_MOVES[FMSP].FROM_N;
      T := FAKED_MOVES[FMSP].TO_N;
      L := FAKED_MOVES[FMSP].LCT;
      S := FAKED_MOVES[FMSP].S;
      IF FMSP > 0 THEN FMSP := FMSP - 1;

    END; (* POP_FM *)


    PROCEDURE FAKE_MOVE( S,T,LC:BYTE);
    BEGIN

      PUSH_FM(PLAYERS[S][LC],T,LC,S);
      BOARD[PLAYERS[S][LC]].COLOR := 7;
      PLAYERS[S][LC]              := T;
      BOARD[T].COLOR              := S;

    END; (* FAKED_MOVE *)


    PROCEDURE RESTORE_MOVE;
    VAR

      F,T,L,S:BYTE;

    BEGIN

      POP_FM(F,T,L,S);
      PLAYERS[S][L]             := F;
      BOARD[T].COLOR            := 7;
      BOARD[F].COLOR            := S;

    END; (* RESTORE_MOVE *)


  BEGIN  (* PLAN_ENDING *)

    MESSAGE(31);
    SHORTEST_M := 15;
    ST         := CHESTER_SET;
    MOVE(PLAYERS[PLAY_ST][1],TEMP_PLAYERS[1],10);
    FOR I:= 1 TO 10 DO BEGIN

      MOVE(TEMP_PLAYERS[1],PLAYERS[PLAY_ST][1],10);
      PLAN_END := TRUE;
      INIT2_LAND_NODES;
      LANDING_NODES(2,FALSE,0,PLAYERS[CHESTER_SET][I],TND);
      SEARCH_BOARD(TRUE,TRUE,CHESTER_SET,PLAYERS[CHESTER_SET][I],I,1,
                   FND,TND,LC,LNST,DDEST);
      PLAN_END := FALSE;
      REPEAT

        POP_LN2(TO_NODE);

      UNTIL TO_NODE IN [0..61,
                     FIXED_LOC[CHESTER_SET][1]..FIXED_LOC[CHESTER_SET][10],
                     FIXED_LOC[OPPONENT_SET][1]..FIXED_LOC[OPPONENT_SET][10]];

      WHILE TO_NODE <> 0 DO BEGIN

        MOVE(TEMP_PLAYERS[1],PLAYERS[PLAY_ST][1],10);
        FROM_NODE := PLAYERS[CHESTER_SET][I];
        INIT_FAKED_MOVES;
        M   := 0;
        LOC := I;
        REPEAT

          FAKE_MOVE(CHESTER_SET, TO_NODE,LOC);
          M := M + 1;
          EM.MOVES_LEFT[M].FN    := FROM_NODE;
          EM.MOVES_LEFT[M].TN    := TO_NODE;
          EM.MOVES_LEFT[M].LOCON := LOC;
          SORT;
          PLAN_A_MOVE(FROM_NODE,TO_NODE,LOC,LNST);
          IF TO_NODE <> 0 THEN ENDING;

        UNTIL (TO_NODE = 0) OR (M = SHORTEST_M);

        FOR J := 1 TO M DO RESTORE_MOVE;

        IF M < SHORTEST_M THEN WITH END_MOVES[PLAY_ST] DO BEGIN

          MOVE(EM.MOVES_LEFT[1].FN,MOVES_LEFT[1].FN, M * 3);
          FINNISH    := TRUE;
          NUM_LEFT   := M;
          MOVES_DONE := 0;
          SHORTEST_M := M;

        END;
        REPEAT

          POP_LN2(TO_NODE);

        UNTIL TO_NODE IN [0..61,
                     FIXED_LOC[CHESTER_SET][1]..FIXED_LOC[CHESTER_SET][10],
                     FIXED_LOC[OPPONENT_SET][1]..FIXED_LOC[OPPONENT_SET][10]];

      END; (* while to_nd <> 0 *)

    END; (* for i 1 to 10 *)
    MOVE(TEMP_PLAYERS[1],PLAYERS[PLAY_ST][1],10);

  END; (* PLAN_ENDING *)


  PROCEDURE GET_ENDING_MOVE(PLAY_ST:BYTE);
  VAR

    WAIT_FOR_OTHER_SETS :BOOLEAN;
    J                   :BYTE;

  BEGIN

    WAIT_FOR_OTHER_SETS := FALSE;
    FOR J := 1 TO NUM_SETS DO
      WAIT_FOR_OTHER_SETS :=  NOT END_MOVES[PLAY_SETS[J].CT].FINNISH;

    WITH  END_MOVES[PLAY_ST] DO BEGIN

      IF (NOT WAIT_FOR_OTHER_SETS) AND (MOVES_DONE < NUM_LEFT) THEN BEGIN

        MOVES_DONE := MOVES_DONE + 1;
        WITH MOVES_LEFT[MOVES_DONE] DO BEGIN

          ST         := PLAY_ST;
          FROM_NODE  := FN;
          TO_NODE    := TN;
          LONGEST    := 255;
          AT_THE_END := TRUE;
          LOC        := 1;
          WHILE PLAYERS[ST][LOC] <> FROM_NODE DO LOC := LOC + 1;

        END;

      END
      ELSE TO_NODE := 0;

    END;

  END; (* GET_ENDING_MOVE *)


BEGIN  (* THINK *)

  IF ( NUM_MOVES = 0) OR (( NUM_MOVES = 1 ) AND ( NOT ME_FIRST ))
  OR ((PLAY_MODE = REASSUME) AND ( NOT MOVED_YET))
  THEN INIT_DATA;
  TO_NODE    := 0;
  PLAN_END   := FALSE;
  AT_THE_END := FALSE;
  IF ( PLAY_SETS[1].CT IN [1,6] ) AND (NUM_SETS IN [1,3]) AND
    (( NUM_MOVES = 0) OR (( NUM_MOVES = 1 ) AND ( NOT ME_FIRST )))
  THEN START;

  IF TO_NODE = 0 THEN BEGIN

    I := 1;
    WHILE (I <= NUM_SETS) AND (NOT AT_THE_END) DO BEGIN

      FINNISHING    := FALSE;
      CHESTER_SET   := PLAY_SETS[I].CT;
      OPPONENT_SET  := PLAY_SETS[I].OP;
      IF NOT END_MOVES[CHESTER_SET].FINNISH AND (NUM_MOVES > 50) THEN BEGIN

        SORT;
        IS_IT_FINNISHING;
        IF FINNISHING THEN PLAN_ENDING(CHESTER_SET);

      END
      ELSE IF NUM_MOVES <= 50 THEN SORT;
      IF NOT END_MOVES[CHESTER_SET].FINNISH
      THEN PLAN_A_MOVE(FROM_NODE,TO_NODE,LOC,LONGEST)
      ELSE GET_ENDING_MOVE(CHESTER_SET);

      IF TO_NODE = 0 THEN LONGEST := 0;
      MOV[I].FROM   := FROM_NODE;
      MOV[I].T      := TO_NODE;
      MOV[I].LN     := LONGEST;
      MOV[I].LC     := LOC;
      I             := I + 1;

    END;
    IF NOT AT_THE_END THEN BEGIN

      MAXIMUM;
      IF NUM_MOVES > 50 THEN ENDING;

    END;

  END;

END; (* THINK *)


{$I FRONTEND.PAS}


BEGIN { Main program }

  REPEAT

    RESTART := FALSE;
    INIT;
    IF NOT TERMINATE THEN CHOICES;
    IF NOT TERMINATE AND NOT RESTART THEN BEGIN

      DRAWBOARD;
      MESSAGE(9);
      IF NUM_PLAYERS > 0 THEN HUMANS_PLAYLOOP
      ELSE PLAYLOOP;

    END;

  UNTIL NOT RESTART;
  MODE_AND_COLOR(2);

END. { Main program }




