{
   Ŀ
   Ĵ
   Ĵ          GO-HELP.PAS Include-Modul.           Ĵ
   Ĵ         Letzte Aenderung:  24/11/85           Ĵ
   Ĵ
   

 Hinweis: Zur Verwendung dieses Systems in anderen Programmen,
          aendern Sie diese Datei Ihren Wuenschen gemaess, bin-
          den Sie sie in Ihr Hauptprogramm ein und fuegen Sie
          alle die in GO-MOKU.PAS mit ... Hilfsystem ... ge-
          kennzeichneten Anweisungen in Ihr Programm ein.
}

procedure Help;
const
  MaxLines = 50;           { Max. Anzahl Zeilen im Bildschirmfenster }
  FirstCol = 50;
  FirstRow =  8;
  LastCol  = 75;
  LastRow  = 21;
  HelpFileName : string[20] = 'GO-MOKU.HLP';

type
  RowType     = string[25];
  ScreenArray = array[1..MaxLines] of RowType; { speichert Hilfstext }

var
  HelpFile : Text;                              { die Hilfstextdatei }
  HelpText : ScreenArray;                { Storage for the Hilfstext }
  LastLineRead : integer;       { Nummer der letzten gelesenen Zeile }
  BorderTop, BorderBottom,                          { Fensterraender }
  BorderLeft, BorderRight : byte;

procedure DrawBorder;
{ zeichnet Rand um Fenster }
const
  VerticalBorder = #186; HorizontalBorder = #205;
  UpLeft         = #201; UpRight          = #187;
  DownLeft       = #200; DownRight        = #188;
var
  Row, Col : integer;
begin
  BorderTop := 1;  BorderBottom := 16;
  BorderLeft := 1; BorderRight := 29;
  ClrScr;
  TextColor(NormalColor - 8);
  GotoXY(BorderLeft, BorderTop);
  Write(UpLeft);
  for Col := BorderLeft + 1 to BorderRight - 22 do
    Write(HorizontalBorder);
  TextColor(NormalColor);
  Write(' GOMOKU INFO ');
  TextColor(NormalColor - 8);
  for Col := BorderLeft + 20 to BorderRight - 1 do
    Write(HorizontalBorder);
  Write(UpRight);
  for Row := BorderTop + 1 to BorderBottom - 1 do
  begin
    GotoXY(BorderLeft, Row);
    Write(VerticalBorder);
    GotoXY(BorderRight, Row);
    Write(VerticalBorder);
  end;
  GotoXY(BorderLeft, BorderBottom);
  Write(DownLeft);
  for Col := BorderLeft + 1 to BorderRight - 1 do
    Write(HorizontalBorder);
  Write(DownRight);
end; { DrawBorder }

procedure DrawHelpLine;
{ zeichnet Kommandozeile unter Fenster }
begin
  GotoXY(BorderLeft + 1, BorderBottom + 1);
  WriteHelp(#24 + #196, 1);
  WriteHelp(#25 + #196 + 'Zeilen ', 1);
  WriteHelp('PgUp' + #196, 4);
  WriteHelp('PgDn' + #196 + 'Seiten', 4);
end; { DrawHelpLine }

function ReadHelpFile : boolean;
{ liest Hilfstext ein; liefert true, wenn dies gelingt }
var
  Ch : char;

procedure LoadArray;
{ speichert den Hilfstext in einem Feld }
begin
  GotoXY(1, 2);
  ClrEOL;
  WriteLn(' Lesen der Datei . . .');
  Delay(1000);
  FillChar(HelpText, SizeOf(HelpText), #0); { Initialisiert Feld }
  LastLineRead := 0;
  while not EOF(HelpFile) and (LastLineRead < MaxLines) do
  begin
    LastLineRead := LastLineRead + 1;
    ReadLn(HelpFile, HelpText[LastLineRead]);
  end;
  if not EOF(HelpFile) then
  begin
    WriteLn;
    WriteLn;
    WriteLn(' Fehler, dieses Programm');
    WriteLn('liest nur ', MaxLines, ' Zeilen!');
  end;
end; { LoadArray }

begin { ReadHelpFile }
  Window(FirstCol, FirstRow, LastCol, LastRow);
  GotoXY(1, 1);
  ClrScr;
  GotoXY(1, 1);
  WriteLn;
  Write(HelpFileName,' wird gesucht');
  Delay(1000);
  Assign(HelpFile, HelpFileName);
  {$I-}
  Reset(HelpFile);
  {$I+}
  if IOresult <> 0 then
  begin
    GotoXY(1, 2);
    ClrEOL;
    WriteLn(HelpFileName, ' nicht gefunden.');
    Write('Druecken Sie <ESC> ');
    Read(KBD, Ch);
    ReadHelpFile := false;
  end
  else
  begin
    LoadArray;
    if LastLineRead < 1 then
    begin
      ClrScr;
      GotoXY(1, 2);
      ClrEOL;
      WriteLn('Die Info-Datei ist leer!');
      Write('Druecken Sie <ESC> ');
      Read(KBD, Ch);
      ReadHelpFile := false;
    end
    else
    begin
      ReadHelpFile := true;
      FileRead := true;
    end;
  end;
end; { ReadHelpFile }

procedure Displayfile;
{ schreibt den Hilfstext in das Fenster }
const
  PgDn   = #81;
  PgUp   = #73;
  ScrlDn = #80;
  ScrlUp = #72;
  Esc    = #27;
var
  TopLine, BottomLine, MaxRows   : integer;
  PgCommand                      : char;

procedure DisplayPage(TopLine, BottomLine : integer);
{ schreibt genau 1 Seite Text in das Fenster }
var
  Row : integer;
begin
  ClrScr;
  for Row := TopLine to BottomLine do
  begin
    if Row <> BottomLine then
      WriteLn(HelpText[row])
    else
      Write(HelpText[row]);
  end;
  GotoXY(1, LastRow);
end; { DisplayPage }

procedure PageDown(var TopLine, BottomLine : integer);
{ blaettert 1 Seite weiter im Fenster }
begin
  if BottomLine + 1 <= LastLineRead then
  begin
    if (BottomLine + MaxRows) > LastLineRead then
      BottomLine := LastLineRead
    else
      BottomLine := BottomLine + MaxRows;
    if (BottomLine - MaxRows + 1) >= 1 then
      TopLine := (BottomLine - MaxRows + 1)
    else
      TopLine := 1;
    DisplayPage(TopLine, BottomLine);
  end;
end; { PageDown }

procedure PageUp(var TopLine, BottomLine : integer);
{ blaettert 1 Seite zurueck im Fenster }
begin
  if TopLine > 1 then
  begin
    if (TopLine - MaxRows) > 1 then                 { Setze Kopfzeile }
      TopLine := TopLine - MaxRows
    else
      TopLine := 1;
    if (TopLine + MaxRows - 1) > LastLineRead then  { Setze Fusszeile }
      BottomLine := LastLineRead
    else
      BottomLine := TopLine + MaxRows - 1;
    DisplayPage(TopLine, BottomLine);
  end;
end; { PageUp }

procedure ScrollUp(var TopLine, BottomLine : integer);
{ blaettert 1 Zeile zurueck im Fenster }
begin
  if TopLine > 1 then
  begin
    if (BottomLine - TopLine + 1) >= MaxRows then { Bildschirm war voll }
      BottomLine := BottomLine - 1;
    TopLine := TopLine - 1;
    GotoXY(1, MaxRows);
    DelLine;
    GotoXY(1, 1);
    InsLine;
    Write(HelpText[TopLine]);
    GotoXY(1, MaxRows);
  end;
end; { ScrollUp }

procedure ScrollDown(var TopLine, BottomLine : integer);
{ blaettert 1 Zeile weiter im Fenster }
begin
  if BottomLine < LastLineRead then
  begin
    TopLine := TopLine + 1;
    BottomLine := BottomLine + 1;
    GotoXY(1, 1);
    DelLine;
    GotoXY(1, MaxRows);
    InsLine;
    Write(HelpText[BottomLine]);
    GotoXY(1, MaxRows);
  end;
end; { ScrollDown }

procedure Init;
{ Initialisierungsprozedur }
begin
  MaxRows := LastRow - FirstRow + 1;
  TopLine := 1;
  if MaxRows > LastLineRead then
    BottomLine := LastLineRead
  else
    BottomLine := MaxRows;
  DisplayPage(TopLine, BottomLine);  { Show first page }
end; { Init }

begin { Displayfile }
  Init;
  repeat
    Read(KBD, PgCommand);
    PgCommand := UpCase(PgCommand);
    if (PgCommand = CtrlC) or (PgCommand = 'E') then
      Abort;
    if (PgCommand = Esc) and KeyPressed then
    begin
      Read(KBD, PgCommand);
      PgCommand := UpCase(PgCommand);
      case PgCommand of
        PgDn   : PageDown(TopLine, BottomLine);
        PgUp   : PageUp(TopLine, BottomLine);
        ScrlDn : ScrollDown(TopLine, BottomLine);
        ScrlUp : ScrollUp(TopLine, BottomLine);
      end;
    end;
  until (PgCommand = Esc) and (not KeyPressed);
end; { Displayfile }

begin { Help }
  GotoXY(49, 5);                     { zeige Hilfskommandos }
  Write('<');
  WriteHelp('ESC> = Ende         ', 3);
  Window(FirstCol - 2, FirstRow - 1, LastCol + 1, LastRow + 2);
  GotoXY(1, 1);
  DrawBorder;
  DrawHelpLine;
  if FileRead then
  begin
    Window(FirstCol, FirstRow, LastCol, LastRow);
    GotoXY(1, 1);
    Displayfile;
  end
  else
  if ReadHelpFile then
    Displayfile;
  Window(FirstCol - 2, FirstRow - 1,           { schliesse Fenster }
         LastCol + 1, LastRow + 2);
  GotoXY(1, 1);
  ClrScr;
  Window(1, 1, 80, 25);                   { Restauriere Bildschirm }
  GotoXY(1, 1);
  GotoXY(49, 5);
  WriteHelp('?-fuer Info    ', 1);             { Restauriere Menue }
end; { Help }

{ ===================== Ende des Hilfsmoduls ===================== }
