                         Arena Programmer's Hint Sheet
                         =============================
 
Opcodes used in Arena Programming
 
Opcode    Parameters                 Notes
------------------------------------------------------------------------------
MOV      <dir>                 Move in direction <dir>
RTS                            Return from a subroutine
NOP                            No OPeration.  Does nothing.
END                            End of the program; Restart from beginning.
SET      :<reg>  <val>         Sets a register <reg> to be equal to a
                               value <val>.
CMP       <val1>  <val1>       Compares value <val1> to <val2>, placing
                               the result in :C (:C= <val1>-<val2>).
ADD       :<reg>  <val>        Adds <val> to register <reg>.
SUB       :<reg>  <val>        Subtracts <val> to register <reg>.
MUL       :<reg>  <val>        Multiplies <val> to register <reg>.
DIV       :<reg>  <val>        Divides <val> to register <reg>.
JMP       <addr>               Moves program execution to line <addr>.
JLT       <addr>               If :C < 0 then JMP <addr>.
JGT       <addr>               If :C > 0 then JMP <addr>.
JEQ       <addr>               If :C = 0 then JMP <addr>.
JSR       <addr>               Goto the subroutine at address <addr>.
GUN       <dir>                Fire the cannons in direction <dir>.
DJZ       <val> <addr>         Jump to address <addr> <val> times.
RAD       <dir> <range>        Do a radar scan in direction <dir> to a
                               range of <range>.  Place the results in
                               the :S and :R registers.
MSG     <str>                  Beep and flash the string <str> to the
                               Controllers.
Notes:
 
<dir> = a legal direction value, between 0 and 7.  Greater numbers
        are reduced to fit into this range.
 
:<reg> = a CPU register, :A through :Z.
 
<val> to <valn> = a numeric value, from -128 to +127.
 
<range> = a numeric value between 1 and 30.
 
<addr>  = a numeric value representing a line of code.  Its range is
          between 1 and the maximum lines of code for the robot's
          brain size.  (Max = Brain * 8).
 
Registers:
 
Name         Notes
----------------------------------------------------------
:A   Accumulator Register. (not used in 2.1)
:B   Accumulator Register. (not used in 2.1)
:C   Condition code register.  Holds the results of CMP tests.
:D   Contains the direction of the last MOV command.
:F   Contains the direction of the last GUN command.
:G   Holds a random value between 0 and 7.
:H   The number of damage points taken.
:K   Holds the current number of executions for the DJZ command.
:L   Holds the actual number of executions needed.
:M   The maximum numbner of damage points possible.
:P   Program counter.
:R   Range of last object scanned.
:S   Type of last object scanned:
       0 = Nothing, 1 = Friendly -1 = enemy -2 = wall -3 = junk.
:T   The direction of the last RAD command.
:X   Current X position.
:Y   Current Y position.
 
This leaves: :E,:I,:J,:O,:Q,:U,:V,:W,:Z free.
 
 
Richard Brown
 
 
 
 
