Program USNAVY;

{This module will ask the player to select his navy.  Possible ships to
select from will be displayed.

Read theater and ship selection information
Do until last (20) axis ship moved
.   Move next ship to axis navy
End
Display axis ship information
Display allied ship selection information
Initialize navy data
Do until selections complete [END key]
.   Display assets available and ship count
.   Move cursor to selection
.   If ship already selected
.   .   Remove ship from allied navy
.   .   Decrement ship count by 1
.   .   Redisplay ship unhighlighted
.   .   Add cost back to assets
.   Else
.   .   Increment ship count by 1
.   .   If count > maximum allowed
.   .   .   Increment ship count and ignore selection
.   .   Else
.   .   .   Deduct cost from assets
.   .   .   If assets < 0
.   .   .   .   Add cost back to assets
.   .   .   .   Increment ship count by 1
.   .   .   Else
.   .   .   .   Move ship to allied navy
.   .   .   .   Redisplay ship highlighted
.   .   .   End
.   .   End
.   End
End

Display battle order of allied navies
Chain FLEETS Module}

{$I COMMON.PAS}
{$I BORDER.PAS}
{$I CURSOR.PAS}
{$I PUTPIC.PAS}

Type
    Tempship = record
               ID:string[10];
               Attack:integer;
               Defense:integer;
               Model:char;
               Theater:integer;
               Select:char;
               end;

Var
    Taken:array[1..20] of integer;
    Available:array[1..48] of tempship;
    ShipsAllow:integer;
    xcnt,acnt,t,u,v:integer;
    d:char;
    Points:integer;
    Temp_Type:string[10];

Procedure Ship_Stats(s:integer);
begin
with Available[s] do
begin
  Gotoxy(2,14);
  Temp_type:='          ';
  case model of
    'B': Temp_Type:='Battleship';
    'C': Temp_Type:='Crusier   ';
    'D': Temp_Type:='Destroyer ';
    'S': Temp_Type:='Submarine ';
    'V': Temp_Type:='Convoy    ';
    'A': Temp_Type:='Carrier   ';
    'K': Temp_Type:='Kamikazi  ';
    'M': Temp_Type:='Mtr.Ptl.Bt';
    'P': Temp_Type:='Planes    ';
  end;
  Gotoxy(2,14);
  FastWrite(Concat('Type-',Temp_Type),7,0,1);
  Gotoxy(20,14);
  LowVideo;
  Write('Attack-',Attack);
  Gotoxy(30,14);
  Write('Defense-',Defense);
end;
Gotoxy(41,14);
Fastwrite('Theater limitations-',7,0,1);
if available[s].theater=0 then
  Fastwrite('Unlimited       ',7,0,1)
else
  Write(Theater[available[s].theater].name,'        ');
end;

Begin
ClrScr;

Theacnt:=0;
Xcnt:=0;
Acnt:=0;
for i:=1 to 20 do                                {Clear old garbage}
  begin
     with axis_navy[i] do
       begin
         Id:='          ';
         Model:=' ';
         Theater:=0;
         Status:=9;
         Attack:=0;
         Defense:=0;
         Damage:=0;
         Fleet:=0;
         Work1:=0;
         Work2:=0;
       end;
    with allied_navy[i] do
       begin
         Id:='          ';
         Model:=' ';
         Theater:=0;
         Status:=9;
         Attack:=0;
         Defense:=0;
         Damage:=0;
         Fleet:=0;
         Work1:=0;
         Work2:=0;
       end;
  end;
Assign(Source,ConCat(Name,'.dat'));              {Open selected data file}
Reset(Source);
While not EOF(Source) do                         {Read data and put in proper}
begin                                            {locations}
  Readln(Source,Line);
  case copy(Line,1,1) of
       'T': begin
               Theacnt:=Theacnt+1;               {Incr theater count}
               with Theater[Theacnt] do          {Insert Theater information}
                  begin
                     Name:=copy(Line,9,15);
                     Val(copy(Line,25,2),x,j);
                     Val(copy(Line,28,2),y,j);
                     Val(copy(Line,31,2),max,j);
                  end;
            end;
       'M': PicName:=copy(Line,9,15)+'.map';
       'X': begin
               Xcnt:=Xcnt+1;
               If Xcnt<21 then
               with Axis_Navy[Xcnt] do            {Install Axis ships}
                  begin
                     Id:=copy(Line,9,10);
                     Model:=copy(Line,31,1);
                     Val(copy(Line,34,2),Theater,j);
                     Status:=0;
                     Val(copy(Line,25,2),Attack,j);
                     Val(copy(Line,28,2),Defense,j);
                     Damage:=0;
                     Fleet:=0;
                     Work1:=0;
                     Work2:=0;
                  end;
            end;
       'A': begin
             Acnt:=Acnt+1;
             If Acnt<48 then
             with Available[Acnt] do              {Install Allied ships}
                 begin
                   Id:=copy(Line,9,10);
                   Model:=copy(Line,31,1);
                   Val(copy(Line,34,2),Theater,j);
                   Val(copy(Line,25,2),Attack,j);
                   Val(copy(Line,28,2),Defense,j);
                end;
             end;
       'F': Val(copy(Line,9,3),Init_Factor,j);    {Install Initative factor}
       'P': Val(copy(Line,9,3),Points,j);         {Install points allowed}
       'S': Val(copy(Line,9,3),ShipsAllow,j);     {Install ships allowed}
       'V': Val(copy(Line,25,3),Victory_Points_to_win,j);
                                                  {Install points to win}
       'N':                                       {Install navy names}
            case copy(Line,5,1) of
              'X': Axis_Name:=copy(Line,9,10);
              'A': Allied_Name:=copy(Line,9,10);
            end;

  end;
end;
ClrScr;
Border(1,1,80,22,1,7,0);                          {Draw border}
Gotoxy(30,3);                                     {Display Combatants}
NormVideo;
Write(' ',Allied_Name,' vs ',Axis_Name,' ');
Gotoxy(22,6);
FastWrite('THEATER',7,0,1);
Gotoxy(42,6);
FastWrite('SHIPS ALLOWED',7,0,1);
For i:= 1 to theacnt  do
  begin
     With Theater[i] do
        begin
           Gotoxy(22,7+i);
           FastWrite(Name,7,0,1);
           Gotoxy(48,7+i);
           LowVideo;
           Write(max);
        end;
  end;
Gotoxy(28,20);
Fastwrite('PRESS ANY KEY TO CONTINUE',7,0,1);
uncursor;
read(kbd,c);
window(2,4,78,20);
Clrscr;
window(1,1,80,25);
Gotoxy(28,5);
FastWrite(ConCat('Ships available to ',Axis_Name),7,0,1);
Gotoxy(10,6);                                     {Display Axis ships}
FastWrite('Attack, Defense, * [Limited Theater Availability] are shown.',7,0,1);
j:=6;k:=7;
For i:= 1 to xcnt do
   Begin
      k:=k+1;
      if k=13 then
         begin
           k:=8;
           j:=j+18;
         end;
      Gotoxy(j,k);
      with Axis_Navy[i] do
         begin
           Write(Attack,Defense);
           if Theater>0 then
             FastWrite('*',7,0,1);
           Gotoxy(j+3,k);
           FastWrite(Id,7,0,1);
         end;
   end;
Gotoxy(28,21);
Fastwrite('Press Return to continue ',7,0,1);
Uncursor;
Read(kbd,c);
Gotoxy(10,23);
Fastwrite('Use cursor keys to make selection. ENTER selects or removes.',
        7,0,1);
Gotoxy(13,24);
FastWrite('END completes selection process. Q or q terminates game.',7,0,1);
Gotoxy(47,5);
Fastwrite(ConCat(Allied_Name,'      '),7,0,1);
Window(4,6,78,21);
Clrscr;
For i:=1 to acnt do                              {Clear select marks}
  with Available[i] do
    Select:='n';
j:=2;k:=2;
For i:= 1 to acnt do                              {Display avail. Allied ships}
   Begin
      k:=k+1;
      if k>12 then
         begin
           k:=3;
           j:=j+18;
         end;
      Gotoxy(j,k);
      with Available[i] do
         begin
            Write(' ',Defense,' ');
            FastWrite(Id,7,0,1);
         end;
   end;
                                                 {Display current stats}
Ship_Stats(1);
j:=1;k:=3;
Ships:=0;
Gotoxy(4,16);
FastWrite('Ship selections remaining -             Points remaining -',7,0,1);
Repeat                                           {Move cursor and select ships}
  Gotoxy(33,16);                                 {until END pressed}
  Write(ShipsAllow-Ships,' ');
  Gotoxy(63,16);
  Write(Points,' ');
  Gotoxy(j,k);
  Fastwrite(chr(26),15,0,3);
  uncursor;
  l:=cursor;
  Gotoxy(j,k);
  Fastwrite(' ',7,0,3);
  case l of                                       {adjust cursor location}
     1 : j:=j-18;
     2 : j:=j+18;
     3 : k:=k-1;
     4 : k:=k+1;
  end;                                           {adjust cursor to wrap if}
  if j<0 then j:=55;                             {invalid request}
  if k<3 then k:=12;
  if j>72 then j:=1;
  if k>12 then k:=3;
  v:=(((j-1) div 18)*10)+k-2;
  if v>acnt then
    begin
      m:=(acnt mod 10)+2;
      n:=0;
      if k>m then n:=-1;
      if l=2 then j:=1;
      if l=4 then k:=3;
      if l=3 then k:=m;
      if l=1 then j:=(((acnt div 10)+n)*18)+1;
      v:=(((j-1) div 18)*10)+k-2;
    end;
  Ship_Stats(v);
  if l=13 then
    begin
      with Available[v] do
        begin
          if Select = 's' then                {Remove ship if selected}
            begin
              Points:=Points+Defense;
              Select:= 'n';
              Gotoxy(j+1,k);
              Write(' ',defense,' ');
              FastWrite(Id,7,0,1);
              Ships:=Ships-1;
            end
          else                                {Add ship if not selected}
            begin
              Points:=Points-Defense;
              Ships:=Ships+1;
              If (Points>-1) and (Ships<=ShipsAllow) then
                begin
                  Select:= 's';
                  Gotoxy(j+1,k);
                  Write(' ',defense,' ');
                  FastWrite(Id,0,7,1);
                end
              else                            {Ignore request if not enough}
                begin                         {points or ships}
                  Points:=Points+Defense;
                  Ships:=Ships-1;
                end;
            end;
        end;
     end;
until (l=5) or (quitsw=1);
if quitsw<>1 then
  begin
    j:=0;k:=1;
    repeat                                    {Move selected ships to allied}
      repeat                                  {navy}
         j:=j+1;                              {Find selected ship}
      until available[j].select='s';
      with Allied_Navy[k] do                  {Move selected data to navy}
        begin
          ID:=Available[j].ID;
          Model:=Available[j].model;
          Theater:=Available[j].theater;
          Attack:=Available[j].attack;
          Defense:=Available[j].defense;
          Fleet:=0;
          Status:=0;
          Damage:=0;
          Work1:=0;
          Work2:=0;
          k:=k+1;
        end;
    until k>Ships;
    Window(1,23,80,24);                          {Print allied navy selected}
    ClrScr;
    Window(2,6,79,21);
    ClrScr;
    Window(1,1,80,25);
    Gotoxy(33,6);                                 {Display Allied navy}
    FastWrite('Ships Selected',7,0,1);
    j:=0;k:=8;
    For i:= 1 to Ships do
       Begin
          Gotoxy(7+j*18,k);
          with Allied_Navy[i] do
             FastWrite(Id,7,0,1);
          j:=j+1;
          if j=4 then
            begin
              j:=0;
              k:=k+1;
            end;
       end;
    Gotoxy(28,21);
    Fastwrite('PRESS ANY KEY TO CONTINUE',7,0,1);
    Uncursor;
    Read(kbd,c);
    gotoxy(1,1);
    Assign(Source,'fleet.chn');
    Chain(Source);
  end;
Window(1,1,80,25);
ClrScr;
End.
