REM ** YAHTZEE ** THE GAME OF YAHTZEE ** DMK ** 08/16/87 **
REM ** WRITTEN AND COMPILED BY DAVID KEIL **
REM *************************************************************************
REM ** FUNCTIONS **
DEF FNS$(A$)
	STATIC A: FNS$="": IF A$="" THEN EXIT DEF
	FOR A=LEN(A$) TO 1 STEP -1
		IF INSTR(CHR$(0)+" ",MID$(A$,A,1))=0 THEN FNS$=MID$(A$,1,A): A=1
	NEXT
END DEF
REM *************************************************************************
REM ** INIT PROGRAM VARIABLES **
	DEFINT A-Z: ON ERROR GOTO PROGRAM.ERROR
	DIM C(5),K(18,6),F(5),A$(6),DS$(13),DS(13),G(13,6),S(6,5)
	DIM M(13,6),TN(6),DU(6),GP$(15),GP(15),DIE$(5),SK(13),CLF(6),CLB(6)
	RESTORE BOARD.DATA: FOR A=1 TO 13: READ DS$(A),DS(A): NEXT
	RESTORE SOUND.DATA: FOR A=1 TO 6: READ TN(A): NEXT
	RESTORE DICE.DATA: FOR A=0 TO 5: READ DIE$(A): NEXT
	SCREEN 0,0,0: WIDTH 80: COLOR 7,0: CLS
	PRINT "                                 ** YAHTZEE **"
	PRINT "                              THE GAME OF YAHTZEE"
	PRINT
	PRINT "     WRITTEN AND COMPILED BY DAVID KEIL OF GREENVILLE, SC (803) 295-4971"
	LOCATE 12,15: PRINT "Would you like sound effects (Y or N)? ";
	CALL SCREEN.INPUT((12),(POS(0)),1,"",SN$,"YN"): PRINT SN$;
	LOCATE 14,15: PRINT "Do you have a color monitor (Y or N)? ";
	CALL SCREEN.INPUT((14),(POS(0)),1,"",A$,"YN"): PRINT A$;
	IF A$="Y" THEN RESTORE COLOR.DATA ELSE RESTORE MONO.DATA
	FOR A=0 TO 6: READ CLF(A),CLB(A): NEXT
	LOCATE 16,15: PRINT "Do you want to use joystick (Y or N)? ";
	CALL SCREEN.INPUT((16),(POS(0)),1,"",JS$,"YN"): PRINT JS$;
	IF JS$="Y" THEN
		LOCATE 18,15: PRINT "Center joystick and push any key.";
		WHILE INKEY$="": WEND: CALL MAKE.SOUND((3))
		JS=STICK(0): JS=STICK(0): JS=STICK(1)
	END IF
	CALL MOUSE((-1),(0),(0),(0)): GOSUB PRINT.INSTR: GOSUB GET.SCORES
REM *************************************************************************
REM ** START PROGRAM **
START:
	FOR A=1 TO 6: FOR B=1 TO 17: K(B,A)=0: NEXT: NEXT
	C1=39: C2=63: C3=33: C4=56: COLOR 7,0: CLS
	GOSUB DRAW.BOARD: GOSUB DISPLAY.SCORES
	LOCATE 25,1: PRINT "How many players? ";
	CALL SCREEN.INPUT((25),(POS(0)),1,"",A$,"123456"): N=VAL(A$)
	IF N<6 THEN
		CALL CLEAR.LINE((25),(25))
		CC=0: LOCATE 25,1: PRINT "Do you want to play against me (Y or N)? ";
		CALL SCREEN.INPUT((25),(POS(0)),1,"",A$,"YN")
		IF A$="Y" THEN CC=1
	END IF: RESTORE MOVE.DATA
	FOR A=1 TO 13: READ M(A,1),G(A,1)
		FOR B=2 TO 6: M(A,B)=M(A,1): G(A,B)=G(A,1): NEXT
	NEXT
	FOR A=1 TO N
GET.NAME:
		CALL CLEAR.LINE((25),(25)): LOCATE 25,1
		PRINT "Player number"A;"Name please: ";
		CALL SCREEN.INPUT((25),(POS(0)),10,A$(A),A$(A),"ABCDEFGHIJKLMNOPQRSTUVWXYZ. ")
		IF A$(A)="" THEN CALL MAKE.SOUND((5)): GOTO GET.NAME
	NEXT: A=0: IF CC=1 THEN N=N+1: A$(N)="COMPUTER"
PLAY.GAME:
	A=(A MOD N)+1: H=1: RANDOMIZE TIMER
	FOR B=1 TO N: K(18,B)=1
		FOR C=1 TO 13: IF K(C,B)=0 THEN K(18,B)=0: H=0
		NEXT
	NEXT: IF H THEN GOTO DISPLAY.WINNERS
	IF K(18,A) THEN GOTO PLAY.GAME
	CALL CLEAR.LINE((23),(25)): LOCATE 23,4*(A-1)+14: PRINT A$(A);
	CALL DISPLAY.CHOICES((A)): H=0: FOR B=1 TO 5: F(B)=1: NEXT
	M1=7: M2=0: M3=392: M4=440: CALL MOUSE(M1,M2,M3,M4)
	M1=8: M2=0: M3=0: M4=168: CALL MOUSE(M1,M2,M3,M4)
	M1=4: M2=0: M3=416: M4=72: CALL MOUSE(M1,M2,M3,M4)
ROLL.DIE:
	H=H+1: MR=0: C=1
	FOR B=1 TO 5
		IF F(B) THEN_
			C(B)=INT(6*RND(1)+1): CALL DISPLAY.DIE((C(B)),(B-1),(5)): C=0:_
			CALL WAIT.HERE((.05!))
	NEXT: IF C THEN H=3
	IF A$(A)="COMPUTER" THEN FLAG=0: GOTO DICE.LOGIC
PLAYER.SELECT:
	IF H>2 THEN GOTO DICE.LOGIC
	FOR B=1 TO 5: F(B)=0: NEXT: B=3: LOCATE 25,1: PRINT "Select dice";
SELECT.DIE:
	CALL DISPLAY.POINTER((1)): CALL GET.MOVEMENT(DIR,(0))
	IF ABS(DIR)=1 THEN
		CALL DISPLAY.POINTER((0)): B=B+DIR
		IF B<1 THEN B=6 ELSE IF B>6 THEN B=1
		CALL MAKE.SOUND((3))
	ELSEIF DIR=2 THEN
		CALL DISPLAY.POINTER((0))
		IF B=6 THEN CALL MAKE.SOUND((3)): GOTO ROLL.DIE
		F(B)=F(B) XOR 1: CALL DISPLAY.DIE((C(B)),(B-1),(5-F(B)))
	ELSEIF DIR=3 THEN
		GOSUB RESTART
	ELSEIF DIR>=256 THEN
		CALL DISPLAY.POINTER((0))
		B=DIR-255: IF B=6 THEN CALL MAKE.SOUND((3)): GOTO ROLL.DIE
		F(B)=F(B) XOR 1: CALL DISPLAY.DIE((C(B)),(B-1),(5-F(B)))
	END IF: GOTO SELECT.DIE
DICE.LOGIC:
	FOR B=0 TO 6: FOR C=0 TO 5: S(B,C)=0: NEXT: NEXT
	FOR B=1 TO 5
		X=C(B): S(X,0)=S(X,0)+1
		P=S(X,0): S(X,P)=B
	NEXT: X=0
	FOR B=5 TO 1 STEP -1
		FOR C=6 TO 1 STEP -1
			IF S(C,0)=B THEN S(0,X)=C: X=X+1
		NEXT
	NEXT: IF A$(A)="COMPUTER" THEN GOTO COMPUTER.SELECT
	CALL CLEAR.LINE((25),(25)): LOCATE 25,1: PRINT "Select move";
	FLAG=1: GOSUB COMPUTER.SELECT: FLAG=0: B=I: OLDMOVE=I*8-8
	M1=7: M2=0: M3=0: M4=0: CALL MOUSE(M1,M2,M3,M4)
	M1=8: M2=0: M3=0: M4=96: CALL MOUSE(M1,M2,M3,M4)
	M1=4: M2=0: M3=0: M4=I*8-8: CALL MOUSE(M1,M2,M3,M4)
SELECT.MOVE:
	COLOR CLF(3)+16,CLB(3): LOCATE DS(B),1: PRINT DS$(B);: CALL GET.MOVEMENT(DIR,(1))
	IF ABS(DIR)=1 THEN
		IF NOT(K(B,A)=0 OR (B=12 AND K(B,A)>=0 AND S(S(0,0),0)=5)) THEN_
			COLOR CLF(3),CLB(3) ELSE COLOR 0,7
		LOCATE DS(B),1: PRINT DS$(B);
NOT.VALID:
		B=B+DIR: IF B<1 THEN B=13 ELSE IF B>13 THEN B=1
		IF NOT(K(B,A)=0 OR (B=12 AND K(B,A)>=0 AND S(S(0,0),0)=5)) THEN GOTO NOT.VALID
		CALL MAKE.SOUND((3)): OLFMOVE=B*8-8
	ELSEIF DIR=2 THEN
		I=B: GOTO PLAYER.MOVE
	ELSEIF DIR=3 THEN
		GOSUB RESTART
	ELSEIF DIR>=256 THEN
		IF NOT(K(B,A)=0 OR (B=12 AND K(B,A)>=0 AND S(S(0,0),0)=5)) THEN_
			COLOR CLF(3),CLB(3) ELSE COLOR 0,7
		LOCATE DS(B),1: PRINT DS$(B);
		B=DIR-255
	END IF: GOTO SELECT.MOVE
PLAYER.MOVE:
	IF NOT(K(B,A)=0 OR (B=12 AND K(B,A)>=0 AND S(S(0,0),0)=5)) THEN_
		DIR=1: COLOR CLF(3),CLB(3): LOCATE DS(B),1: PRINT DS$(B);: GOTO NOT.VALID
	IF I<=6 THEN
		CALL CHECK.DIE
		IF X<>-1 THEN K(I,A)=I*S(S(0,X),0): GOTO COMPUTE.SCORES
	ELSEIF I=7 THEN
		IF S(S(0,0),0)>=3 THEN K(I,A)=C(1)+C(2)+C(3)+C(4)+C(5): GOTO COMPUTE.SCORES
	ELSEIF I=8 THEN
		IF S(S(0,0),0)>=4 THEN K(I,A)=C(1)+C(2)+C(3)+C(4)+C(5): GOTO COMPUTE.SCORES
	ELSEIF I=9 THEN
		IF (S(S(0,0),0)=3 AND S(S(0,1),0)=2) OR S(S(0,0),0)=5 THEN_
			K(9,A)=25: GOTO COMPUTE.SCORES
	ELSEIF I=10 THEN
		IF (S(1,0)>0 AND S(2,0)>0 AND S(3,0)>0 AND S(4,0)>0)_
		OR (S(2,0)>0 AND S(3,0)>0 AND S(4,0)>0 AND S(5,0)>0)_
		OR (S(3,0)>0 AND S(4,0)>0 AND S(5,0)>0 AND S(6,0)>0) THEN_
			K(10,A)=30: GOTO COMPUTE.SCORES
	ELSEIF I=11 THEN
		IF (S(1,0) AND S(2,0) AND S(3,0) AND S(4,0) AND S(5,0)=1)_
		OR (S(2,0) AND S(3,0) AND S(4,0) AND S(5,0) AND S(6,0)=1) THEN_
			K(11,A)=40: GOTO COMPUTE.SCORES
	ELSEIF I=12 THEN
		IF S(S(0,0),0)=5 THEN IF K(12,A)=0 THEN K(12,A)=50: GOTO COMPUTE.SCORES_
		ELSE K(12,A)=K(12,A)+100: GOTO COMPUTE.SCORES
	ELSE
		K(I,A)=C(1)+C(2)+C(3)+C(4)+C(5): GOTO COMPUTE.SCORES
	END IF: K(I,A)=-1: GOTO COMPUTE.SCORES
COMPUTER.SELECT:
	FOR B=1 TO 5: F(B)=0: NEXT B: I=0
	IF K(12,A)>=0 AND S(S(0,0),0)=5 THEN
		I=12: IF K(12,A)=0 THEN S=50 ELSE S=K(12,A)+100
	ELSEIF K(11,A)=0 AND_
	((S(1,0) AND S(2,0) AND S(3,0) AND S(4,0) AND S(5,0)=1)_
	OR (S(2,0) AND S(3,0) AND S(4,0) AND S(5,0) AND S(6,0)=1)) THEN
		I=11: S=40
	ELSEIF K(10,A)=0 AND_
	((S(1,0)>0 AND S(2,0)>0 AND S(3,0)>0 AND S(4,0)>0)_
	OR (S(2,0)>0 AND S(3,0)>0 AND S(4,0)>0 AND S(5,0)>0)_
	OR (S(3,0)>0 AND S(4,0)>0 AND S(5,0)>0 AND S(6,0)>0)) THEN
		IF H<3 AND K(11,A)=0 AND FLAG=0 THEN GOSUB SMALL.LARGE: GOTO COMPUTER.ROLL_
			ELSE I=10: S=30
	ELSEIF K(9,A)=0 AND S(S(0,0),0)=3 AND S(S(0,1),0)=2 THEN
		I=9: S=25
	ELSEIF H<3 THEN
		I=0
	ELSEIF K(8,A)=0 AND S(S(0,0),0)>=4 AND S(0,0)>=4 THEN
		I=8: S=S(S(0,0),0)*S(0,0)+S(0,1)
	ELSEIF S(6,0)>2 AND K(6,A)=0 THEN
		I=6: S=6*S(6,0)
	ELSEIF S(5,0)>2 AND K(5,A)=0 THEN
		I=5: S=5*S(5,0)
	ELSEIF S(4,0)>2 AND K(4,A)=0 THEN
		I=4: S=4*S(4,0)
	ELSEIF S(3,0)>2 AND K(3,A)=0 THEN
		I=3: S=3*S(3,0)
	ELSEIF S(2,0)>2 AND K(2,A)=0 THEN
		I=2: S=2*S(2,0)
	ELSEIF S(1,0)>2 AND K(1,A)=0 THEN
		I=1: S=1*S(1,0)
	ELSEIF K(8,A)=0 AND S(S(0,0),0)=4 THEN
		I=8: S=S(S(0,0),0)*S(0,0)+S(0,1)
	ELSEIF K(7,A)=0 AND S(S(0,0),0)>2 THEN
		I=7: S=C(1)+C(2)+C(3)+C(4)+C(5)
	ELSEIF K(13,A)=0 AND C(1)+C(2)+C(3)+C(4)+C(5)>19 THEN
		I=13: S=C(1)+C(2)+C(3)+C(4)+C(5)
	END IF: IF I THEN IF FLAG THEN RETURN ELSE K(I,A)=S: GOTO COMPUTE.SCORES
DICE.CONTROL:
	H=H+1: IF H>3 THEN GOTO BEST.MOVE
	IF S(S(0,0),0)>1 AND (K(S(0,0),A)=0 OR K(7,A)=0 OR K(8,A)=0) THEN GOTO GET.DICE
	MR=0
DC1:
	MR=(MR MOD 13)+1: I=M(MR,A)
	IF I=0 THEN GOTO DC1 ELSE IF I=12 AND K(12,A)>=0 THEN GOTO GD1_
	ELSE IF K(I,A)<>0 THEN GOTO DC1
	IF I=9 THEN GOTO MAKE.FULL.HOUSE ELSE IF I=10 OR I=11 THEN GOTO MAKE.STRAIGHT
GET.DICE:
	IF K(7,A)<>0 AND K(8,A)<>0 THEN GOSUB NEXT.ROLL: GOTO COMPUTER.ROLL
GD1:
	M=0: J=1
GD2:
	M=M+1: IF M>4 THEN GOTO COMPUTER.ROLL
	K=S(0,M): IF K=0 THEN GOTO COMPUTER.ROLL
	FOR L=1 TO S(K,0): F(J)=S(K,L): J=J+1: NEXT: GOTO GD2
MAKE.FULL.HOUSE:
	J=1
	FOR K=0 TO 4
		IF S(0,K)<>0 THEN_
			IF K>=2 THEN FOR L=1 TO S(S(0,K),0): F(J)=S(S(0,K),L): J=J+1: NEXT_
			ELSE IF K<>1 AND S(S(0,0),0)>=4 THEN_
				FOR L=4 TO S(S(0,0),0): F(J)=S(S(0,0),L): J=J+1: NEXT
	NEXT
MAKE.STRAIGHT:
	J=1
	FOR K=1 TO 6
		IF S(K,0)>=2 THEN FOR L=2 TO S(K,0): F(J)=S(K,L): F=F+1: NEXT
	NEXT
	IF S(1,0)<>0 AND S(6,0)<>0 THEN_
		IF S(2,0)=0 THEN F(J)=S(1,1) ELSE F(J)=S(6,1)
	J=J+1
COMPUTER.ROLL:
	CALL WAIT.HERE((1!))
	FOR B=1 TO 5
		IF F(B)>=1 THEN_
			C=B: B=F(B): CALL DISPLAY.DIE((C(B)),(B-1),(4)): B=C: CALL WAIT.HERE((.5!))
	NEXT: CALL WAIT.HERE((.5!))
	FOR B=1 TO 5
		IF F(B)>=1 THEN_
			C(F(B))=INT(6*RND(1)+1): C=B: B=F(B): CALL DISPLAY.DIE((C(B)),(B-1),(5)): B=C:_
			CALL WAIT.HERE((.05!))
		F(B)=0
	NEXT: CALL WAIT.HERE((.5!)): GOTO DICE.LOGIC
BEST.MOVE:
	S=-1
	FOR B=4 TO 0 STEP -1
		IF S(0,B)<>0 AND S(S(0,B),0)>1 AND K(S(0,B),A)=0 THEN_
			I=S(0,B): S=S(0,B)*S(S(0,B),0): GOTO FOUND.BEST
	NEXT
	FOR B=4 TO 0 STEP -1
		IF S(0,B)<>0 AND S(0,B)<=3 AND K(S(0,B),A)=0 THEN_
			I=S(0,B): S=S(0,B)*S(S(0,B),0):GOTO FOUND.BEST
	NEXT
	IF K(13,A)=0 THEN I=13: S=C(1)+C(2)+C(3)+C(4)+C(5): GOTO FOUND.BEST
	FOR B=4 TO 0 STEP -1
		IF S(0,B)<>0 AND S(S(0,B),0)>0 AND K(S(0,B),A)=0 THEN_
			I=S(0,B): S=S(0,B)*S(S(0,B),0): GOTO FOUND.BEST
	NEXT: MR=0
BM1:
	MR=(MR MOD 13)+1: I=G(MR,A)
	IF I=0 THEN GOTO BM1 ELSE IF K(I,A)<>0 THEN GOTO BM1
	IF I<=6 THEN CALL CHECK.DIE: IF X=-1 THEN GOTO FOUND.BEST_
		ELSE S=S(I,0)*I: IF S<>0 THEN GOTO FOUND.BEST
	IF I=13 AND K(13,A)=0 THEN S=C(1)+C(2)+C(3)+C(4)+C(5)
FOUND.BEST:
	IF FLAG THEN RETURN ELSE K(I,A)=S
COMPUTE.SCORES:
	FOR B=14 TO 17: K(B,A)=0: NEXT
	FOR B=1 TO 6
		IF K(B,A)>0 THEN K(15,A)=K(15,A)+K(B,A)
	NEXT: IF K(15,A)>62 THEN K(14,A)=35
	FOR B=7 TO 13
		IF K(B,A)>0 THEN K(16,A)=K(16,A)+K(B,A)
	NEXT: K(17,A)=K(14,A)+K(15,A)+K(16,A): GOSUB PRINT.SCORE
	FOR B=1 TO 13
		IF M(B,A)<>12 AND M(B,A)=I THEN M(B,A)=0
		IF G(B,A)<>12 AND G(B,A)=I THEN G(B,A)=0
	NEXT: GOTO PLAY.GAME
DISPLAY.WINNERS:
	FOR A=1 TO N
		FOR B=A TO N
			IF K(17,B)>K(17,A) THEN SWAP K(17,A),K(17,B): SWAP A$(A),A$(B)
		NEXT
	NEXT
PRINT.WINNERS:
	CALL DISPLAY.CHOICES((0)): CALL CLEAR.LINE((23),(25))
	GOSUB ADD.SCORES
	GOSUB DISPLAY.SCORES
	RESTORE WINNER.DATA
	FOR A=1 TO N
		CALL MAKE.SOUND((2)): CALL CLEAR.LINE((25),(25))
		LOCATE 25,1: READ A$: IF A=N AND N>1 THEN A$=" LAST PLACE "
		PRINT A$+"    "+A$(A);: CALL WAIT.HERE((4!))
	NEXT: FOR A=1 TO N: IF A$(A)="COMPUTER" THEN SWAP A$(A),A$(N)
	NEXT: GOTO END.PROGRAM
REM *************************************************************************
REM ** END OF PROGRAM **
END.PROGRAM:
	CALL CLEAR.LINE((25),(25))
	LOCATE 24,1: PRINT "+++  End of game  +++";
	LOCATE 25,1: PRINT "Play again (Y or N)? ";
	CALL SCREEN.INPUT((25),(POS(0)),1,"",A$,"YN")
	IF A$="Y" THEN GOTO START ELSE CALL MAKE.SOUND((5))
	END
PROGRAM.ERROR:
	CALL CLEAR.LINE((23),(25)): LOCATE 24,1: PRINT "Program error #";ERR;
	CALL MAKE.SOUND((2)): LOCATE 25,1: PRINT "Push any key to end program";
	WHILE INKEY$="": WEND: CALL MAKE.SOUND((5))
	END
REM *************************************************************************
REM ** START OF SUBROUTINES **
PRINT.INSTR:
	IF CLF(0)=14 THEN COLOR 2,0
	CLS: PRINT "                        Y A H T Z E E ": PRINT
	PRINT "This is the game of YAHTZEE - "
	PRINT "From 1 to 6 players may play, or one may play against the computer,"
	PRINT "with each player's current status shown on the screen's game board."
	PRINT "You have to 'SCORE' each play, and the strategy involved is to"
	PRINT "guess whether you will be lucky in future rolls.": PRINT
	PRINT "      A YAHTZEE is five of a kind.  "
	PRINT "      A SMALL STRAIGHT is any sequence of four."
	PRINT "      A LARGE STRAIGHT is any sequence of five."
	PRINT "A second YAHTZEE earns a bonus of 100 points (if the YAHTZEE is put"
	PRINT "into the YAHTZEE block)..... in addition you will get and extra turn"
	PRINT "at the end of the game."
	PRINT "On each play you will get one roll of the five dice, followed by two"
	PRINT "chances to re-roll selected die.  GOOD LUCK on your playing!": PRINT
	PRINT "To select dice for re-roll:"
	PRINT "      Use ARROWS to move selector next to die. Push SPACE to select die."
	PRINT "      Move selector off screen and push SPACE to re-roll selected dice."
	PRINT "To select board position:"
	PRINT "      Use ARROWS to move blinking selector over desired board position."
	PRINT "      Push SPACE To select."
	PRINT "ESCape will end the game.";
	LOCATE 25,1: PRINT "                 Press any key to continue. . . .";
	CALL MAKE.SOUND((1)): WHILE INKEY$="": WEND: CALL MAKE.SOUND((3)): RETURN
DRAW.BOARD:
	RESTORE LINE.DATA: READ A$,B$,C$,D$
	CLS: COLOR CLF(2),CLB(2): LOCATE ,14: PRINT A$
	FOR B=1 TO 13
		LOCATE DS(B),14: PRINT C$
	NEXT: LOCATE ,14: PRINT B$
	PRINT "TOTAL LOWER.."+C$: PRINT "TOP BONUS...."+C$
	PRINT "GRAND TOTAL.."+C$: LOCATE ,14: PRINT D$
	LOCATE 8,14: PRINT B$
	PRINT "TOTAL UPPER.."+C$: LOCATE ,14: PRINT B$: COLOR CLF(6),0
	A$="YAHTZEE": FOR B=5 TO 11: LOCATE B,43: PRINT MID$(A$,B-4,1);: NEXT
	FOR B=1 TO 5:LOCATE B*4-2,46:PRINT B;:NEXT: CALL DISPLAY.CHOICES((0))
	IF MOUSE.FLG=1 THEN
		COLOR CLF(5),CLB(5)
		LOCATE 21,50: PRINT " ROLL  ": LOCATE ,50: PRINT " DICE  "
	END IF: RETURN
DISPLAY.SCORES:
	LOCATE 1,59: COLOR CLF(0),CLB(0): PRINT"Greatest Players Ever"
	COLOR CLF(1),CLB(1)
	LOCATE ,59: PRINT"    Name        Score": LOCATE ,59:PRINT"-------------- ------"
	FOR B=1 TO 9
		LOCATE ,59: PRINT STR$(B)+"."+GP$(B);TAB(77);USING"###";GP(B)
	NEXT
	LOCATE ,59: PRINT "10."+GP$(10);TAB(77);USING"###";GP(10)
	LOCATE 15,59: COLOR CLF(0),CLB(0): PRINT"Weakest Players Ever "
	COLOR CLF(1),CLB(1)
	LOCATE ,59: PRINT"    Name        Score": LOCATE 17,59:PRINT"------------- -------"
	FOR B=1 TO 5
	LOCATE ,59: PRINT STR$(B);"."+GP$(B+10);TAB(77);USING"###";GP(B+10)
	NEXT: COLOR 7,0: RETURN
ADD.SCORES:
	FOR A=1 TO N: FOR B=1 TO 10
		IF K(17,A)>GP(B) THEN
			IF B=10 THEN
				GP$(B)=A$(A): GP(B)=K(17,A)
			ELSE
				FOR C=10 TO B+1 STEP -1
					GP$(C)=GP$(C-1): GP(C)=GP(C-1)
				NEXT: GP$(B)=A$(A): GP(B)=K(17,A)
			END IF: B=10
		END IF
	NEXT: NEXT
	FOR A=1 TO N: FOR B=11 TO 15
		IF K(17,A)<GP(B) OR (K(17,A)<180 AND GP(B)=0) THEN
			IF B=15 THEN
				GP$(B)=A$(A): GP(B)=K(17,A)
			ELSE
				FOR C=15 TO B+1 STEP -1
					GP$(C)=GP$(C-1): GP(C)=GP(C-1)
				NEXT: GP$(B)=A$(A): GP(B)=K(17,A)
			END IF: B=15
		END IF
	NEXT: NEXT: GOSUB PUT.SCORES: RETURN
PRINT.SCORE:
	CALL MAKE.SOUND((2)): COLOR 15,0
	FOR B=1 TO 13
		IF K(B,A)<0 THEN LOCATE DS(B),4*A+11: PRINT "  0";_
		ELSE IF K(B,A)>0 THEN LOCATE DS(B),4*A+11: PRINT USING "###";K(B,A);
	NEXT
	LOCATE 9,4*A+11: PRINT USING "###";K(15,A)
	LOCATE 19,4*A+11: PRINT USING "###";K(16,A)
	LOCATE ,4*A+11: PRINT USING "###";K(14,A)
	LOCATE ,4*A+11: PRINT USING "###";K(17,A)
	COLOR 7,0: RETURN
RESTART:
	COLOR 7,0: CALL CLEAR.LINE((25),(25))
	LOCATE 25,1: PRINT "Abort game (Y or N)? ";
	CALL SCREEN.INPUT((25),(POS(0)),1,"N",A$,"YN")
	CALL CLEAR.LINE((25),(25)): IF A$="Y" THEN RETURN END.PROGRAM ELSE RETURN
NEXT.ROLL:
	FOR J=1 TO 5: F(J)=0: NEXT: J=1
	FOR Q=0 TO 4
		R=S(0,Q)
		IF R<>0 THEN
			IF K(R,A)=0 THEN GOTO NR1
			FOR T=1 TO 4
				IF S(R,T)=0 THEN T=4 ELSE F(J)=S(R,T): J=J+1
			NEXT
		END IF
	NEXT
NR1:
	IF J=6 THEN RETURN
	FOR Q=Q+1 TO 4
		R=S(0,Q)
		IF R<>0 THEN
			FOR T=1 TO 4
				IF S(R,T)=0 THEN T=4 ELSE F(J)=S(R,T): J=J+1
			NEXT
		END IF
	NEXT: RETURN
SMALL.LARGE:
	H=H+1
	IF S(S(0,0),0)=2 THEN
		F(1)=S(S(0,0),1)
	ELSEIF S(1,0) AND S(2,0) AND S(3,0) AND S(4,0)=1 THEN
		IF S(5,1)>1 THEN F(1)=S(5,1) ELSE F(1)=S(6,1)
	ELSEIF S(2,0) AND S(3,0) AND S(4,0) AND S(5,0)=1 THEN
		IF S(1,1)>1 THEN F(1)=S(1,1) ELSE F(1)=S(6,1)
	ELSE
		IF S(1,1)>1 THEN F(1)=S(1,1) ELSE F(1)=S(2,1)
	END IF: RETURN
GET.SCORES:
	ON ERROR GOTO GETERR
	OPEN"R",1,"YAHTZEE.TOP",512: FIELD 1,512 AS A$: GET 1,1
	FOR A=1 TO 512: MID$(A$,A,1)=CHR$(ASC(MID$(A$,A,1)) XOR 255): NEXT
	IF MID$(A$,1,3)="TOP" THEN
		FOR A=1 TO 15
			GP$(A)=FNS$(MID$(A$,A*12-8,10)): GP(A)=CVI(MID$(A$,A*12+2,2))
		NEXT
	ELSE
		FOR A=1 TO 15: GP$(A)="": GP(A)=0: NEXT
	END IF: CLOSE
GETRET:
	ON ERROR GOTO PROGRAM.ERROR: RETURN
GETERR:
	LOCATE 24,1: PRINT "PROBLEMS EXIST PREVENTING THE LOADING OF THE HIGH SCORES.";
	LOCATE 25,1: PRINT "CORRECT PROBLEM AND PRESS 'ENTER' OR PRESS 'A' TO ABORT LOAD. ";
	CALL SCREEN.INPUT((25),(POS(0)),1,"",A$,("A"+CHR$(13))): CALL CLEAR.LINE((24),(25))
	IF A$="" THEN RESUME GET.SCORES ELSE RESUME GETRET
PUT.SCORES:
	ON ERROR GOTO PUTERR
	OPEN"R",1,"YAHTZEE.TOP",512: FIELD 1,512 AS A$: B$="TOP"
	FOR A=1 TO 15
		B$=B$+GP$(A)+SPACE$(10-LEN(GP$(A)))+MKI$(GP(A))
	NEXT: B$=B$+SPACE$(512-LEN(B$))
	FOR A=1 TO 255: MID$(B$,A,1)=CHR$(ASC(MID$(B$,A,1)) XOR 255): NEXT
	LSET A$=B$: PUT 1,1: CLOSE
PUTRET:
	ON ERROR GOTO PROGRAM.ERROR: RETURN
PUTERR:
	LOCATE 24,1: PRINT "PROBLEMS EXIST PREVENTING THE SAVING OF THE HIGH SCORES.";
	LOCATE 25,1: PRINT "CORRECT PROBLEM AND PRESS 'ENTER' OR PRESS 'A' TO ABORT SAVE. ";
	CALL SCREEN.INPUT((25),(POS(0)),1,"",A$,("A"+CHR$(13))): CALL CLEAR.LINE((24),(25))
	IF A$="" THEN RESUME PUT.SCORES ELSE RESUME PUTRET
REM *************************************************************************
REM ** START OF DATA STATEMENTS **
BOARD.DATA:
	DATA "ONES.........",2,"TWOS.........",3,"THREES.......",4
	DATA "FOURS........",5,"FIVES........",6,"SIXES........",7
	DATA "3 OF A KIND..",11,"4 OF A KIND..",12,"FULL HOUSE...",13
	DATA "SM STRAIGHT..",14,"LG STRAIGHT..",15,"YATZEE.......",16
	DATA "CHANCE.......",17
SOUND.DATA:
	DATA 49,51,53,54,56,61
LINE.DATA:
	DATA "ͻ"
	DATA "Ķ"
	DATA ".................."
	DATA "ͼ"
DICE.DATA:
	DATA "       ","     ","      ","    ","      ","      "
MOVE.DATA:
	DATA 6,11,5,8,4,10,3,9,7,12,8,7,2,1,1,2,11,3,10,4,12,5,9,6,13,13
WINNER.DATA:
	DATA "+++   THE WINNER   +++"," SECOND PLACE"," THIRD PLACE "
	DATA " FOURTH PLACE "," FIFTH PLACE "," SIXTH PLACE "
COLOR.DATA:
	DATA 14,4,10,1,6,0,14,6,14,1,14,4,14,0
MONO.DATA:
	DATA 15,7,0,7,7,0,7,0,15,7,0,7,7,0
REM *************************************************************************
REM ** START OF SUBPROGRAMS **
	'Prompt screen for input
	' ROW% = Prompt row, COL% = Prompt column
	' MAX% = Max # chars to input
	' CUR$ = Current value of field being prompted, field not altered.
	' INP$ = Return value
	' VALID$ = Valid chars during input
SUB SCREEN.INPUT(ROW,COL,MAX,CUR$,INP$,VALID$) STATIC
INPSTART:
	CALL MAKE.SOUND((1)): CPS=1: STRFLG=1: INP$=CUR$
	IF LEN(INP$)>MAX THEN INP$=LEFT$(INP$,MAX) ELSE INP$=INP$
INPCLEAR:
	INSFLG=0: SIZ=LEN(INP$): LOCATE ROW,COL,1
	PRINT INP$+STRING$(MAX-SIZ,95);: LOCATE ,COL+CPS-1
INPGET:
	IP$=INKEY$: ON LEN(IP$)+1 GOTO INPGET,INPCHR
	IP=ASC(RIGHT$(IP$,1)): GOTO INPFUN
INPCHR:
	IP=ASC(IP$): IF IP>96 AND IP<123 THEN IP=IP AND 223: IP$=CHR$(IP)
	IF INSTR(VALID$,IP$)=0 THEN GOTO INPCTL
INPDIS:
	IF CPS>MAX THEN GOTO INPERR ELSE CPS=CPS+1
	IF CPS-1>SIZ THEN
		SIZ=SIZ+1: INP$=INP$+IP$: PRINT IP$;
	ELSEIF INSFLG=1 THEN
		SIZ=SIZ+1: INP$=LEFT$(INP$,CPS-2)+IP$+MID$(INP$,CPS-1)
		IF SIZ>MAX THEN INP$=LEFT$(INP$,MAX): SIZ=MAX
		PRINT MID$(INP$,CPS-1);: LOCATE ,COL+CPS-1
	ELSE
		INP$=LEFT$(INP$,CPS-2)+IP$+MID$(INP$,CPS): PRINT IP$;
	END IF
	IF MAX=1 THEN IP=13: GOTO INPFUN
	IF STRFLG THEN STRFLG=0: INP$=IP$: CPS=2: CALL MAKE.SOUND((3)): GOTO INPCLEAR_
	ELSE GOTO INPOK
INPCTL:
	IF IP>=32 THEN GOTO INPERR
INPFUN:
	IF IP<>13 THEN STRFLG=0
	ON INSTR(CHR$(8)+CHR$(13)+CHR$(27)+"GKMORS",CHR$(IP))_
		GOTO INPBS,INPRET,INPSTART,INPBG,INPLC,INPRC,INPED,INPINS,INPDL
INPERR:
	CALL MAKE.SOUND((1)): GOTO INPGET
INPOK:
	CALL MAKE.SOUND((3)): GOTO INPGET
INPBS:
	IF CPS=1 THEN GOTO INPERR ELSE CPS=CPS-1: SIZ=SIZ-1
	IF CPS>SIZ THEN INP$=LEFT$(INP$,SIZ)_
	ELSE INP$=LEFT$(INP$,CPS-1)+MID$(INP$,CPS+1)
	LOCATE ,POS(0)-1: PRINT MID$(INP$,CPS)+STRING$(MAX-SIZ,95);
	LOCATE ,COL+CPS-1: GOTO INPOK
INPBG:
	CPS=1: LOCATE ,COL: GOTO INPOK
INPLC:
	IF CPS>1 THEN CPS=CPS-1: PRINT CHR$(29);: GOTO INPOK ELSE GOTO INPERR
INPRC:
	IF CPS<SIZ+1 THEN CPS=CPS+1: PRINT CHR$(28);: GOTO INPOK ELSE GOTO INPERR
INPED:
	CPS=SIZ+1: LOCATE ,COL+CPS-1: GOTO INPOK
INPINS:
	INSFLG=INSFLG XOR 1: GOTO INPOK
INPDL:
	IF SIZ>=CPS THEN PRINT CHR$(28);: CPS=CPS+1: GOTO INPBS ELSE GOTO INPERR
INPRET:
	IF MAX=1 AND INP$="" AND INSTR(VALID$,CHR$(13))=0 THEN GOTO INPGET
	LOCATE ROW,COL,0: PRINT SPACE$(MAX);: LOCATE ROW,COL
END SUB
SUB MAKE.SOUND(X) STATIC
	SHARED SN$,TN(),C(),B: IF SN$="N" THEN EXIT SUB
	IF X=1 THEN
		PLAY "L64T200N70"
	ELSEIF X=2 THEN
		PLAY "T150MLL64O5CC#DD#EFF#GG#AA#B"
	ELSEIF X=3 THEN
		PLAY "L64T200N46"
	ELSEIF X=4 THEN
		PLAY "L32T150N"+STR$(TN(C(B)))+";"
	ELSEIF X=5 THEN
		BEEP
	END IF
END SUB
SUB DISPLAY.DIE(DIE,J,COL) STATIC
	SHARED DIE$(),CLF(),CLB(): CALL MAKE.SOUND((4))
	IF DIE=1 THEN A=0: B=5: C=0 ELSE IF DIE=2 THEN A=2: B=0: C=4_
	ELSE IF DIE=3 THEN A=2: B=5: C=4 ELSE IF DIE=4 THEN A=1: B=0: C=1_
	ELSE IF DIE=5 THEN A=1: B=5: C=1 ELSE A=3: B=0: C=3
	COLOR CLF(COL),CLB(COL): LOCATE 4*J+1,50
	PRINT DIE$(A): LOCATE ,50: PRINT DIE$(B): LOCATE ,50: PRINT DIE$(C)
	COLOR 7,0: LOCATE 25,1
END SUB
SUB DISPLAY.CHOICES(A) STATIC
	SHARED DS$(),DS(),K(),CLF(),CLB()
	FOR B=1 TO 13
		IF K(B,A)=0 OR (K(B,A)>0 AND B=12) THEN_
			COLOR 0,7 ELSE COLOR CLF(3),CLB(3)
		LOCATE DS(B),1: PRINT DS$(B)
	NEXT: COLOR 7,0
END SUB
SUB WAIT.HERE(A!) STATIC
	WHILE INKEY$<>"": WEND: B!=TIMER
	WHILE INKEY$="" AND TIMER<(B!+A!): WEND
END SUB
SUB DISPLAY.POINTER(C) STATIC
	SHARED B,CLF(),CLB()
	IF C THEN COLOR CLF(5),CLB(5) ELSE COLOR CLF(6),0
	LOCATE B*4-3,47: PRINT " ": LOCATE ,47
	IF B<6 THEN PRINT CHR$(B+48): LOCATE ,47
	PRINT " ": COLOR 7,0
END SUB
SUB GET.MOVEMENT(DIR,FLG) STATIC
	SHARED JS$,JS,OLDMOVE: DIR=0: JSFL=0
	IF FLG=0 THEN CALL MOUSE((1),(0),(0),(0))
	WHILE DIR=0: A$=INKEY$
		IF A$=CHR$(0)+CHR$(72) THEN DIR=-1_
		ELSE IF A$=CHR$(0)+CHR$(80) THEN DIR=1_
		ELSE IF A$=CHR$(27) THEN DIR=3_
		ELSE IF A$=" " OR A$=CHR$(13) THEN DIR=2_
		ELSE IF A$<>"" AND DIR=0 THEN CALL MAKE.SOUND((1))
		IF JS$="Y" THEN
			A=STICK(0): A=STICK(0): A=STICK(1)
			IF JSFL<>0 AND A>JS/2 AND A<JS+JS/2 THEN DIR=JSFL
			IF JSFL=0 THEN IF A<JS/2 THEN JSFL=-1 ELSE IF A>JS+JS/2 THEN JSFL=1
			IF STRIG(1) THEN WHILE STRIG(1): WEND: CALL WAIT.HERE((.1!)): DIR=2
		END IF
		IF FLG=1 THEN
			M1=3: M2=0: M3=0: M4=0: CALL MOUSE(M1,M2,M3,M4)
			M4=M4/8: IF M4<>OLDMOVE THEN DIR=256+M4: OLDMOVE=M4
			M1=6: M2=0: M3=0: M4=0: CALL MOUSE(M1,M2,M3,M4)
			IF (M1 AND 1)=0 AND M2>0 THEN DIR=2
		ELSE
			M1=6: M2=0: M3=0: M4=0: CALL MOUSE(M1,M2,M3,M4)
			IF (M1 AND 1)=0 AND M2>0 THEN
				DIR=256+INT(M4/32): IF ((M4/8) MOD 4)=3 THEN DIR=0
			END IF
		END IF
	WEND: IF FLG=0 THEN CALL MOUSE((2),(0),(0),(0))
END SUB
SUB MOUSE(M1,M2,M3,M4) STATIC
	SHARED MOUSE.SEG,MOUSE.FLG,MOUSE
	IF M1=-1 THEN
		DEF SEG=0
		MOUSE.SEG=PEEK(207)*256+PEEK(206): MOUSE=PEEK(205)*256+PEEK(204)+2
		DEF SEG=MOUSE.SEG
		IF PEEK(MOUSE-2)=207 OR PEEK(MOUSE-2)=0 THEN_
			DEF SEG: MOUSE=0: MOUSE.SEG=0: MOUSE.FLG=0: GOTO MSRET
		M1=0: CALL ABSOLUTE(M1,M2,M3,M4,MOUSE)
		IF M1=0 THEN DEF SEG: MOUSE=0: MOUSE.SEG=0: MOUSE.FLG=0: GOTO MSRET
		M1=7: M2=0: M3=392: M4=440: CALL ABSOLUTE(M1,M2,M3,M4,MOUSE)
		M1=8: M2=0: M3=0: M4=168: CALL ABSOLUTE(M1,M2,M3,M4,MOUSE)
		DEF SEG: MOUSE.FLG=1
	ELSEIF MOUSE.FLG=1 AND (M1=0 OR M1=1 OR M1=2 OR M1=3 OR M1=6 OR M1=7 OR M1=8 OR M1=4) THEN
		DEF SEG=MOUSE.SEG: CALL ABSOLUTE(M1,M2,M3,M4,MOUSE): DEF SEG
	END IF
MSRET:
END SUB
SUB CLEAR.LINE(F,T) STATIC
	VIEW PRINT F TO T: CLS: VIEW PRINT 1 TO 24
END SUB
SUB CHECK.DIE STATIC
	SHARED S(),I,X: X=-1
	FOR A=0 TO 4: IF S(0,A)=I THEN X=A
	NEXT
END SUB
