' ---------------------------------------------------------
'
'            * *  DRAGON-WORLD  * *
'
' ein Strategiespiel fr zwei Personen
'
' copyright by Markus Woitzik
' 16. Mrz  1988  /  Bonn             -  Version 3.30
'                                        (29.April'88)
' ---------------------------------------------------------

' BC /16/03/88 : vers. 3.30 : 1 001


' require EGA - Card  !



' Das Programm lt sich leicht modifizieren und so eigenen Wnschen an-
' anpassen . Wem die Mglichkeiten in der User-Genesis-Routine noch zu
' wenig sind , der findet nun folgend das Basic-Quellprogramm , welches unter
' Turbo-Basic lauffhig bzw. compilierbar ist !
' Die verwendeten Variablen werden zum Programmbeginn erlutert , die
' einzelnen Unterroutine / Programmabschnitte markiert.


' Dieses Programm zhlt zur Free-soft und darf frei copiert und weitergegeben
' werden unter den in - sub Freesoft - erluterten Bedingungen !
'                     

' Spieldauer (je nach geladenem Krieg) ca. 2 - 4 Stunden


' --  Verwendete Variablen --
'
'     i,i1,i2,i3,i4,aa$,aa,a,a$,a1,a2,j,zz,z    - Zhl bzw Entscheidungsvar.
'     Posx,Posy          - betreff Cursorposition in Genesis-routine
'     Landschaft(76,17)  - enthlt Farbwerte der Dragon-World
'     Spieler            - wer dran ist (1 oder 2)
'     Truppe             - Welche Armee momentan dran ist (1-26)
'     Motivation(Spieler,Truppe) - Motivationsgrad der betr. Armee
'     Anzahl(Spieler,Truppe)     - Mannstrke
'     Kampfst(Spieler,Truppe)    - Kampfstrke der betr. Armee
'     ascii(Spieler,Truppe)      - ascii-Zeichen der Armee fr Bildschirmdarst.
'     PositionX(Spieler,Truppe)  - Positionswert der Zeile
'     PositionY(Spieler,Truppe)  -       "       der Spalte
'     Namen$(Spieler,Truppe)     - Name der Armee (z.B. Soldaten)
'     Darunter(Spieler,Truppe)   - enthlt Feld unter der Armee
'     Satz$(18)          - enthlt Einleitunsstory
'     na$                -    "    Name des gewnschten Files
'     Jahr               - ist bei Mondjahr=5 , bei Sonnenjahr = 10
'     Runde              - in welcher ZugRunde man sich befindet
'     Zug$(Spieler,Truppe,Runde)  - Enthlt Richtungsangabe der Armeen
'     Verteidiger / Bedrohte   - entsprechen Spieler + Truppe (GegenSpieler
'                                beim Kampf )
'     Umgebung(Spieler)  - enthlt Handicapwert fr Kampf
'     Feldherr(Spieler)  - enthlt Vorteilswer fr Kampf wenn Fhrerperson in
'                          unmittelbarer Nhe zur kmpfenden Armee ist
'     Angriff / Verteidigung - enthalten Kampfwerte der Kontrahenten
'     VGefallen / AGefallen  -    "      Anzahl der Gefallenen der Schlacht
'     Speicher , Speicher1   - Zwischenspeicher
'     mpause                 - enthlt Blinkverzoegerung in Sekunden
'     blname$/rtname$     - Namen der beiden Knige
'     insgdauer           - Insgesamtanzahl der gespielten Runden
'     RHptstgew/BHptstgew - Hauptstadt gewechselt
'     RTote/BTote         - Anzahl der Toten
'     GGesamtpers/BGesamtpers  - briggebliebene Personen
'     RAnfst/BAnfst       - Anfangsstrke (Personen)
'     RAngriffeSt/BAngriffeSt  - Anzahl der Stadtangriffe
'     RSiegTr/BSiegTr     - Siege ber gegn. Truppen
'     Spielrunde          - na eben welche Spielrunde dran ist !
'     MEndMot(Spieler,Spielrunde)  - enthlt Durchschnittsmotivation
'     EndAnz(Spieler,Spielrunde)   - enthlt Truppenstrke (Anzahl Personen)
'     EndStadt(Spieler,Spielrunde) - enthlt Anzahl eigener Stdte


$include "pic-bc.box"         ' Brain- copyright BC picture
$include "erklaer.box)        ' enthlt die Spielerklrung (File auf Diskette
                              ' mit demselben Namen)


screen 0,0,0                  ' Textmodus
randomize timer
defint a-l
defsng m
defint n-z
goto Hauptprogramm



sub taste                      ' Routine die Tastendruck abwartet.
  a$=inkey$
  locate 24,69
  color 8,0,0
  print"- taste -";
 mark:
  if inkey$ = "" then mark
  color 7,0,0
  locate 24,69
  print"          ";
end sub



sub Emblem                     ' Schreibt Emblem
  color 4,6,0
  print"Ŀ"
  print" Dragon - World "
  print""
  color 7,0,0
end sub


sub Freesoft                   ' Freesoft - Bestimmungen fr Dragon-World
  cls
  call Emblem
  print
  print"Dieses Programm wurde mit Turbo Basic compiliert. Das dazugehrige"
  print"Basic-Quell-Programm ist ebenfalls auf dieser Diskette, es ist aus-"
  print"fhrlich erlutert um qualifizierte nderungen jedem User zu er-"
  print"mglichen !"
  color 15,0,0
  print"Dieses Programm darf frei copiert und weitergegeben werden unter"
  print"den folgenden Bedingungen :" :color 7,0,0
  print
  print"   Auf die Software darf kein Preis erhoben werden , im"
  print"    Klartext : Dragon-World darf nur KOSTENLOS weitergegeben werden !"
  print
  print"   Bei diesem Programm ist von mir die Mglichkeit untersttzt"
  print"    worden, das Original-Listing von Dragon-World zu verndern, oder"
  print"    nach eigenen Vorstellungen zu verbessern ."
  print"    Jeder der meint er hat es ntig (oder braucht es...) wird dann"
  print"    seinen Namen in die Copyright-Zeile propfen !!"
  print"    (Trittbrettfahrer wird es immer geben !)"
  print"    Aber auch dann bitte (!) ich darum - so FAIR zu sein -"
  print"    und die modifizierte Version als Free-soft zu deklarieren !!!"
  call taste
end sub


sub Anfangsbild                ' Erffnungsbild des Programms
  cls
  color 4,0,0
  print
  print"        "
  print"      ۻĻ_"
  print"        ___"
  print"       "
  print"                 ";:color 15,4,0 :print"   D R A G O N - W O R L D  "
  color 4,0,0
  print"         "
  print"    ļ"
  print"   "
  color 7,0,0
  locate 13,1
  print "Dieses Strategiespiel ist fr 2 Personen !"
  print "Es luft auf einem IBM-PC oder Kompatiblen mit einer EGA - Karte ."
  print "(Sollte diese nicht CGA - Abwrtskompatibel sein so ndern Sie bitte"
  print "die Addresse des Bildschirmspeichers im ASCII-Basic-Listing.)"
  color 15,0,0
  print :print
  print "              Dieses Programm zhlt zur Free-software"
  color 6,0,0
  print :print
  print "          copyright by Markus Woitzik  ,  Mrz 1988  /  Bonn"
  print "                           - Version 3.30 -"
  call taste
end sub


Dimensionieren:
  dim Landschaft(76,17)
  dim Motivation(2,26) , Anzahl(2,26) , Kampfst(2,26) , ascii(2,26)
  dim PositionX(2,26) , PositionY(2,26) , Namen$(2,26) , Darunter(2,26)
  dim Satz$(18) , Zug$(2,26,10) , Umgebung(2) , Feldherr(2)
  dim MEndMot(2,56),EndAnz(2,56),EndStadt(2,56)
  ton$=" a5 a15 a19 a4 f13 a+15 o4 c8 c20 c20 c3"
  Attake$=" g6 b18 g20 b8 b16 o4 d6 d15 g4"
return


sub Rahmen
  color 8,0,0
  locate 3,2:print"Ŀ"
  for i=4 to 18
  locate i,2:print"                                                                           "
  next i
  locate 19,2:print""
  call Weltloeschen
end sub


unro1:
  if peek(Posx*2 + Posy*160)<>250 then return
  Poke Posx*2+1 + Posy*160 , 0
  poke Posx*2 + Posy*160 , 32
return


TruppenPosi:                   ' definier Anfangsposition der Armeen fr
  for i=1 to 2                                                     ' Genesis
    for zz=1 to 26
      PositionX(i,zz) = 2
      PositionY(i,zz) = 3
  next zz,i
return


sub Weltloeschen               ' Lschroutine fr Spielfeld
  def seg = &hb800             ' Bildschirmanfangsaddresse fr CGA
  for Posy=3 to 17
    for Posx=2 to 76
      poke Posx*2+1 + Posy*160 , 0
  next Posx,Posy
end sub


Makerot:                       ' Frbt alle andere Stdte bis auf neue
  RHptstgew = RHptstgew + 1                      ' Hauptstadt dunkelrot
  Speicher = Spieler
  Speicher1= Truppe
  for Spieler = 1 to 2
    for Truppe = 1 to 26
      if Anzahl(Spieler,Truppe) > 0 then gosub WegArmee
  next Truppe,Spieler
  for i3=3 to 17
    for i4=2 to 76
      if peek(i4*2 + i3*160)=219 and peek(i4*2+1 + i3*160)=12 then _
         poke i4*2+1 + i3*160 , 4
  next i4,i3
  poke (PositionX(1,1)+RichtungX)*2+1 + (PositionY(1,1)+RichtungY)*160 , 12
  for Spieler = 1 to 2
    for Truppe = 1 to 26
      if Anzahl(Spieler,Truppe) > 0 then gosub HinArmee
  next Truppe,Spieler
  Spieler= Speicher
  Truppe = Speicher1
return


Makeblau:                      ' Frbt alle blauen Stdte bis auf neue
  BHptstgew = BHptstgew + 1                         ' Hauptstadt dunkelblau
  Speicher = Spieler
  Speicher1= Truppe
  for Spieler = 1 to 2
    for Truppe = 1 to 26
      if Anzahl(Spieler,Truppe) > 0 then gosub WegArmee
  next Truppe,Spieler
  for i3=3 to 17
    for i4=2 to 76
      if peek(i4*2 + i3*160)=219 and peek(i4*2+1 + i3*160)= 9 then _
         poke i4*2+1 + i3*160 , 1
  next i4,i3
  poke (PositionX(2,1)+RichtungX)*2+1 + (PositionY(2,1)+RichtungY)*160 , 9
  for Spieler = 1 to 2
    for Truppe = 1 to 26
      if Anzahl(Spieler,Truppe) > 0 then gosub HinArmee
  next Truppe,Spieler
  Spieler= Speicher
  Truppe = Speicher1
return


Zaubern:                          ' Zauberroutine fr Magier
  def seg = &hb800                ' Bildschirmanfangsaddresse fr CGA
  if Spieler=1 then color 0,4,0
  if Spieler=2 then color 0,1,0
  locate 20,2 :print"** MAGIE ** (j/n) ";
  input b$
  if b$="j" then Zau1
 return
 Zau1:
  if Spieler=1 then color 4,0,0
  if Spieler=2 then color 1,0,0
  locate 22,2 :print " w = Wald  / g = Gebirge / n = normal"
  locate 23,2 :print " (Mit 8 - 4 - 2 - 6 wird der Cursor gesteuert / evtl. Num Lock umschalten)";
  Posix=2
  Posiy=3
 Zau11:
  aa = peek(Posix*2 + Posiy*160)
  a2 = peek(Posix*2+1 + Posiy*160)

 Zau2:
  poke Posix*2+1 + Posiy*160 , 13
  poke Posix*2 + Posiy*160 , 248
  aa$=inkey$
  if aa$="" then Zau2
  if aa$="8" and Posiy>3 then gosub Zau4 :Posiy = Posiy - 1 :gosub Zau5
  if aa$="2" and Posiy<17 then gosub Zau4 :Posiy = Posiy + 1 :gosub Zau5
  if aa$="4" and Posix > 2 then gosub Zau4 :Posix = Posix - 1 :gosub Zau5
  if aa$="6" and Posix < 76 then gosub Zau4 :Posix = Posix + 1 :gosub Zau5
  if aa$="w" and aa = 32 then poke Posix*2+1 + Posiy*160,2 :_
     poke Posix*2 + Posiy*160,219 :call TextDel :return
  if aa$="g" and aa = 32 then poke Posix*2+1 + Posiy*160,6 :_
     poke Posix*2 + Posiy*160,219 :call TextDel :return
  if aa$="n" and a2 = 2 then_
     poke Posix*2 + Posiy*160,32 :poke Posix*2+1 + Posiy*160,0 :call TextDel :return
  if aa$="n" and a2 = 6 then_
     poke Posix*2 + Posiy*160,32 :poke Posix*2+1 + Posiy*160,0 :call TextDel :return
  goto Zau2


Zau4:
  poke Posix*2 + Posiy*160 , aa
  poke Posix*2+1 + Posiy*160 , a2
return

Zau5:
  aa = peek(Posix*2 + Posiy*160)
  a2 = peek(Posix*2+1 + Posiy*160)
return


Landles:                       ' liest die Spielweltdaten in Landschaft() ein
  for Posy=3 to 17
    for Posx=2 to 76
      Landschaft(Posx,Posy) = peek(Posx*2+1 + Posy*160)
  next Posx,Posy
return


Landaufbau:                    ' poked Spielwelt in Rahmen
  for Posy=3 to 17
    for Posx=2 to 76
      if Landschaft(Posx,Posy) <> 0 then poke Posx*2+1 + Posy*160 ,_
         Landschaft(Posx,Posy) :poke Posx*2 + Posy*160 , 219
  next Posx,Posy
return


HinArmee:                      ' setzt eine Armee auf ihre neue Position
  Darunter(Spieler,Truppe) = peek (PositionX(Spieler,Truppe)*2+1 +_
                             PositionY(Spieler,Truppe)*160)
  if Spieler = 1 then a = 12
  if Spieler = 2 then a = 9
  poke PositionX(Spieler,Truppe)*2+1 + PositionY(Spieler,Truppe)*160 , a
  poke PositionX(Spieler,Truppe)*2 + PositionY(Spieler,Truppe)*160 ,_
       ascii(Spieler,Truppe)
return


WegArmee:                      ' lscht Armee auf alter Position
  poke PositionX(Spieler,Truppe)*2+1 + PositionY(Spieler,Truppe)*160 ,_
       Darunter(Spieler,Truppe)
  if Darunter(Spieler,Truppe) <> 0 then poke PositionX(Spieler,Truppe)*2 +_
       PositionY(Spieler,Truppe)*160 , 219 : return
  poke PositionX(Spieler,Truppe)*2 + PositionY(Spieler,Truppe)*160 , 32
return


sub TextDel                    ' lscht das Textfenster (letzten Zeilen)
  color 7,0,0
  for i=20 to 23 :locate i,1
    print"                                                                                ";
  next i
  locate 24,1
    print"                                                                               ";
end sub


Zuegeloeschen:                 ' lscht gesamten Zge aller Armeen
  for i=1 to 2
    for zz=1 to 26
      for a=1 to 10
        Zug$(i,zz,a) = "0"
  next a,zz,i
return


ClearTr:                       ' lscht kurzzeitig alle Armeen vom Spielfeld
  Speicher = Spieler
  Speicher1= Truppe
  for Spieler = 1 to 2
    for Truppe = 1 to 26
      if Anzahl(Spieler,Truppe) > 0 then gosub WegArmee
  next Truppe,Spieler
  call taste
  for Spieler = 1 to 2
    for Truppe = 1 to 26
      if Anzahl(Spieler,Truppe) > 0 then gosub HinArmee
  next Truppe,Spieler
  Spieler= Speicher
  Truppe = Speicher1
return


sub Rasteron                   ' baut Punktraster auf
  for i=3 to 17
    for zz=2 to 76
      if peek( zz*2 + i*160) = 32 then poke zz*2+1 + i*160,8 :_
         poke zz*2 + i*160 , 250
  next zz,i
end sub


sub Rasteroff                  ' lscht Punktraster wieder
  for i=3 to 17
    for zz=2 to 76
      if peek( zz*2 + i*160) = 250 then poke zz*2+1 + i*160,0 :_
         poke zz*2 + i*160 , 32
  next zz,i
end sub


Maske:                         ' Eingabemaske fr Armeebewegungen
  if Anzahl(Spieler,Truppe)=0 then return
  color 6,0,0
  locate 20,2 :print"Truppe                       Mot. Anz."
  locate 21,2 :print"Ĵ"
  locate 22,2 :print"                                      "
  color 15,0,0
  locate 22,3 :print Namen$(Spieler,Truppe)
  locate 22,33 :print using "##.#" ; Motivation(Spieler,Truppe)
  locate 22,39 :print Anzahl(Spieler,Truppe)
  color 8,0,0
  locate 20,45 :print"Ŀ"
  locate 21,45 :print" "
  locate 22,45 :print""
  if Spieler=1 then color 28,0,0
  if Spieler=2 then color 25,0,0
  locate 21,46 :print chr$(ascii(Spieler,Truppe))
  color 8,0,0
  locate 24,1 :print"1=clear-Truppen / 2=Raster ein / 3=Raster aus / 4=nochmal eingeben";
  for zz=1 to 7
    gosub WegArmee :delay(0.1) :gosub HinArmee :delay(0.1)
  next zz
  if Jahr=4 then Mas2
 Mas1:
  color 6,0,0
  locate 20,60 :print"12345"
  locate 21,60 :print"     "
  locate 22,60 :print"(N-S-W-O-0)"
 Mas11:
  for a1=1 to 5
 Mas12:
  a$=inkey$
    if a$="" then Mas12
    if a$="n" then Zug$(Spieler,Truppe,a1) = a$ :goto Mas13
    if a$="s" then Zug$(Spieler,Truppe,a1) = a$ :goto Mas13
    if a$="w" then Zug$(Spieler,Truppe,a1) = a$ :goto Mas13
    if a$="o" then Zug$(Spieler,Truppe,a1) = a$ :goto Mas13
    if a$="0" then Zug$(Spieler,Truppe,a1) = a$ :goto Mas13
    if a$="1" then gosub ClearTr
    if a$="2" then call Rasteron
    if a$="3" then call Rasteroff
    if a$="4" then Mas1
  goto Mas12
 Mas13:
    z=59 + a1*2
    if Spieler=1 then color 12,0,0
    if Spieler=2 then color 9,0,0
    locate 21,z :print a$
    next a1
return
 Mas2:
    color 6,0,0
    locate 20,58 :print"1234567890"
    locate 21,58 :print"          "
    locate 22,58 :print"(N-S-W-O-0)"
 Mas21:
    for a1=1 to 10
 Mas22:
    a$=inkey$
    if a$="" then Mas22
    if a$="n" then Zug$(Spieler,Truppe,a1) = a$ :goto Mas23
    if a$="s" then Zug$(Spieler,Truppe,a1) = a$ :goto Mas23
    if a$="w" then Zug$(Spieler,Truppe,a1) = a$ :goto Mas23
    if a$="o" then Zug$(Spieler,Truppe,a1) = a$ :goto Mas23
    if a$="0" then Zug$(Spieler,Truppe,a1) = a$ :goto Mas23
    if a$="1" then gosub ClearTr
    if a$="2" then call Rasteron
    if a$="3" then call Rasteroff
    if a$="4" then Mas2
    goto Mas22
 Mas23:
    z=57 + a1*2
    if Spieler=1 then color 12,0,0
    if Spieler=2 then color 9,0,0
    locate 21,z :print a$
 next a1
return


Daten:                         ' liest feste Armee-Daten in Variablen ein
  for i=1 to 2
    restore
    for zz=1 to 26
      read Kampfst(i,zz)
      read ascii(i,zz)
      read namen$(i,zz)
  next zz,i
  data 30,147,"Knig & seine Leibwache"
  data 27,233,"Magier & seine Druiden"
  data 23,157,"General & seine Hauptleute"
  data 20,97,"Bogenschtzen"
  data 20,98,"Bogenschtzen"
  data 20,99,"Bogenschtzen"
  data 24,100,"Ritter"
  data 24,101,"Ritter"
  data 14,102,"Soldaten"
  data 14,103,"Soldaten"
  data 14,104,"Soldaten"
  data 14,105,"Soldaten"
  data 14,106,"Soldaten"
  data 14,107,"Soldaten"
  data 14,108,"Soldaten"
  data 35,240,"Drachen"
  data 16,109,"Schwertkmpfer"
  data 16,110,"Schwertkmpfer"
  data 16,111,"Schwertkmpfer"
  data 16,112,"Schwertkmpfer"
  data 19,113,"Wache Morgenstern"
  data 19,114,"Wache Morgenstern"
  data 16,115,"Wache Speer"
  data 16,116,"Wache Speer"
  data 18,246,"Wache Rammbock"
  data 20,195,"Wache Armbrust"
return


Genesis:                       ' Routine zum Neuschpfen von Spielen & Welten
  cls
  color 15,4,8
  locate 5,20 :print " User - Genesis - Routine "
  color 14,0,0
  print
  print"In dieser Routine erschaffen Sie sich eine neue Drachenwelt , neue"
  print"Armeen , Stdte und deren Geschichte !"
  print
  print"Es wird in folgenden Schritten verfahren :"
  print
  print"      - Drachenwelt erschaffen"
  print"      - Armeen bestimmen"
  print"      - Armeen positionieren"
  print"      - Story schreiben (max. 18 Zeilen !)"
  call taste
  color 7,0,0
  cls : color 14,0,0 :print "Drachenwelt erschaffen :"
  call Rahmen
  color 7,0,0
  locate 20,10 :print"w = Wald           g = Gebirge                ";
  color 15,0,0 :print" (0 = Ende)":color 7,0,0
  locate 21,10 :print"r = rote Stadt     b = blaue Stadt";
  color 3,0,0:print"             Cursorsteuerung:" :color 7,0,0
  locate 22,10 :print"- = rote Hauptst.  + = blaue Hauptst.";
  color 3,0,0:print"          8 - 4 - 2 - 6":color 11,0,0
  locate 23,10 :print"lschen : drberfahren !";
  color 3,0,0:print"                       (Num Lock umschalten)";:color 7,0,0
  Posx=2 :Posy=3
 Label2:
  def seg = &hb800             ' Bildschirmanfangsaddresse fr CGA
  Farbwert = -1
  a$=inkey$
  if a$="" then Label2
  gosub unro1
  if a$ = "8" then Posy=Posy-1 :if Posy<3 then Posy=3
  if a$ = "4" then Posx=Posx-1 :if Posx<2 then Posx=2
  if a$ = "2" then Posy=Posy+1 :if Posy>17 then Posy=17
  if a$ = "6" then Posx=Posx+1 :if Posx>76 then Posx=76
  if a$ = "w" then Farbwert=2
  if a$ = "g" then Farbwert=6
  if a$ = "r" then Farbwert=4
  if a$ = "b" then Farbwert=1
  if a$ = "-" then Farbwert=12
  if a$ = "+" then Farbwert=9
  if a$ = "0" then Label3
  poke Posx*2+1 + Posy*160 , 7
  poke Posx*2 + Posy*160 , 250
  if Farbwert = -1 then Label2
  Poke Posx*2+1 + Posy*160 , Farbwert
  poke Posx*2 + Posy*160 , 219
  goto Label2
 Label3:
  gosub unro1
  color 7,0,0
  gosub Landles
  gosub Daten
 Label7:
  cls
  print"Sie bestimmen nun die Anfangsmotivation und die Anfangsstrke"
  print"der Armeen."
  print
  color 14,0,0
  print :print
  print"Truppeninitialisierung :" :color 6,0,0
  print
  print"(Motivation :  1 -  10 /    10=Maximum )"
  print"(Anzahl     :  1 - 100 /   100=Maximum )"
  print"(Kampfstrke: 10 -  35 /zur Information)"
  for i=1 to 2
    for zz=1 to 26
    color 6,0,0
    locate 14,1
    print
    print"    Truppe                      Motivation  Anzahl      Kampfstrke"
    print"   "
    print"                                                                   "
    if i=1 then color 4,0,0
    if i=2 then color 1,0,0
    locate 17,5 :print Namen$(i,zz)
    locate 17,61 :print Kampfst(i,zz)
   Label4:
    locate 17,34 :input Motivation(i,zz)
    if Motivation(i,zz)<1 or Motivation(i,zz)>10 then Label4
   Label5:
    locate 17,47 :input Anzahl(i,zz)
    if Anzahl(i,zz)<1 or Anzahl(i,zz)>100 then Label5
    next zz,i
   Label6:
    locate 20,1 :color 7,0,0
    print "Sind Ihre Eingaben vollstndig korrekt (j/n) ";
    input a$
    if a$="n" then Label7
    if a$="j" then Label8
    goto Label6
   Label8:
    cls
    gosub TruppenPosi
    color 14,0,0 :print"Armeen positionieren :"
    call Rahmen
    gosub Landaufbau
    color 15,4,0 :locate 2,10
    print"Vom Einsetztfeld runtergehen / berschreiten Sie keine anderen Armeen";
    color 3,0,0
    locate 20,3 :print "Mit dem Cursor 8 - 4 - 2 - 6"
    locate 21,3 :print "Armee positionieren (evtl."
    locate 22,3 :print "Num Lock umschalten) !" :color 11,0,0
    locate 24,3 :print "Mit Enter speichern & nchste Armee positionieren.";
    for Spieler=1 to 2
      for Truppe=1 to 26
      gosub HinArmee
   Label9:
        a$ = inkey$
        if a$ = "" then Label9
        if a$ = "8" then gosub WegArmee :PositionY(Spieler,Truppe) = PositionY(Spieler,Truppe) - 1 :_
                if PositionY(Spieler,Truppe) < 3 then PositionY(Spieler,Truppe) = 3
        if a$ = "4" then gosub WegArmee :PositionX(Spieler,Truppe) = PositionX(Spieler,Truppe) - 1 :_
                if PositionX(Spieler,Truppe) < 2 then PositionX(Spieler,Truppe) = 2
        if a$ = "2" then gosub WegArmee :PositionY(Spieler,Truppe) = PositionY(Spieler,Truppe) + 1 :_
                if PositionY(Spieler,Truppe) > 17 then PositionY(Spieler,Truppe) = 17
        if a$ = "6" then gosub WegArmee :PositionX(Spieler,Truppe) = PositionX(Spieler,Truppe) + 1 :_
                if PositionX(Spieler,Truppe) > 76 then PositionX(Spieler,Truppe) = 76
        gosub HinArmee
    if a$ = chr$(13) then next Truppe,Spieler :goto Label10
    goto Label9
   Label10:
    call TextDel
    locate 21,1 :color 7,0,0
    print" nochmal (j/n) ";
    input a$
    if a$ = "j" then Label8
    if a$ = "n" then Label11
    goto Label10
   Label11:
    cls
    color 14,0,0 :print"Die Einleitungsstory schreiben :"
    color 7,0,0
    print
    print"(Sie mssen insgesamt 18 Zeilen schreiben mit max. 70 Zeichen)"
    for i=5 to 23
      color 14,6,0
     again:
      locate i,3 :print"                                                                    "
      locate i,1 :line input Satz$(i-5)
      if len(Satz$(i-5))>70 then again
    next i
   Label12:
    locate 24,2
    color 7,0,0
    print"nochmal (j/n) ";
    input a$
    if a$ = "j" then Label11
    if a$ = "n" then Label13
    goto Label12
   Label13:
    cls
    call Emblem
    color 14,0,0
    print :print
    print "Bitte geben Sie nun den Namen des Files ein ,"
    print "(ohne das Suffix .drw)  : ";
    input na$
    if len(na$)>8 then Label13

    open "o",#1,na$+".drw"     ' Abspeichern der SpielDaten auf Diskette
    for i=1 to 2
      for zz=1 to 26
        write #1 , Motivation(i,zz) , Anzahl(i,zz) , Kampfst(i,zz) , ascii(i,zz)
        write #1 , PositionX(i,zz) , PositionY(i,zz) , Namen$(i,zz)
        write #1 , Darunter(i,zz)
    next zz,i
    for i = 0 to 18
      write #1 , Satz$(i)
    next i
    for zz = 1 to 17
      for i = 1 to 76
        write #1 , Landschaft(i,zz)
    next i,zz
    close #1
    cls
 return


Hauptprogramm:                     ' Beginn des Hauptprogramms  * * * * * * *

  call piccop : screen 0
  gosub Dimensionieren
  call Anfangsbild
  call Freesoft
  cls
 Label1:                       ' Startmen
  call Emblem
  locate 10,20 :print" 1 = Erklrung"
  locate 11,20 :print" 2 = User - Genesis - Routine"
  locate 12,20 :print" 3 = Spielbeginn"
  locate 13,20 :print" 4 = Altes Spiel"
  locate 15,21 :input a1
  if a1<1 or a1>4 then Label1
  if a1=1 then call Erklaerung
  if a1=2 then gosub Genesis
  if a1=3 then Start
  if a1=4 then Reinloaden
  goto Label1


Start:                          ' Spielbeginn

  cls
   call Emblem
   color 15,0,0
   print
   print "Whlen Sie Ihr Spiel : ":color 7,0,0 :print :print"Files -"
   files "*.drw"
   color 14,0,0
   print :print
   print "Bitte geben Sie nun den Namen des Files ein ,"
   print "(ohne das Suffix .drw)  : ";
   input na$
   if len(na$)>8 then na$=right$(na$,8)
   print
   print "Eingabe der Verzgerung fr die Blinksequenz vor dem Bewegen"
   print "der Truppen ,[sec.] (0.3:normal) ";
   input mpause
   if mpause > 1 then mpause = 1
   Spielrunde = 0
   gosub Nameneingabe

   open "i",#1,na$+".drw"      ' Einlesen der Spieldaten von Diskette
   for i=1 to 2
     for zz=1 to 26
       input #1 , Motivation(i,zz) , Anzahl(i,zz) , Kampfst(i,zz) , ascii(i,zz)
       input #1 , PositionX(i,zz) , PositionY(i,zz) , Namen$(i,zz)
       input #1 , Darunter(i,zz)
   next zz,i
   for i = 1 to 18
     input #1 , Satz$(i)
   next i
   for zz = 1 to 17
     for i = 1 to 76
       input #1 , Landschaft(i,zz)
   next i,zz
   close #1
    for zz=1 to 26
      RAnfst = RAnfst + Anzahl(1,zz)
      BAnfst = BAnfst + Anzahl(2,zz)
    next zz
   screen 0
   cls
   print"The Story :" :print :print :color 6,0,0
   for i=0 to 18 :print Satz$(i) :next i
   call taste
   color 8,0,0
  Aufbau:
   cls
   def seg = &hb800            ' Bildschirmanfangsaddresse fr CGA
   call Rahmen
   call Weltloeschen
   gosub Landaufbau
   call taste
   for Spieler = 1 to 2
     for Truppe = 1 to 26
       if Anzahl(Spieler,Truppe) > 0 then gosub HinArmee
   next Truppe,Spieler
   Jahr = 0

  Bewegungen:                  ' Bewegungsausfhrung der Befehle
   Jahr = Jahr + 1
   if Jahr = 5 then Jahr = 1
   color 8,0,0
   locate 1,2 :print"Mondjahr":if Jahr=1 then color 15,7,0:locate 1,2:print"Mondjahr":color 8,0,0
   locate 1,21:print"Mondjahr":if Jahr=2 then color 15,7,0:locate 1,21:print"Mondjahr":color 8,0,0
   locate 1,41:print"Mondjahr":if Jahr=3 then color 15,7,0:locate 1,41:print"Mondjahr":color 8,0,0
   locate 1,61:print"Sonnenjahr":if Jahr=4 then color 14,7,0:locate 1,61:print"Sonnenjahr"
   call TextDel
   color 15,7,0
   locate 21,2 :print" Truppenorder / Bewegung "
   gosub Zuegeloeschen
   Spielrunde = Spielrunde + 1
   gosub Datensich
   gosub Absaven
   for Spieler = 1 to 2
     locate 21,2
     if Spieler = 1 then color 15,4,0 :print" Der rote Knig gibt nun seine Order ! "
     if Spieler = 2 then color 15,1,0 :print" Der blaue Knig gibt nun seine Order ! "
     call Rasteroff
     beep :delay(0.5):beep
     call taste
   for Truppe = 1 to 26
   call TextDel
   if Anzahl(Spieler,Truppe) = 0 then Weiter
   gosub Maske
  Weiter:
   next Truppe
   call TextDel
   next Spieler
  Kampfphase:                  ' Beginn der Kampfphase
   def seg = &hb800            ' Bildschirmanfangsaddresse fr CGA
   call TextDel
   color 15,7,0 :locate 21,2
   print " K A M P F P H A S E "
   call Rasteroff
   call taste
   call TextDel

  Fahne1:
   Wert = 5
   if Jahr = 4 then Wert = 10

   for Runde = 1 to Wert
   for Truppe = 1 to 26

   check=1
   if int(rnd*2+1) = 1 then Spieler=1 :goto Naechster
   Spieler=2

  Naechster:
   call TextDel
   RichtungX = 0
   RichtungY = 0
   if Anzahl(Spieler,Truppe)=0 then :goto End1
   i2=0
   for i1=1 to Wert
     if Zug$(Spieler,Truppe,i1) = "0" then i2=i2+1
   next i1
   if i2 = Wert and Runde = 1 and Motivation(Spieler,Truppe) < 9.9 then_
           Motivation(Spieler,Truppe) = Motivation(Spieler,Truppe) + 0.25
   if i2 = Wert and Truppe = 2 and Runde = 1 then gosub Zaubern

   gosub WegArmee :delay(mpause):gosub HinArmee
   delay(mpause):gosub WegArmee
   delay(mpause):gosub HinArmee
   delay(mpause):gosub WegArmee :delay(mpause):gosub HinArmee

   if Zug$(Spieler,Truppe,Runde) = "0" then Ende
  Verlauf:
   if Zug$(Spieler,Truppe,Runde) = "n" and PositionY(Spieler,Truppe) > 3 then_
      RichtungY = -1
   if Zug$(Spieler,Truppe,Runde) = "s" and PositionY(Spieler,Truppe) < 17 then_
      RichtungY = 1
   if Zug$(Spieler,Truppe,Runde) = "w" and PositionX(Spieler,Truppe) > 2 then_
      RichtungX = -1
   if Zug$(Spieler,Truppe,Runde) = "o" and PositionX(Spieler,Truppe) < 76 then_
      RichtungX = 1

   if peek ((PositionX(Spieler,Truppe)+RichtungX)*2 +_
            (PositionY(Spieler,Truppe)+RichtungY)*160) = 32 then Ende
   if peek ((PositionX(Spieler,Truppe)+RichtungX)*2 +_
            (PositionY(Spieler,Truppe)+RichtungY)*160) = 219 then Fahne2
   gosub Kampf
   goto Ende

  Fahne2:                      ' Untergrundcheck
   if peek ((PositionX(Spieler,Truppe)+RichtungX)*2+1 +_
            (PositionY(Spieler,Truppe)+RichtungY)*160) = 2 then Wald
   if peek ((PositionX(Spieler,Truppe)+RichtungX)*2+1 +_
            (PositionY(Spieler,Truppe)+RichtungY)*160) = 6 then Gebirge
   if peek ((PositionX(Spieler,Truppe)+RichtungX)*2+1 +_
            (PositionY(Spieler,Truppe)+RichtungY)*160) = 4 then RStadt
   if peek ((PositionX(Spieler,Truppe)+RichtungX)*2+1 +_
            (PositionY(Spieler,Truppe)+RichtungY)*160) = 1 then BStadt
   if peek ((PositionX(Spieler,Truppe)+RichtungX)*2+1 +_
            (PositionY(Spieler,Truppe)+RichtungY)*160) = 12 then HRStadt
   if peek ((PositionX(Spieler,Truppe)+RichtungX)*2+1 +_
            (PositionY(Spieler,Truppe)+RichtungY)*160) = 9 then HBStadt
   beep : beep : stop

  Tod:                         ' Anzahl Armee < 0
   sound 700,10 :sound 600,10 :sound 500,10 :sound 400,10 :sound 300,10
   call TextDel
   if Spieler=1 then color 12,0,0
   if Spieler=2 then color 9,0,0
   zz = int(rnd*8+1)
   if zz=1 then aa$="abgenippelt ."
   if zz=2 then aa$="dahingerafft ."
   if zz=3 then aa$="krepiert ."
   if zz=4 then aa$="ausgelscht ."
   if zz=5 then aa$="ausgetilgt ."
   if zz=6 then aa$="weggemetzelt ."
   if zz=7 then aa$="gestorben ."
   if zz=8 then aa$="vernichtend geschlagen ."
   locate 22,2 :print "Ihre Truppe : ";Namen$(Spieler,Truppe);" ist ";aa$
   if Spieler=1 then color 4,0,0
   if Spieler=2 then color 1,0,0
   locate 24,2 :print "  um ";time$; "Uhr";
   gosub WegArmee
   call taste
 return


  Wald:                        ' Truppe in Waldgebiet gelaufen
   if Truppe = 16 then Ende
   if int(rnd*10+1) > 3 then Ende
   if Spieler=1 then color 12,0,0
   if Spieler=2 then color 9,0,0
   locate 20,2 :print "Botschaft fr den Knig :"
   color 15,2,0
   if int(rnd*3+1) = 1 then Wald1
   for i=1 to 10
     i1 = int(rnd*100)
     sound 60+i1,3
   next i
   locate 22,2 :print "Truppe  : ";Namen$(Spieler,Truppe);" hat sich verlaufen !"
   i = int(rnd*4+1)
   if i=1 then Zug$(Spieler,Truppe,Runde) = "n"
   if i=2 then Zug$(Spieler,Truppe,Runde) = "s"
   if i=3 then Zug$(Spieler,Truppe,Runde) = "o"
   if i=4 then Zug$(Spieler,Truppe,Runde) = "w"
   delay(5)
   goto Verlauf
  Wald1:
   for i=1 to 20
     i1 = int(rnd*1000)
     i2 = int(rnd*3+1)
     sound 4000+i1,i2
   next i
   locate 22,2
   i = int(rnd*5+1)
   print "Truppe  : ";Namen$(Spieler,Truppe);" hat ";i;" Mann verloren !!"
   Anzahl(Spieler,Truppe) = Anzahl(Spieler,Truppe) - i
   if Anzahl(Spieler,Truppe) <= 0 then Anzahl(Spieler,Truppe) = 0 : gosub Tod :goto End1
   delay(5)
goto Ende

  Gebirge:                     ' Truppe in Gebirge gelaufen
   if Truppe = 16 then Ende
   if int(rnd*3+1) > 1 then Ende
   if Spieler=1 then color 12,0,0
   if Spieler=2 then color 9,0,0
   locate 20,2 :print "Botschaft fr den Knig :"
   sound 100,10
   sound 120,10
   sound 110,12
   color 15,6,0
   locate 22,2 :print "Truppe  : ";Namen$(Spieler,Truppe);" kommt nicht voran !"
   delay(5)
   RichtungX = 0
   RichtungY = 0
goto Ende

  RStadt:                      ' Truppe in rote Stadt gelaufen
   if Spieler=1 and Truppe=1 then gosub Makerot
   if Spieler=1 then Ende
   BAngriffeSt = BAngriffeSt + 1
   if int(rnd*4+1) < 2 then RStadt1
   play"o3 x" + varptr$(ton$)
   color 9,0,0 :locate 20,2 :print "Botschaft fr den Knig : "
   locate 22,2 :print "Die Stadt ist erobert , geplndert  und ausgeraubt worden !"
   locate 23,2 :print "Die blaue Fahne, mein Gebieter, weht auf allen Zinnen !"
   delay(5.3)
   for zz=1 to 26
     Motivation(1,zz) = Motivation(1,zz) - 1 :if Motivation(1,zz) < 0 then_
     Motivation(1,zz) = 0
     Motivation(2,zz) = Motivation(2,zz) + 1 :if Motivation(2,zz) > 10 then_
     Motivation(2,zz) = 10
   next zz
   poke (PositionX(Spieler,Truppe)+RichtungX)*2+1 +_
        (PositionY(Spieler,Truppe)+RichtungY)*160 , 1
goto Ende
  RStadt1:
   sound 100,30
   color 9,0,0 :locate 20,2 :print "Botschaft fr den Knig : "
   locate 22,2 :print "Die Stadtmauern hielten dem Angriff stand !"
   delay(5)
   RichtungX = 0
   RichtungY = 0
goto Ende


  BStadt:                      ' Truppe in blau Stadt gelaufen
   if Spieler=2 and Truppe=1 then gosub Makeblau
   if Spieler=2 then Ende
   RAngriffeSt = RAngriffeSt + 1
   if int(rnd*4+1) < 2 then BStadt1
   play"o3 x" + varptr$(ton$)
   color 12,0,0 :locate 20,2 :print "Botschaft fr den Knig : "
   locate 22,2 :print "Die Stadt ist erobert , geplndert  und ausgeraubt worden !"
   locate 23,2 :print "Die rote Fahne, mein Gebieter, weht auf allen Zinnen !"
   delay(5.3)
   for zz=1 to 26
     Motivation(1,zz) = Motivation(1,zz) + 1 :if Motivation(1,zz) >10 then_
     Motivation(1,zz) = 10
     Motivation(2,zz) = Motivation(2,zz) - 1 :if Motivation(2,zz) < 0  then_
     Motivation(2,zz) = 0
   next zz
   poke (PositionX(Spieler,Truppe)+RichtungX)*2+1 +_
        (PositionY(Spieler,Truppe)+RichtungY)*160 , 4
goto Ende
  BStadt1:
   sound 100,30
   color 12,0,0 :locate 20,2 :print "Botschaft fr den Knig : "
   locate 22,2 :print "Die Stadtmauern hielten dem Angriff stand !"
   delay(5)
   RichtungX = 0
   RichtungY = 0
goto Ende

  HRStadt:                     ' Truppe in Hauptstadt gelaufen
   if Spieler=1 then Ende
   sound 5000,60
   if int(rnd*4+1) < 2 then HRStadt1
   color 31,1,0
   locate 22,2 :print " B L A U   H A T     G E W O N N E N "
   call taste
   gosub Datensich
   goto Beurteilung

  HRStadt1:
   color 9,0,0 :locate 20,2 :print "Botschaft fr den Knig : "
   sound 100,30
   locate 22,2 :print "Die Hauptstadt konnte sich verteidigen !"
   delay(5)
   RichtungX = 0
   RichtungY = 0
goto Ende

  HBStadt:                     ' Truppe in Hauptstadt gelaufen
   if Spieler=2 then Ende
   sound 5000,60
   if int(rnd*4+1) < 2 then HBStadt1
   color 31,4,0
   locate 22,2 :print " R O T     H A T     G E W O N N E N "
   call taste
   gosub Datensich
   goto Beurteilung

  HBStadt1:
   color 12,0,0 :locate 20,2 :print "Botschaft fr den Knig : "
   sound 100,30
   locate 22,2 :print "Die Hauptstadt konnte sich verteidigen !"
   delay(5)
   RichtungX = 0
   RichtungY = 0
goto Ende


Ende:                          ' evtl. Bewegungsausfhrung
  color 7,0,0
  if Anzahl(Spieler,Truppe)=0 then End1
  gosub WegArmee
  PositionX(Spieler,Truppe) = PositionX(Spieler,Truppe) + RichtungX
  PositionY(Spieler,Truppe) = PositionY(Spieler,Truppe) + RichtungY
  gosub HinArmee
End1:                          ' Ende der Runden / der andere Spieler
  if check = 1 and Spieler=1 then Spieler=2 :check = 2:goto Naechster
  if check = 1 and Spieler=2 then Spieler=1 :check = 2:goto Naechster
  next Truppe
  next Runde
goto Bewegungen


Kampf:                         ' Routine der Kamphandlung zweier Armeen
  call TextDel
  if Spieler=1 and peek((PositionX(Spieler,Truppe)+RichtungX)*2+1 +_
     (PositionY(Spieler,Truppe)+RichtungY)*160) = 12  then RichtungX=0 :_
     RichtungY=0 :return
  if Spieler=2 and peek((PositionX(Spieler,Truppe)+RichtungX)*2+1 +_
     (PositionY(Spieler,Truppe)+RichtungY)*160) = 9  then RichtungX=0 :_
     RichtungY=0 :return
  play"o3 x" + varptr$(Attake$)

  if Spieler=1 then Verteidiger=2 :Far = 4 :Far1 = 12 :VFar = 1 :VFar1 = 9
  if Spieler=2 then Verteidiger=1 :Far = 1 :Far1 = 9  :VFar = 4 :VFar1 = 12
  i4 = peek((PositionX(Spieler,Truppe)+RichtungX)*2 +_
           (PositionY(Spieler,Truppe)+RichtungY)*160)
  for i=1 to 26
     if ascii(Verteidiger,i) = i4 then Bedrohte = i
  next i

  for i=1 to 2
    Umgebung(i) = 0 : Feldherr(i) = 0
  next i

  if Darunter(Spieler,Truppe) = 2 then Umgebung(Spieler) = -5
  if Darunter(Spieler,Truppe) = 2 and Truppe = 3 then Umgebung(Spieler) = 5
  if Darunter(Spieler,Truppe) = 2 and Truppe = 16 then Umgebung(Spieler) = 1
  if Darunter(Spieler,Truppe) = 6 then Umgebung(Spieler) = -7
  if Darunter(Spieler,Truppe) = 6 and Truppe = 3 then Umgebung(Spieler) = +7
  if Darunter(Spieler,Truppe) = 6 and Truppe = 16 then Umgebung(Spieler) = 1
  if Darunter(Spieler,Truppe) = 6 and Truppe > 16 and Truppe < 21 then_
     Umgebung(Spieler) = 5
  if Darunter(Spieler,Truppe) = Far then Umgebung(Spieler) = 7
  if Darunter(Spieler,Truppe) = Far1 then Umgebung(Spieler) = 5
  if Darunter(Verteidiger,Bedrohte) = VFar and Truppe=25 then Umgebung(Spieler) = 11
  if Darunter(Verteidiger,Bedrohte) = VFar1 and Truppe=25 then Umgebung(Spieler) = 10
  for i = PositionX(Spieler,Truppe)-1 to PositionX(Spieler,Truppe)+1
  for j = PositionY(Spieler,Truppe)-1 to PositionY(Spieler,Truppe)+1
    if peek(i*2 + j*160) = 147 and peek(i*2+1 + j*160) = Far1 then Feldherr(Spieler)=6
    if peek(i*2 + j*160) = 233 and peek(i*2+1 + j*160) = Far1 then Feldherr(Spieler)=5
    if peek(i*2 + j*160) = 157 and peek(i*2+1 + j*160) = Far1 then Feldherr(Spieler)=7
  next j,i

  if Darunter(Verteidiger,Bedrohte) = 2 then Umgebung(Verteidiger) = -5
  if Darunter(Verteidiger,Bedrohte) = 2 and Bodrohte = 3 then Umgebung(Verteidiger) = 5
  if Darunter(Verteidiger,Bedrohte) = 2 and Bedrohte = 16 then Umgebung(Verteidiger) = 1
  if Darunter(Verteidiger,Bedrohte) = 6 then Umgebung(Verteidiger) = -7
  if Darunter(Verteidiger,Bedrohte) = 6 and Bedrohte = 3 then Umgebung(Verteidiger) = +7
  if Darunter(Verteidiger,Bedrohte) = 6 and Bedrohte = 16 then Umgebung(Verteidiger) = 1
  if Darunter(Verteidiger,Bedrohte) = 6 and Bedrohte > 16 and Bedrohte < 21 then_
     Umgebung(Verteidiger) = 5
  if Darunter(Verteidiger,Bedrohte) = VFar then Umgebung(Verteidiger) = 10 :if_
        Spieler=1 then RAngriffeSt=RAngriffeSt+1 else BAngriffeSt=BAngriffeSt+1
  if Darunter(Verteidiger,Bedrohte) = VFar1 then Umgebung(Verteidiger) = 8 :if_
        Spieler=1 then RAngriffeSt=RAngriffeSt+1 else BAngriffeSt=BAngriffeSt+1
  if Darunter(Spieler,Truppe) = Far and Bedrohte=25 then Umgebung(Verteidiger) = 11
  if Darunter(Spieler,Truppe) = VFar1 and Bedrohte=25 then Umgebung(Verteidiger) = 10
  for i = PositionX(Verteidiger,Bedrohte)-1 to PositionX(Verteidiger,Bedrohte)+1
  for j = PositionY(Verteidiger,Bedrohte)-1 to PositionY(Verteidiger,Bedrohte)+1
    if peek(i*2 + j*160) = 147 and peek(i*2+1 + j*160) = VFar1 then Feldherr(Verteidiger)=6
    if peek(i*2 + j*160) = 233 and peek(i*2+1 + j*160) = VFar1 then Feldherr(Verteidiger)=5
    if peek(i*2 + j*160) = 157 and peek(i*2+1 + j*160) = VFar1 then Feldherr(Verteidiger)=7
  next j,i

  gosub WegArmee : delay(0.1) :gosub HinArmee : delay(0.1) :gosub WegArmee
  delay(0.1) :gosub HinArmee : delay(0.1) :gosub WegArmee :delay(0.1) :gosub HinArmee
  Speicher=Spieler
  Speicher1=Truppe
  Spieler = Verteidiger
  Truppe = Bedrohte
  gosub WegArmee : delay(0.1) :gosub HinArmee :delay(0.1) :gosub WegArmee
  delay(0.1) :gosub HinArmee : delay(0.1) :gosub WegArmee :delay(0.1) :gosub HinArmee
  Spieler = Speicher
  Truppe = Speicher1

  if Spieler = 1 then color 12,0,0
  if Spieler = 2 then color 9,0,0
  locate 20,2 :print"-- ";chr$(ascii(Spieler,Truppe));" --"
  locate 21,2 :print Namen$(Spieler,Truppe)
  locate 22,2
  if Umgebung(Spieler)>0 then print "** Vorteil **"
  if Umgebung(Spieler)<0 then print "++ Nachteil ++"
  locate 23,2
  if Feldherr(Spieler)>0 then print "! Feldherr !"
  locate 24,2 :color 6,0,0
  print"Mot. ";:print using "##.#";Motivation(Spieler,Truppe);
  locate 24,12 :print "Anz. ";Anzahl(Spieler,Truppe);

  if Verteidiger = 1 then color 12,0,0
  if Verteidiger = 2 then color 9,0,0
  locate 20,50 :print"-- ";chr$(ascii(Verteidiger,Bedrohte));" --"
  locate 21,50 :print Namen$(Verteidiger,Bedrohte)
  locate 22,50
  if Umgebung(Verteidiger)>0 then print "** Vorteil **"
  if Umgebung(Verteidiger)<0 then print "++ Nachteil ++"
  locate 23,50
  if Feldherr(Verteidiger)>0 then print "! Feldherr !"
  locate 24,50 :color 6,0,0
  print"Mot. ";:print using "##.#";Motivation(Verteidiger,Bedrohte);
  locate 24,60 :print "Anz. ";Anzahl(Verteidiger,Bedrohte);
  call taste

                               ' Kampfentscheidende Formeln !!
  Angriff= int(Anzahl(Spieler,Truppe)*1.7) + int(Motivation(Spieler,Truppe) * int(rnd*3+13))_
           + Kampfst(Spieler,Truppe) * int(rnd*3+2) + Umgebung(Spieler) * int(rnd*4+3)_
           + Feldherr(Spieler) * 2
  Verteidigung= int(Anzahl(Verteidiger,Bedrohte)*1.7) + int(Motivation(Verteidiger,Bedrohte) * int(rnd*3+13))_
           + Kampfst(Verteidiger,Bedrohte) * int(rnd*3+2) + Umgebung(Verteidiger) * int(rnd*4+3)_
           + Feldherr(Spieler) * 2

  if Verteidigung > Angriff then Verteidigung = Verteidigung + 25
  if Angriff > Verteidigung then Angriff = Angriff + 25

                               'Ergebnis des Kampfes
  color 0,7,0
  locate 20,34 :print"Ŀ"
  locate 21,34 :print"          "
  locate 22,34 :print"          "
  locate 23,34 :print"          "
  locate 24,34 :print"";

  if Verteidigung * 2 < Angriff then Sieg
  if Angriff * 2 < Verteidigung then Sieg

  color 31,7,0
  locate 21,37 :print"REMIS"
  VGefallen = -int(rnd*Motivation(Spieler,Truppe)+1+Motivation(Spieler,Truppe)/2)
  AGefallen = -int(rnd*Motivation(Verteidiger,Bedrohte)+1+Motivation(Spieler,Truppe)/2)
  if Angriff > Verteidigung then VGefallen = VGefallen - 2
  if Verteidigung > Angriff then AGefallen = AGefallen - 2
  if Angriff > Verteidigung and Spieler=1 then locate 22,36 :color 12,7,0: print "*"
  if Angriff > Verteidigung and Spieler=2 then locate 22,36 :color 9,7,0 : print "*"
  if Verteidigung > Angriff and Verteidiger=1 then locate 22,41 :color 12,7,0 :print "*"
  if Verteidigung > Angriff and Verteidiger=2 then locate 22,41 :color 9,7,0 :print "*"
  RichtungX=0
  RichtungY=0
  goto Beenden

 Sieg:
  if Angriff > Verteidigung and Spieler=1 then color 31,4,0 :goto Siegan
  if Angriff > Verteidigung and Spieler=2 then color 25,1,0 :goto Siegan
  goto ZweiterSieg
 Siegan:
  locate 21,36
  if Spieler=1 then print"ROT SIEG" :RSiegTr = RSiegTr + 1
  if Spieler=2 then print"BL. SIEG" :BSiegTr = BSiegTr + 1
  VGefallen = -int(rnd*Motivation(Spieler,Truppe)+8)
  AGefallen = -int(rnd*Motivation(Verteidiger,Bedrohte)+3)
  Motivation(Spieler,Truppe) = Motivation(Spieler,Truppe) + 1
  if Motivation(Spieler,Truppe) > 10 then Motivation(Spieler,Truppe) = 10
  Motivation(Verteidiger,Bedrohte) = Motivation(Verteidiger,Bedrohte) - 1
  if Motivation(Verteidiger,Bedrohte) < 0 then Motivation(Verteidiger,Bedrohte) = 0
  for i=1 to 10
    Zug$(Verteidiger,Bedrohte,i) = "0"
  next i

  GeheX = 0 :GeheY = 0
  if Zug$(Spieler,Truppe,Runde) = "n" and PositionY(Verteidiger,Bedrohte) < 17 then GeheY = 1
  if Zug$(Spieler,Truppe,Runde) = "s" and PositionY(Verteidiger,Bedrohte) > 3 then GeheY = -1
  if Zug$(Spieler,Truppe,Runde) = "o" and PositionX(Verteidiger,Bedrohte) < 76 then GeheX = 1
  if Zug$(Spieler,Truppe,Runde) = "w" and PositionX(Verteidiger,Bedrohte) > 3 then GeheX = -1
  if peek((PositionX(Verteidiger,Bedrohte)+GeheX)*2 +_
     (PositionY(Verteidiger,Bedrohte)+GeheY)*160) <> 32 then _
     RichtungX = 0 :RichtungY = 0 : goto Beenden
  Speicher = Spieler
  Speicher1 = Truppe
  Spieler = Verteidiger
  Truppe = Bedrohte

  Anzahl(Spieler,Truppe) = Anzahl(Spieler,Truppe) + VGefallen
  SpezMarke = 1

  gosub WegArmee
  if Anzahl(Spieler,Truppe)<= 0 then  hierher
  PositionX(Spieler,Truppe) = PositionX(Spieler,Truppe) + GeheX
  PositionY(Spieler,Truppe) = PositionY(Spieler,Truppe) + GeheY
  gosub HinArmee
 hierher:
  Spieler = Speicher
  Truppe = Speicher1
  if int(rnd*4+1) > 1 then Beenden
  for i=1 to 10
    Zug$(Spieler,Truppe,i) = "0"
  next i
  goto Beenden

ZweiterSieg:
  RichtungX=0
  RichtungY=0
  locate 21,36
  if Verteidiger=1 then color 31,4,0 :print"ROT SIEG" :RSiegTr = RSiegTr + 1
  if Verteidiger=2 then color 9,1,0 :print"BL. SIEG" :BSiegTr = BSiegTr + 1
  VGefallen = -int(rnd*Motivation(Spieler,Truppe)+3)
  AGefallen = -int(rnd*Motivation(Verteidiger,Bedrohte)+8)
  Motivation(Spieler,Truppe) = Motivation(Spieler,Truppe) - 1
  if Motivation(Spieler,Truppe) < 0 then Motivation(Spieler,Truppe) = 0
  Motivation(Verteidiger,Bedrohte) = Motivation(Verteidiger,Bedrohte) + 1
  if Motivation(Verteidiger,Bedrohte) > 10 then Motivation(Verteidiger,Bedrohte) = 10
  for i=1 to 10
    Zug$(Spieler,Truppe,i) = "0"
  next i
  if int(rnd*4+1) > 1 then Beenden
  for i=1 to 10
    Zug$(Verteidiger,Bedrohte,i) = "0"
  next i

Beenden:
  if Spieler=1 then color 12,4,0
  if Spieler=2 then color 9,1,0
  locate 23,36 :print AGefallen
  if Verteidiger=1 then color 12,4,0
  if Verteidiger=2 then color 9,1,0
  locate 23,41 :print VGefallen :if SpezMarke=1 then SpezMarke=0 : VGefallen=0
  delay(6)
  Anzahl(Spieler,Truppe) = Anzahl(Spieler,Truppe) + AGefallen
  if Anzahl(Spieler,Truppe) <= 0 then Anzahl(Spieler,Truppe) = 0 :gosub Tod
  Anzahl(Verteidiger,Bedrohte) = Anzahl(Verteidiger,Bedrohte) + VGefallen
  if Anzahl(Verteidiger,Bedrohte) <= 0 then Anzahl(Verteidiger,Bedrohte)=0 :goto KPF1
return
 KPF1:
  Speicher = Spieler
  Speicher1 = Truppe
  Spieler = Verteidiger
  Truppe = Bedrohte
  gosub Tod
  Spieler = Speicher
  Truppe = Speicher1
return

Nameneingabe:
  screen 9,0,0
  color 7
  print :print "Bitte Ihre Herrschernamen eingeben (Max 8 Buchst.) :"
  print
  print :color 8
  print "(Hellblau)"
  draw "BM 100,70 C9 u8 e3 u e f d f4 e4 f4 e4 f4 e4 f4 e4 u e f d f3 d8 l42"
  paint (102,68),1,9
  draw "BM 107,60 e3 r e2 r2 e r3 e r2 f r3 f r2 f2 r f3"
  paint (115,57),8,9
  draw "BM 121,52 u4 BM122,52 u4 Nl3 Nr2 u Nl3 Nr2 Nu2 Bl u2"
  color 7
  locate 5,22
  input blname$

  locate 8,1 :color 8:print "(Hellrot)"
  draw "BM 100,110 C12 u8 e3 u e f d f4 e4 f4 e4 f4 e4 f4 e4 u e f d f3 d8 l42"
  paint (102,108),4,12
  draw "BM 107,100 e3 r e2 r2 e r3 e r2 f r3 f r2 f2 r f3"
  paint (115,97),8,12
  draw "BM 121,92 u4 BM122,92 u4 Nl3 Nr2 u Nl3 Nr2 Nu2 Bl u2"
  color 7
  locate 8,22
  input rtname$

  if len(rtname$)>8 or len(blname$)>8 then Zuviel
return

 Zuviel:
  print :print :color 15
  beep
  print "Nicht mehr als 8 Buchstaben !"
  delay(4):cls
  goto Nameneingabe


Beurteilung:
  if Spielrunde < 2 then end
  screen 9
  cls
  locate 1,3
  color 7
  if Spieler = 1 then color 12:print"Es hat GEWONNEN : King ";rtname$;" I  ";:_
     color 4:print"(rot)"
  if Spieler = 2 then color 9:print"Es hat GEWONNEN : King ";blname$;" I  ";:_
     color 1:print"(blau)"
  color 7
  insgdauer = Spielrunde
  locate 1,58 :print"Dauer :";:color 15:print int(insgdauer);:color 7:_
     print" Runden"
  line (10,30)-(290,160),4,b
  line (310,30)-(590,160),1,b
  color 8
  locate 19,48 :print"Ŀ";
  locate 20,48 :print"      Motivation/Durchschn.";
  locate 21,48 :print"      Gesamtanzahl Truppen ";
  locate 22,48 :print"      Anzahl eigener Stdte";
  locate 23,48 :print"";
  draw"BM 386,275 C12 e4 f e4 f e4"
  draw"BM 397,274 C9 e4 f e4 f e4"
  draw"BM 389,288 C1 e5 f3 e6"
  draw"BM 402,289 C4 e5 f3 e6"
  draw"BM 390,304 C8 u4 r6 d r6 u2 r6 d3 r6 d2 l23"
  paint (392,303),8,8
  line (5,200)-(350,200),8,,&haaaa
  line (50,190)-(50,322),8,,&haaaa
  line (155,190)-(155,322),8,,&haaaa
  draw"BM 57,192 C9 u4 f2 e2 f2 e2 d4 l8"
  paint (58,191),9,9
  draw"BM 164,192 C12 u4 f2 e2 f2 e2 d4 l8"
  paint (165,191),12,12
  locate 14,10 :color 9 :print blname$
  locate 14,24 :color 12 :print rtname$
  color 9
  locate 16,12 :print int(BHptstgew)
  locate 16,25 :color 12:print int(RHptstgew)
    RTote = RAnfst - RGesamtpers
    BTote = BAnfst - BGesamtpers
  locate 18,12 :color 9:print int(BTote)
  locate 18,25 :color 12:print int(RTote)
  locate 20,12 :color 9:print int(BAngriffeSt)
  locate 20,25 :color 12:print int(RAngriffeSt)
  locate 22,12 :color 9:print int(BSiegTr)
  locate 22,25 :color 12:print int(RSiegTr)
  color 6
  locate 16,33 :print"Hptst. gew."
  locate 18,33 :print"Tote"
  locate 20,33 :print"Stadtangriffe"
  locate 22,33 :print"SchlachtSiege"
  color 8
  locate 15,54 :print"Time :";time$
  locate 16,54 :print"Date :";date$;" eng."
  locate 17,54 :print"cop. by M.Woitzik"
  draw"BM 10,223 C14 u8 e2 f2 d2 r2 u2 r2 d2 r2 u2 d2 r2 u2 r2 d2 r2 u2 r2 d2"
  draw"r2 u2 e2 f2 d8 l24"
  paint (11,222),6,14
  draw"BM 20,252 u7 l4 u3 r4 u4 r3 d4 r4 d3 l4 d7 l3"
  paint (21,251),6,14
  draw"BM 12,265 C6 r4 u4 r4 d4 r4 u4 r4 d4 r4 u4 r4 d4 r4"
  draw"BM 15,276 C14 e16 Br5 g4 Nh3 g4 Nh3 g4 Nh3 g4 Nh3 g"
  draw"BM 16,311 e16 l10 d f d2 g d l2 d r4"
  paint (26,298),6,14

  for Spieler=1 to 2
    if Spieler = 1 then StartpixelX=5 :StartpixelY=130
    if Spieler = 2 then StartpixelX=305
    if insgdauer > 56 then insgdauer = 56
      for zz=1 to insgdauer
           XM$ = str$(StartpixelX+zz*5)
           YM$ = str$(StartpixelY - int(MEndMot(Spieler,zz)*10))
        if zz=1 then draw"BM"+XM$+","+YM$
        if Spieler=1 then draw"C12" else draw"C9"
        draw"M"+XM$+","+YM$
      next zz

      for zz=1 to insgdauer
           XM$ = str$(StartpixelX+zz*5)
           YA$ = str$(StartpixelY - int(EndAnz(Spieler,zz)/100*7))
        if zz=1 then draw"BM"+XM$+","+YA$
        if Spieler=1 then draw"C4" else draw"C1"
        draw"M"+XM$+","+YA$
      next zz

      for zz=1 to insgdauer
           XM$ = str$(StartpixelX+1+zz*5)
           YS$ = str$(StartpixelY+30 - int(EndStadt(Spieler,zz)*2))
        if zz=1 then draw"C8 BM"+XM$+",160" :draw"M"+XM$+","+YS$
        draw"M"+XM$+","+YS$
        if zz=insgdauer then draw"M"+XM$+",160"
      next zz
      XM$ = str$(StartpixelX+6)
      XEnd$ = str$(Startpixel+1+insgdauer*5+5) :if Spieler=2 then _
              XEnd$ = str$(Startpixel+1+insgdauer*5+305)
      draw "BM "+XM$+",160"
      draw "M"+XEnd$+",160"
      paint (val(XM$)+1,159),8,8
  next Spieler
  zz$=inkey$ :zz$=inkey$
55555 if inkey$="" then 55555
  screen 0
  print :print"Dragon-World is ready"
  delay(3)
  end


Datensich:
  RGesamtpers = 0 :BGesamtpers = 0
  for zz=1 to 26
    RGesamtpers = RGesamtpers + Anzahl(1,zz)
    BGesamtpers = BGesamtpers + Anzahl(2,zz)
  next zz
  RTote = RAnfst - RGesamtpers
  BTote = BAnfst - BGesamtpers
 if Spielrunde < 57 then EndAnz(1,Spielrunde) = RGesamtpers
 if Spielrunde < 57 then EndAnz(2,Spielrunde) = BGesamtpers

  Motirot = 0 :Motiblau = 0:wr = 0 : wb = 0
  for zz=1 to 26
    if Anzahl(1,zz) > 0 then Motirot = Motirot + Motivation(1,zz) :wr = wr + 1
    if Anzahl(2,zz) > 0 then Motiblau = Motiblau + Motivation(2,zz) :wb=wb + 1
  next zz
  if Spielrunde < 57 then MEndMot(1,Spielrunde) = Motirot / wr
  if Spielrunde < 57 then MEndMot(2,Spielrunde) = Motiblau / wb

 if Spielrunde > 56 then call TextDel:color 7,0,0 :locate 20,1 :_
    print "Spielrunde : ";Spielrunde :beep :delay(4) :call TextDel :return
  EndStadt(1,Spielrunde)=0 :EndStadt(2,Spielrunde)=0
  for Spieler = 1 to 2
    for Truppe = 1 to 26
      if Anzahl(Spieler,Truppe) > 0 then gosub WegArmee
  next Truppe,Spieler

  for i3=3 to 17
    for i4=2 to 76
      if peek(i4*2 + i3*160)=219 and peek(i4*2+1 + i3*160)= 12 then _
         EndStadt(1,Spielrunde) = EndStadt(1,Spielrunde) + 1
      if peek(i4*2 + i3*160)=219 and peek(i4*2+1 + i3*160)= 4 then _
         EndStadt(1,Spielrunde) = EndStadt(1,Spielrunde) + 1
      if peek(i4*2 + i3*160)=219 and peek(i4*2+1 + i3*160)= 9 then _
         EndStadt(2,Spielrunde) = EndStadt(2,Spielrunde) + 1
      if peek(i4*2 + i3*160)=219 and peek(i4*2+1 + i3*160)= 1 then _
         EndStadt(2,Spielrunde) = EndStadt(2,Spielrunde) + 1
  next i4,i3

  for Spieler = 1 to 2
    for Truppe = 1 to 26
      if Anzahl(Spieler,Truppe) > 0 then gosub HinArmee
  next Truppe,Spieler
return


Absaven:
  call TextDel
  color 8,0,0
  locate 21,3 :print "Spielstand abspeichern ? (j/taste)  / %=aufgeben."
55566 a$=inkey$
  if a$="" then 55566
  if a$="j" then Absav
  if a$="%" then Aufgeb
  call TextDel
return

 Absav:
  call TextDel
  color 14,0,0
  locate 21,1 :input "Filename bitte (ohne .Suffix) : ";Zws$
  if len(Zws$)>8 then Absav
  color 8,0,0 :locate 23,1 :print "- liest zustzlich Landschaftsform ein -"
  delay(1)
  color 7,0,0

  for Spieler = 1 to 2
    for Truppe = 1 to 26
      if Anzahl(Spieler,Truppe) > 0 then gosub WegArmee
  next Truppe,Spieler
  gosub Landles
  for Spieler = 1 to 2
    for Truppe = 1 to 26
      if Anzahl(Spieler,Truppe) > 0 then gosub HinArmee
  next Truppe,Spieler
  locate 23,1 :print"                                                    "

  open "o",#1,Zws$+".sps"
   write #1,na$,blname$,rtname$,mpause,Spielrunde
   for i=1 to 2
     for zz=1 to 26
       write #1, Motivation(i,zz), Anzahl(i,zz) ,Kampfst(i,zz) , ascii(i,zz)
       write #1, PositionX(i,zz) ,PositionY(i,zz) ,Namen$(i,zz)
       write #1, Darunter(i,zz)
   next zz,i
   for zz=1 to 17
     for i=1 to 76
       write #1, Landschaft(i,zz)
   next i,zz
   write #1, RHptstgew, BHptstgew ,RTote ,BTote, RGesamtpers, BGesamtpers
   write #1, RAnfst ,BAnfst ,RAngriffeSt ,BAngriffeSt ,BSiegTr ,RSiegTr
   for i=1 to 2
     for zz=1 to 56
       write #1, MEndMot(i,zz), EndAnz(i,zz), EndStadt(i,zz)
   next zz,i
  close #1
  call TextDel
return


Reinloaden:
  cls
  call Emblem
  color 14,0,0
  print :print "Laden eines alten Spiels !"
  print :color 6,0,0
  files "*.sps"
  color 14,0,0 :print
  input "Bitte File eingeben (ohne .Suffix) : ";Zws$
  if Zws$="" then cls : goto Label1
  if len(Zws$)>8 then Reinloaden

  open "i",#1,Zws$+".sps"
  input #1,na$,blname$,rtname$,mpause,Spielrunde
  for i=1 to 2
    for zz=1 to 26
      input #1, Motivation(i,zz), Anzahl(i,zz) ,Kampfst(i,zz) , ascii(i,zz)
      input #1, PositionX(i,zz) ,PositionY(i,zz) ,Namen$(i,zz)
      input #1, Darunter(i,zz)
  next zz,i
  for zz=1 to 17
    for i=1 to 76
      input #1, Landschaft(i,zz)
  next i,zz
  input #1, RHptstgew, BHptstgew ,RTote ,BTote, RGesamtpers, BGesamtpers
  input #1, RAnfst ,BAnfst ,RAngriffeSt ,BAngriffeSt ,BSiegTr ,RSiegTr
  for i=1 to 2
    for zz=1 to 56
      input #1, MEndMot(i,zz), EndAnz(i,zz), EndStadt(i,zz)
  next zz,i
  close #1
  color 4,0,0
  print
  print Zws$+".sps  : Datenfile"
  print "                        - Spiel : ";na$
  print "                        - Spielrunde : ";Spielrunde
  print "                        - (rot)";rtname$;"  kontra  ";blname$;"(blau)"
  color 7,0,0
  print
  print "Correct ? (j/n)"
55577 a$=inkey$
  if a$="" then 55577
  if a$="n" then cls : goto Label1
  if a$="j" then Spielrunde = Spielrunde - 1 : goto Aufbau
  goto 55577


Aufgeb:
  call TextDel
  locate 21,1 :color 15,0,0
  print "Sind Sie WIRKLICH SICHER !!?!? (j/n)"
55589 a$=inkey$
  if a$="j" then Aufgegeben
  if a$="n" then call TextDel :return
  goto 55589
 Aufgegeben:
  cls
  color 8,0,0
  locate 10,30 :print "oohhh ... welche Schande !"
  color 14,0,0
  locate 15,30 :print "Wer ist dann der SIEGER ?!"
  locate 17,30 :print "  ROT = 1  /  BLAU = 2"
  locate 19,40 :input a
  if a<1 or a>2 then Aufgegeben
  Spieler = a
 goto Beurteilung













