unit Ending;

interface

uses Crt,Graph3,Title,Globals,Graph;

procedure TheEnd;

implementation

procedure TheEnd;                      (***** THE END , EXPLOSION *****)
const
  NoOfDots   = 170;
var
  Code,Ctr4,Colr,
  Backgr,Expl,Dist,
  x,y        : integer;
  HoldShip   : array [1..1000] of byte;
  Dot        : array [1..NoOfDots] of record
                 x,y : word;
                 xinc,yinc : word;
                 bcol : byte;
               end;

  procedure Pod (x,y,col : word);
  begin
    PutPixel (x,y,col); PutPixel (x+1,y,col);
    PutPixel (x,y+1,col); PutPixel (x+1,y+1,col);
  end;
  procedure MovePod (Times,Xinc,Yinc : integer);
  var Ctr4 : integer;
  begin
    for Ctr4 := 1 to Times do begin
      Delay (60);
      Pod (x,y,Backgr);
      Inc (x,Xinc); Inc (y,Yinc);
      Pod (x,y,3);
    end;
  end;

begin
  ClearDevice;
  SetColor (2);
  Arc (0,700,0,90,680);
  SetFillStyle (SolidFill,2);
  FloodFill (0,199,2);
  TurtleDelay (0);
  TurtleWindow (159,99,320,200); PenDown;
  SetPosition (-159,-50); SetPenColor (1);
  SetHeading (60); Forwd (4);
  TurnRight (32); Forwd (11);
  TurnRight (100); Forwd (7);
  TurnLeft (167); Forwd (6);
  TurnRight (90); Forwd (10);
  TurnRight (10); Forwd (6);
  TurnLeft (30);  Forwd (7);
  TurnRight (30); Forwd (10);
  TurnRight (20); Forwd (4);
  TurnLeft (45);  Forwd (7);
  TurnRight (100); Forwd (12);
  TurnRight (30); Forwd (6);
  TurnLeft (140); Forwd (7);
  TurnRight (110); Forwd (8);
  TurnLeft (160); Forwd (10);
  TurnRight (45); Forwd (8);
  TurnLeft (20); Forwd (9);
  TurnLeft (20); Forwd (5);
  TurnRight (60); Forwd (6);
  TurnLeft (150); Forwd (10);
  TurnRight (150); Forwd (7);
  TurnRight (45); Forwd (8);
  TurnLeft (80); Forwd (15);
  TurnLeft (20); Forwd (8);
  TurnLeft (60); Forwd (7);
  TurnRight (150); Forwd (20);
  TurnRight (45); Forwd (10);
  TurnLeft (60); Forwd (8);
  TurnRight (80); Forwd (10);
  SetFillStyle (SolidFill,1);
  FloodFill (0,190,1);
  for Ctr4 := 1 to 300 do begin
    x := Random (320); y := Random (200);
    if GetPixel (x,y) = 0 then PutPixel (x,y,Random (4));
  end;
  SetFillStyle (SolidFill,0);
  Bar (182,33,212,53);
  SetPosition (50,50); SetPenColor (1);
  SetHeading (250); Forwd (4);
  TurnRight (45); Forwd (5);
  TurnRight (45); Forwd (3);
  TurnLeft (45);  Forwd (7);
  TurnLeft (45);  Forwd (3);
  TurnRight (45); Forwd (6);
  TurnRight (90); Forwd (6);
  TurnRight (90); Forwd (6);
  TurnRight (45); Forwd (3);
  TurnLeft (45);  Forwd (7);
  TurnLeft (45);  Forwd (3);
  TurnRight (45); Forwd (5);
  TurnRight (45); Forwd (4);
  SetFillStyle (SolidFill,2);
  FloodFill (190,39,1);
  FloodFill (203,47,1);
  x := 195; y := 45;
  Backgr := 0;
  Pod (x,y,3);
  Delay (2000);
  Sound (1000); Delay (100); NoSound;
  MovePod (10,1,3);
  MovePod (10,0,3);
  MovePod (5,-1,2);
  MovePod (5,-2,1);
  MovePod (10,-3,0);
  MovePod (10,-3,-1);
  MovePod (5,-3,0);
  MovePod (5,-2,1);
  MovePod (7,-1,2);
  MovePod (5,0,2);
  Backgr := 2;
  MovePod (5,1,2);
  MovePod (5,1,1);
  MovePod (5,0,1);
  MovePod (3,-1,1);
  Sound (200); Delay (100); Nosound;
  Delay (1000);
  GetImage (183,34,211,52,HoldShip);
  for Ctr4 := 1 to 60 do begin
    Sound (Ctr4*15);
    Delay (20);
    PutImage (182+Random(3),33+Random(3),HoldShip,NormalPut);
  end;
  NoSound;
  for Ctr4 := 1 to NoOfDots do with Dot [Ctr4] do begin
    x    := 183+Random (29);
    y    := 34 +Random (19);
    xinc := Random (13) -6;
    yinc := Random (11) -6;
    bcol := 0;
    while (xinc=0) and (yinc=0) do begin
      xinc := Random (13) -6;
      yinc := Random (11) -6;
    end;
  end;
  SetFillStyle (SolidFill,0);
  Bar (182,33,212,53);
  for Expl := 1 to 70 do begin
    Code := (100-Expl)*20;
    Colr := 4 - (Ord(Expl>10) + Ord(Expl>30) + 1);
    if Colr<3 then Colr := 3-Colr;
    for Ctr4 := 1 to NoOfDots do with Dot [Ctr4] do begin
      PutPixel (x,y,bcol);
      Inc (x,xinc);
      Inc (y,yinc);
      if Random (5) = 0 then Inc (yinc);
			bcol := GetPixel (x,y);
      PutPixel (x,y,Colr);
      Sound (Random (Code));
    end;
  end;
  NoSound;
  SetTextJustify (CenterText,CenterText);
  SetTextStyle (GothicFont,HorizDir,7);
  SetColor (2); OutTextXY (159,83,'The End');
  SetColor (1); OutTextXY (160,84,'The End');
  SetColor (3); OutTextXY (161,85,'The End');
  Play ('t120 o1 l2 ef#4gea#1');
  SetTextStyle (DefaultFont,HorizDir,1);
  OutTextXY (160,140,'Your adventure is completed!');
  OutTextXY (160,170,'Now press any key ...');
  while KeyPressed do K1:=ReadKey;
  K1 := ReadKey;
end;

end.
