' GUESLIST.BAS -- This module handles the list of guesses
' $INCLUDE: 'J.INC'

TYPE GuessType
	Word AS STRING * 5
	Points AS INTEGER
END TYPE

DIM SHARED Guess(1 TO 20) AS GuessType, Guesses
DIM SHARED MyBox AS BoxType, TopRow, BotRow, LftCol, RtCol

SUB InitGuessList
	FOR Lp = 1 TO 20
		Guess(Lp).Word$ = " "
		Guess(Lp).Points = GuessScore(Lp)
	NEXT Lp
	Guesses = 0
	GameWonFlag = FALSE
	CALL BoxCoords(GuessListBox, MyBox)
	TopRow = MyBox.TopRow
	BotRow = MyBox.BotRow
	LftCol = MyBox.LftCol
	RtCol = MyBox.RtCol

	NormalBox (GuessListBox)
	COLOR Dark, Background, Background
	FOR Lp = 1 TO 20
		LOCATE Lp + TopRow, LftCol + 2, 0
		PRINT USING "----- ###"; Guess(Lp).Points;
	NEXT Lp
	COLOR Normal, Background, Background
END SUB

SUB AddGuess (NewWord$)
	Guesses = Guesses + 1
	Guess(Guesses).Word$ = NewWord$
	Temp$ = SecretWord$
	Points = 0
	IF NewWord$ <> Temp$ THEN
		FOR Lp = 1 TO 5
			Letter$ = MID$(NewWord$, Lp, 1)
			Posn = INSTR(Temp$, Letter$)
			IF Posn THEN
				Points = Points + 1
				MID$(Temp$, Posn, 1) = " "
			END IF
		NEXT Lp
		Guess(Guesses).Points = Points
		IF Points = 0 THEN
			RemoveFromPossList (NewWord$)
		END IF
		AddToScore (Points)
		AddToUsedList (NewWord$)
	ELSE
		AddToScore (GuessScore(Guesses))
	END IF
	RedrawGuessList
END SUB

SUB RedrawGuessList
	TempPossList$ = PossibleLetterList$
	FOR Lp = 1 TO Guesses
		TempKnown$ = KnownList$
		FOR Lp2 = 1 TO 5
			Letter$ = MID$(Guess(Lp).Word$, Lp2, 1)
			COLOR Normal, Background, Background
			IF INSTR(TempPossList$, Letter$) THEN
				COLOR Exclude, Background, Background
			END IF
			IF INSTR(TempKnown$, Letter$) THEN
				COLOR Known, Background, Background
				MID$(TempKnown$, INSTR(TempKnown$, Letter$), 1) = " "
			ELSEIF INSTR(KnownList$, Letter$) THEN
				COLOR Uncertain, Background, Background
			END IF
			LOCATE TopRow + Lp, LftCol + Lp2 + 1, 0
			PRINT Letter$;
		NEXT Lp2
		COLOR Normal, Background, Background
		PRINT USING " ###"; Guess(Lp).Points;
	NEXT Lp
END SUB

FUNCTION GuessCount%
	GuessCount = Guesses
END FUNCTION
