' KNWNLIST.BAS -- This module keeps track of the list of letters that the
' user knows are in the secret word, and lets the user modify the list
' $INCLUDE: 'J.INC'

DIM SHARED MyBox AS BoxType, TopRow, BotRow, LftCol, RtCol
DIM SHARED KnownLetters AS STRING * 5, KnownCount

SUB InitKnownList
	CALL BoxCoords(KnownBox, MyBox)
	TopRow = MyBox.TopRow
	BotRow = MyBox.BotRow
	LftCol = MyBox.LftCol
	RtCol = MyBox.RtCol
	KnownLetters$ = " "
	KnownCount = 0
	NormalBox (KnownBox)
	COLOR Normal, Background, Background
	LOCATE TopRow + 1, LftCol + 2, 0
	PRINT "Known Letters";
	COLOR Dark, Background, Background
	LOCATE TopRow + 3, LftCol + 6, 0
	PRINT "-----";
END SUB

SUB ChangeKnownList
	ShowMessage ("Enter letter, Backspace to erase, <TAB> for next box, <Return> to end")
	HighlightBox (KnownBox)
	Row = TopRow + 3
	Col = LftCol + 6
	DO
		COLOR Dark, Background, Background
		LOCATE Row, Col + KnownCount, 1, 0, 7
		DO
			Char$ = INKEY$
		LOOP UNTIL LEN(Char$)
		IF Char$ = CHR$(13) THEN                        'Carriage return
			COLOR Normal, Background, Background
			NormalBox (KnownBox)
			EXIT SUB
		ELSEIF Char$ = CHR$(9) THEN                     'TAB
			COLOR Normal, Background, Background
			NormalBox (KnownBox)
			ChangePossList
			EXIT SUB
		ELSE                                            'Changes in this box
			IF Char$ = CHR$(8) AND KnownCount > 0 THEN   '  Backspace
				MID$(KnownLetters$, KnownCount, 1) = " "
				KnownCount = KnownCount - 1
				LOCATE Row, Col + KnownCount, 0
				PRINT "-";
				LOCATE Row, Col + KnownCount, 1, 0, 7
				COLOR Normal, Background, Background
				RedrawGuessList
				RedrawPossList
			END IF
			Char$ = UCASE$(Char$)                        '  Other characters
			IF Char$ >= "A" AND Char$ <= "Z" AND KnownCount < 5 THEN
				COLOR Known, Background, Background
				PRINT Char$;
				KnownCount = KnownCount + 1
				MID$(KnownLetters$, KnownCount, 1) = Char$
				COLOR Normal, Background, Background
				RedrawGuessList
				RedrawPossList
			END IF
		END IF
	LOOP
END SUB

FUNCTION KnownList$
	KnownList$ = KnownLetters$
END FUNCTION

