' MSGBOX.BAS -- This module takes care of the message box.  It allows
' temporarily saving messages on a message stack
' $INCLUDE: 'J.INC'

' $DYNAMIC
DIM SHARED MessageStack$(1)
DIM SHARED StackPtr, Blank$
DIM SHARED MyBox AS BoxType, TopRow, BotRow, LftCol, RtCol

SUB InitMessage
	CALL BoxCoords(MessageBox, MyBox)
	TopRow = MyBox.TopRow
	BotRow = MyBox.BotRow
	LftCol = MyBox.LftCol
	RtCol = MyBox.RtCol
	MaxLen = RtCol - LftCol - 1
	Blank$ = STRING$(MaxLen, " ")
	StackPtr = 1
	REDIM MessageStack$(1 TO 10)
	NormalBox (MessageBox)
END SUB

SUB PushMsg
	IF StackPtr <= 10 THEN
		MessageStack$(StackPtr) = Blank$       'Last message printed
		StackPtr = StackPtr + 1
	END IF
END SUB

SUB PopMsg
	IF StackPtr > 1 THEN
		StackPtr = StackPtr - 1
	END IF
	ShowMessage (MessageStack$(StackPtr))
END SUB

SUB ShowMessage (Msg$)
	Temp$ = Msg$
	IF LEN(Temp$) < LEN(Blank$) THEN
		Temp$ = STRING$((LEN(Blank$) - LEN(Temp$)) / 2, " ") + Temp$
	END IF
	LSET Blank$ = Temp$
	COLOR Normal, Background, Background
	LOCATE TopRow + 1, LftCol + 1, 0
	PRINT Blank$;
END SUB

