' POSSLIST.BAS -- This module maintains the list of possible letters
' and lets the user change the status of letters in that list
' $INCLUDE: 'J.INC'

DIM SHARED MyBox AS BoxType, TopRow, BotRow, LftCol, RtCol
DIM SHARED PossList AS STRING * 26

SUB InitPossList
	CALL BoxCoords(PossListBox, MyBox)
	TopRow = MyBox.TopRow
	BotRow = MyBox.BotRow
	LftCol = MyBox.LftCol
	RtCol = MyBox.RtCol
	PossList$ = " "

	NormalBox (PossListBox)
	LOCATE TopRow + 1, LftCol + 2, 0
	COLOR Normal, Background, Background
	PRINT "Possible Letters:";
	RedrawPossList
END SUB

SUB RemoveFromPossList (NewWord$)
	FOR Lp = 1 TO 5
		Letter$ = MID$(NewWord$, Lp, 1)
		Posn = ASC(Letter$) - ASC("A") + 1
		MID$(PossList$, Posn, 1) = Letter$
	NEXT Lp
	RedrawPossList
END SUB

SUB ChangePossList
	ShowMessage ("Enter letter to change, <TAB> for notes, <Return> to end")
	HighlightBox (PossListBox)
	DO
		COLOR Normal, Background, Background
		LOCATE TopRow + 1, LftCol + 35, 1, 0, 7
		PRINT "==> ";
		DO
			Char$ = INKEY$
		LOOP UNTIL LEN(Char$)
		IF Char$ = CHR$(9) OR Char$ = CHR$(13) THEN     'TAB & RETURN
			LOCATE TopRow + 1, LftCol + 35, 0
			PRINT "     ";
			NormalBox (PossListBox)
			IF Char$ = CHR$(9) THEN
				MakeNotes
			END IF
			EXIT SUB
		ELSE
			Char$ = UCASE$(Char$)
			IF Char$ >= "A" AND Char$ <= "Z" THEN
				Posn = ASC(Char$) - ASC("A") + 1
				OldValue$ = MID$(PossList$, Posn, 1)
				IF OldValue$ = " " THEN
					MID$(PossList$, Posn, 1) = Char$
				ELSE
					MID$(PossList$, Posn, 1) = " "
				END IF
				RedrawPossList
				RedrawGuessList
			END IF
		END IF
	LOOP
END SUB

FUNCTION PossibleLetterList$
	PossibleLetterList$ = PossList$
END FUNCTION

SUB RedrawPossList
	LOCATE TopRow + 3, LftCol + 2, 0
	TempKnown$ = KnownList$
	FOR Lp = 1 TO 26
		Char$ = CHR$(Lp + ASC("A") - 1)
		IF INSTR(TempKnown$, Char$) THEN
			COLOR Known, Background, Background
		ELSEIF MID$(PossList$, Lp, 1) = " " THEN
			COLOR Normal, Background, Background
		ELSE
			COLOR Exclude, Background, Background
		END IF
		PRINT CHR$(Lp + ASC("A") - 1); " ";
	NEXT Lp
END SUB

