' USEDLIST.BAS -- This module handles the list of letters that have
' already been used in a word
' $INCLUDE: 'J.INC'

DECLARE SUB RedrawUsedList ()

DIM SHARED MyBox AS BoxType, TopRow, BotRow, LftCol, RtCol
DIM SHARED UsedList AS STRING * 26

SUB InitUsedList
	CALL BoxCoords(UsedBox, MyBox)
	TopRow = MyBox.TopRow
	BotRow = MyBox.BotRow
	LftCol = MyBox.LftCol
	RtCol = MyBox.RtCol

	NormalBox (UsedBox)
	LOCATE TopRow + 1, LftCol + 2, 0
	PRINT "Untried Letters:"
	UsedList$ = " "
	RedrawUsedList
END SUB

SUB AddToUsedList (Word$)
	FOR Lp = 1 TO 5
		Letter$ = MID$(Word$, Lp, 1)
		MID$(UsedList$, ASC(Letter$) - ASC("@"), 1) = Letter$
	NEXT Lp
	RedrawUsedList
END SUB

SUB RedrawUsedList
	LOCATE TopRow + 3, LftCol + 2, 0
	FOR Lp = ASC("A") TO ASC("Z")
		IF INSTR(UsedList$, CHR$(Lp)) THEN
			COLOR Exclude, Background, Background
		ELSE
			COLOR Normal, Background, Background
		END IF
		PRINT CHR$(Lp); " ";
	NEXT Lp
END SUB

