100 REM
110 REM "Mini-Golf Simulation" (Generic MS-BASIC Version)
120 REM (C) Copyright 1989, One Thousand Magazine
130 REM and Randy Hawkins, All Rights Reserved
140 REM
150 SCREEN 1: COLOR 0, 1: KEY OFF: CLS
160 DIM WHO$(5), SCORE(5), BALL(7), HOLD(124), ARROW(124)
170 CIRCLE (4, 4), 3: PAINT (4, 4), 3, 3: GET (1, 1)-(7, 7), BALL
180 REM
190 REM How many players and who are they?
200 REM
210 RANDOMIZE TIMER: CLS
220 PRINT "Welcome to OTM's Mini-Golf Game": GOSUB 1630
230 PRINT : PRINT "How many will play (1-5)? ";
240 A$ = INKEY$: IF A$ < "1" OR A$ > "5" THEN 240
250 LOCATE 9, 27: PRINT A$: PRINT : NP = VAL(A$): FOR A = 1 TO NP
260 PRINT "Player #"; CHR$(A + 48); : INPUT WHO$(A)
270 WHO$(A) = LEFT$(WHO$(A), 17): NEXT A: PRINT
280 REM
290 REM Start play by displaying one of 18 holes
300 REM
310 FOR HOLE = 1 TO 18: CLS : X = INT((HOLE + 3) / 4)
320 Y = HOLE - (X - 1) * 4: ON X GOTO 330, 340, 350, 360, 370
330 ON Y GOSUB 1090, 1110, 1140, 1160: GOTO 410
340 ON Y GOSUB 1180, 1220, 1260, 1280: GOTO 410
350 ON Y GOSUB 1300, 1320, 1380, 1410: GOTO 410
360 ON Y GOSUB 1440, 1450, 1480, 1540: GOTO 410
370 ON Y GOSUB 1560, 1590
380 REM
390 REM Display hole info, ball, and hole for each player
400 REM
410 SCORE(0) = SCORE(0) + PAR
420 FOR PL = 1 TO NP: ANGLE = 0: STROKE = 0: X = BX: Y = BY
430 FOR A = 1 TO 4: LOCATE A, 1: PRINT STRING$(39, 32): NEXT A
440 LOCATE 1, 8: PRINT "Player: "; WHO$(PL)
450 PRINT "Current Score:"; SCORE(PL)
460 LOCATE 3, 3: PRINT "Hole Number:"; HOLE; "(Par";
470 PRINT STR$(PAR); ")": LOCATE 4, 7: PRINT "Strokes:"; STROKE
480 PUT (X - 3, Y - 3), BALL: CIRCLE (HX, HY), 4, 2: PAINT (HX, HY), 2, 2
490 REM
500 REM Display arrow and select direction
510 REM
520 GET (270, 0)-(300, 30), HOLD: PUT (270, 0), HOLD
530 DRAW "BM285,15 TA" + STR$(ANGLE) + "0 C15 BR5 R10 H2 D4 E2"
540 GET (270, 0)-(300, 30), ARROW: PUT (270, 0), ARROW: PUT (270, 0), HOLD
550 PUT (X - 15, Y - 15), ARROW: DEF SEG = 0: POKE 1050, PEEK(1052)
560 A$ = INKEY$: IF A$ = "" THEN 560 ELSE IF VAL(A$) THEN 700
565 IF A$ = CHR$(27) THEN 1610
570 IF ASC(A$) THEN 560 ELSE A$ = MID$(A$, 2, 1)
580 REM
590 REM Move arrow and re-draw
600 REM
610 IF A$ = "H" THEN ANGLE = ANGLE + SGN(COS(ANGLE / 5.72))
620 IF A$ = "K" THEN ANGLE = ANGLE + SGN(SIN(ANGLE / 5.72))
630 IF A$ = "P" THEN ANGLE = ANGLE - SGN(COS(ANGLE / 5.72))
640 IF A$ = "M" THEN ANGLE = ANGLE - SGN(SIN(ANGLE / 5.72))
650 ANGLE = ANGLE - 36 * (ANGLE < 0) + 36 * (ANGLE = 36)
660 PUT (X - 15, Y - 15), ARROW: GOTO 520
670 REM
680 REM Start the ball rolling
690 REM
700 SPEED = VAL(A$) * 20: PUT (X - 15, Y - 15), ARROW
710 DX = 2 * COS(ANGLE / 5.72): DY = -2 * SIN(ANGLE / 5.72)
720 SCORE(PL) = SCORE(PL) + 1: LOCATE 2, 15: PRINT SCORE(PL)
730 STROKE = STROKE + 1: LOCATE 4, 15: PRINT STROKE
740 SPEED = SPEED - 1: IF SPEED < 1 THEN 520
750 NX = POINT(X + DX + SGN(DX) * 3, Y)
760 NY = POINT(X, Y + DY + SGN(DY) * 3)
770 IF (NX = 2) + (NY = 2) THEN 850 ELSE Q = TIMER
780 IF (NX <> 0) * (NX <> 3) THEN DX = -DX: SOUND 100, .1
790 IF (NY <> 0) * (NY <> 3) THEN DY = -DY: SOUND 100, .1
800 PUT (X - 3, Y - 3), BALL: X = X + DX: Y = Y + DY
810 PUT (X - 3, Y - 3), BALL: WHILE TIMER - Q < .01: WEND: GOTO 740
820 REM
830 REM Ball is in the hole
840 REM
850 DX = (HX - X) / 10: DY = (HY - Y) / 10
860 FOR A = 1 TO 10: PUT (X - 3, Y - 3), BALL
870 X = X + DX: Y = Y + DY: PUT (X - 3, Y - 3), BALL
880 SOUND (11 - A) * 100, .1: NEXT A: BEEP: A = TIMER
890 WHILE TIMER - A < 3: WEND: NEXT PL
900 CLS : LOCATE 8, 3: PRINT "Par Thru"; HOLE; "holes ";
910 WHILE POS(0) < 35: PRINT CHR$(46); : WEND
920 PRINT USING "###"; SCORE(0): FOR PL = 1 TO NP
930 LOCATE PL + 9, 3: PRINT WHO$(PL); CHR$(32);
940 WHILE POS(0) < 35: PRINT CHR$(46); : WEND
950 PRINT USING "###"; SCORE(PL): NEXT PL: A = TIMER
960 WHILE TIMER - A < 5: WEND: NEXT HOLE
970 REM
980 REM Announce winners and quit
990 REM
1000 PRINT : IF NP = 1 THEN 1052 ELSE A = 1
1010 FOR PL = 2 TO NP: IF SCORE(PL) < SCORE(A) THEN A = PL
1020 NEXT PL: PRINT TAB(13); "Congratulations"
1030 FOR PL = 1 TO NP: IF SCORE(PL) > SCORE(A) THEN 1050
1040 PRINT TAB(20 - LEN(WHO$(PL)) / 2); WHO$(PL)
1050 NEXT PL
1052 PRINT : PRINT SPC(10); "Play Again (Y/N)? ";
1054 A$ = INKEY$: IF A$ = "Y" OR A$ = "y" THEN 210
1056 IF A$ = "N" OR A$ = "n" THEN 1610 ELSE 1054
1060 REM
1070 REM Holes #1 thru #5
1080 REM
1090 LINE (8, 71)-(311, 179), 1, BF: LINE (12, 75)-(307, 175), 0, BF
1100 BX = 23: BY = 85 + RND * 80: HX = 290: HY = 125: PAR = 2: RETURN
1110 LINE (8, 71)-(241, 179), 1, BF: CIRCLE (237, 125), 70, 1
1115 PAINT (300, 125), 1, 1: CIRCLE (237, 125), 66, 0
1120 PAINT (237, 125), 0, 0: LINE (12, 75)-(237, 175), 0, BF
1125 BX = 23: BY = 85 + RND * 80
1130 HX = 237: HY = 125: PAR = 2: RETURN
1140 LINE (8, 46)-(311, 184), 1, BF: LINE (12, 50)-(307, 180), 0, BF
1150 BX = 23: BY = 65: HX = 290: HY = 165: PAR = 3: RETURN
1160 GOSUB 1090: LINE (62, 105)-(250, 110), 1, BF
1170 LINE (62, 140)-(250, 145), 1, BF: RETURN
1180 GOSUB 1110: LINE (155, 95)-(160, 155), 1, BF: RETURN
1190 REM
1200 REM Holes #6 thru #10
1210 REM
1220 GOSUB 1140: LINE (90, 90)-(237, 140), 1, BF
1225 LOCATE 13, 13: PRINT STRING$(17, 32);
1230 LOCATE 14, 13: PRINT "      O N E      ";
1240 LOCATE 15, 13: PRINT " T H O U S A N D ";
1250 LOCATE 16, 13: PRINT " M A G A Z I N E ";
1255 LOCATE 17, 13: PRINT STRING$(17, 32); : RETURN
1260 GOSUB 1090: FOR A = 70 TO 220 STEP 75
1270 LINE (A, 105)-(A + 30, 145), 1, BF: NEXT A: RETURN
1280 GOSUB 1110: LINE (100, 75)-(140, 115), 1, BF
1290 LINE (100, 135)-(140, 175), 1, BF: RETURN
1300 GOSUB 1140: LINE (12, 92)-(260, 96), 1, BF
1310 LINE (59, 136)-(307, 140), 1, BF: RETURN
1320 GOSUB 1090: CIRCLE (120, 175), 50, 1, 0, 3.14
1330 CIRCLE (207, 75), 50, 1, 3.14, 6.28: PAINT (120, 165), 1, 1
1340 PAINT (207, 85), 1, 1: RETURN
1350 REM
1360 REM Holes #11 thru #15
1370 REM
1380 GOSUB 1110: LINE (60, 110)-(100, 140), 1, BF
1390 LINE (140, 75)-(180, 110), 1, BF
1400 LINE (140, 140)-(180, 175), 1, BF: RETURN
1410 GOSUB 1140: LINE (86, 50)-(92, 130), 1, BF
1420 LINE (154, 100)-(160, 180), 1, BF
1430 LINE (220, 50)-(226, 130), 1, BF: HY = 65: RETURN
1440 GOSUB 1140: LINE (12, 135)-(207, 180), 1, BF
1445 LINE (0, 139)-(203, 199), 0, BF: HX = 230: RETURN
1450 GOSUB 1110: CIRCLE (90, 125), 25, 1
1460 CIRCLE (170, 125), 25, 1: PAINT (90, 125), 1, 1
1470 PAINT (170, 125), 1, 1: RETURN
1480 GOSUB 1140: FOR A = 1 TO 5
1490 CIRCLE (A * 53, 180 - A * 22), 10, 1
1500 PAINT (A * 53, 180 - A * 22), 1, 1: NEXT A: RETURN
1510 REM
1520 REM Holes #16 thru #18
1530 REM
1540 GOSUB 1140: LINE (12, 120)-(110, 180), 1, BF
1545 LINE (0, 124)-(106, 199), 0, BF: LINE (210, 120)-(307, 180), 1, BF
1550 LINE (214, 124)-(319, 199), 0, BF: HX = 160: RETURN
1560 GOSUB 1110: FOR A = 1 TO 4
1570 LINE (40 + A * 30, 50 + A * 25)-(46 + A * 30, 75 + A * 25), 1, BF
1580 NEXT A: RETURN
1590 GOSUB 1140: LINE (82, 50)-(237, 120), 1, BF
1600 LINE (86, 46)-(233, 116), 0, BF: HY = 65: RETURN
1610 SCREEN 0: WIDTH 80: CLS: LOCATE 12, 30
1620 PRINT "One Moment Please...": RUN "menu"
1630 PRINT: PRINT "Use the arrow keys to aim your shot"
1640 PRINT "(if the up arrow key does not work,"
1650 PRINT "use the PG UP key).  Press a number"
1660 PRINT "from 1 (easy) to 9 (hard) to putt"
1670 PRINT "the ball.  Good luck!": RETURN
