100 REM
110 REM "Linear Regression Program" by Randy Hawkins
120 REM (C) Copyright 1989, One Thousand Magazine and Randy Hawkins
130 REM
132 COMMON RH: IF RH = 0 THEN SYSTEM
134 CLEAR: KEY (17) ON: KEY 17, CHR$(0) + CHR$(1)
136 ON KEY (17) GOSUB 780
140 SCREEN 0: WIDTH 80: KEY OFF: COLOR 14,0: CLS: DIM X(20),Y(20)
150 PRINT "LINEAR REGRESSION PROGRAM": PRINT
160 PRINT "This program will statistically evaluate the relationship"
170 PRINT "existing between two groups of variables, and allow you to"
180 PRINT "predict the value of either variable at specified value(s)"
190 PRINT "of the other.": PRINT
200 REM
210 REM Accept names for each set of variables
220 REM
230 PRINT "What is the name of the first"
240 LINE INPUT "variable or group of measurements? "; XNAME$
250 PRINT: PRINT "What is the name of the other"
260 LINE INPUT "variable or group of measurements? "; YNAME$
270 REM
280 REM Accept X and Y values
290 REM
300 N = N + 1: PRINT: PRINT "Enter a measured or observed"
310 PRINT "value for "; XNAME$;: INPUT X(N): PRINT
320 PRINT "When "; XNAME$; " equals"; X(N); "what is"
330 PRINT "the corresponding value of ";YNAME$;: INPUT Y(N)
340 IF N = 1 THEN 300 ELSE PRINT
350 PRINT "Do you want to enter another pair of points (Y/N)? ";
360 A$ = INKEY$: IF A$ = "Y" OR A$ = "y" THEN PRINT "Y": GOTO 300
370 IF A$ = "N" OR A$ = "n" THEN PRINT "N" ELSE 360
380 REM
390 REM Present Regression Options
400 REM
410 PRINT: PRINT "Program Options": PRINT
420 PRINT "1 ... Review All Entries in Table Form"
430 PRINT "2 ... Add More Data Points"
440 PRINT "3 ... Calculate Correlation Coefficient"
450 PRINT "4 ... Given "; XNAME$; ", Predict Value for "; YNAME$
460 PRINT "5 ... Given "; YNAME$; ", Predict Value for "; XNAME$
470 PRINT "6 ... Begin a New Study": PRINT "7 ... Exit this Program"
480 PRINT: PRINT "Enter the number of your selection --> ";
490 A$ = INKEY$: IF A$ < "1" OR A$ > "7" THEN 490
500 PRINT A$: PRINT: ON VAL(A$) GOTO 540,300,630,680,710,770,780
510 REM
520 REM Data Table
530 REM
540 PRINT: PRINT XNAME$; CHR$(32); CHR$(61); X(1); SPC(5);
550 B = POS(0): PRINT YNAME$; CHR$(32); CHR$(61); Y(1)
560 FOR A = 2 TO N: PRINT XNAME$; CHR$(32); CHR$(61); X(A);
570 PRINT TAB(B); YNAME$; CHR$(32); CHR$(61); Y(A): NEXT A
580 PRINT: PRINT "Press <ANY KEY> to continue...": A$ = INKEY$
590 WHILE A$ = "": A$ = INKEY$: WEND: GOTO 410
600 REM
610 REM Correlation coefficient
620 REM
630 GOSUB 820: PRINT "For this set of data, the correlation"
640 PRINT "coefficient is equal to"; ABS(R2)*100; "%.": GOTO 410
650 REM
660 REM Use slope and intercept for predictions
670 REM
680 GOSUB 820: PRINT "Enter a value for "; XNAME$; " --> ";
690 INPUT "", XNEW: YNEW = SLOPE * XNEW + INTER
700 PRINT "Predicted Value of "; YNAME$; " --> "; YNEW: GOTO 410
710 GOSUB 820: PRINT "Enter a value for "; YNAME$; " --> ";
720 INPUT "", YNEW: XNEW = (YNEW - INTER) / SLOPE
730 PRINT "Predicted Value of "; XNAME$; " --> "; XNEW: GOTO 410
740 REM
750 REM Restart program or quit
760 REM
770 GOTO 134
780 CLS: LOCATE 12, 30: PRINT "One Moment Please...": RUN "menu"
790 REM
800 REM Calculate key statistical quantities
810 REM
820 SX = 0: SY = 0: SX2 = 0: SY2 = 0: SXY = 0
830 FOR A = 1 TO N: SX = SX + X(A): SY = SY + Y(A)
840 SX2 = SX2 + X(A) * X(A): SY2 = SY2 + Y(A) * Y(A)
850 SXY = SXY + X(A) * Y(A): NEXT A
860 SLOPE = (SXY - SX * SY / N) / (SX2 - SX * SX / N)
870 INTER = (SY - SLOPE * SX) / N
880 STDVX = SQR((SX2 - SX * SX / N) / (N - 1))
890 STDVY = SQR((SY2 - SY * SY / N) / (N - 1))
900 R = SLOPE * STDVX / STDVY: R2 = R * R: RETURN
