1000 REM
1010 REM              Star Trek Game
1020 REM            Copyright (c) 1990
1030 REM by Randy Hawkins and ONE THOUSAND Magazine
1040 REM            All Rights Reserved
1050 REM
1055 COMMON RH: IF RH = 0 THEN SYSTEM
1060 SCREEN 0: WIDTH 40: KEY OFF: COLOR 2,0: DIM G(15), F(15)
1070 FOR A = 1 TO 4: READ DX(A), DY(A): NEXT A
1080 DATA -1, 0, 0, -1, 0, +1, +1, 0
1090 DEF FNZ(X) = INT(RND * X) + 1
1100 DEF FNX(Z) = (Z AND 7) * 2 + 3
1110 DEF FNY(Z) = INT(Z / 8) * 2 + 4
1120 RANDOMIZE TIMER: ON ERROR GOTO 2720
1130 REM
1140 REM Present Introduction and Review Commands
1150 REM
1160 CLS: LOCATE 3,6: PRINT "Star Trek: The Computer Game"
1170 LOCATE 5,1: PRINT "You are the captain of the Enterprise."
1180 PRINT "Use these commands to remove all of the"
1190 PRINT "Klingon invaders from Federation space:"
1200 LOCATE 9,4: PRINT "I = impulse engines (for moving"
1210 PRINT TAB(8); "within the current sector)"
1220 LOCATE 12,4: PRINT "W = warp engines (for moving"
1230 PRINT TAB(8); "to another sector)"
1240 LOCATE 15,4: PRINT "P = fire phasers (energy beams"
1250 PRINT TAB(8); "to destroy Klingons)"
1260 LOCATE 18,4: PRINT "T = fire torpedos (weapon more"
1270 PRINT TAB(8); "powerful than phasers)"
1280 LOCATE 21,1: PRINT "Watch your shields -- the Klingons will"
1290 PRINT "shoot back.  Press any key to begin.";
1300 DEF SEG = 0: POKE 1050, PEEK(1052): WHILE INKEY$ = "": WEND
1310 REM
1320 REM Load Stars, Bases, Klingons in Each Quadrant
1330 REM
1340 CLS: FOR A = 0 TO 15: G(A) = 0: NEXT A: NB = 3: FOR A = 1 TO NB
1350 B = FNZ(16) - 1: IF G(B) <> 0 THEN 1350 ELSE G(B) = -10: F(B) = 1
1360 NEXT A: FOR A = 0 TO 15: S = FNZ(8): K = FNZ(4) - 1
1370 G(A) = G(A) - S * 100 - K: TK = TK + K: NEXT A
1380 REM
1390 REM Draw Tactical Display
1400 REM
1410 CLS: LOCATE 2,1: PRINT STRING$(19,219)
1420 LOCATE 20,1: PRINT STRING$(19,219)
1430 FOR A = 3 TO 19: LOCATE A,1: PRINT CHR$(219)
1440 LOCATE A,19: PRINT CHR$(219): NEXT A
1450 LOCATE 2,24: PRINT "Map of Galaxy"
1460 LOCATE 3,21: PRINT CHR$(201); STRING$(17,205); CHR$(187)
1470 FOR A = 4 TO 10: LOCATE A,21: PRINT CHR$(186)
1480 LOCATE A,39: PRINT CHR$(186): NEXT A: LOCATE 11,21
1490 PRINT CHR$(200); STRING$(17,205); CHR$(188)
1500 GOSUB 2340: SEC = FNZ(16) - 1
1510 REM
1520 REM Present Quadrant Information and Accept Command
1530 REM
1540 GOSUB 2110: GOSUB 2270
1550 GOSUB 2350: GOSUB 2470: LOCATE 23,5: PRINT STRING$(30,32)
1560 LOCATE 23,11,1: PRINT "Command (I,W,P,T)?"; CHR$(32);
1570 A$ = INKEY$: IF A$ = "" THEN 1570
1580 CMD = INT((INSTR("IiWwPpTt",A$) + 1) / 2): LOCATE 23,5
1585 IF A$ = CHR$(27) THEN 2740 ELSE IF CMD = 0 THEN 1570
1590 IF CMD < 3 THEN PRINT "Move"; ELSE PRINT "Fire";
1600 PRINT CHR$(32);"Which Direction ("; CHR$(27); CHR$(24);
1610 PRINT CHR$(25); CHR$(26); CHR$(41); CHR$(63); CHR$(32);
1620 A$ = INKEY$: IF A$ = "" THEN 1620 ELSE A$ = RIGHT$(A$,1)
1625 IF A$ = CHR$(27) THEN 2740
1630 DIR = INSTR("KHPM",A$): IF DIR = 0 THEN 1620
1640 ON CMD GOTO 1680, 1790, 1910, 1910
1650 REM
1660 REM Move Within Quadrant
1670 REM
1680 LOCATE 23,10: PRINT "How Many Parsecs (1-8)?"; CHR$(32);
1690 A$ = INKEY$: IF A$ = CHR$(27) THEN 2740
1695 IF A$ < "1" OR A$ > "8" THEN 1690 ELSE N = VAL(A$)
1700 N = VAL(A$) + 1: LOCATE 23,5,0: PRINT STRING$(30,32): GOTO 1750
1710 IF SCREEN(EY + 2 * DY(DIR),EX + 2 * DX(DIR)) <> 250 THEN 1550
1720 FOR A = 1 TO 2: LOCATE EY, EX: PRINT CHR$(468 - A * 218)
1730 EY = EY + DY(DIR): EX = EX + DX(DIR): LOCATE EY, EX
1740 PRINT "E": SOUND A * 100, 1: NEXT A: PUL = PUL - 2
1750 GOSUB 2380: N = N - 1: IF N * PUL > 0 THEN 1710 ELSE 1550
1760 REM
1770 REM Warp to Another Quadrant
1780 REM
1790 IF DIR = 1 AND (SEC AND 3) = 0 THEN 1550
1800 IF DIR = 2 AND (SEC < 4) THEN 1550
1810 IF DIR = 3 AND (SEC > 11) THEN 1550
1820 IF DIR = 4 AND (SEC AND 3) = 3 THEN 1550
1830 SEC = SEC + DX(DIR) + 4 * DY(DIR): LOCATE 23,4,0
1840 PRINT "Engaging Warp Drive ... Stand By";: WRP = WRP - 10
1850 FOR A = 200 TO 1200 STEP 4: SOUND A, .1: SOUND A-150, .1
1860 NEXT A: FOR A = 15 TO 1 STEP -1: NOISE 4, A, 2: NEXT A
1870 LOCATE 23,4: PRINT STRING$(35,32): GOSUB 2350: GOTO 1540
1880 REM
1890 REM Fire Phasers or Torpedos
1900 REM
1910 IF (CMD = 3 AND PHA < 1) OR (CMD = 4 AND TOR < 1) THEN 1550
1920 LOCATE 23,4,0: PRINT STRING$(30,32)
1930 IF CMD = 4 THEN TOR = TOR - 1: GOSUB 2420
1940 PCOPY 0,1: X = EX: Y = EY: A$ = CHR$(58 + CMD * 49)
1950 IF CMD = 3 AND (DIR = 2 OR DIR = 3) THEN A$ = CHR$(186)
1960 X = X + DX(DIR): Y = Y + DY(DIR): PHA = PHA + 2 * (CMD = 3)
1970 SOUND 40 + (PHA + TOR) * 10, 1: B = SCREEN(Y,X)
1980 IF CMD = 3 AND (B = 42 OR B = 219 OR PHA < 1) THEN 2070
1990 IF CMD = 4 THEN PCOPY 1,0: IF B = 219 THEN 2070
2000 LOCATE Y,X: PRINT A$;: IF B = 32 OR B = 250 THEN 1960
2010 PCOPY 1,0: FOR A = 1 TO 50: PRINT CHR$(29); CHR$(15);
2020 SOUND 100, .1: PRINT CHR$(29); CHR$(250);: NEXT A
2030 IF B = 75 THEN TK = TK - 1: G(SEC) = G(SEC) - 1
2040 IF B = 42 THEN G(SEC) = G(SEC) - 100
2050 IF B = 66 THEN G(SEC) = G(SEC) - 10
2060 GOSUB 2270: GOTO 1550
2070 PCOPY 1,0: GOTO 1550
2080 REM
2090 REM Place Stars, Bases, and Klingons in Quadrant
2100 REM
2110 FOR A = 4 TO 18 STEP 2: FOR B = 3 TO 17 STEP 2: LOCATE A,B
2120 PRINT CHR$(250): NEXT B,A: S = VAL(MID$(STR$(G(SEC)),2,1))
2130 Z = FNZ(64) - 1: IF SCREEN(FNY(Z),FNX(Z)) <> 250 THEN 2130
2140 LOCATE FNY(Z), FNX(Z): PRINT CHR$(42): S = S - 1: IF S THEN 2130
2150 IF MID$(STR$(G(SEC)),3,1) <> "1" THEN 2180
2160 Z = FNZ(64) - 1: IF SCREEN(FNY(Z),FNX(Z)) <> 250 THEN 2160
2170 LOCATE FNY(Z), FNX(Z): PRINT "B"
2180 K = VAL(MID$(STR$(G(SEC)),4,1)): IF K = 0 THEN 2210
2190 Z = FNZ(64) - 1: IF SCREEN(FNY(Z),FNX(Z)) <> 250 THEN 2190
2200 LOCATE FNY(Z), FNX(Z): PRINT "K": K = K - 1: IF K THEN 2190
2210 Z = FNZ(64) - 1: IF SCREEN(FNY(Z),FNX(Z)) <> 250 THEN 2210
2220 EX = FNX(Z): EY = FNY(Z): LOCATE EY, EX: PRINT "E"
2230 G(SEC) = ABS(G(SEC)): RETURN
2240 REM
2250 REM Present Galaxy Map
2260 REM
2270 FOR A = 0 TO 15: LOCATE INT(A/4) * 2 + 4, (A AND 3) * 4 + 23
2280 COLOR 2 + 2 * (A = SEC), -2 * (A = SEC)
2290 IF G(A) < 0 THEN PRINT "---" ELSE PRINT USING "###"; G(A)
2300 NEXT A: COLOR 2, 0: RETURN
2310 REM
2320 REM Charge Up Utilities, Display Energy Levels
2330 REM
2340 PUL = 100: WRP = 100: SHL = 100: PHA = 100: TOR = 5: RETURN
2350 COLOR 2: LOCATE 20,25: PRINT STRING$(11,32): LOCATE 20,25
2360 IF SCREEN(EY,EX-2) <> 66 AND SCREEN(EY,EX+2) <> 66 THEN 2380
2370 PRINT "D O C K E D": IF F(SEC) THEN GOSUB 2340: F(SEC) = 0
2380 COLOR 2-2*(PUL<21): LOCATE 13,25: PRINT USING "Impluse:###%"; PUL
2390 COLOR 2-2*(WRP<21): LOCATE 14,28: PRINT USING "Warp:###%"; WRP
2400 COLOR 2-2*(SHL<21): LOCATE 15,25: PRINT USING "Shields:###%"; SHL
2410 COLOR 2-2*(PHA<21): LOCATE 16,25: PRINT USING "Phasers:###%"; PHA
2420 COLOR 2-2*(TOR<2): LOCATE 17,24: PRINT USING "Torpedos:###"; TOR
2430 COLOR 2: LOCATE 18,24: PRINT USING "Klingons:###"; TK: RETURN
2440 REM
2450 REM All Klingons Gone?  If Not, Let Them Shoot
2460 REM
2470 IF TK = 0 THEN 2640 ELSE IF SCREEN(20,25) = 68 THEN RETURN
2480 IF MID$(STR$(G(SEC)),4,1) = "0" THEN RETURN
2490 LOCATE 23,5,0: PRINT STRING$(30,32)
2500 LOCATE 23,8: PRINT "Red Alert: Klingon Attack!"
2510 FOR A = 0 TO 63: X = FNX(A): Y = FNY(A)
2520 IF SCREEN(Y,X) <> 75 THEN 2580
2530 SHL = SHL - INT(40 / SQR((EX - X)^2 + (EY - Y)^2))
2540 DX = (EX - X) / 10: DY = (EY - Y) / 10: PCOPY 0,1
2550 FOR B = 0 TO 10: LOCATE Y,X: PRINT CHR$(219): SOUND 1000,.1
2560 X = X + DX: Y = Y + DY: PCOPY 1,0: NEXT B
2570 IF SHL < 1 THEN 2620 ELSE GOSUB 2350
2580 NEXT A: RETURN
2590 REM
2600 REM Announce Completion of Game
2610 REM
2620 LOCATE 22,4: PRINT "Your shields have been destroyed!"
2630 LOCATE 23,4: PRINT "The Federation has been defeated!": GOTO 2660
2640 LOCATE 22,4: PRINT "The Klingons have been eliminated!"
2650 LOCATE 23,5: PRINT CHR$(32); "The Federation has been saved!"
2660 LOCATE 24,8,1: PRINT "Want to play again (Y/N)?"; CHR$(32);
2670 A$ = INKEY$: IF A$ = "Y" OR A$ = "y" THEN 1160
2680 IF A$ = "N" OR A$ = "n" THEN 2740 ELSE 2670
2690 REM
2700 REM Error Trapping Routine
2710 REM
2720 IF ERL = 1860 THEN RESUME 1870 ELSE RESUME 2730
2730 CLS: PRINT: PRINT "Error Code #"; ERR; "in Line Number"; ERL
2740 SCREEN 0: WIDTH 80: CLS: LOCATE 12, 30
2750 PRINT "One Moment Please...": RUN "menu"
