                              COREWAR COMMANDS
                             ------------------

   BGN Name   This needs to be at the beginning of every organism.  Name
              can be any string.

   END        This needs to be at the end of every organism.

   DAT  B     Holds a data value B.  Executing a DAT command will produce
              an error.

   MOV  A B   Move the contents from A into B.

   ADD  A B   Add the contents of A to the contents of B.

   SUB  A B   Subtract the contents of A from the contents of B.

   JMP  A     Jump (transfer control) to address A.

   JMZ  A B   If the contents of B are zero, jump to address A.

   JMN  A B   If the contents of B are not zero, jump to address A.

   JMG  A B   If the contents of B are greater than zero, jump to 
              address A.

   DJZ  A B   Decrement the contents of B, and jump to address A if the 
              contents of B are then zero.

   DJN  A B   Decrement the contents of B, and jump to address A if the
              contents of B are then unequal to zero.

   CMP  A B   Compare the contents of A and the contents of B, and if 
              they are unequal, skip the next instruction.

   SPL  A     Create another execution stream starting at address A.

   JWN  A B   Jump to address A if you own B.

   RND  A B   Put a random number modulus B in address A.

   SLP  A     Sleep the current execution stream for a number of cycles
              equal to the contents of A.

The addressing is as follows:

   Relative :  N   the number of the relative address.

   Indirect :  @N  the address pointed to by what's at address N.

Examples :

   MOV   #3   10    ;  moves number 3 to a relative address 10 ahead. 

   MOV   5    10    ;  moves what's at relative address 5 to relative
                       address 10.

   MOV   @-2   5    ;  moves what's pointed to by relative address -2
                       to relative address 5.

   MOV   #5   @10   ;  moves number 5 to what's pointed to by relative
                       address 10 ahead.


Commands can be either upper or lowercase.  Several organisms have been
included with Corewar as examples.  Here are a few of the more interesting
ones :

   BUG.PRG
   DAEMON.PRG
   DEFENDER.PRG
   DEMON.PRG
   GEMINI.PRG
   PARASITE.PRG

