ATTFILES.HLP
This menu allows you to save and
reload sets of parameters or complete
pictures.  The parameter files have
the suffix .SAP, for "Strange Attractor
Parameters," and the picture files
have the suffix .GIF.

SAVE PARAMETERS: [Alt-s]
LOAD PARAMETERS: [Alt-l]
The parameter files are only a few
hundred bytes in size.  When you
reload a parameter file, the image
is live, meaning that all the program
parameters have been set to the
saved values.  This is useful for
repeating experiments or demonstrations.
 Since parameter files are so small,
they are good for exchanging with
friends who have their own copy
of JAMES GLEICK'S CHAOS: THE SOFTWARE.
 Parameter files are in fact text
files, so you can edit them with
your word processor.

SAVE IMAGE AS GIF: [Alt-g]
SAVE SCREEN AS GIF: [Alt-h]
TheGIF files are large, often as
big as 30,000 bytes.  When saving
a .GIF file you can save a copy
of just the IMAGE area or you can
save a copy of the whole SCREEN,
including the stamps and the status
line.  GIF files are a standard,
bit-mapped picture format used for
portability among all personal computers,
including Macintosh, Amiga, Atari,
Apple II, and IBM.  In some cities
it is possible to have prints or
posters made from GIF files.

VIEW GIF IMAGE: [Alt-f]
When you view a GIF you will see
exactly what you saw when you saved
it,  and then when you press any
key, the picture will disappear.
 Viewing a GIF file does NOT reset
the parameters.

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To exit the menu without
doing anything, select the CANCEL
button, or press the ESCAPE key,
or click the right mouse button.

ATTHTWK.HLP
This menu is for tweaking the Hnon
attractors or the Hnon Horseshoe
attractor.  You are watching marks
made by a flock of points which
are jumping around onscreen.  Each
point keeps using Hnon's equations
to compute the next position it
should jump to.

FLOCK SIZE: [v] [INS, DEL]
A SMALL flock has 1 point, a MEDIUM
flock has 4 points, and a LARGE
flock has 64 points.  On the main
screen, if the triangular Select
cursor is showing, you can change
the flock size by adding points
with the left mouse button or with
the INS key.  You can delete flock
points with the right mouse button
or the DEL key.  After deleting
points, use Alt-r to clear the screen
to remove the old points' images.
 If you change the CHAOTICITY, the
flock size will return to one of
the standard values of 1, 4, or
64.

TRACE TYPE: [t]
In POINT Trace Type, each point
marks a single pixel when it lands.
 In LINE Trace Type, each point
draws a line segment from its present
position to its next position. 
After a point has drawn a certain
number of segments it starts erasing
the oldest ones.  The number of
segments which a point draws before
erasing is controlled by the TRACE
LENGTH parameter on the OPTIONS
menu.

CHAOTICITY: [a,A,b,B,c,C]
This tweak does not apply to the
Hnon Horseshoe.  For each value
of CHAOTICITY between 0 and 4, the
standard Hnon attractor takes on
a different shape.  Some of the
images may look better if you zoom
out.  CHAOTICITY can be adjusted
by typing in a new value, using
the slider, or using the buttons
beneath the slider.  When the TWEAKS
menu is not displayed you can use
the aAbBcC keys to decrease (lower
case) or increase (upper case) the
CHAOTICITY in large steps (aA),
medium steps (bB), or small steps
(cC).

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To drag a slider,
use the arrow keys, or hold the
left mouse button down and move
the mouse --- or move the mouse
to a position on the slider bar
and left-click the mouse.  To reject
your changes, select the CANCEL
button, or press the ESCAPE key,
or click the right mouse button.
 Select the ACCEPT button to adopt
your changes.

ATTLGTWK.HLP
This menu is for tweaking the Logistic
Map, the Logistic Pulse, or the
Logistic Hump, all of which are
images of the same process.

ACCURACY:
This applies only to the Logistic
Map.  The ACCURACY controls how
many left-to-right passes it takes
until the image shown is quite accurate.
 If ACCURACY is low, the earlier
passes have lines which are fanned
out into sheaves of several lines.

CHAOTICITY: [a,A,b,B,c,C]
This applies only to the Logistic
Pulse and the Logistic Hump.  Each
value of Chaoticity between 0 and
4 corresponds to a vertical cross-section
of the Logistic Map.  The values
between about 3 and 4 are the most
interesting.  CHAOTICITY can be
adjusted by typing in a new value,
using the slider, or using the buttons
beneath the slider.  When the TWEAKS
menu is not displayed you can use
the aAbBcC keys to decrease (lower
case) or increase (upper case) the
CHAOTICITY in large steps (aA),
medium steps (bB), or small steps
(cC).  When the TWEAKS menu is not
displayed you can use the aAbBcC
keys to decrease (lower case) or
increase (upper case) the CHAOTICITY
in large steps (aA), medium steps
(bB), or small steps (cC).

HUMPSPOT: [o,O]
This affects all three Logistic
displays, but is the easiest to
see in Logistic Hump.  The horizontal
axis in the Logistic Hump picture
runs from 0 to 1.  The HUMPSPOT
variable lets you move the curve's
hump to any position from 0.1 to
0.9.  In Logistic Hump, any fixed
value of CHAOTICITY produces the
same shape "spider-web" pattern
over the whole range of HUMPSPOTs.
 The effect of HUMPSPOT on Logistic
Map is to dramatically warp the
pattern down or up, yet without
moving the horizontal positions
of the branchings to the left or
the right.  The HUMPSPOT value is
adjusted by typing in a new value,
using the slider, or using the buttons
beneath the slider.  When the TWEAKS
menu is not displayed, you can decrease
or increase the HUMPSPOT by pressing
o or O.

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To drag a slider,
use the arrow keys, or hold the
left mouse button down and move
the mouse --- or move the mouse
to a position on the slider bar
and left-click the mouse.  To reject
your changes, select the CANCEL
button, or press the ESCAPE key,
or click the right mouse button.
 Select the ACCEPT button to adopt
your changes.

ATTLTWK.HLP 
This menu is for tweaking the Lorenz
attractor, which we show as a flock
of points moving in three-dimensional
space.  Points can be drawn as little
"flies" with their own 3D coordinate
systems.

FLOCK SIZE: [v] [INS, DEL]
A SMALL flock has 1 point, a MEDIUM
flock has 27 points, and a LARGE
flock has 64 points.  You can also
set the flocksize by typing a number
into the number box.  On the main
screen, if the triangular Select
cursor is showing, you can change
the flock size by adding points
with the left mouse button or with
the INS key.  You can delete flock
points with the right mouse button
or the DEL key.  The points you
add will have the form of "flies."
 When you change flock size, any
flies will be eliminated.

VIEW: [x,y,z,w]
The Lorenz attractor is a pattern
in three-dimensional space.  The
three VIEWs X, Y, and Z show the
attractor from a point on the x,y,
and z axes, respectively.  The FLY
VIEW takes the most recently added
fly's current coordinate system,
picks a point on the fly's axis
of motion, and projects from that
point onto the plane of the fly's
other two axes.

ACCURACY: [u,U]
ACCURACY measures the size of the
simulation's timesteps.  This value
is shown in the number box.  HIGH
ACCURACY means small timesteps,
and LOW ACCURACY means large timesteps.
 Timesteps can be set directly by
typing into the number box.  If
you use a very small stepsize, you
should turn RIBBON ERASE off.

RIBBON ERASE: [t,s]
If RIBBON ERASE is OFF, the moving
points lay down permanent trails.
 If RIBBON ERASE is ON, old trails
after they reach a certain length.
 This length is controlled by the
TRACE LENGTH parameter on the OPTIONS
menu.  The flies' trails can only
be toggled on and off with the s
key.

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

ATTPAL.HLP
COLOR SQUARES:
Use the mouse or arrow keys to highlight
a color square and left-click or
press Enter to select it for editing.
 If we number the colors 1 through
8 in the top row and 9 through 16
in the second row, then color number
1 is the background color; this
is the color square selected by
default when you enter the palette
menu.  Colors 1, 2, 7, 8, 15, and
16 are used in the menus, and the
other colors are used in the images.
 If you have "unlocked" the menu
colors by pressing Alt-e, then the
menu colors are used in the image
as well.

R G B SLIDERS:
The sliders control the amount of
RED, GREEN, and BLUE used to make
the shade of the selected color
square.  If you have no mouse, use
the up and down arrow keys to put
the cursor on a slider.  To drag
a slider, use the left and right
arrow keys, or hold the left mouse
button down and move the mouse ---
or move the mouse to a position
on a slider bar and left-click the
mouse.  Since EGA systems have fewer
colors than VGA graphics systems,
they display a larger slider.

SAVE: [s]
LOAD: [l]
These keys call up a menu which
lets you save or load a particular
palette.  When the Game module starts
up it always loads the ATTRACT.PAL.
 If you save a palette under the
name ATTRACT.PAL, then this will
become the new default palette for
the Game module.  The .PAL files
are saved as small text files.

To reject your color changes, select
the CANCEL button, press ESC, or
right-click your mouse.  To keep
your color changes, select the ACCEPT
button by moving to it and pressing
Enter.

ATTRMAIN.HLP
GETTING STARTED
Keep pressing d to look at the seven
different types of attractors. 
Their names are Lorenz, Yorke, Hnon,
Hnon Horseshoe, Logistic Map, Logistic
Pulse, and Logistic Hump.  SPECIAL
HOT KEYS, CURSOR ACTIONS, and GENERAL
HOT KEYS are listed below.

SPECIAL HOT KEYS
A,a: Increase or decrease CHAOTICITY
by 0.1.
B,b: Increase or decrease CHAOTICITY
by 0.01.
C,c: Increase or decrease CHAOTICITY
by 0.001.
  d: Change to the next attractor.
  e: Toggle between ZOOM cursor
and SELECT cursor.
L,l: Increase or decrease the TRACE
LENGTH.
  n: Toggle betwen general Hnon
and Horseshoe Hnon.
  n: Change Yorke's parameters.
  N: Reset Yorke's parameters.
O,o: Shift the Logistic HUMPSPOT
right or left.
  p: Toggle automatic stamping
  s: Toggle Lorenz flies' trace.
  t: Toggle TRACE TYPE in Lorenz,
Yorke, Hnon, & Hnon Horseshoe.
  t: Toggles between Logistic Pulse
and Logistic Hump.
U,u: Increase or decrease Lorenz
ACCURACY.
  v: Change the FLOCK SIZE.
  w: Change the Yorke WORLD SHAPE.
  w: Pick FLY VIEW in Lorenz.
x,y,z: Pick X, Y, or Z VIEW in Lorenz.
comma: slower.
period: faster.
Spacebar: single step.
Shift + Spacebar: Continuous run.
Alt-1 thru Alt-3: Restore the parameters
from stamp 1 through stamp 3.
Alt-4 thru Alt-6: Show the parameters
for stamp 1 through stamp 3.
(Stamp 1 is at bottom, Stamp 3 at
top.)

CURSOR ACTIONS
  e: Toggle between ZOOM cursor
and SELECT cursor.
INS or left-click with ZOOM cursor
or ZOOMBOX: Zoom in.
DEL or right-click with ZOOM cursor
or ZOOMBOX: Zoom out.
INS or left-click with SELECT cursor:
Add a flock point in Lorenz , Henon,
or Yorke.
DEL or right-click with SELECT cursor:
Delete a flock point in Lorenz ,
Henon, or Yorke.
INS or left-click with SELECT cursor:
In Logistic Map, sets CHAOTICITY
and changes to Logistic Pulse.
INS or left-click with SELECT cursor:
In Logistic Pulse and Logistic Hump,
changes starting value and redraws.
DEL or right-click with SELECT cursor:
In Logistic Pulse and Logistic Hump,
returns to Logistic Map.

GENERAL HOT KEYS
Alt-a: Select a preset palette.
Alt-b: Randomize the palette.
Alt-c: Recenter and unzoom the image.
Alt-d: Select the default palette.
Alt-e: Toggle the use of the menu
colors in the image.  (Does not
work in Toy.)
Alt-f: Look at a .GIF file.
Alt-g: Save the image area as a
.GIF file.
Alt-h: Save the whole screen as
a .GIF file.
Alt-i: Change the status line mode.
Alt-j: Cycle the colors one step
forward.
Alt-k: Cycle the colors one step
backwards.
Alt-l: Load a parameter file.
Alt-m: Toggle between color and
monochrome images.
Alt-o: Recenter the screen at current
cursor position.
Alt-p: Enter the palette editor.
Alt-q: Quit to DOS.
Alt-r: Erase and redraw the image.
Alt-w: Save the current parameters.
Alt-t: Make a stamp.
Alt-v: Turn sound on or off.
Alt-w: Show information about program.
Alt-x: Exit to the Chaos menu.
Alt-y: Change the automatic color-cycling
mode.
Alt-z: Toggle the zoombox on or
off.

ATTVIEW.HLP 
COLOR CYCLE ONCE: [Alt-j, Alt-k]
This cycles the image colors one
notch forward or backwards for each
time you select the FORWARD or REVERSE
button.  This command takes effect
immediately.

AUTOCYCLE: [Alt-y]
This sets the image's colors to
cycling continuously forward or
backward, or turns the continuous
cycling off.

PALETTE: [Alt-d, Alt-b, Alt-a, Alt-p]
You can return to the DEFAULT starting
palette, try a RANDOM palette, step
through the various PRESET palettes,
or enter a new menu to EDIT your
palette.

MONOCHROME: [Alt-m]
If you have a VGA-compatible graphics,
you can switch a special monochrome
mode OFF or ON.

SOUND: [Alt-v]
The SOUND can be turned ON or OFF.
 In Lorenz, the frequency of the
tone is proportional to the speed
of the most recent flock member.
 In the other attractor types, the
tone is propotional to the most
recent flock member's height above
the bottom screen edge.

STAMPING: [p]
If STAMPING is set to MANUAL, you
must press Alt-t whenever you want
to save a stamp.  If STAMPING is
AUTO, then a new stamp is made with
each keypress.

CURSOR: [e]
The ZOOM cursor enables you to zoom
in and out with INS and DEL, or
with the left and right mouse buttons.
 The SELECT cursor allows you to
add or delete flock points with
the same controls.  In Logistic
Map, the SELECT cursor chooses a
CHAOTICITY and goes to Logistic
Pulse mode.

TRACE LENGTH: [l,L]
This controls the length of the
trails in Lorenz if the TWEAKS menu
RIBBON ERASE is ON, and controls
the number of segments per line
in Henon and Yorke if the TWEAKS
menu TRACE TYPE is LINE.  You can
enter a number or you can select
the - or +b buttons or you can enter
a number in the number box.

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

ATTYPE.HLP 
This menu allows you to switch among
seven options.  You can cycle through
the options without this menu by
using the d key.

LORENZ:
The Lorenz Attractor is a pattern
in three-dimensional space.  The
moving points and airplanes hug
the attractor.  Press x,y,z, and
w for different views.  Use the
SELECT cursor and left and right
clicks or presses of INS and DEL
to add and remove points.

YORKE:
The Yorke attractors are rippled
patterns inside a two-dimensional
unit square.  Note that the opposite
edges match.  Use the n key to vary
them, and adjust CHAOTICITY with
A and a.

HNON:
The Hnon attractors are mandala-like
patterns in two-dimensional space.
 Use the a and A keys to vary them.
 Press Alt-v to toggle sound on
and off.

HNON HORSESHOE:
The Hnon Horseshoe attractor is
a folded two-dimensional pattern
with endless levels of detail. 
Try using the ZOOM cursor to zoom
in on it.

LOGISTIC MAP:
The Logistic Map consists of a large
number of one-dimensional attractors
set vertically and stuck side to
side.  Try using the ZOOM cursor
to find self-similarities in it.
 Use the SELECT cursor with left-click
or INS to see the LOGISTIC PULSE
pattern for a vertical slice.

LOGISTIC PULSE:
Each setting of CHAOTICITY produces
a different pulse.  Use Alt-v to
hear them, and use Alt-i to see
the chaoticity value.  Press A and
a to vary the CHAOTICITY.  Use t
to swap back and forth between LOGISTIC
PULSE and LOGISTIC HUMP.

LOGISTIC HUMP:
This shows the process by which
LOGISTIC PULSE is computed.  Use
O and o to shift the curve's hump
back and forth.  Use A and a to
vary the CHAOTOCITY.  Use t to swap
back and forth between LOGISTIC
HUMP and LOGISTIC PULSE.

USING THE MENU:
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

ATTYTWK.HLP This menu is for tweaking
the Yorke attractors.
FLOCK SIZE: [v] [INS, DEL]

A SMALL flock has 1 point, a MEDIUM
flock has 4 points, and a LARGE
flock has 64 points.  On the main
screen, if the triangular Select
cursor is showing, you can change
the flock size by adding points
with the left mouse button or with
the INS key, or deleting flock points
with the right mouse button or the
DEL key.  After deleting points,
use Alt-r to clear the screen to
remove the old points' images. 
If you change the CHAOTICITY, X
SHIFT, or Y SHIFT paramters, the
flock size will return to one of
the standard values of 1, 4, or
64.

TRACE TYPE: [t]
In POINT Trace Type, each point
marks a single pixel when it lands.
 In LINE Trace Type, each point
draws a line segment from its present
position to its next position. 
After a point has drawn a certain
number of segments it starts erasing
the oldest ones.  The number of
segments which a point draws before
erasing is controlled by the TRACE
LENGTH parameter on the OPTIONS
menu.

WORLD SHAPE: [w]
In the Yorke attractor the screen
is wrapped around so that if a point
moves off one side of the screen
it comes back on the opposite side.
 It is as if the opposite edges
are glued together.  We allow the
possibility that an edge may be
flipped over before the gluing.
 If WORLD SHAPE is TORUS, no edges
are flipped.  In KLEIN, the top
edge is flipped from left to right
before being glued to the bottom
edge.In PROJECTIVE, we also flip
the right edge from top to bottom
before gluing it to the left edge.

CHAOTICITY: [a,A,b,B,c,C]
X SHIFT:
Y SHIFT:
If you set CHAOTICITY to 0, you
can see that the effect of X SHIFT
and Y SHIFT are to change the angle
of some line-like patterns.  For
each X SHIFT and Y SHIFT setting,
there are a few optimal values of
CHAOTICITY that produce the best
images.  You can change each of
the three parameters by slecting
the appropriate number box and typing
in a new number, using the sliders,
or using the buttons beneath the
sliders.  When the TWEAKS menu is
not displayed you can use the aAbBcC
keys to decrease (lower case) or
increase (upper case) the CHAOTICITY
in large steps (aA), medium steps
(bB), or small steps (cC).

RANDOMIZE: [n]
RESET: [N]
The first five times you use RANDOMIZE
you go through five preset parameter
settings.  After that, RANDOMIZE
only changes X SHIFT and Y SHIFT.
 RESET goes back to the first of
the presets.

USING THE MENU:
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To drag a slider,
use the arrow keys, or hold the
left mouse button down and move
the mouse --- or move the mouse
to a position on the slider bar
and left-click the mouse.  To reject
your changes, select the CANCEL
button, or press the ESCAPE key,
or click the right mouse button.
 Select the ACCEPT button to adopt
your changes.

BARNFILE.HLP 
This menu allows you to save and
reload sets of parameters or complete
pictures.  The parameter files have
the suffix .IFS, for "Iterated Function
System," and the picture files have
the suffix .GIF.

SAVE PARAMETERS: [Alt-s]
LOAD PARAMETERS: [Alt-l]
The parameter files are only a few
hundred bytes in size.  When you
reload a parameter file, the image
is live, meaning that all the program
parameters have been set to the
saved values.  This is useful for
repeating experiments or demonstrations.
 Since parameter files are so small,
they are good for exchanging with
friends who have their own copy
of JAMES GLEICK'S CHAOS: THE SOFTWARE.
 Parameter files are in fact text
files, so you can edit them with
your word processor.

SAVE IMAGE AS GIF: [Alt-g]
SAVE SCREEN AS GIF: [Alt-h]
TheGIF files are large, often as
big as 30,000 bytes.  When saving
a .GIF file you can save a copy
of just the IMAGE area or you can
save a copy of the whole SCREEN,
including the stamps and the status
line.  GIF files are a standard,
bit-mapped picture format used for
portability among all personal computers,
including Macintosh, Amiga, Atari,
Apple II, and IBM.  In some cities
it is possible to have prints or
posters made from GIF files.

VIEW GIF IMAGE: [Alt-f]
When you view a GIF you will see
exactly what you saw when you saved
it,  and then when you press any
key, the picture will disappear.
 Viewing a GIF file does NOT reset
the parameters.

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To exit the menu without
doing anything, select the CANCEL
button, or press the ESCAPE key,
or click the right mouse button.

BARNMAIN.HLP 
GETTING STARTED
First press n repeatedly to flip
through the preset images.  Then
press w to turn on Triangle Edit
mode, and try left-clicking to move
the white triangle's corners.  If
you do not have a mouse, use Shift-arrowkeys
to move around in the image, and
press the 5 key on the keypad to
move a triangle's corner.  SPECIAL
HOT KEYS, CURSOR ACTIONS, and GENERAL
HOT KEYS are listed below.

SPECIAL HOT KEYS
  a: Adds a new map.
  c: Changes current map for editing.
  e: Shows the weight editor.
  f: Change the FLOCK TYPE. 
  j: Change the COLORING style.
  l: Toggle automatic palette randomization.
  m: Toggle map icons.
  n: Show the next preset pattern.
  r: Clear screen and re-initialize
the flock.
  t: Toggle the TRACE.
  u: Undo one change to this image.
  v: Undo all changes to this image.
  z: Randomize the maps. 
Alt-1 thru Alt-3: Restore the parameters
from stamp 1 through stamp 4.
(Stamp 1 is at bottom, Stamp 4 at
top.)

CURSOR ACTIONS
i or the keypad 5 or left-click
with TRIANGLE cursor: Move nearest
triangle corner to cursor.
c or right-click with TRAINGLE cursor:
Change the active triangle.
I or left-click with WEIGHT cursor:
Increase weight of the nearest map.
i or right-click with WEIGHT cursor:
Decrease weight of the nearest map.
k with WEIGHT cursor: Set weight
of the nearest map to zero.
w : Toggle between WEIGHT cursor
and TRIANGLE cursor.
INS,DEL with either cursor: Zoom
in or zoom out.
INS,DEL with ZOOMBOX: Zoom in or
zoom out.

GENERAL HOT KEYS
Alt-a: Select a preset palette.
Alt-b: Randomize the palette.
Alt-c: Recenter and unzoom the image.
Alt-d: Select the default palette.
Alt-e: Toggle the use of menu colors
in the image. (Does not work in
Toy.)
Alt-f: Look at a .GIF file.
Alt-g: Save the image area as a
.GIF file.
Alt-h: Save the whole screen as
a .GIF file.
Alt-i: Change the status line mode.
Alt-j: Cycle the colors one step
forward.
Alt-k: Cycle the colors one step
backwards.
Alt-l: Load a parameter file.
Alt-m: Toggle between color and
monochrome images.
Alt-o: Recenter the screen at current
cursor position.
Alt-p: Enter the palette editor.
Alt-q: Quit to DOS.
Alt-r: Erase and redraw the image.
Alt-w: Save the current parameters.
Alt-t: Make a stamp.
Alt-v: Turn sound on or off.
Alt-w: Show information about program.
Alt-x: Exit to the Chaos menu.
Alt-y: Change the automatic color-cycling
mode.
Alt-z: Toggle the zoombox on or
off.

BARNOPTS.HLP 
COLOR CYCLE ONCE: [Alt-j, Alt-k]
This cycles the image colors one
notch forward or backwards for each
time you select the FORWARD or REVERSE
button.  This command takes effect
immediately.

AUTOCYCLE: [Alt-y]
This sets the image's colors to
cycling continuously forward or
backward, or turns the continuous
cycling off.

PALETTE: [Alt-d, Alt-b, Alt-a, Alt-p]
You can return to the DEFAULT starting
palette, try a RANDOM palette, step
through the various PRESET palettes,
or enter a new menu to EDIT your
palette.

MONOCHROME: [Alt-m]
If you have a VGA-compatible graphics,
you can switch a special monochrome
mode OFF or ON.

COLORING: [J,j]
The ONE MAP style of COLORING most
clearly shows the influence of the
distinct maps on the image.  Use
the j key to see how the other COLORING
styles look with your image.  Note
that when the use of menu colors
is toggled on and off with the Alt-e
key, some of the COLORING effects
will change.

MAPS: [m]
This turns square icon pictures
of the maps ON or OFF.  Each map
icon is the image under that map
of the image area's rectangular
border.  The "faces" on the maps
are so you can see if they involve
a flip or a rotation.

FLOCK TYPE: [f]
The chaos game shows a flock of
points hopping about and coloring
the spots where they land.  The
DOTS flock starts as a 4 by 4 grid
of 16 points.  The RECTANGLE flock
starts as hundreds of points arranged
in lines along the edges of the
screen.  The LOGO flock starts as
hundreds of points arranged into
the Autodesk logo.  The r key will
re-fill a flock.

TRACE: [t]
If trace is OFF, each flock point's
mark is erased right after being
painted; if trace is ON, the marks
persist. DOTS and LOGO usually look
best with trace ON; RECTANGLE looks
best with trace OFF.

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

BARNPAL.HLP
COLOR SQUARES:
Use the mouse or arrow keys to highlight
a color square and left-click or
press Enter to select it for editing.
 If we number the colors 1 through
8 in the top row and 9 through 16
in the second row, then color number
1 is the background color; this
is the color square selected by
default when you enter the palette
menu.  Colors 1, 2, 7, 8, 15, and
16 are used in the menus, and the
other colors are used in the images.
 If you have "unlocked" the menu
colors by pressing Alt-e, then the
menu colors are used in the image
as well.

R G B SLIDERS:
The sliders control the amount of
RED, GREEN, and BLUE used to make
the shade of the selected color
square.  If you have no mouse, use
the up and down arrow keys to put
the cursor on a slider.  To drag
a slider, use the left and right
arrow keys, or hold the left mouse
button down and move the mouse ---
or move the mouse to a position
on a slider bar and left-click the
mouse.  Since EGA systems have fewer
colors than VGA graphics systems,
they display a larger slider.

SAVE: [s]
LOAD: [l]
These keys call up a menu which
lets you save or load a particular
palette.  When the Game module starts
up it always loads the GAME.PAL.
 If you save a palette under the
name GAME.PAL, then this will become
the new default palette for the
Game module.  The .PAL files are
saved as small text files.

To reject your color changes, select
the CANCEL button, press ESC, or
right-click your mouse.  To keep
your color changes, select the ACCEPT
button by moving to it and pressing
Enter.

BARNTWK.HLP
How to Use the Tweaking Controls

When "tweak" mode is activated (using
the F4 key), a new set of controls
appears on your screen, and the
calculated image shrinks to fill
one quarter of the screen. The controls
are designed to let you easily change
the parameters of the IFS currently
in effect, in three different (but
equivalent) representations. 
The six numbers that make up a single
map in an IFS are displayed in three
ways: as raw numbers (which we call
"Matrix" mode); as three corners
of a triangle (which we call "Triangles"
mode); or as values representing
the geometric concepts of "rotatation",
"tanslation", and "scaling". The
"Display Mode" button rotates between
these three modes.  The bottom part
of the screen shows all the parameters
for the first six maps (you can
show more maps, if there are any,
by either clicking on the left and
right arrow boxes, or by using the
PgUp and PgDn keys); the bottom
display is always in "Matrix" mode.

In "Matrix" mode, the six numbers
are called simply by the labels
A through F. The A and D parameters
tend to change the height and width
of the rectangle; the B and C parameters
tend to "squash" or "stretch" the
box; the E and F parameters change
the box location. Matrix mode is
generally used to describe Barnsley
fractals, and is most useful for
sharing interesting discoveries
with other intrepid Barnsley explorers.

In "Triangles" mode, you control
the parameters based upon the X
and Y coordinates of the three points
of a triangle.  
In "Angles" mode, the parameters
are based upon rotation, scaling,
and translation. The two rotation
values are specified in degrees
(from -180 to 180); the scaling
is always a positive value; and
the translation is identical to
the E and F parameters in "Matrix"
mode. Note that sometimes you will
try to change one of the rotation
angles, and the change will seem
to be not accepted by the computer.
This will happen when the box is
"degenerate" (that is, it has a
scale of zero in one of the directions).

In all of the modes, weight is displayed
the same way.  When you add weight
from one map, you remove it from
the others in a regular fashion.
 
The "Increment" button determines
how much of a change the plus/minus
buttons will make. Note that in
"Angles" mode, the increment is
actually multiplied by 10; so that
if the "increment" is .1, the angle
will actually change by 1 degree.

If you want to enter the numbers
manually, rather than using the
plus and minus keys, either click
on the big part of the button (the
part with the name and the number
on it), or move the highlight to
that button with the arrow keys
and hit the Enter key. 
If you are in "Triangles" mode,
you can edit the image on the screen
as described in "triangle editing"
mode above. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.


BARNWGHT.HLP 
This menu is the most precise way
to control the weights of the maps
in your current function system.
 Navigate with the arrow keys or
mouse, and type in the numbers that
you want to set. The numbers are
probablilities; for example, if
a map has probability .500, it will
be selected 1/2 the time. 
There are two special controls on
this menu. 
The first is NORMALIZE. This one
adjusts all the values so that they
add to 1.000.  
The second is EQUALIZE.  This one
makes all the values the same. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

FORGANIM.HLP 
This is the Animation menu. From
here, you can make animated movies
of clouds, planets, contours, or
mountains, varying the parameters
used from frame to frame. Select
which sort of forgery you wish to
animate; change the parameters as
you wish (you can set the parameters
from the main screen using the Start
and End buttons as well); and press
or click ANIMATE to start the animation.
The resulting movie will be compatible
with Autodesk Animator. 
The different parameters vary over
time in smooth gradations. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.


FORGCOPT.HLP 
There are only two options specific
to  Contouring. The first option,
Smoothing, selects between a raw
display of the data (when smoothing
is Off) or a smoothed-out display
of the data. The second option,
Wrapping, only applies when Smoothing
is on; when activated, the image
will be continuous in both the east-west
and north-south directions. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.


FORGE.HLP 
HotKeys: 
F1-F9 select something on the menu

Up and down arrow keys change the
 "active button" 
If the active button is on a slider,
 right and left arrow keys move
the  slider. 
Alt-X: quit to main menu 
Alt-Q: quit to DOS 
a,A: animate 
e,E: set end animation values 
m,M: change mesh size 
r,R: render 
s,S: set start animation values

t,T: change terms 
v,V: view animation 
x,X: save DXF file 
z,Z: randomize 
Alt-F: view GIF file 
Alt-G: save GIF file 
1,2,3, and 4 will change which rectangle
the next image will be created in.
Left-clicking on a rectangle does
the same thing. 
Alt-1 through Alt-4 will set the
parameters to that in rectangle
1 through 4. Right-clicking on a
rectangle does the same thing. 
'S' will set the starting animation
parameters to the current parameters;
'E' will set the ending parameters.


USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To drag a slider,
use the arrow keys, or hold the
left mouse button down and move
the mouse --- or move the mouse
to a position on the slider bar
and left-click the mouse.  To reject
your changes, select the CANCEL
button, or press the ESCAPE key,
or click the right mouse button.
 Select the ACCEPT button to adopt
your changes.

FORGFILE.HLP 
This menu allows you to save and
reload sets parameters, complete
pictures, animations, or Autocad
drawing files.  The parameter files
have the suffix .FOR, for "Forgery,"
the picture files have the suffix
.GIF, the animation files have the
suffix .FLI, and the Autocad drawings
use the  suffix .DXF.

SAVE PARAMETERS: [Alt-s]
LOAD PARAMETERS: [Alt-l]
The parameter files are only a few
hundred bytes in size.  When you
reload a parameter file, the image
is live, meaning that all the program
parameters have been set to the
saved values.  This is useful for
repeating experiments or demonstrations.
 Since parameter files are so small,
they are good for exchanging with
friends who have their own copy
of JAMES GLEICK'S CHAOS: THE SOFTWARE.
 Parameter files are in fact text
files, so you can edit them with
your word processor.

SAVE IMAGE AS GIF: [Alt-g]
SAVE SCREEN AS GIF: [Alt-h]
TheGIF files are large, often as
big as 30,000 bytes.  When saving
a .GIF file you can save a copy
of just the IMAGE area or you can
save a copy of the whole SCREEN,
including the stamps and the status
line.  GIF files are a standard,
bit-mapped picture format used for
portability among all personal computers,
including Macintosh, Amiga, Atari,
Apple II, and IBM.  In some cities
it is possible to have prints or
posters made from GIF files.

VIEW GIF IMAGE: [Alt-f]
When you view a GIF you will see
exactly what you saw when you saved
it,  and then when you press any
key, the picture will disappear.
 Viewing a GIF file does NOT reset
the parameters.

ANIMATE:
This brings up the special Animation
menu. This is only useful if you
have a VGA. 

VIEW ANIMATION:
"View Animation" will allow you
to view animations, if you have
a VGA. 

SAVE AS DXF:
This creates a kind of three-dimensional
blueprint of the image which can
be exported to such programs as
Autodesk Animator, AutoCAD, AutoSketch,
or AutoShade.  No matter what Rendering
selection you make, all DXF files
are made into Mountains. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To exit the menu without
doing anything, select the CANCEL
button, or press the ESCAPE key,
or click the right mouse button.

FORGMOPT.HLP 
There are four options involving
mountain generation. 
"Azimuth" and "Elevation" control
the "camera" viewpoint. Elevation
can go from 0 to 90 degrees, and
is a measure of how high from the
ground  the camera is. Azimuth spins
the entire mountain range around
its center.  
"Limit" controls what percentage
of the screen height will be filled
with the mountain range. 
"Clouds" is only used during rendering
in VGA mode and in animation. If
clouds are on, then  a cloudy background
will be added to the rendered  image.


USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

FORGOOPT.HLP 
These options control whether information
is placed on renderings and animations.
Parameter Stamping puts the parameters
used to create a rendering on the
screen; Frame Stamping puts the
frame number of each frame on the
screen of an animation. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

FORGOPTS.HLP 
From here you access the individual
options  menus. 
USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

FORGPOPT.HLP 
There are six controls involving
 planet generation. 
The "hour" and "season" control
where the "star" is relative to
the "planet", and hence the positioning
of the "dark side" of the planet.
The hour can range from -24 to 24,
simulating the rotation of the planet
around its axis (or, if you prefer
to think geocentrically, the motion
of the star around the planet.)
The "season" controls the inclination
of the star; season zero means that
the star is on the same plane as
the orbit of the "planet". 
"Projection" controls how the planet
is painted. If the projection is
"globe", the planet will look somewhat
like  a globe; if the projection
is "map", it will look like a flat
map of the planet. 
"Icecaps" determines whether or
not icecaps are painted. 
"Dither" only affects rendering
and animation, and determines whether
the image is "dithered", with lots
of dots (this looks best when viewed
from a distance), or undithered.

"Rotation" only affects animation.
When rotation is EW or WE, the planet
will rotate from frame to frame,
giving a complete rotation over
the course of the animation. 
USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

FORGREND.HLP 
This is the Rendering Menu. From
this menu, you create full-screen
renderings of your Fractal Forgery.
 If you have a VGA, you can create
256-color renderings; otherwise,
you are limited to 16-color renderings.
 Use the mouse or the arrow keys
to move the cursor; left-click or
hit RETURN to activate the button
that the cursor is on. If you select
"Render to File", you will be prompted
for a filename in which to save
the completed rendering. Press ESC
(or right-click the mouse) to cancel.


USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

MAGCHARG.HLP 
This is the Magnet Charge Editor.
From this menu, you can set the
charges on each of the magnets to
whatever you like. If there are
more than 10 magnets, you can use
the Next Page key to see more magnets.
 
USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.


MAGFILE.HLP 
This menu allows you to save and
reload sets of parameters or complete
pictures.  The parameter files have
the suffix .MFG, and the picture
files have the suffix .GIF.

SAVE PARAMETERS: [Alt-s]
LOAD PARAMETERS: [Alt-l]
The parameter files are only a few
hundred bytes in size.  When you
reload a parameter file, the image
is live, meaning that all the program
parameters have been set to the
saved values.  This is useful for
repeating experiments or demonstrations.
 Since parameter files are so small,
they are good for exchanging with
friends who have their own copy
of JAMES GLEICK'S CHAOS: THE SOFTWARE.
 Parameter files are in fact text
files, so you can edit them with
your word processor.

SAVE IMAGE AS GIF: [Alt-g]
SAVE SCREEN AS GIF: [Alt-h]
TheGIF files are large, often as
big as 30,000 bytes.  When saving
a .GIF file you can save a copy
of just the IMAGE area or you can
save a copy of the whole SCREEN,
including the stamps and the status
line.  GIF files are a standard,
bit-mapped picture format used for
portability among all personal computers,
including Macintosh, Amiga, Atari,
Apple II, and IBM.  In some cities
it is possible to have prints or
posters made from GIF files.

VIEW GIF IMAGE: [Alt-f]
When you view a GIF you will see
exactly what you saw when you saved
it,  and then when you press any
key, the picture will disappear.
 Viewing a GIF file does NOT reset
the parameters.

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To exit the menu without
doing anything, select the CANCEL
button, or press the ESCAPE key,
or click the right mouse button.

MAGNETS.HLP 
Pendulum and Magnets 
In this programs your computer screen
is filled with simulated force fields.
The white spot acts as the bob of
a pendulum whose natural resting
state is the screen's center, and
the blue and red spots act as magnets
which attract or repel the bob.
You are in effect looking down on
this system from above---just as
if you staring down at an iron plumb
bob dangling over magnets on the
floor. 
If only the unshifted key is listed,
the shifted key has the same effect.
If two keys are listed, the unshifted
key decreases, the shifted key increases
the affected item. 
a    Toggle the force type in between
Inverse Square and Inverse Linear

b B     decrease or increase centerpull

c C     change magnet charges 
d D     put the magnets on a circle,
        and change radius of this
circle. 
 e       toggle between lively mode
        and physical mode  
f F     change friction 
g G     change sampling frequency

h       randomize magnet positions

i       randomize magnet charges
 
j       toggle basin mode 
k K     change the magnet radius

l L     change trace length 
n       temporarlily save a layout
as an         addditional canned
layout  
o       changes between big and
small motion         steps for arrow
keys. 
r       reset. 
s       fetch.  
t T     cycle through trace types

u       reversibility togggle 
v       reverse 
x X     chagne magnet radius 
y       toggle the friction type

, and . to make program run slower
or faster. 
+ and - to change the sign of a
boxed magnet.       If no magnet
is boxed, then + and - set     
the sign of all the magnets to plus
or     minus.  
0 through 9 to set up 0 to 9 magnets
 
Arrow keys to move the club.  You
can use Home, End,      PgUp and
PgDn for diagonal motion. 
INS and DEL insert or delete a magnet
at      the cursor.  
Spacebar to pause and step 
Shift-spacebar to restart 
Enter to swing the club  
Alt-A to select preset palettes

Alt-B to select a random palette

 Alt-D to select the default palette

Alt-F to view a GIF file 
Alt-G to save image as GIF file

Alt-H to save screen as GIF file

Alt-L to load a layout parameter
file 
Alt-N to load next canned layout

Alt-P palette editor 
Alt-Q quit to DOS 
Alt-R Redraw.  Erase the old trails.

Alt-S to save layout parameters

Alt-V to toggle sound. 
Alt-W to get an info box 
Alt-X exit to DOS 
Alt-Y color cycle 
There are six tweakable items on
the control panel. To increase or
decrase an item, move the cursor
to the plus or minus key and leftclick
or hit ENTER. If you have a mouse,
you can change by a larger amount
by rightclicking. You can also move
the cursor to the number box itself,
hit ENTER or left-click, and enter
the new number. 
MAGOPTS.HLP 
Documentation on the options panel
to be filled in here.  
USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

MAGPAL.HLP 
COLOR SQUARES:
Use the mouse or arrow keys to highlight
a color square and left-click or
press Enter to select it for editing.
 If we number the colors 1 through
8 in the top row and 9 through 16
in the second row, then color number
1 is the background color; this
is the color square selected by
default when you enter the palette
menu.  Colors 1, 2, 7, 8, 15, and
16 are used in the menus, and the
other colors are used in the images.
 If you have "unlocked" the menu
colors by pressing Alt-e, then the
menu colors are used in the image
as well.

R G B SLIDERS:
The sliders control the amount of
RED, GREEN, and BLUE used to make
the shade of the selected color
square.  If you have no mouse, use
the up and down arrow keys to put
the cursor on a slider.  To drag
a slider, use the left and right
arrow keys, or hold the left mouse
button down and move the mouse ---
or move the mouse to a position
on a slider bar and left-click the
mouse.  Since EGA systems have fewer
colors than VGA graphics systems,
they display a larger slider.

SAVE: [s]
LOAD: [l]
These keys call up a menu which
lets you save or load a particular
palette.  When the Game module starts
up it always loads the MAGNETS.PAL.
 If you save a palette under the
name MAGNETS.PAL, then this will
become the new default palette for
the Game module.  The .PAL files
are saved as small text files.

To reject your color changes, select
the CANCEL button, press ESC, or
right-click your mouse.  To keep
your color changes, select the ACCEPT
button by moving to it and pressing
Enter.

MAND.HLP 
HOT KEYS: 
a,A: decrease and increase the 'A'
 parameter. (Cubic fractals only.)

b,B: decrease and increase the 'B'
 parameter. (Cubic fractals only.)

c,C: Recenter and reset the fractal.

d,D: Toggle 4D Cursor Tracking.

e,E: Cursor select Cubic Mandelbrot.

f,F: Change cubic fill type. 
i,I: decrease and increase maximum
iterations. 
j,J: Cursor select Julia or cubic
Julia. 
l,L: Change "slice type". 
m,M: Select the Mandelbrot set.

n,N: Change Mandelbrot fill type.

r,R: Select the Rudy set. 
s,S: Change Rudy set fill type.

u,U: Decrement and increment "U"
parameter. 
v,V: Decrement and increment "V"
parameter. 
w,W: Decrement and increment band
width. 
x,X: Toggle between zoom and select
cursor. 
Alt-A: Preset palettes. 
Alt-B: Randomize palette. 
Alt-C: Center and reset. 
Alt-D: Default palette. 
Alt-G: Save image to GIF. 
Alt-H: Save entire screen to GIF.

Alt-I: Status line toggle. 
Alt-J: Cycle palette once. 
Alt-K: Cycle palette backwards once.

Alt-M: Monochrome toggle. 
Alt-O: Toggle open edges. 
Alt-P: Palette editor. 
Alt-Q: Quit to DOS. 
Alt-V: Sound toggle. 
Alt-X: Quit to main menu. 
Alt-Y: Color cycle toggle. 
Alt-Z: Zoom box. 
Alt-1 through Alt-4: Select stamp
1-4   (1 is on the bottom.) (Or
left-click  on a stamp.) 
Alt-5 through Alt-8: Show info for
 stamp 1-4. (Or right-click on a
 stamp.) 
+ and - select forwards and backwards
through the presets. 
MANDFILE.HLP 
This menu allows you to save and
reload sets of parameters or complete
pictures.  The parameter files have
the suffix .FRP, for "FRactal Paramters,"
and the picture files have the suffix
.GIF.

SAVE PARAMETERS: [Alt-s]
LOAD PARAMETERS: [Alt-l]
The parameter files are only a few
hundred bytes in size.  When you
reload a parameter file, the image
is live, meaning that all the program
parameters have been set to the
saved values.  This is useful for
repeating experiments or demonstrations.
 Since parameter files are so small,
they are good for exchanging with
friends who have their own copy
of JAMES GLEICK'S CHAOS: THE SOFTWARE.
 Parameter files are in fact text
files, so you can edit them with
your word processor.

SAVE IMAGE AS GIF: [Alt-g]
SAVE SCREEN AS GIF: [Alt-h]
TheGIF files are large, often as
big as 30,000 bytes.  When saving
a .GIF file you can save a copy
of just the IMAGE area or you can
save a copy of the whole SCREEN,
including the stamps and the status
line.  GIF files are a standard,
bit-mapped picture format used for
portability among all personal computers,
including Macintosh, Amiga, Atari,
Apple II, and IBM.  In some cities
it is possible to have prints or
posters made from GIF files.

VIEW GIF IMAGE: [Alt-f]
When you view a GIF you will see
exactly what you saw when you saved
it,  and then when you press any
key, the picture will disappear.
 Viewing a GIF file does NOT reset
the parameters.

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To exit the menu without
doing anything, select the CANCEL
button, or press the ESCAPE key,
or click the right mouse button.

MANDOPTS.HLP 
Auto Cycle and Auto Rev Cycle 
    These contols set the colors
to spinning in opposite senses.
  One gives a feeling of inward
motion, the other an illusion of
 expansion.  These make eyecatching
displays when done to a finished
 image.  The Auto Cycles are also
useful for bringing out certain
 features of the image: things like
tendrils, cracks and shoals.   The
use of these features does slow
down the calculation of  unfinished
images, but can be useful here for
guessing what the  finished image
will look like. 
Cycle Once and Cycle Once Reverse

    These single step controls are
useful for getting an image  to
look its best with a given palette.
 Usuall it looks nice, for  instance,
to have the brightest colors in
close to the boundary  between the
fractal's inside and outside.  Using
the f and g keys  to control these
directly from the keyboard works
well. 
Wider Bands, Thinner Bands 
    These two switches allow you
to increase or decrease the  bandsize
parameter which is shown at the
end of both lines.   The effects
of this parameter are nonlinear,
meaning that  sometimes a big change
has small effect on the picture
and vice  versa.  As a practical
matter, larger values of bandwidth
push  the lively flame-like areas
out from the dark inner fractal,
 and smaller values pull the flames
in.  Changing the bandwidth  parameter
forces the program to recalculate
the whole screen,  so if you are
going to tweak the bands, it is
better to try out  several values
of bandwidth and fix on one before
letting the  whole screen get calculated.
 Remember that the bandwidth you
 select will stay the same for the
next picture, so usually one  should
reset it to 1, which is the value
which works for the  widest range
of pictures. 
Toggle Monochrome 
    This switch sets the screen
to black and white.  It is not 
a very important switch, as we have
a preset black and white  palette
available anyway, but if you are
planning to make black  and white
images with our program, it may
be useful to have lots  of black
and white palette options. 
Sound 
    The sound can be set on or off.
 The noise is gotten by  setting
the frequency of the tone to be
proportional to the number  code
of the color assigned to the last
pixel painted.  Sometimes  if the
program is running pretty slowly
the sound is almost OK,  but usually
its ugly. 
Cursor Type 
    This is a very important switch.
 It is this switch that  changes
the cursor between being a SQUARE
which does ZOOOMING,  and being
a DIAMOND that does SELECTING. 
When the cursor is in  ZOOM mode,
a left click will enlarge the picture,
and a right  click will decrease
its size.  The INS and DEL keys
perform the  same functions as the
left and right mouse clicks, so
INS is zoom  in, and DEL is zoom
out, when the cursor is in ZOOM
mode.  When  the cursor is in SELECT
mode, the left mouse click or INS
key  select parameters for a Julia
set and draw the Julia set.  In
 SELECT mode, the right mouse click
or DEL key select parameters  for
a Mandelbrot set and draw a Mandelbrot
set.     If you select a Julia point
inside the Mandelbrot set you will
 get a Julia set which has a pinched
disklike interior.  If you  select
a Julia point outside the Mandelbrot
set you will get a  Julia set which
is broken into pieces.  This is
true in the  quadratic and in the
cubic cases. 
4D Cursor Track and 4D Slice Plane

    As it turns out, the Cubic Mandelbrot
sets can be stacked  together into
a single four dimensional whole,
an object which  is called the Cubic
Connectedness Locus, or CCM.  Another
way to  put it is to say that the
CCM is the set of all parameter
quadruples  (a,b,u,v) such that
the Cubic Julia set determined by
these paramters  is connected. 
Looked at a third way, you might
think of the CCM as  a 3D object
which changes over time, not that
any of the directions  A, B, U,
or V has more reason to be called
"time" or "height" than  does any
other. 
    The 4D Slice Plane button (
or the l or L keys ) allows us to
 slice the Cubic Connectedness Locus
in six different ways, and to  view
these slices Cubic Mandelbrot Sets.
 Since the four dimensions  are
A, B, U, and V, the slice planes
are the UV-Plane, the AB-Plane,
 the AU-plane, the BV-plane, the
BU-plane, and the AV-plane.  Our
 program always starts up with Slice
Plane set to the UV-plane.   Changing
a or b moves the UV plane parallel
to itself, picking  out different
slices of the CCM.  But if you have
used the 4D Slice  Plane button,
then you may be using, say, the
AU-plane.  In this case  it is the
unmentioned parameters b and v which
will move the Cubic  Mandelbrot
sets around. 
    In investigating these different
slices, it is useful to have the
 cursor in SELECT mode and keep
checking the Cubic Julia sets to
be  found inside the Cubic Mandelbrots.
 The Cubic Julias are always  drawn
from the same pool.  One difference,
however, is that when I  am in the
familiar UV-plane, I set A and B
by hand, and pick U and  V by left
clicking the mouse.  But if I am
in, again, the AU-plane,  say, then
I set A and U by hand, and pick
B and V by left clicking  the mouse.

    In pursuing these views it is
useful to put the 4D Cursor Trace
 ON.  This has the effect of always
keeping a particular Cubic Julia
 set value at the center of the
screen.  That is, if the 4D Cursor
 Trace is ON, then when I switch
from one 4D Slice Plane to  another,
the screen boundaries will be adjusted
to keep the same  Julia set pick
spot at the center.  The one thing
about the 4D  Cursor Trace feature
is to remember to turn it OFF when
you are  not consciously using it,
otherwise your zooms won't work
right.   Fortunately, pressing c
to recenter, or C to reset will
turn the  4D Cursor Trace feature
off. 
Status Line 
chooses one of three options: no
status line, a status line that
tracks the cursor position for zooming,
or a status line that shows the
current parameters. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

MANDPAL.HLP 
COLOR SQUARES:
Use the mouse or arrow keys to highlight
a color square and left-click or
press Enter to select it for editing.
 If we number the colors 1 through
8 in the top row and 9 through 16
in the second row, then color number
1 is the background color; this
is the color square selected by
default when you enter the palette
menu.  Colors 1, 2, 7, 8, 15, and
16 are used in the menus, and the
other colors are used in the images.
 If you have "unlocked" the menu
colors by pressing Alt-e, then the
menu colors are used in the image
as well.  This is a good idea with
Mandel, although when the colors
are unlocked, color-cycling will
affect the menus.

R G B SLIDERS:
The sliders control the amount of
RED, GREEN, and BLUE used to make
the shade of the selected color
square.  If you have no mouse, use
the up and down arrow keys to put
the cursor on a slider.  To drag
a slider, use the left and right
arrow keys, or hold the left mouse
button down and move the mouse ---
or move the mouse to a position
on a slider bar and left-click the
mouse.  Since EGA systems have fewer
colors than VGA graphics systems,
they display a larger slider.

SAVE: [s]
LOAD: [l]
These keys call up a menu which
lets you save or load a particular
palette.  When the Game module starts
up it always loads the MANDEL.PAL.
 If you save a palette under the
name MANDEL.PAL, then this will
become the new default palette for
the Game module.  The .PAL files
are saved as small text files.

To reject your color changes, select
the CANCEL button, press ESC, or
right-click your mouse.  To keep
your color changes, select the ACCEPT
button by moving to it and pressing
Enter.

MANDTYPE.HLP 
    This menu allows you to switch
among five types of fractals: Julia
sets, Cubic Julia sets, the Mandelbrot
set, the Cubic Mandelbrot sets,
and the Rudy set.  This menu also
lets you change the "filling" of
the Mandelbrot, Cubic Mandelbrot,
and Rudy sets.  Changing the "filling"
does NOT affect the Julia sets or
the Cubic Julia sets. 
    After selecting a new type you
may need to change the A, B, U,
and/or V parameters to get a nice
picture.  Usually:  The CUBIC Julias
and CUBIC Mandelbrots are affected
by A, B.  The JULIAs and the Cubic
JULIAs are affected by U and V.
 The Rudy sets and the Mandelbrot
set aren't affected by parameters.
 See the Help screen for the TWEAK
Menu for information on adjusting
parameters. 
    Each of our fractal types is
calculated in more or less the same
way: each pixel position P1 is used
as the starting point of its own
long calculation of new points:
   P1 ---> P2 --->...  Pn --->...

In the case of the Julia sets and
the Mandelbrot set, the "--->" represents
the use of two quadratic equations
(equations with things like x-squared
in them).  In the case of the Cubic
Julia, the Cubic Mandelbrot, and
the Rudy sets, the "--->" represents
the use of two cubic equations (equations
with things like x-cubed in them.)
Therefore we think of our five fractal
types as being in two families:

 Quadradic:  The Julia sets and
  the Mandelbrot set.   Cubic: The
Cubic Julia sets, the Cubic Mandelbrot
sets, and the Rudy set. 
 If the new points of the sequence
P1 ---> P2 ---> ... ---> Pn --->...
eventually wander off screen then
the pixel is givena color based
on the value of n for which Pn is
first off screen.  If the points
manage to always stay on screen,
then P1 is colored black, provided
that Fill Type Blank is active.
 (And provided that the color table
being used sets its lowest color
to black, as most of them do). 
    When Fill is set to Bullseye,
the color of P1 will be based on
the CLOSEST distance which the Pn
sequence gets to the screen center.
 When Fill is set to Feathers, the
color of P1 will be based on the
value of n for which Pn reaches
its closest approach to the screen
center.  Points in the same ring
of a Bullseye behave similarly,
and if they are in the same feather,
they act even more alike under the
---> transformation that moves point
to point. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

MNDTWEAK.HLP 
    This menu allows you to numericallly
set the parameters X,Y,W, A,B,U,V,
and I.  To change a parameter, move
the highlight to where the parameter
is. You can use your mouse to drag
the highlight, or you can use the
arrow keys.  When you are on the
paramter you want to change, hit
RETURN or left-click and type in
the new value. You can use backspace
to go back over what you've typed.
When you have the value you want,
press Enter.  You may then edit
another parameter or, if you are
done you can click on the OK box,
or press Enter until the highlight
goes to the OK box. 
X, Y, and W control the position
(X,Y) and the size (W is horizontal
width) of the current view. 
A,B,U and V all affect the shapes
of the Cubic Julias.  A and B alone
affect the shape of the Cubic Mandelbrots.
 U and V alone affect the shapes
of the regular Julias.   
    The I parameter controls the
maxiumum amount of time (iteration
count) which the program uses per
pixel. High values of I mean slower
speed and more precision, lower
values of I mean increased speed
and less accuracy.   Whenever you
zoom in or out, the program guesses
at a good value of I for that size
image.  If, however, you change
the W value by hand, the I parameter
will not automatically adjust to
match it.  Generally, a good value
is something like 100 times the
number of decimal places out to
the first nonzero digit in your
W parameter.  Thus if W is .002,
a value of 3 * 100 would be OK for
I, though in the cubic case 2 *
100 would do, and in the quadratic
case 4 * 100 might look better.

    When this menu is not up, you
can adjust A,B,U,V, and I by using
the lowercase and uppercase a,b,u,v,
and i keys.  Lowercase subtracts
a small number from a parameter,
and uppercase adds a small number
to it. 
    You can also adjust parameters
by using the SELECT mode cursor.
 You can switch between SELECT mode
and ZOOM mode cursors by using the
x key, or you can switch cursor
mode by using the VIEWS menu. 
    Using the triangular SELECT
mode cursor, if your screen is showing
either a Mandelbrot or a Julia,
then a left click of the mouse or
a press of the INS key will set
the Julia  parameters U and V on
the basis of the screen position,
and draw the new Julia.  If your
screen is showing a regular Julia
set, then a right click or press
of the DEL key will return you to
the Mandelbrot set. 
    Using the diamond SELECT mode
cursor, if your screen is showing
a Rudy set, a Cubic Mandelbrot,
or a Cubic Julia, then a left click
of the mouse or a press of the INS
key will set the Cubic Julia parameters
U and V on the basis of the cursor's
screen position, and show the Cubic
Julia.  If the  screen is showing
a Cubic Julia, a right click or
press of DEL switches to a Cubic
Mandelbrot without changing parameters.
 If your screen is showing a Rudy
set or a Cubic Mandelbrot set, 
then a right click of the mouse
or a press of the DEL key will set
the Cubic Mandelbrot parameters
A and B on the basis of the cursor
position, and draw a new Cubic Mandebrot.

    In the case that you have used
the OPTS menu or the l and L keys
to select a 4D slice other than
the uv-plane slice, then the left
click or INS will change the parameters
of the plane you are slicing with,
and the right click will change
the other two parameters. 
An interesting use of the TWEAKS
menu is to look up published paramters
of fractals and type them in.  Peitgen's
Shepherd's crook in the Seahorse
Valley of the Mandelbrot set can
be seen, for  instance, by setting
X = -0.7452, Y = 0.1126, W = 0.008,
and I = 300. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

TOY.HLP 
This module shows four universes
in which orderly spiral patterns
can emerge out of a random start.

QUICK KEY SUMMARY 
Arrow keys move from button to 
 button. 
If the button has a -+ on the  
right, then the "+" and "-"   keys
activate the button. 
ENTER selects plain buttons. 
 F1  Help 
F3  Toggle Fast Mode 
F4  Pattern 
F5  Screen+Pattern 
F7  Toggle Grid Lines 
F8  Default palette 
F9  Toggle instant/delayed change

F10 Save Image as GIF file 
Alt keys: 
Alt-A Preset Palette 
Alt-B Random Palette 
Alt-D Default Palette 
Alt-F GIF Viewer 
Alt-G Save Image as GIF 
Alt-H Save Screen as GIF 
Alt-J Cycle Palette Forward 
Alt-K Cycle Palette Reverse 
Alt-L Load Parameters 
Alt-M Monochrome Toggle 
Alt-P Palette Editor 
Alt-Q Quit to DOS 
Alt-R Randomize Screen 
Alt-S Save Parameters 
Alt-X Exit Program 
Alt-W Program information 
Alt-Y Color Cycle Threeway Toggle
        (off, forward, reverse)

Alt-Z Zoombox when not zoomed  
    all the way our or in 
Alt-1 through Alt-4 -- overlay 
      canned images 1-4 
Alt-5 through Alt-8 -- replace 
     canned images 1-4 
 Space bar stops and single steps;

 Shift key + Space bar restarts
when stopped. 
INS zooms in to lower resolution

DEL zooms out to higher resolution

Letter keys: 
b & B Toggle High Res Sea Type 
f & F Fast/Slow Toggle 
g & G Grid Toggle 
t & T Rotate through Types 
w & W Toggle Wrap. 
s & S bring up the Shape menu 
Other keys are specific to the automaton
being displayed. For each of these,
the lower case letter decreases
the parameter, the upper case increases.

In HODGE: 
   i & I change "Increment" 
   n & N change "Number" 
 In NLUKY: 
The keys n,l,u,k,y and their uppercases
change the parameters by those names.

 In EAT: 
e & E change maxEat. 
d & D both toggle determinism. 
In TUBE: 
h & H change "Hide" 
e & E change "Eat" 
a & A change "Alarm" 
j & J toggle "Jazz" 
TOYFILE.HLP 
This menu allows you to save and
reload sets of parameters or complete
pictures.  The parameter files have
the suffix .SAP, for "Strange Attractor
Parameters," and the picture files
have the suffix .GIF.

SAVE PARAMETERS: [Alt-s]
LOAD PARAMETERS: [Alt-l]
The parameter files are only a few
hundred bytes in size.  When you
reload a parameter file, the image
is live, meaning that all the program
parameters have been set to the
saved values.  This is useful for
repeating experiments or demonstrations.
 Since parameter files are so small,
they are good for exchanging with
friends who have their own copy
of JAMES GLEICK'S CHAOS: THE SOFTWARE.
 Parameter files are in fact text
files, so you can edit them with
your word processor.

SAVE IMAGE AS GIF: [Alt-g]
SAVE SCREEN AS GIF: [Alt-h]
TheGIF files are large, often as
big as 30,000 bytes.  When saving
a .GIF file you can save a copy
of just the IMAGE area or you can
save a copy of the whole SCREEN,
including the stamps and the status
line.  GIF files are a standard,
bit-mapped picture format used for
portability among all personal computers,
including Macintosh, Amiga, Atari,
Apple II, and IBM.  In some cities
it is possible to have prints or
posters made from GIF files.

VIEW GIF IMAGE: [Alt-f]
When you view a GIF you will see
exactly what you saw when you saved
it,  and then when you press any
key, the picture will disappear.
 Viewing a GIF file does NOT reset
the parameters.

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To exit the menu without
doing anything, select the CANCEL
button, or press the ESCAPE key,
or click the right mouse button.

TOYOPTS.HLP 
This is the options panel. Click
on a selection, or move the cursor
and hit "return" to change it. The
options (and the hot keys associated
with them) are: 
"Grid lines are ON/OFF" 
This option toggles the use of black
grid lines between the cells in
Coarse and Medium cells. This is
a  purely visual effect to be set
the way you like. The program starts
up with this feature on. 
"Fast mode is ON/OFF" [F3] 
This will toggle between fast and
slow modes in Coarse and Medium
resolution.  In slow mode, the data
for the offscreen cells is still
being calculated, while in fast
mode only the visible cells are
calculated.  If you zoom in with
Fast mode and zoom back out later,
the centeral area will be "older"
or more highly evolved.   
"Sea type is BLANK/NOISY" [b] 
This toggles between two "sea types,"
random sea and empty sea.  This
is an effect that happens when you
zoom out to Very High resolution.
 When you go out to Very High resolution,
the cell pattern from the High resolution
mode is shrunken to a square in
the middle of the screen.  The new
cells around the central square
are the "sea".  This sea can either
be left blank or filled with random
colors.  The program starts out
with the empty sea choice, but if
you press the b key before zooming
out to Very High resolution, a random
sea will be used.  Random sea works
well with Hodge and Nluky, and empty
sea works well with Eat and Tube.

"Wrap is ON/OFF" [w] 
turns the wrap on and off.  When
wrap is on, the rightmost cells
are thought of as touching the leftmost
cells, and the topmost cells as
touching the bottommost cells. 
When wrap is off, the border cells
are frozen to whatever values they
had when you turned the wrap off.
 The program starts out with wrap
on.   
"Load Shape"     [F4] "Overlay Shape"
 [F5] 
F4 erases the existing pattern and
replaces it with a diamond, circle,
or square. This works well with
Hodge and NLUKY. 
F5 loads a diamond, circle, or square
on top of the existing pattern.
This works well with Eat or Tube.

"Changes are INSTANT/DELAYED"  [F9]

F9 toggles between instant and delayed
changes. In the instant mode, the
program looks for keystrokes and
mouse clicks while the next generation
of  the automaton is being calculated;
this gives faster key response,
but often there will be half-completed
screens when you change from  resolution
to resolution, or from automaton
to automaton. In the delayed mode,
the keystrokes and mouse clicks
are only attended to after a complete
generation; this will mean slower
response, but more coherant pictures.
The program starts up in instant
mode. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

TOYPAL.HLP 
COLOR SQUARES:
Use the mouse or arrow keys to highlight
a color square and left-click or
press Enter to select it for editing.
 If we number the colors 1 through
8 in the top row and 9 through 16
in the second row, then color number
1 is the background color; this
is the color square selected by
default when you enter the palette
menu.  In Toy, all the colors are
used in the images, and colors 1,
2, 7, 8, 15, and 16 are used in
the menus.

R G B SLIDERS:
The sliders control the amount of
RED, GREEN, and BLUE used to make
the shade of the selected color
square.  If you have no mouse, use
the up and down arrow keys to put
the cursor on a slider.  To drag
a slider, use the left and right
arrow keys, or hold the left mouse
button down and move the mouse ---
or move the mouse to a position
on a slider bar and left-click the
mouse.  Since EGA systems have fewer
colors than VGA graphics systems,
they display a larger slider.

SAVE: [s]
LOAD: [l]
These keys call up a menu which
lets you save or load a particular
palette.  When the each of the four
Toy rule types start up it always
loads a special palette for that
rules.  The special palettes are
HODGE.PAL, EAT.PAL, NLUKY.PAL, and
TUBE.PAL.  If you save a palette
under one of these names, then it
will become the new default palette
for that Toy module rule type. 
The .PAL files are saved as small
text files.

To reject your color changes, select
the CANCEL button, press ESC, or
right-click your mouse.  To keep
your color changes, select the ACCEPT
button by moving to it and pressing
Enter.

TOYSHAPE.HLP 
This menu allows you to select SHAPES
to overlay or replace the image
on the screen. Four shapes are available:
a square, a diamond, a circle, and
the Autodesk logo. In OVERLAY mode,
the shape is painted on top of the
existing image; in REPLACE mode,
the existing image is blanked and
the new shape is painted. 

USING THE MENU
To highlight a button, use the mouse
or the arrow keys.  To select a
button, left-click the mouse or
press Enter.  To reject your changes,
select the CANCEL button, or press
the ESCAPE key, or click the right
mouse button.  Select the ACCEPT
button to adopt your changes.

SELECT.HLP 
This is the File Selector. Choose
the file to use for the requested
function. 
On the left is a list of all the
files in the selected directory
which match the "wildcard" appropriate
for this function. Use the arrow
keys (and the Home, PgUp, PgDn,
and End keys) to change what part
of the entire file list is being
displayed. If you have a mouse,
you can also move the list by clicking
on the up and down arrows on the
"slider" box to the left of the
file list, or by clicking in the
slider box itself to position the
entire list. 
When you know the filename you want
to use, you can type it into the
Filename box. You may need to move
the highlight to the Filename box
by using the TAB key, or by clicking
on it with the mouse.  If you are
using a mouse, you can click on
a filename in the listing on the
left; if you double click, that
file will be selected.  
You can change the directory by
either moving the highlight to the
"Dir:" box by using the TAB key,
and typing in the new directory
name, or by clicking on a directory
name in the listing (directory names
are identified by a  leading backslash
"\"). Mouse users can also use the
small ".." button to go to the parent
directory, or the "\" button to
go to the top directory. 
You can change disk drives by typing
in a disk drive in the directory
box, or by clicking on one of the
drive letter buttons. 
You can change the wild-card specification
by tabbing to the wild-card box
and typing in a new specification.

When you are done, press ENTER or
click on the OK button. If you want
to cancel the entire operation,
press ESC or click on the "ESC to
CANCEL" button. 
ZOOMASP.HLP 
You can drag around the zoom box
using either the mouse or the arrow
keys. To change the size of the
zoom box, hold down the shift key
while using the arrows or the mouse.
 Right or up makes the box smaller,
left or down makes it bigger.  The
proportions of the zoombox's sides
are always the same.  To zoom in,
press INS or click the left button;
to zoom out, press DEL or click
the right button. To cancel the
whole process, press ESC.
ZOOMFIX.HLP 
You can drag around the zoom box
using either the mouse or the arrow
keys. You cannot change the size
of the zoom box.  To zoom in, press
INS or click the left button; to
zoom out, press DEL or click the
right button.  To cancel the whole
process, press ESC.
ZOOMVAR.HLP 
You can drag around the zoom box
using either the mouse or the arrow
keys. To change the size of the
zoom box, hold down the shift key
while using the arrows or the mouse.
You can change the two sides of
the box independently.  Left makes
it wider, right makes it narrower,
up makes it taller, and down makes
it shorter.  To zoom in, press INS
or click the left button; to zoom
out, press DEL or click the right
button. To cancel the whole process,
press ESC.

