unit digit;

interface

uses graph,crt,dos;

procedure jogo_digitos( dgmem : pointer ; es,di,fo : string; var ok : boolean);

implementation


procedure colocar_g(x,y,graf : integer ; dgmem : pointer);
var grafico : pointer;
begin
  grafico := ptr(seg(dgmem^),ofs(dgmem^)+150*graf);
  PutImage(x*24+16,y*24+8,grafico^,NormalPut);
end; { colocar_g }


procedure desenha_ecra( dgmem : pointer);
var c,x,y : integer;
begin
  SetViewPort(0,0,319,160,ClipOn);
  ClearViewPort;
  SetViewPort(0,0,319,199,ClipOn);

  for c := 0 to 11 do
    begin
      colocar_g(c,0,21,dgmem);
      colocar_g(c,5,21,dgmem);
    end;
  for c := 1 to 4 do
    begin
      colocar_g(0,c,21,dgmem);
      colocar_g(11,c,21,dgmem);
    end;

  for c := 2 to 9 do
    begin
      colocar_g(c,1,13,dgmem);
      colocar_g(c,4,19,dgmem);
      colocar_g(c,2,16,dgmem);
      colocar_g(c,3,16,dgmem);
    end;
  for c := 2 to 3 do
    begin
      colocar_g(1,c,15,dgmem);
      colocar_g(10,c,17,dgmem);
    end;
  colocar_g(1,1,12,dgmem);
  colocar_g(1,4,18,dgmem);
  colocar_g(10,1,14,dgmem);
  colocar_g(10,4,20,dgmem);
end; { desenha_ecra }


procedure calcula_combinacao(var digitos : string ; dgmem : pointer);
var c,som : integer;
    n : byte;
begin
  digitos := '';
  Randomize;
  for c := 1 to 6 do
    begin
      n := round(random*9);
      digitos := digitos + chr(n);
      colocar_g(c+2,2,n,dgmem);
      for som := 1 to 5 do
        begin
          Sound(100*som*c);
          Delay(3);
        end;
      NoSound;
    end;
end; { calcula_combinacao }


procedure ruido;
var c : integer;
begin
  for c := 1 to 15 do
    begin
      Sound(c*400);
      Delay(4);
    end;
  NoSound;
end; { ruido }


procedure ruido2;
var c : integer;
begin
  for c := 1 to 15 do
    begin
      Sound(3000);
      Delay(4);
      Sound(1000);
      Delay(4);
    end;
  NoSound;
end; { ruido2 }


procedure ruido3;
var c : integer;
begin
  for c := 1 to 15 do
    begin
      Sound(300*c);
      Delay(4);
      Sound(1000);
      Delay(4);
      Sound(4000-100*c);
      Delay(4);
    end;
  NoSound;
end; { ruido3 }


procedure verificar_ordem(dig : string; var ok : boolean);
var c : integer;
begin
  ok := true;
  for c := 2 to 6 do
    if ord(dig[c]) < ord(dig[c-1]) then
      ok := false;

  if ok = true then
    begin
      ruido3;
      ruido3;
    end;

  Delay(50);
end; { verificar_ordem }


procedure jogo_digitos ( dgmem : pointer ; es,di,fo : string; var ok : boolean);
var digitos,tempot : string;
    tempo,px       : integer;
    h,s,cont       : word;
    tecla          : string;
    aux            : char;
begin
  desenha_ecra(dgmem);
  Delay(320);
  calcula_combinacao(digitos,dgmem);

  colocar_g(3,3,10,dgmem);
  colocar_g(4,3,11,dgmem);
  tempo := round(random*4)+6;
  px := 3;

  SetViewPort(136,138,183,153,ClipOn);
  ClearViewPort;
  SetColor(3);
  Rectangle(0,0,47,15);
  SetViewPort(0,0,319,199,ClipOn);
  SetTextStyle(DefaultFont,0,1);
  GetTime(h,h,s,h);
  SetColor(2);
  Str(tempo:2,tempot);
  if tempo < 10 then
    tempot[1] := '0';
  OutTextXY(160,150,tempot);

  repeat
    GetTime(h,h,cont,h);
    if cont <> s then
      begin
        SetColor(0);
        OutTextXY(160,150,tempot);

        dec(tempo);
        s := cont;

        SetColor(2);
        Str(tempo:2,tempot);
        if tempo < 10 then
          tempot[1] := '0';
        OutTextXY(160,150,tempot);
        Sound(4000);
        delay(5);
        NoSound;
      end;

    if keypressed then
      begin
        tecla := readkey;
        if tecla = #0 then
          tecla := tecla + readkey;

        if tecla = es then
          if px > 3 then
            begin
              colocar_g(px+1,3,16,dgmem);
              colocar_g(px-1,3,10,dgmem);
              colocar_g(px,3,11,dgmem);
              ruido;
              dec(px);
            end;

        if tecla = di then
          if px < 7 then
            begin
              colocar_g(px,3,16,dgmem);
              colocar_g(px+1,3,10,dgmem);
              colocar_g(px+2,3,11,dgmem);
              ruido;
              inc(px);
            end;

        if tecla = fo then
          begin
            colocar_g(px,2,ord(digitos[px-1]),dgmem);
            colocar_g(px+1,2,ord(digitos[px-2]),dgmem);
            aux := digitos[px-1];
            digitos[px-1] := digitos[px-2];
            digitos[px-2] := aux;
            ruido2;
          end;

      end;
  verificar_ordem(digitos,ok);

  until (tempo = 0) or ok;

end; { jogo_digitos }




end.
